/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.Configure;
import com.ibm.ws.ffdc.DiagnosticEngine;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.DiagnosticModuleRegistrationFailureException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCHelper;
import com.ibm.ws.ffdc.IncidentStreamManager;
import com.ibm.ws.ffdc.ObjectIntrospectorImpl;

public class FFDC {
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int STOPPING = 3;
    private static int serverState = 0;
    private static boolean isServer = false;
    private static String serverName = null;
    private static String fullServerName = null;
    private static Object synchObject = new Object();
    private static String logRoot = null;

    public static void setState(int n) {
        if (n < 1 || n > 3) {
            return;
        }
        if (n != serverState) {
            serverState = n;
            FFDC.configureComponents();
        }
    }

    public static void setServer() {
        isServer = true;
        serverState = 1;
        FFDC.configureComponents();
    }

    public static void setServerName(String string, String string2) {
        serverName = string;
        fullServerName = string2;
        FFDCHelper.setServerName(serverName);
    }

    public static void setLogRoot(String string) {
        logRoot = string;
    }

    public static String getLogRoot() {
        return logRoot;
    }

    public static void resetThread() {
        try {
            IncidentStreamManager.clearIncidentStream(null);
            DiagnosticEngine.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureComponents() {
        Configure configure = null;
        if (!isServer) {
            return;
        }
        Object object = synchObject;
        synchronized (object) {
            configure = Configure.newConfiguration(serverState);
            if (configure == null) {
                return;
            }
            FFDCFilter.configure(configure);
            DiagnosticEngine.configure(configure);
            IncidentStreamManager.configure(configure);
            ObjectIntrospectorImpl.configure(configure);
        }
    }

    public static int registerDiagnosticModule(DiagnosticModule diagnosticModule, String string) {
        try {
            diagnosticModule.init();
        }
        catch (DiagnosticModuleRegistrationFailureException diagnosticModuleRegistrationFailureException) {
            return 2;
        }
        catch (Throwable throwable) {
            return 3;
        }
        if (!DiagnosticEngine.registerDM(diagnosticModule, string)) {
            return 0;
        }
        return 0;
    }

    public static boolean deregisterDiagnosticModule(String string) {
        return DiagnosticEngine.deregisterDM(string);
    }
}

