/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCConstants;
import com.ibm.ws.ffdc.FFDCHelper;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.ffdc.ObjectIntrospector;
import com.ibm.ws.ffdc.ObjectIntrospectorImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivilegedActionException;

class IncidentStreamImpl
implements IncidentStream {
    private static ThreadLocal svFilenames = new ThreadLocal();
    private FileOutputStream ivFileOutputStream;
    private byte[] ivValue;
    private String currentLogFilename = null;
    private ObjectIntrospector ivIntrospector = new ObjectIntrospectorImpl(this);

    public final void write(String string, boolean bl) {
        try {
            byte[] byArray = this.ivValue = bl ? FFDCConstants.svTrueValue : FFDCConstants.svFalseValue;
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, byte by) {
        try {
            this.ivValue = Integer.toString(by).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, char c) {
        try {
            this.ivValue = String.valueOf(c).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, short s) {
        try {
            this.ivValue = Integer.toString(s).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, int n) {
        try {
            this.ivValue = Integer.toString(n).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, long l) {
        try {
            this.ivValue = Long.toString(l, 10).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, float f) {
        try {
            this.ivValue = Float.toString(f).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, double d) {
        try {
            this.ivValue = Double.toString(d).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, String string2) {
        try {
            this.ivValue = string2 == null ? FFDCConstants.svNullValue : string2.getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void write(String string, Object object) {
        try {
            this.ivValue = String.valueOf(object).getBytes();
            if (string == null) {
                this.write(this.ivValue);
            } else {
                this.write(string.getBytes(), this.ivValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void introspectAndWrite(String string, Object object) {
        try {
            if (string != null) {
                this.writeLine(string.getBytes(), FFDCConstants.svZeroSizeByteArray);
            }
            this.ivIntrospector.dumpContents(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void introspectAndWrite(String string, Object object, int n) {
        try {
            if (string != null) {
                this.writeLine(string.getBytes(), FFDCConstants.svZeroSizeByteArray);
            }
            this.ivIntrospector.dumpContents(object, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void introspectAndWrite(String string, Object object, int n, int n2) {
        try {
            if (string != null) {
                this.writeLine(string.getBytes(), FFDCConstants.svZeroSizeByteArray);
            }
            this.ivIntrospector.dumpContents(object, n, n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void writeLine(String string, boolean bl) {
        this.write(string, bl);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, byte by) {
        this.write(string, by);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, char c) {
        this.write(string, c);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, short s) {
        this.write(string, s);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, int n) {
        this.write(string, n);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, long l) {
        this.write(string, l);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, float f) {
        this.write(string, f);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, double d) {
        this.write(string, d);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, String string2) {
        this.write(string, string2);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void writeLine(String string, Object object) {
        this.write(string, object);
        this.write(FFDCConstants.svLineSeparator);
    }

    public final void introspectAndWriteLine(String string, Object object) {
        try {
            this.introspectAndWrite(string, object);
            this.write(FFDCConstants.svLineSeparator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void introspectAndWriteLine(String string, Object object, int n) {
        try {
            this.introspectAndWrite(string, object, n);
            this.write(FFDCConstants.svLineSeparator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void introspectAndWriteLine(String string, Object object, int n, int n2) {
        try {
            this.introspectAndWrite(string, object, n, n2);
            this.write(FFDCConstants.svLineSeparator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    IncidentStreamImpl() {
    }

    final void initialize() {
        try {
            this.ivFileOutputStream = FFDCHelper.createFileOutputStream(this.getUniqueFileName(), false);
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void open() {
        try {
            this.ivFileOutputStream = FFDCHelper.createFileOutputStream(this.getCurrentFileName(), true);
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void resetIncidentStream() {
        this.currentLogFilename = null;
        try {
            this.ivFileOutputStream.close();
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.ivFileOutputStream = null;
    }

    final void write(byte[] byArray) {
        try {
            this.ivFileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void writeLine(byte[] byArray) {
        try {
            this.ivFileOutputStream.write(byArray);
            this.ivFileOutputStream.write(FFDCConstants.svLineSeparator);
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void write(byte[] byArray, byte[] byArray2) {
        try {
            int n = byArray.length;
            int n2 = byArray2.length;
            int n3 = 0;
            byte[] byArray3 = new byte[n + FFDCConstants.svSizeOfEqualsSign + n2];
            System.arraycopy(byArray, 0, byArray3, n3, n);
            System.arraycopy(FFDCConstants.svEqualsSign, 0, byArray3, n3 += n, FFDCConstants.svSizeOfEqualsSign);
            System.arraycopy(byArray2, 0, byArray3, n3 += FFDCConstants.svSizeOfEqualsSign, n2);
            this.write(byArray3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void writeLine(byte[] byArray, byte[] byArray2) {
        this.write(byArray, byArray2);
        this.write(FFDCConstants.svLineSeparator);
    }

    private String getUniqueFileName() {
        try {
            String string = Integer.toHexString(Thread.currentThread().hashCode());
            String string2 = FFDCHelper.generateOutputFileName(null, string);
            String string3 = (String)svFilenames.get();
            if (string3 != null) {
                String string4 = string3.substring(0, string3.lastIndexOf("_") + 1);
                String string5 = string2.substring(0, string2.lastIndexOf("_") + 1);
                if (string5.equals(string4)) {
                    StringBuffer stringBuffer = new StringBuffer(string5);
                    String string6 = string3.substring(string3.lastIndexOf("_") + 1, string3.lastIndexOf(".txt"));
                    int n = Integer.parseInt(string6);
                    stringBuffer.append(++n);
                    stringBuffer.append(".txt");
                    string2 = new String(stringBuffer);
                }
            }
            svFilenames.set(string2);
            return string2;
        }
        catch (WsException wsException) {
            return null;
        }
    }

    private String getCurrentFileName() {
        String string = this.currentLogFilename;
        if (string == null) {
            this.currentLogFilename = string = this.getUniqueFileName();
        }
        return string;
    }
}

