/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

class WrappingFileOutputStream
extends OutputStream {
    private String ivMainFileName = null;
    private File ivMainFile = null;
    private String ivDirectory = null;
    private String ivNamePrefix = null;
    private String ivNameSuffix = null;
    private String ivSepChar = "_";
    private int ivMaxBackups;
    private String[] ivBackupFiles = null;
    private String ivPreviousTimeStamp = null;
    private int ivTimeStampCounter = 1;
    private SimpleDateFormat ivDateFormatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
    private long ivMaxFileSize;
    private long ivCurFileSize = 0L;
    private FileOutputStream ivFileStream = null;

    WrappingFileOutputStream(String string, int n, int n2) throws IOException, WsException {
        this.ivMainFile = new File(string);
        this.ivMainFileName = string;
        int n3 = this.ivMainFileName.lastIndexOf(File.separator);
        if (n3 == -1) {
            throw new WsException(string + " does not contain a path separator character");
        }
        this.ivDirectory = this.ivMainFileName.substring(0, n3);
        String string2 = this.ivMainFileName.substring(n3 + 1, this.ivMainFileName.length());
        if (string2 == null || string2.equals("")) {
            throw new WsException(string + " is not a proper fully qualified file name");
        }
        n3 = string2.lastIndexOf(46);
        if (n3 == -1) {
            this.ivNamePrefix = string2;
            this.ivNameSuffix = null;
        } else {
            this.ivNamePrefix = string2.substring(0, n3);
            this.ivNameSuffix = string2.substring(n3, string2.length());
        }
        boolean bl = FFDCHelper.fileExists(this.ivMainFile);
        this.ivCurFileSize = !bl ? 0L : FFDCHelper.getFileLength(this.ivMainFile);
        this.ivMaxFileSize = n;
        this.ivMaxBackups = n2;
        if (this.ivMaxBackups > 0) {
            this.ivBackupFiles = this.generateBackupFileList();
        }
        try {
            this.ivFileStream = FFDCHelper.createFileOutputStream(this.ivMainFileName, true);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new WsException(this.ivMainFileName + " failed to create", privilegedActionException);
        }
    }

    public void write(int n) throws IOException {
        this.incrementCount(1);
        this.ivFileStream.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.incrementCount(byArray.length);
        this.ivFileStream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.incrementCount(n2);
        this.ivFileStream.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.ivFileStream.flush();
    }

    public void close() throws IOException {
        this.ivFileStream.close();
    }

    private void incrementCount(int n) throws IOException {
        this.ivCurFileSize += (long)n;
        if (this.ivCurFileSize >= this.ivMaxFileSize) {
            this.switchFiles();
            this.ivCurFileSize = n;
        }
    }

    private void switchFiles() throws IOException {
        this.ivFileStream.flush();
        this.ivFileStream.close();
        String string = this.createBackupFileName();
        File file = new File(string);
        boolean bl = FFDCHelper.renameFile(this.ivMainFile, file);
        try {
            this.ivFileStream = FFDCHelper.createFileOutputStream(this.ivMainFileName, false);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(this.ivMainFileName + " failed to create");
        }
        this.ivCurFileSize = 0L;
    }

    private String createBackupFileName() {
        Date date = new Date(System.currentTimeMillis());
        String string = this.ivDateFormatter.format(date);
        if (this.ivPreviousTimeStamp == null) {
            this.ivPreviousTimeStamp = string;
        } else {
            if (this.ivPreviousTimeStamp.startsWith(string)) {
                string = string + Integer.toHexString(this.ivTimeStampCounter++);
            }
            this.ivPreviousTimeStamp = string;
        }
        String string2 = this.ivDirectory + File.separator + this.ivNamePrefix + this.ivSepChar + string + this.ivNameSuffix;
        int n = this.ivBackupFiles.length - 1;
        String string3 = this.ivBackupFiles[n];
        if (string3 != null) {
            FFDCHelper.deleteFile(new File(string3));
        }
        int n2 = n;
        int n3 = n - 1;
        while (n2 > 0) {
            this.ivBackupFiles[n2] = this.ivBackupFiles[n3];
            --n2;
            --n3;
        }
        this.ivBackupFiles[0] = string2;
        return string2;
    }

    private String[] generateBackupFileList() {
        String[] stringArray = FFDCHelper.listFileNames(new File(this.ivDirectory));
        if (stringArray == null || stringArray.length == 0) {
            return new String[this.ivMaxBackups];
        }
        String string = this.ivDirectory + File.separator;
        int n = stringArray.length;
        Vector<String> vector = new Vector<String>(n);
        Vector<Long> vector2 = new Vector<Long>(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l;
            String string2 = string + stringArray[i];
            File file = new File(string2);
            if (!FFDCHelper.isFile(file) || (l = this.getFileTimestamp(stringArray[i])) == 0L) continue;
            vector.addElement(string2);
            vector2.addElement(new Long(l));
            ++n2;
        }
        if (vector.isEmpty()) {
            String[] stringArray2 = new String[this.ivMaxBackups];
            for (int i = 0; i < this.ivMaxBackups; ++i) {
                stringArray2[i] = null;
            }
            return stringArray2;
        }
        return this.sortAndDeleteFiles(vector, vector2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getFileTimestamp(String string) {
        if (!string.startsWith(this.ivNamePrefix)) return 0L;
        string = string.substring(this.ivNamePrefix.length() + 1);
        if (this.ivNameSuffix != null) {
            if (!string.endsWith(this.ivNameSuffix)) return 0L;
            string = string.substring(0, string.length() - this.ivNameSuffix.length());
        }
        try {
            Date date = this.ivDateFormatter.parse(string);
            return date.getTime();
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private String[] sortAndDeleteFiles(Vector vector, Vector vector2) {
        int n;
        int n2;
        int n3 = vector.size();
        String[] stringArray = new String[n3];
        long[] lArray = new long[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = (String)vector.elementAt(n2);
            lArray[n2] = (Long)vector2.elementAt(n2);
        }
        n2 = stringArray.length;
        boolean bl = true;
        while (bl) {
            bl = false;
            int n4 = 0;
            for (n = 1; n < n2; ++n) {
                if (lArray[n4] < lArray[n]) {
                    long l = lArray[n4];
                    String string = stringArray[n4];
                    lArray[n4] = lArray[n];
                    lArray[n] = l;
                    stringArray[n4] = stringArray[n];
                    stringArray[n] = string;
                    bl = true;
                }
                ++n4;
            }
        }
        String[] stringArray2 = new String[this.ivMaxBackups];
        if (n2 <= this.ivMaxBackups) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            for (n = n2; n < this.ivMaxBackups; ++n) {
                stringArray2[n] = null;
            }
        } else {
            System.arraycopy(stringArray, 0, stringArray2, 0, this.ivMaxBackups);
            for (n = this.ivMaxBackups; n < n2; ++n) {
                if (stringArray[n] == null) continue;
                FFDCHelper.deleteFile(new File(stringArray[n]));
            }
        }
        return stringArray2;
    }

    String[] getBackupFileList() {
        if (this.ivBackupFiles == null || this.ivBackupFiles.length == 0) {
            return null;
        }
        int n = this.ivBackupFiles.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.ivBackupFiles[i];
        }
        return stringArray;
    }
}

