/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.datagraph.impl;

import com.ibm.etools.emf.event.Event;
import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.DataObjectInfo;
import com.ibm.etools.wdo.Diagnostic;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.EventCreator;
import com.ibm.etools.wdo.datagraph.EventLog;
import com.ibm.etools.wdo.datagraph.WdoFactory;
import com.ibm.etools.wdo.datagraph.impl.DataObjectInfoImpl;
import com.ibm.etools.wdo.datagraph.impl.EDataObjectImpl;
import com.ibm.etools.wdo.datagraph.impl.WdoConfig;
import com.ibm.etools.wdo.serialization.DataGraphJavaSerializationHelper;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EDataGraphImpl
extends EDataObjectImpl
implements EDataGraph,
EStructuralFeature.Internal.DynamicValueHolder,
Serializable {
    protected Object setting;
    protected int settingID;
    protected List events;
    protected List diagnostics;
    protected ResourceSet resourceSet;
    protected DataObjectInfo dataObjectInfo;
    protected EventCreator eventCreator;

    public EDataGraphImpl(EClass eClass, ResourceSet resourceSet) {
        EDataGraphImpl.checkSchema(eClass);
        this.eSetClass(eClass);
        this.resourceSet = resourceSet;
    }

    public static void checkSchema(EClass eClass) {
        if (!eClass.getEAllAttributes().isEmpty()) {
            throw new IllegalArgumentException("A DataGraph schema may not contain EAttributes.");
        }
        EList eList = eClass.getEAllReferences();
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            EReference eReference = (EReference)eList.get(n);
            if (!eReference.isContainment()) {
                throw new IllegalArgumentException("DataGraph schema EReference " + eReference.getName() + " must have containment=true");
            }
            if (eReference.isMany()) {
                throw new IllegalArgumentException("DataGraph schema EReference " + eReference.getName() + " must have upper bound=1");
            }
            ++n;
        }
        if (eClass.getEPackage() == null || eClass.getEPackage().eResource() == null) {
            throw new IllegalArgumentException("The DataGraph schema must be in an EPackage.");
        }
    }

    public void allocateSettings(int n) {
    }

    public Object dynamicGet(int n) {
        return n == this.settingID ? this.setting : null;
    }

    public void dynamicSet(int n, Object object) {
        this.setting = object;
        this.settingID = n;
    }

    public void dynamicUnset(int n) {
        this.setting = null;
    }

    public boolean hasSettings() {
        return true;
    }

    protected EStructuralFeature.Internal.DynamicValueHolder eSettings() {
        return this;
    }

    public boolean eDynamicIsSet(EStructuralFeature eStructuralFeature) {
        int n = this.eDynamicFeatureID(eStructuralFeature);
        if (n <= -1) {
            throw new IllegalArgumentException("The feature '" + eStructuralFeature.getName() + "' is not a valid feature");
        }
        return n == this.settingID && this.setting != null;
    }

    public void eDynamicSet(EStructuralFeature eStructuralFeature, Object object) {
        int n = this.eDynamicFeatureID(eStructuralFeature);
        if (object != null && this.setting != null && n != this.settingID) {
            throw new IllegalArgumentException("Only one root feature may be set at a time.");
        }
        super.eDynamicSet(eStructuralFeature, object);
    }

    public NotificationChain eBasicSetContainer(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        if (internalEObject != null) {
            throw new IllegalArgumentException("DataGraphs cannot be contained.");
        }
        return super.eBasicSetContainer(internalEObject, n, notificationChain);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public EventCreator getEventCreator() {
        if (this.eventCreator == null) {
            this.eventCreator = WdoFactory.eINSTANCE.createEventCreator(this);
        }
        return this.eventCreator;
    }

    public EventLog getEventLog() {
        return this.getEventCreator();
    }

    public List getEvents() {
        if (this.events == null) {
            this.events = new EventList();
        }
        return this.events;
    }

    public List getDiagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new DiagnsoticList();
        }
        return this.diagnostics;
    }

    public DataObjectInfo getDataObjectInfo() {
        if (this.dataObjectInfo == null) {
            this.dataObjectInfo = new DataObjectInfoImpl(this);
        }
        return this.dataObjectInfo;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new DataGraphJavaSerializationHelper(this);
    }

    public DataObject getDataObject() {
        return this;
    }

    public EPackage getPackage(String string) {
        return WdoConfig.getPackage(string, this.getResourceSet(), true);
    }

    public class DiagnsoticList
    extends BasicEList {
        protected Object[] newData(int n) {
            return new Diagnostic[n];
        }
    }

    protected class EventList
    extends BasicEList {
        protected EventList() {
        }

        protected Object[] newData(int n) {
            return new Event[n];
        }
    }
}

