/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.datagraph.impl;

import com.ibm.etools.emf.event.Change;
import com.ibm.etools.emf.event.EventFactory;
import com.ibm.etools.emf.event.EventUtil;
import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.DataGraph;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.EventLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EventLogImpl
implements EventLog {
    DataGraph dataGraph;
    boolean isLogging = false;
    protected EventUtil eventUtil = null;
    protected Change[] changes = null;
    int eventCount = 0;
    protected Map newObjectToChangeMap = null;
    protected Map oldObjectToChangeMap = null;

    public EventLogImpl(DataGraph dataGraph) {
        this.dataGraph = dataGraph;
    }

    protected EventUtil getEventUtil() {
        if (this.eventUtil == null) {
            this.eventUtil = EventFactory.eINSTANCE.createEventUtil((Notifier)this.getDataGraph(), this.getEDataGraph().getResourceSet());
        }
        return this.eventUtil;
    }

    protected Change[] getChanges() {
        if (this.changes == null || this.getEDataGraph().getEvents().size() != this.eventCount) {
            this.changes = this.getEventUtil().getBackwardChanges(this.getEDataGraph().getEvents());
            this.newObjectToChangeMap = new HashMap();
            this.oldObjectToChangeMap = new HashMap();
            int n = 0;
            while (n < this.changes.length) {
                Change change = this.changes[n];
                if (change.getNewEObject() != null) {
                    this.newObjectToChangeMap.put(change.getNewEObject(), change);
                }
                if (change.getOldEObject() != null) {
                    this.oldObjectToChangeMap.put(change.getOldEObject(), change);
                }
                ++n;
            }
            this.eventCount = this.getEDataGraph().getEvents().size();
        }
        return this.changes;
    }

    public void startLogging() {
        this.clearLog();
        this.getEventUtil().activateEventAdapter(this.getEDataGraph().getEvents());
        this.isLogging = true;
    }

    public void stopLogging() {
        this.getEventUtil().deactivateEventAdapter();
        this.isLogging = false;
    }

    public void clearLog() {
        this.getEDataGraph().getEvents().clear();
        this.changes = null;
        this.eventCount = 0;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    protected EDataGraph getEDataGraph() {
        return (EDataGraph)this.dataGraph;
    }

    public List getChangedDataObjects() {
        Change[] changeArray = this.getChanges();
        BasicEList basicEList = new BasicEList();
        int n = 0;
        while (n < changeArray.length) {
            Change change = changeArray[n];
            if (change.getNewEObject() != null) {
                basicEList.add(change.getNewEObject());
            } else {
                basicEList.add(change.getOldEObject());
            }
            ++n;
        }
        return basicEList;
    }

    public boolean isCreated(DataObject dataObject) {
        Change change = (Change)this.newObjectToChangeMap.get(dataObject);
        return change != null && change.getOldEObject() == null;
    }

    public boolean isDeleted(DataObject dataObject) {
        Change change = (Change)this.oldObjectToChangeMap.get(dataObject);
        return change != null && change.getNewEObject() == null;
    }

    public List getOldValues(DataObject dataObject) {
        Change change = (Change)this.newObjectToChangeMap.get(dataObject);
        if (change == null) {
            return null;
        }
        BasicEList basicEList = new BasicEList();
        Change.Setting[] settingArray = change.getSettings();
        int n = 0;
        while (n < settingArray.length) {
            Change.Setting setting = settingArray[n];
            SettingImpl settingImpl = new SettingImpl((EObject)dataObject, setting.getFeature(), setting.getOldValue(), setting.isOldSet());
            basicEList.add(settingImpl);
            ++n;
        }
        return basicEList;
    }

    public static class SettingImpl
    implements EventLog.Setting {
        EObject eObject;
        EStructuralFeature feature;
        Object value;
        boolean isSet = false;

        public SettingImpl(EObject eObject, EStructuralFeature eStructuralFeature, Object object, boolean bl) {
            this.eObject = eObject;
            this.feature = eStructuralFeature;
            this.value = object;
            this.isSet = bl;
        }

        public String getFeatureName() {
            return this.feature.getName();
        }

        public int getFeatureIndex() {
            return this.eObject.eClass().getEAllStructuralFeatures().indexOf(this.feature);
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isSet() {
            return this.isSet;
        }
    }
}

