/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.datagraph.impl;

import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.DataGraph;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.EDocument;
import com.ibm.etools.wdo.datagraph.EDocumentClass;
import com.ibm.etools.wdo.datagraph.EventCreator;
import com.ibm.etools.wdo.datagraph.WdoFactory;
import com.ibm.etools.wdo.datagraph.WdoPackage;
import com.ibm.etools.wdo.datagraph.impl.DynamicDataObjectImpl;
import com.ibm.etools.wdo.datagraph.impl.EDataGraphImpl;
import com.ibm.etools.wdo.datagraph.impl.EDocumentClassImpl;
import com.ibm.etools.wdo.datagraph.impl.EDocumentImpl;
import com.ibm.etools.wdo.datagraph.impl.EventCreatorImpl;
import com.ibm.etools.wdo.datagraph.impl.WdoConfig;
import com.ibm.etools.wdo.store.Store;
import com.ibm.etools.wdo.store.impl.StoreDataObjectImpl;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class WdoFactoryImpl
extends EFactoryImpl
implements WdoFactory {
    protected Store store = null;

    public EObject create(EClass eClass) {
        int n = eClass.getClassifierID();
        if (n == 0 || n == 1 || this.getEPackage() != eClass.getEPackage()) {
            return this.createGen(eClass);
        }
        if (eClass instanceof EDocumentClass) {
            return this.createEDocument(eClass);
        }
        return (EObject)this.createDataObject(eClass);
    }

    public DataObject createDataObject() {
        return this.createDataObject(null);
    }

    public DataObject createDataObject(EClass eClass) {
        if (this.store == null) {
            DynamicDataObjectImpl dynamicDataObjectImpl = new DynamicDataObjectImpl();
            dynamicDataObjectImpl.eSetClass(eClass);
            return dynamicDataObjectImpl;
        }
        StoreDataObjectImpl storeDataObjectImpl = new StoreDataObjectImpl();
        storeDataObjectImpl.setStore(this.store);
        storeDataObjectImpl.eSetClass(eClass);
        return storeDataObjectImpl;
    }

    public EDocument createEDocument(EClass eClass) {
        EDocumentImpl eDocumentImpl = new EDocumentImpl();
        eDocumentImpl.eSetClass(eClass);
        return eDocumentImpl;
    }

    public EDocument createEDocument() {
        return this.createEDocument(null);
    }

    public EObject createGen(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createEDocumentClass();
            }
            case 1: {
                return this.createEDocument();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        if (eDataType.getEPackage() == WdoPackage.eINSTANCE) {
            return this.createFromStringGen(eDataType, string);
        }
        return super.createFromString(eDataType, string);
    }

    public Object createFromStringGen(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createWDOByteArrayFromString(eDataType, string);
            }
            case 3: {
                return this.createWDODateFromString(eDataType, string);
            }
            case 4: {
                return this.createWDOBigDecimalFromString(eDataType, string);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        if (eDataType.getEPackage() == WdoPackage.eINSTANCE) {
            return this.convertToStringGen(eDataType, object);
        }
        return super.convertToString(eDataType, object);
    }

    public String convertToStringGen(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertWDOByteArrayToString(eDataType, object);
            }
            case 3: {
                return this.convertWDODateToString(eDataType, object);
            }
            case 4: {
                return this.convertWDOBigDecimalToString(eDataType, object);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public EDocumentClass createEDocumentClass() {
        EDocumentClassImpl eDocumentClassImpl = new EDocumentClassImpl();
        eDocumentClassImpl.getESuperTypes().add(WdoPackage.eINSTANCE.getEDocument());
        return eDocumentClassImpl;
    }

    public byte[] createWDOByteArrayFromString(EDataType eDataType, String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = this.c2b(cArray[n2++]);
            int n4 = this.c2b(cArray[n2++]);
            byArray[n++] = (byte)(n3 * 16 + n4);
        }
        return byArray;
    }

    protected int c2b(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        throw new NumberFormatException();
    }

    public String convertWDOByteArrayToString(EDataType eDataType, Object object) {
        byte[] byArray = (byte[])object;
        char[] cArray = new char[byArray.length * 2];
        char[] cArray2 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = (byArray[n] & 0xF0) / 16;
            int n4 = byArray[n++] & 0xF;
            cArray[n2++] = cArray2[n3];
            cArray[n2++] = cArray2[n4];
        }
        return new String(cArray);
    }

    public Date createWDODateFromString(EDataType eDataType, String string) {
        long l = Long.parseLong(string);
        return new Date(l);
    }

    public String convertWDODateToString(EDataType eDataType, Object object) {
        long l = ((Date)object).getTime();
        return String.valueOf(l);
    }

    public BigDecimal createWDOBigDecimalFromString(EDataType eDataType, String string) {
        return new BigDecimal(string);
    }

    public String convertWDOBigDecimalToString(EDataType eDataType, Object object) {
        return object.toString();
    }

    public WdoPackage getWdoPackage() {
        return (WdoPackage)this.getEPackage();
    }

    public static WdoPackage getPackage() {
        return WdoPackage.eINSTANCE;
    }

    public EDataGraph createEDataGraph(EClass eClass) {
        ResourceSet resourceSet = this.createEDataGraphResourceSet();
        return this.createEDataGraph(eClass, resourceSet);
    }

    public EDataGraph createEDataGraph(EClass eClass, ResourceSet resourceSet) {
        this.defaultInit(eClass, resourceSet);
        EDataGraphImpl eDataGraphImpl = new EDataGraphImpl(eClass, resourceSet);
        return eDataGraphImpl;
    }

    public void defaultInit(EClass eClass, ResourceSet resourceSet) {
        URI uRI;
        Resource resource;
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setName(eClass.getName() + "Package");
            ePackage.setNsPrefix(eClass.getName());
            ePackage.setNsURI(eClass.getName() + ".xml");
            ePackage.getEClassifiers().add(eClass);
            WdoConfig.initPackage(eClass.getEPackage());
        }
        if ((resource = ePackage.eResource()) == null) {
            uRI = URI.createURI((String)ePackage.getNsURI());
            resource = new XMIResourceImpl(uRI);
            resource.getContents().add(ePackage);
        }
        if (!EPackage.Registry.INSTANCE.containsKey(ePackage.getNsURI())) {
            uRI = resource.getResourceSet();
            if (uRI == null) {
                resourceSet.getResources().add(resource);
            } else if (uRI != resourceSet) {
                throw new IllegalArgumentException("EClass " + eClass.getName() + " is already in a ResourceSet.");
            }
        }
    }

    public ResourceSet createEDataGraphResourceSet() {
        return new WdoConfig.WdoResourceSetImpl();
    }

    public EventCreator createEventCreator(DataGraph dataGraph) {
        return new EventCreatorImpl(dataGraph);
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public Store getStore() {
        return this.store;
    }
}

