/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.path;

import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.Accessor;
import com.ibm.etools.wdo.datagraph.impl.AccessorImpl;
import com.ibm.etools.wdo.path.XPathTokenizer;
import java.util.List;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DefaultPath {
    public static Accessor getAccessor(DataObject dataObject, String string) {
        AccessorImpl accessorImpl = new AccessorImpl(dataObject);
        if (XPathTokenizer.hasDelimiters(string)) {
            DefaultPath.process(accessorImpl, string);
        } else {
            accessorImpl.setFeatureName(string);
        }
        return accessorImpl;
    }

    protected static void process(Accessor accessor, String string) {
        XPathTokenizer.Tokens tokens = XPathTokenizer.tokenize(string.toCharArray());
        int n = tokens.size();
        int n2 = 0;
        if ("/".equals(tokens.peek(0))) {
            accessor.setEObject(EcoreUtil.getRootContainer((EObject)accessor.getEObject()));
            ++n2;
        }
        while (n2 < n) {
            String string2 = tokens.peek(n2);
            char c = string2.charAt(0);
            if ('/' == c) {
                EObject eObject = (EObject)accessor.get();
                accessor.setEObject(eObject);
            } else if ("..".equals(string2)) {
                EObject eObject = accessor.getEObject().eContainer();
                if (eObject == null) {
                    throw new IllegalArgumentException("No containing object for " + accessor.getEObject());
                }
                accessor.setEObject(eObject);
            } else if ('.' == c) {
                string2 = tokens.peek(++n2);
                int n3 = Integer.parseInt(string2);
                accessor.setIndex(n3);
            } else if ('[' == c) {
                string2 = tokens.peek(++n2);
                char c2 = tokens.peek(n2 + 1).charAt(0);
                if ('=' != c2) {
                    int n4 = Integer.parseInt(string2) - 1;
                    accessor.setIndex(n4);
                    ++n2;
                } else {
                    String string3;
                    ++n2;
                    if ("\"".equals(string3 = tokens.peek(++n2))) {
                        ++n2;
                        string3 = tokens.peek(++n2);
                    }
                    ++n2;
                    int n5 = DefaultPath.matchingIndex((List)accessor.get(), string2, string3);
                    if (n5 < 0) {
                        throw new IndexOutOfBoundsException("No index with " + string2 + "=" + string3);
                    }
                    accessor.setIndex(n5);
                }
            } else if ('@' == c) {
                ++n2;
            } else {
                accessor.setFeatureName(string2);
            }
            ++n2;
        }
    }

    protected static int matchingIndex(List list, String string, String string2) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            String string3;
            EStructuralFeature eStructuralFeature;
            EObject eObject = (EObject)list.get(n);
            Object object = eObject.eGet(eStructuralFeature = eObject.eClass().getEStructuralFeature(string), true);
            if (object != null && string2.equals(string3 = EcoreUtil.convertToString((EDataType)((EDataType)eStructuralFeature.getEType()), (Object)object))) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

