/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.path;

import org.eclipse.emf.common.util.BasicEList;

public class XPathTokenizer {
    public static boolean hasDelimiters(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Tokens tokenize(char[] cArray) {
        int n = cArray.length;
        Tokens tokens = new Tokens(n);
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c2;
            char c3 = c;
            c = cArray[n2];
            char c4 = c2 = n2 < n - 1 ? cArray[n2 + 1] : (char)'\u0000';
            if (bl) {
                if (c == '\"') {
                    tokens.endToken(stringBuffer, true);
                    bl = false;
                } else {
                    stringBuffer.append(c);
                }
            } else {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (c3 != ' ') {
                            tokens.endToken(stringBuffer, false);
                        }
                        c = ' ';
                        break;
                    }
                    case '\"': {
                        tokens.endToken(stringBuffer, false);
                        tokens.add("\"");
                        bl = true;
                        break;
                    }
                    case '.': 
                    case '/': 
                    case ':': {
                        if (c3 != c) {
                            tokens.endToken(stringBuffer, false);
                        }
                        stringBuffer.append(c);
                        if (c2 == c) break;
                        tokens.endToken(stringBuffer, false);
                        break;
                    }
                    case '(': 
                    case ')': 
                    case '*': 
                    case '@': 
                    case '[': 
                    case ']': 
                    case '|': {
                        tokens.endToken(stringBuffer, false);
                        tokens.add(String.valueOf(c));
                        break;
                    }
                    case '!': {
                        tokens.endToken(stringBuffer, false);
                        stringBuffer.append(c);
                        break;
                    }
                    case '=': {
                        tokens.endToken(stringBuffer, false);
                        tokens.add(String.valueOf(c));
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            ++n2;
        }
        tokens.endToken(stringBuffer, false);
        return tokens;
    }

    public static class Tokens
    extends BasicEList {
        public Tokens(int n) {
            super(n);
        }

        public String peek() {
            return this.size > 0 ? (String)this.data[0] : " ";
        }

        public String peek(int n) {
            return n < this.size ? (String)this.data[n] : " ";
        }

        public Tokens pop() {
            this.remove(0);
            return this;
        }

        public Tokens pop(int n) {
            while (n-- > 0) {
                this.remove(n);
            }
            return this;
        }

        void endToken(StringBuffer stringBuffer, boolean bl) {
            if (bl || stringBuffer.length() > 0) {
                this.add(stringBuffer.toString());
            }
            stringBuffer.setLength(0);
        }

        protected boolean canContainNull() {
            return false;
        }

        protected Object[] newData(int n) {
            return new String[n];
        }
    }
}

