/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.serialization;

import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.DataGraph;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.WdoFactory;
import com.ibm.etools.wdo.datagraph.impl.WdoConfig;
import com.ibm.etools.wdo.serialization.NonCopyingByteArrayOutputStream;
import com.ibm.etools.wdo.xmlmediator.impl.DataGraphResourceImpl;
import com.ibm.etools.wdo.xmlmediator.impl.DataGraphXMLHelperImpl;
import com.ibm.etools.wdo.xmlmediator.impl.EventResourceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DataGraphJavaSerializationHelper
implements Externalizable {
    protected Object realObject;

    public DataGraphJavaSerializationHelper() {
        this.realObject = null;
    }

    public DataGraphJavaSerializationHelper(Object object) {
        this.realObject = object;
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.realObject;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.serialize(this.realObject, objectOutput, false);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.realObject = this.deserialize(objectInput);
    }

    public void serialize(Object object, ObjectOutput objectOutput) throws IOException {
        this.serialize(object, objectOutput, false);
    }

    public void serialize(Object object, ObjectOutput objectOutput, boolean bl) throws IOException {
        EDataGraph eDataGraph = (EDataGraph)object;
        this.saveMetaData(objectOutput, eDataGraph, bl);
        EClass eClass = ((EObject)eDataGraph).eClass();
        Resource resource = eClass.getEPackage().eResource();
        URI uRI = resource.getURI().appendFragment(resource.getURIFragment((EObject)eClass));
        this.writeString(objectOutput, uRI.toString());
        DataGraphXMLHelperImpl dataGraphXMLHelperImpl = new DataGraphXMLHelperImpl((DataGraph)eDataGraph);
        NonCopyingByteArrayOutputStream nonCopyingByteArrayOutputStream = new NonCopyingByteArrayOutputStream();
        try {
            dataGraphXMLHelperImpl.saveDataGraph(new HashMap(), "ASCII", (OutputStream)nonCopyingByteArrayOutputStream);
            int n = nonCopyingByteArrayOutputStream.size();
            objectOutput.writeInt(n);
            objectOutput.write(((ByteArrayOutputStream)nonCopyingByteArrayOutputStream).toByteArray(), 0, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        List list = eDataGraph.getEvents();
        if (list != null && list.size() > 0) {
            EventResourceImpl eventResourceImpl = new EventResourceImpl(URI.createURI((String)"event.xmi"), eDataGraph.getResourceSet());
            eventResourceImpl.getContents().addAll(list);
            this.writeResource(objectOutput, (Resource)eventResourceImpl);
        } else {
            objectOutput.writeInt(0);
        }
    }

    public Object deserialize(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ResourceSet resourceSet = WdoFactory.eINSTANCE.createEDataGraphResourceSet();
        this.readMetaData(objectInput, resourceSet);
        EClass eClass = this.readSchema(objectInput, resourceSet);
        EDataGraph eDataGraph = WdoFactory.eINSTANCE.createEDataGraph(eClass, resourceSet);
        Resource resource = this.readData(objectInput, eDataGraph);
        this.loadDataGraph(eDataGraph, resource);
        eDataGraph.getEventLog().startLogging();
        this.readEvents(objectInput, eDataGraph);
        return eDataGraph;
    }

    protected void writeResource(ObjectOutput objectOutput, Resource resource) throws IOException {
        NonCopyingByteArrayOutputStream nonCopyingByteArrayOutputStream = new NonCopyingByteArrayOutputStream();
        resource.save((OutputStream)nonCopyingByteArrayOutputStream, null);
        int n = nonCopyingByteArrayOutputStream.size();
        objectOutput.writeInt(n);
        objectOutput.write(((ByteArrayOutputStream)nonCopyingByteArrayOutputStream).toByteArray(), 0, n);
    }

    protected void readResource(ObjectInput objectInput, Resource resource) throws IOException {
        int n = objectInput.readInt();
        byte[] byArray = this.readByteArray(objectInput, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
        resource.load((InputStream)byteArrayInputStream, null);
        WdoConfig.initPackages(resource);
    }

    protected void writeString(ObjectOutput objectOutput, String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            byArray[n3] = (byte)(c >>> 8 & 0xFF);
            byArray[n3 + 1] = (byte)(c >>> 0 & 0xFF);
            ++n2;
            n3 += 2;
        }
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray, 0, byArray.length);
    }

    protected String readString(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        byte[] byArray = this.readByteArray(objectInput, n);
        char[] cArray = new char[n /= 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            cArray[n2] = (char)((byArray[n3] << 8) + (byArray[n3 + 1] << 0));
            ++n2;
            n3 += 2;
        }
        return new String(cArray);
    }

    protected byte[] readByteArray(ObjectInput objectInput, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            n2 = objectInput.read(byArray, n2, n - n2) + n2;
        }
        return byArray;
    }

    protected void saveMetaData(ObjectOutput objectOutput, EDataGraph eDataGraph, boolean bl) throws IOException {
        if (bl) {
            EList eList = eDataGraph.getResourceSet().getResources();
            int n = eList.size();
            objectOutput.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                Resource resource = (Resource)eList.get(n2);
                String string = resource.getURI().toString();
                String string2 = resource.getClass().getName();
                this.writeString(objectOutput, string);
                this.writeString(objectOutput, string2);
                ++n2;
            }
            int n3 = n - 1;
            while (n3 >= 0) {
                this.writeResource(objectOutput, (Resource)eList.get(n3));
                --n3;
            }
        } else {
            objectOutput.writeInt(0);
        }
    }

    protected void readMetaData(ObjectInput objectInput, ResourceSet resourceSet) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        EList eList = resourceSet.getResources();
        int n2 = 0;
        while (n2 < n) {
            URI uRI = URI.createURI((String)this.readString(objectInput));
            String string = this.readString(objectInput);
            try {
                Resource resource = (Resource)Class.forName(string).newInstance();
                resource.setURI(uRI);
                eList.add(resource);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new WrappedException((Exception)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                throw new WrappedException((Exception)instantiationException);
            }
            ++n2;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            this.readResource(objectInput, (Resource)eList.get(n3));
            --n3;
        }
    }

    protected EClass readSchema(ObjectInput objectInput, ResourceSet resourceSet) throws IOException {
        URI uRI = URI.createURI((String)this.readString(objectInput));
        return (EClass)resourceSet.getEObject(uRI, true);
    }

    protected Resource readData(ObjectInput objectInput, EDataGraph eDataGraph) throws IOException {
        EClass eClass = ((EObject)eDataGraph).eClass();
        DataGraphResourceImpl dataGraphResourceImpl = new DataGraphResourceImpl(URI.createURI((String)"data"));
        EList eList = eDataGraph.getResourceSet().getResources();
        eList.add(eClass.eResource());
        eList.add(dataGraphResourceImpl);
        this.readResource(objectInput, (Resource)dataGraphResourceImpl);
        return dataGraphResourceImpl;
    }

    protected void loadDataGraph(EDataGraph eDataGraph, Resource resource) {
        DataObject dataObject = (DataObject)resource.getContents().get(0);
        EClass eClass = ((EObject)eDataGraph).eClass();
        EReference eReference = (EReference)eClass.getEAllReferences().get(0);
        String string = eReference.getName();
        ((DataObject)eDataGraph).set(string, dataObject.get(string));
    }

    protected void readEvents(ObjectInput objectInput, EDataGraph eDataGraph) throws IOException {
        int n = objectInput.readInt();
        if (n > 0) {
            EventResourceImpl eventResourceImpl = new EventResourceImpl(URI.createURI((String)"event.xmi"), eDataGraph.getResourceSet());
            byte[] byArray = this.readByteArray(objectInput, n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            eventResourceImpl.load((InputStream)byteArrayInputStream, null);
            WdoConfig.initPackages((Resource)eventResourceImpl);
            eDataGraph.getEvents().addAll(eventResourceImpl.getContents());
        }
    }
}

