/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.serialization;

import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.WdoFactory;
import com.ibm.etools.wdo.datagraph.impl.WdoConfig;
import com.ibm.etools.wdo.serialization.DataGraphJavaSerializationHelper;
import com.ibm.etools.wdo.xmlmediator.impl.DataGraphXMLHelperImpl;
import com.ibm.etools.wdo.xmlmediator.impl.EventResourceImpl;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DataObjectJavaSerializationHelper
extends DataGraphJavaSerializationHelper
implements Externalizable {
    public DataObjectJavaSerializationHelper() {
    }

    public DataObjectJavaSerializationHelper(Object object) {
        super(object);
    }

    public void serialize(Object object, ObjectOutput objectOutput, boolean bl) throws IOException {
        DataObject dataObject = (DataObject)object;
        super.serialize(dataObject.getDataGraph(), objectOutput, bl);
        this.writeString(objectOutput, DataGraphXMLHelperImpl.getURIFragment((EObject)((EObject)dataObject)));
    }

    public Object deserialize(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ResourceSet resourceSet = WdoFactory.eINSTANCE.createEDataGraphResourceSet();
        this.readMetaData(objectInput, resourceSet);
        EClass eClass = this.readSchema(objectInput, resourceSet);
        EDataGraph eDataGraph = WdoFactory.eINSTANCE.createEDataGraph(eClass, resourceSet);
        Resource resource = this.readData(objectInput, eDataGraph);
        List list = this.readObjectEvents(objectInput, eDataGraph);
        String string = this.readString(objectInput);
        DataObject dataObject = (DataObject)resource.getEObject(string);
        this.loadDataGraph(eDataGraph, resource);
        eDataGraph.getEventLog().startLogging();
        if (list != null) {
            eDataGraph.getEvents().addAll(list);
        }
        return dataObject;
    }

    protected List readObjectEvents(ObjectInput objectInput, EDataGraph eDataGraph) throws IOException {
        int n = objectInput.readInt();
        if (n > 0) {
            EventResourceImpl eventResourceImpl = new EventResourceImpl(URI.createURI((String)"event.xmi"), eDataGraph.getResourceSet());
            byte[] byArray = this.readByteArray(objectInput, n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            WdoConfig.initPackages((Resource)eventResourceImpl);
            return eventResourceImpl.getContents();
        }
        return null;
    }
}

