/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.navigator.FilterSelectionAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.SortViewAction;

public class SortAndFilterActionGroup
extends ResourceNavigatorActionGroup {
    private SortViewAction sortByTypeAction;
    private SortViewAction sortByNameAction;
    private FilterSelectionAction filterAction;

    public SortAndFilterActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    protected void makeActions() {
        this.sortByNameAction = new SortViewAction(this.navigator, false);
        this.sortByTypeAction = new SortViewAction(this.navigator, true);
        this.filterAction = new FilterSelectionAction(this.navigator, ResourceNavigatorMessages.getString("ResourceNavigator.filterText"));
        this.filterAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/filter_ps.gif"));
        this.filterAction.setImageDescriptor(this.getImageDescriptor("elcl16/filter_ps.gif"));
        this.filterAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/filter_ps.gif"));
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        MenuManager submenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.sort"));
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this.sortByNameAction);
        submenu.add((IAction)this.sortByTypeAction);
        menu.add((IAction)this.filterAction);
    }

    public void updateActionBars() {
        int criteria = this.navigator.getSorter().getCriteria();
        this.sortByNameAction.setChecked(criteria == 1);
        this.sortByTypeAction.setChecked(criteria == 2);
    }
}

