/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;

public class WorkspaceActionGroup
extends ResourceNavigatorActionGroup {
    private BuildAction buildAction;
    private BuildAction rebuildAction;
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private RefreshAction refreshAction;
    static /* synthetic */ Class class$0;

    public WorkspaceActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.openProjectAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.closeProjectAction);
        super.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("refresh", (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler("buildProject", (IAction)this.buildAction);
        actionBars.setGlobalActionHandler("rebuildProject", (IAction)this.rebuildAction);
        actionBars.setGlobalActionHandler("openProject", (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler("closeProject", (IAction)this.closeProjectAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                project = (IProject)iAdaptable.getAdapter((Class)clazz);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && !ResourcesPlugin.getWorkspace().isAutoBuilding() && hasBuilder) {
            this.buildAction.selectionChanged(selection);
            menu.add((IAction)this.buildAction);
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.add((IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.add((IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.add((IAction)this.closeProjectAction);
            }
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000E && event.stateMask == 0 && this.refreshAction.isEnabled()) {
            this.refreshAction.refreshAll();
        }
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void makeActions() {
        Shell shell = this.navigator.getSite().getShell();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.openProjectAction = new OpenResourceAction(shell);
        workspace.addResourceChangeListener((IResourceChangeListener)this.openProjectAction, 1);
        this.closeProjectAction = new CloseResourceAction(shell);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeProjectAction, 1);
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.refreshAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/refresh_nav.gif"));
        this.buildAction = new BuildAction(shell, 10);
        this.rebuildAction = new BuildAction(shell, 6);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(selection);
        this.buildAction.selectionChanged(selection);
        this.rebuildAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
    }
}

