/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class CopyTaskAction
extends TaskAction {
    public CopyTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.copy_task_action_context");
    }

    public void run() {
        TaskList taskList = this.getTaskList();
        TableViewer viewer = taskList.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        taskList.cancelEditing();
        List list = selection.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        this.setClipboard(markers, TaskList.createMarkerReport(markers));
        taskList.updatePasteEnablement();
    }

    private void setClipboard(IMarker[] markers, String markerReport) {
        block3: {
            try {
                Object[] data = new Object[]{markers, markerReport};
                Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                this.getTaskList().getClipboard().setContents(data, transferTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)WorkbenchMessages.getString((String)"CopyToClipboardProblemDialog.title"), (String)WorkbenchMessages.getString((String)"CopyToClipboardProblemDialog.message"))) break block3;
                this.setClipboard(markers, markerReport);
            }
        }
    }
}

