/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskListMessages;

class GotoTaskAction
extends TaskAction {
    public GotoTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.goto_task_action_context");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.getTaskList().getSelection();
        Object o = selection.getFirstElement();
        if (!(o instanceof IMarker)) {
            return;
        }
        IMarker marker = (IMarker)o;
        IResource resource = marker.getResource();
        if (marker.exists() && resource instanceof IFile) {
            IWorkbenchPage page = this.getTaskList().getSite().getPage();
            try {
                page.openEditor(marker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                DialogUtil.openError((Shell)page.getWorkbenchWindow().getShell(), (String)TaskListMessages.getString("GotoTask.errorMessage"), (String)e.getMessage(), (PartInitException)e);
            }
        }
    }
}

