/*
 * Decompiled with CFR 0.152.
 */
package count;

import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import test.PerfTestBase;
import test.PerfTestResults;

public abstract class CounterBase
extends PerfTestBase
implements PerfTestResults {
    private boolean fJustCounting;
    private String fLabel;
    protected int fElemCount;
    protected int fAttrCount;
    protected int fCharCount;
    protected int fSpaceCount;

    protected CounterBase(ParsedEntityFactory parsedEntityFactory) {
        super(parsedEntityFactory);
    }

    protected int processSwitch(String[] stringArray, int n) throws Exception {
        int n2 = super.processSwitch(stringArray, n);
        if (n2 != n) {
            return n2;
        }
        String string = stringArray[n];
        if (string.charAt(0) != '-') {
            return n;
        }
        switch (string.charAt(1)) {
            case 'c': {
                this.fJustCounting = true;
                this.fIterations = 1;
                return ++n;
            }
            case 'l': {
                this.fLabel = stringArray[++n];
                return ++n;
            }
        }
        return n;
    }

    protected void count(String[] stringArray) throws Exception {
        this.fLabel = null;
        this.fJustCounting = false;
        super.runPerfTest(stringArray, this);
    }

    public void recordResult(EntityInputSource entityInputSource, double d, int n) {
        String string = entityInputSource.getSystemId();
        int n2 = string.lastIndexOf(92);
        int n3 = string.lastIndexOf(47);
        XMLString xMLString = entityInputSource.getContent();
        boolean bl = false;
        if (xMLString == null) {
            xMLString = this.fEntityContent;
            if (xMLString.endOffset == 0) {
                ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, true);
                parsedEntity.getContent(xMLString);
                bl = true;
            }
        }
        int n4 = xMLString.endOffset - xMLString.offset;
        if (bl) {
            xMLString.endOffset = 0;
        }
        if (n2 > n3) {
            string = string.substring(n2 + 1);
        } else if (n3 >= 0) {
            string = string.substring(n3 + 1);
        }
        if (this.fJustCounting) {
            if (this.fLabel != null) {
                System.out.print(this.fLabel);
                System.out.print(":");
                System.out.print(string);
                System.out.print(":");
                System.out.print(n4);
                System.out.print(":");
                System.out.print(this.fElemCount);
                System.out.print(":");
                System.out.print(this.fAttrCount);
                System.out.print(":");
                System.out.print(this.fCharCount);
                System.out.print(":");
                System.out.print(this.fSpaceCount);
            } else {
                System.out.print(string);
                System.out.print(": ");
                System.out.print(n4);
                System.out.print(" bytes (");
                System.out.print(this.fElemCount);
                System.out.print(" elems, ");
                System.out.print(this.fAttrCount);
                System.out.print(" attrs, ");
                System.out.print(this.fCharCount);
                System.out.print(" chars, ");
                System.out.print(this.fSpaceCount);
                System.out.print(" spaces)");
            }
        } else {
            double d2 = (double)n * 1000000.0 / d;
            double d3 = 1.0E9 / d2;
            double d4 = (double)n4 * d2 / 1048576.0;
            if (this.fLabel != null) {
                System.out.print(this.fLabel);
                System.out.print(":");
                System.out.print(string);
                System.out.print(":");
                System.out.print(n4);
                System.out.print(":");
                System.out.print((double)((int)d3) / 1000.0);
                System.out.print(":");
                System.out.print((double)((int)d2) / 1000.0);
                System.out.print(":");
                System.out.print((double)((int)d4) / 1000.0);
            } else {
                System.out.print(string);
                System.out.print(": ");
                System.out.print(n4);
                System.out.print(" bytes, ");
                System.out.print((double)((int)d3) / 1000.0);
                System.out.print(" ms (");
                System.out.print((double)((int)d2) / 1000.0);
                System.out.print(" docs/sec, ");
                System.out.print((double)((int)d4) / 1000.0);
                System.out.print(" MB/sec)");
            }
        }
        System.out.println();
    }
}

