/*
 * Decompiled with CFR 0.152.
 */
package count.sax;

import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ByteArrayParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import count.CounterBase;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAX2Counter
extends CounterBase
implements ErrorHandler,
EntityResolver,
ContentHandler {
    private static final boolean COUNT_ALL_CHARS = true;
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private String fParserName = "org.apache.xerces.parsers.SAXParser";
    private XMLReader fXMLReader;
    private InputSource fInputSource;
    private boolean fValidation;
    private boolean fCachingEnabled;
    private boolean fExternalGeneralEntities = true;
    private boolean fExternalParameterEntities = true;
    private boolean fWarmingUp;
    private EntityInputSource fTempSource;

    protected int processSwitch(String[] stringArray, int n) throws Exception {
        int n2 = super.processSwitch(stringArray, n);
        if (n2 != n) {
            return n2;
        }
        String string = stringArray[n];
        if (!string.startsWith("-")) {
            return n;
        }
        if (string.equals("-p")) {
            if (n == stringArray.length - 1) {
                System.err.println("error: missing parser name");
                System.exit(1);
            }
            this.fParserName = stringArray[++n];
            this.fXMLReader = null;
            return ++n;
        }
        if (string.equals("-v")) {
            this.fValidation = true;
            return ++n;
        }
        if (string.equals("-gc")) {
            this.fCachingEnabled = true;
            return ++n;
        }
        if (string.equals("-noge")) {
            this.fExternalGeneralEntities = false;
            return ++n;
        }
        if (string.equals("-nope")) {
            this.fExternalParameterEntities = false;
            return ++n;
        }
        SAX2Counter.printUsage();
        System.exit(1);
        return n;
    }

    protected void parseSetup(String string) throws Exception {
        super.parseSetup(string);
        if (this.fXMLReader == null) {
            this.fXMLReader = XMLReaderFactory.createXMLReader(this.fParserName);
            this.fXMLReader.setErrorHandler(this);
            this.fXMLReader.setEntityResolver(this);
            this.fXMLReader.setContentHandler(this);
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/validation", this.fValidation);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/validation/grammar-caching-enabled", this.fCachingEnabled);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.fExternalGeneralEntities);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", this.fExternalParameterEntities);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.fWarmingUp = true;
    }

    protected boolean runDocumentTest(EntityInputSource entityInputSource) {
        this.fElemCount = 0;
        this.fAttrCount = 0;
        this.fCharCount = 0;
        this.fSpaceCount = 0;
        try {
            XMLString xMLString = entityInputSource.getContent();
            if (this.fInputSource == null) {
                this.fInputSource = new InputSource();
            }
            this.fInputSource.setPublicId(entityInputSource.getPublicId());
            this.fInputSource.setSystemId(entityInputSource.getSystemId());
            this.fInputSource.setEncoding(entityInputSource.getEncoding());
            this.fInputSource.setByteStream(entityInputSource.getByteStream());
            this.fInputSource.setCharacterStream(entityInputSource.getCharacterStream());
            if (xMLString == null) {
                this.fXMLReader.parse(this.fInputSource);
                return true;
            }
            if (xMLString.bytes != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xMLString.bytes, xMLString.offset, xMLString.endOffset - xMLString.offset);
                this.fInputSource.setByteStream(byteArrayInputStream);
            } else if (xMLString.chars != null) {
                CharArrayReader charArrayReader = new CharArrayReader(xMLString.chars, xMLString.offset, xMLString.endOffset - xMLString.offset);
                this.fInputSource.setCharacterStream(charArrayReader);
            } else {
                String string = xMLString.toString();
                StringReader stringReader = new StringReader(string);
                this.fInputSource.setCharacterStream(stringReader);
            }
            this.fXMLReader.parse(this.fInputSource);
        }
        catch (SAXParseException sAXParseException) {
            if (!this.fWarmingUp) {
                sAXParseException.printStackTrace(System.err);
            } else {
                this.fWarmingUp = false;
            }
            return false;
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return false;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.fWarmingUp) {
            return;
        }
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        if (this.fWarmingUp) {
            return;
        }
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) {
        if (this.fWarmingUp) {
            return null;
        }
        return null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.fWarmingUp) {
            return;
        }
        this.fElemCount += string3.length();
        if (attributes != null) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string4 = attributes.getQName(n2);
                this.fAttrCount += string4.length();
                String string5 = attributes.getValue(n2);
                this.fCharCount += string5.length();
                ++n2;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.fWarmingUp) {
            return;
        }
        this.fCharCount += n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (this.fWarmingUp) {
            return;
        }
        this.fSpaceCount += n2;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.fWarmingUp = false;
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void endElement(String string, String string2, String string3) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void skippedEntity(String string) {
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private static void printUsage() {
        System.err.println("usage: java count.sax.SAX2Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify SAX parser by name.");
        System.err.println("           Default parser: org.apache.xerces.parsers.SAXParser");
        System.err.println("  -v       Turn on validation.");
        System.err.println("  -gc      Turn on grammar caching.");
        System.err.println("  -noge    Turn off external general entities.");
        System.err.println("  -nope    Turn off external parameter entities.");
        System.err.println("  -h       This help screen.");
    }

    public SAX2Counter() {
        super((ParsedEntityFactory)new ByteArrayParsedEntityFactory(true));
    }

    public static void main(String[] stringArray) {
        try {
            SAX2Counter sAX2Counter = new SAX2Counter();
            sAX2Counter.count(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

