/*
 * Decompiled with CFR 0.152.
 */
package sax;

import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.ErrorReporter;
import com.ibm.xml.b2b.util.IANACharset;
import com.ibm.xml.b2b.util.IOExceptionWrapper;
import com.ibm.xml.b2b.util.MessageProvider;
import com.ibm.xml.b2b.util.MessageProviderRegistry;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import sax.ExtendedDefaultHandler;
import sax.SAXExceptionWrapper;
import util.DocumentEntityParserBase;

public abstract class SAX2DocumentEntityParserBase
extends DocumentEntityParserBase
implements Attributes,
Locator,
XMLReader,
ErrorReporter {
    private static final boolean RETAIN_OBJECTS_ACROSS_RESET = true;
    private static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    private static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    private ExtendedDefaultHandler fDefaultHandler;
    private EntityInputSource fEntityInputSource = new EntityInputSource();
    private EntityResolver fResolver;
    private ErrorHandler fErrorHandler;
    private ContentHandler fContentHandler;
    private DTDHandler fDTDHandler;
    private DeclHandler fDeclHandler;
    private LexicalHandler fLexicalHandler;
    private char[][] fCharBuffer;
    private int[] fCharBufferOffset;
    private boolean fNamespacePrefixes;
    private boolean fNeedReset;
    private int fAttrCount;
    private int fAttrOffset;
    private EncodingSupport fTargetEncoding;

    protected SAX2DocumentEntityParserBase() {
        this.fDefaultHandler = new ExtendedDefaultHandler();
        this.fDTDHandler = this.fDefaultHandler;
        this.fContentHandler = this.fDefaultHandler;
        this.fErrorHandler = this.fDefaultHandler;
        this.fDeclHandler = this.fDefaultHandler;
        this.fLexicalHandler = this.fDefaultHandler;
        this.fCharBuffer = new char[1][256];
        this.fCharBufferOffset = new int[1];
        String string = System.getProperty("b2bxml.SAX2DocumentEntityParserBase.TargetCharset", null);
        if (string != null) {
            this.fTargetEncoding = IANACharset.getEncodingSupport((String)string.toUpperCase());
        }
    }

    protected void startPrefixMapping(String string, String string2) {
        try {
            this.fContentHandler.startPrefixMapping(string, string2);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void endPrefixMapping(String string) {
        try {
            this.fContentHandler.endPrefixMapping(string);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void startElement(QName qName, boolean bl) {
        try {
            this.fAttrCount = -1;
            this.fContentHandler.startElement(qName.namespaceURI, qName.localPart, qName.str, this);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void startElementAction(boolean bl) {
        try {
            QName qName = this.fDocumentScannerSupport.currentElement;
            super.startPrefixMappings();
            this.startElement(qName, bl);
            if (bl) {
                this.fContentHandler.endElement(qName.namespaceURI, qName.localPart, qName.str);
                super.endPrefixMappings();
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void endElementAction() {
        try {
            QName qName = this.fDocumentScannerSupport.currentElement;
            this.fContentHandler.endElement(qName.namespaceURI, qName.localPart, qName.str);
            super.endPrefixMappings();
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void characters(XMLString xMLString) {
        char[][] cArray = this.fCharBuffer;
        int[] nArray = this.fCharBufferOffset;
        nArray[0] = 0;
        xMLString.getChars(cArray, nArray);
        try {
            this.fContentHandler.characters(cArray[0], 0, nArray[0]);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void character(int n, boolean bl) {
        int n2;
        if (n < 65536) {
            this.fCharBuffer[0][0] = (char)n;
            n2 = 1;
        } else {
            int n3 = n - 65536;
            this.fCharBuffer[0][0] = (char)(55296 + (n3 >> 10));
            this.fCharBuffer[0][1] = (char)(56320 + (n3 & 0x3FF));
            n2 = 2;
        }
        try {
            this.fContentHandler.characters(this.fCharBuffer[0], 0, n2);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void processingInstruction(XMLName xMLName, XMLString xMLString) {
        this.fSymbolTable.addSymbol((XMLString)xMLName);
        try {
            this.fContentHandler.processingInstruction(xMLName.str, xMLString.toString());
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public boolean scanExternalSubset() {
        boolean bl = super.scanExternalSubset();
        try {
            this.fLexicalHandler.endDTD();
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        return bl;
    }

    public boolean skippedExternalSubsetEntity() {
        try {
            this.fContentHandler.skippedEntity("[dtd]");
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        return true;
    }

    public void startCDATA() {
        super.startCDATA();
        try {
            this.fLexicalHandler.startCDATA();
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void endCDATA() {
        super.endCDATA();
        try {
            this.fLexicalHandler.endCDATA();
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void comment(XMLString xMLString) {
        char[] cArray = xMLString.toString().toCharArray();
        try {
            this.fLexicalHandler.comment(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public boolean skippedEntityInContent(int n) {
        try {
            this.fContentHandler.skippedEntity(this.fSymbolTable.toString(n));
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        return true;
    }

    public void reportWarning(String string, int n, Object[] objectArray) {
        try {
            MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider((String)string);
            String string2 = messageProvider.createMessage(null, n, objectArray);
            SAXParseException sAXParseException = new SAXParseException(string2, this);
            this.fErrorHandler.warning(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void reportRecoverableError(String string, int n, Object[] objectArray) {
        try {
            MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider((String)string);
            String string2 = messageProvider.createMessage(null, n, objectArray);
            SAXParseException sAXParseException = new SAXParseException(string2, this);
            this.fErrorHandler.error(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void reportFatalError(String string, int n, Object[] objectArray) {
        try {
            MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider((String)string);
            String string2 = messageProvider.createMessage(null, n, objectArray);
            SAXParseException sAXParseException = new SAXParseException(string2, this);
            this.fErrorHandler.fatalError(sAXParseException);
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public int getLength() {
        if (this.fAttrCount != -1) {
            return this.fAttrCount;
        }
        this.fAttrOffset = this.fNamespacePrefixes ? this.fDocumentScannerSupport.lastMapping - this.fDocumentScannerSupport.firstMapping : 0;
        this.fAttrCount = this.fAttrOffset + this.fDocumentScannerSupport.attrCount;
        return this.fAttrCount;
    }

    public String getURI(int n) {
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fDocumentScannerSupport.attrNames[n - this.fAttrOffset].namespaceURI;
            }
        } else if (n >= 0) {
            return "";
        }
        return null;
    }

    public String getLocalName(int n) {
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fDocumentScannerSupport.attrNames[n - this.fAttrOffset].localPart;
            }
        } else if (n >= 0) {
            return "";
        }
        return null;
    }

    public String getQName(int n) {
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fDocumentScannerSupport.attrNames[n - this.fAttrOffset].str;
            }
        } else if (n >= 0) {
            int n2 = this.fDocumentScannerSupport.firstMapping + n;
            return this.fDocumentScannerSupport.nsDeclQNames[n2];
        }
        return null;
    }

    public String getType(int n) {
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                String string = this.fDocumentScannerSupport.attTypes[n - this.fAttrOffset];
                if (string == null) {
                    return "NMTOKEN";
                }
                if (string.length() == 0) {
                    return "CDATA";
                }
                return string;
            }
        } else if (n >= 0) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(int n) {
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fDocumentScannerSupport.attValues[n -= this.fAttrOffset].toString();
            }
        } else if (n >= 0) {
            int n2 = this.fDocumentScannerSupport.firstMapping + n;
            return this.fDocumentScannerSupport.namespaceURIs[n2];
        }
        return null;
    }

    public int getIndex(String string, String string2) {
        int n = this.fAttrCount - this.fAttrOffset;
        if (n > 0) {
            String string3 = null;
            string2 = string2.intern();
            int n2 = 0;
            while (n2 < n) {
                QName qName = this.fDocumentScannerSupport.attrNames[n2];
                if (string2 == qName.localPart) {
                    if (string3 == null) {
                        string3 = string.intern();
                    }
                    if (string3 == qName.namespaceURI) {
                        return this.fAttrOffset + n2;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }

    public int getIndex(String string) {
        if (this.fAttrCount > 0) {
            int n = this.fAttrCount - this.fAttrOffset;
            string = string.intern();
            int n2 = 0;
            while (n2 < n) {
                if (string == this.fDocumentScannerSupport.attrNames[n2].str) {
                    return this.fAttrOffset + n2;
                }
                ++n2;
            }
            int n3 = this.fDocumentScannerSupport.firstMapping;
            int n4 = 0;
            while (n4 < this.fAttrOffset) {
                if (string == this.fDocumentScannerSupport.nsDeclQNames[n3++]) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.getType(n);
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return this.getType(n);
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.getValue(n);
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return this.getValue(n);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("namespaces")) {
                return true;
            }
            if (string2.equals("namespace-prefixes")) {
                return this.fNamespacePrefixes;
            }
            if (string2.equals("string-interning")) {
                return false;
            }
            if (string2.equals("validation")) {
                return false;
            }
            if (string2.equals("external-general-entities")) {
                return false;
            }
            if (string2.equals("external-parameter-entities")) {
                return false;
            }
            if (string2.equals("lexical-handler/parameter-entities")) {
                return false;
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("namespaces")) {
                if (!bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("namespace-prefixes")) {
                this.fNamespacePrefixes = bl;
                return;
            }
            if (string2.equals("string-interning")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("validation")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("external-general-entities")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("external-parameter-entities")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("lexical-handler/parameter-entities") && bl) {
                throw new SAXNotSupportedException(string);
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("lexical-handler")) {
                return this.fLexicalHandler;
            }
            if (string2.equals("declaration-handler")) {
                return this.fDeclHandler;
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("lexical-handler")) {
                try {
                    this.fLexicalHandler = (LexicalHandler)object;
                    if (this.fLexicalHandler == null) {
                        this.fLexicalHandler = this.fDefaultHandler;
                    }
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
            if (string2.equals("declaration-handler")) {
                try {
                    this.fDeclHandler = (DeclHandler)object;
                    if (this.fDeclHandler == null) {
                        this.fDeclHandler = this.fDefaultHandler;
                    }
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    public boolean resolveExternalEntity(EntityInputSource entityInputSource) {
        if (this.fResolver != null) {
            try {
                String string = entityInputSource.getPublicId();
                String string2 = entityInputSource.getSystemId();
                InputSource inputSource = this.fResolver.resolveEntity(string, string2);
                if (inputSource != null) {
                    entityInputSource.setPublicId(inputSource.getPublicId());
                    entityInputSource.setSystemId(inputSource.getSystemId());
                    entityInputSource.setEncoding(inputSource.getEncoding());
                    entityInputSource.setByteStream(inputSource.getByteStream());
                    entityInputSource.setCharacterStream(inputSource.getCharacterStream());
                    entityInputSource.setBaseURI(null);
                    entityInputSource.setContent(null);
                }
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }
        return true;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler != null ? dTDHandler : this.fDefaultHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler != null ? contentHandler : this.fDefaultHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler != null ? errorHandler : this.fDefaultHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    private void parseEntity(EntityInputSource entityInputSource) throws SAXException, IOException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        try {
            this.fContentHandler.setDocumentLocator(this);
            this.fContentHandler.startDocument();
            if (this.fTargetEncoding != null) {
                ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, true);
                XMLString xMLString = new XMLString();
                byte[][] byArray = new byte[1][256];
                int[] nArray = new int[1];
                parsedEntity.getContent(xMLString);
                if (xMLString.chars == null) {
                    char[][] cArray = new char[1][256];
                    int[] nArray2 = new int[1];
                    xMLString.encoding.convertBytesToChars(xMLString.bytes, xMLString.offset, xMLString.endOffset, cArray, nArray2);
                    xMLString.setValues(cArray[0], 0, nArray2[0]);
                }
                this.fTargetEncoding.convertCharsToBytes(xMLString.chars, xMLString.offset, xMLString.endOffset, byArray, nArray);
                int n = nArray[0];
                xMLString.setValues(byArray[0], 0, n, this.fTargetEncoding);
                if (n == xMLString.bytes.length) {
                    xMLString.bytes = new byte[n << 1];
                    System.arraycopy(byArray[0], 0, xMLString.bytes, 0, n);
                    byArray[0] = xMLString.bytes;
                }
                xMLString.bytes[n] = 0;
                parsedEntity.release();
                entityInputSource.setContent(xMLString);
            }
            super.parse(entityInputSource);
            this.fContentHandler.endDocument();
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            throw iOExceptionWrapper.getIOException();
        }
        catch (SAXExceptionWrapper sAXExceptionWrapper) {
            throw sAXExceptionWrapper.getSAXException();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception.getMessage());
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.fEntityInputSource.setPublicId(inputSource.getPublicId());
        this.fEntityInputSource.setSystemId(inputSource.getSystemId());
        this.fEntityInputSource.setEncoding(inputSource.getEncoding());
        this.fEntityInputSource.setByteStream(inputSource.getByteStream());
        this.fEntityInputSource.setCharacterStream(inputSource.getCharacterStream());
        this.fEntityInputSource.setBaseURI(null);
        this.fEntityInputSource.setContent(null);
        this.parseEntity(this.fEntityInputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.fEntityInputSource.clear();
        this.fEntityInputSource.setSystemId(string);
        this.parseEntity(this.fEntityInputSource);
        Reader reader = this.fEntityInputSource.getCharacterStream();
        if (reader != null) {
            reader.close();
        } else {
            InputStream inputStream = this.fEntityInputSource.getByteStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

