/*
 * Decompiled with CFR 0.152.
 */
package sax.level0;

import com.ibm.xml.b2b.level0.L0DocumentEventHandler;
import com.ibm.xml.b2b.level0.L0DocumentScanner;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.UTF8EncodingSupport;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ByteArrayParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import sax.SAXExceptionWrapper;

public class L0SAX2Parser
extends DefaultHandler
implements Locator,
XMLReader,
Attributes,
L0DocumentEventHandler,
DeclHandler,
LexicalHandler {
    private EntityResolver fResolver;
    private DTDHandler fDTDHandler;
    private ContentHandler fContentHandler;
    private ErrorHandler fErrorHandler;
    private DeclHandler fDeclHandler;
    private LexicalHandler fLexicalHandler;
    private EncodingSupport fDefaultEncoding = UTF8EncodingSupport.getInstance();
    private EncodingSupport fEncoding;
    private String fElementType;
    private char[] fChars = new char[256];
    private int fAttrsCount;
    private String[] fAttNames = new String[32];
    private String[] fAttValues = new String[32];
    private XMLString fTempString = new XMLString();
    private ByteArrayParsedEntityFactory fEntityFactory;
    private EntityInputSource fEntityInputSource;
    private XMLString fEntityContent;
    private static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    private static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";

    public L0SAX2Parser() {
        this.fResolver = this;
        this.fDTDHandler = this;
        this.fContentHandler = this;
        this.fErrorHandler = this;
        this.fDeclHandler = this;
        this.fLexicalHandler = this;
        this.fEntityFactory = new ByteArrayParsedEntityFactory(true);
        this.fEntityInputSource = new EntityInputSource();
        this.fEntityContent = new XMLString();
    }

    private String createString(byte[] byArray, int n, int n2) {
        this.fTempString.setValues(byArray, n, n2, this.fEncoding);
        return this.fTempString.toString();
    }

    public void startElement(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        this.fElementType = this.createString(byArray, n, n + n2);
        this.fAttrsCount = 0;
        if (!bl) {
            this.endOfAttributes(bl2);
        }
    }

    public void attributeName(byte[] byArray, int n, int n2) {
        if (this.fAttrsCount == this.fAttNames.length) {
            String[] stringArray = new String[this.fAttrsCount << 1];
            System.arraycopy(this.fAttNames, 0, stringArray, 0, this.fAttrsCount);
            this.fAttNames = stringArray;
            stringArray = new String[this.fAttrsCount << 1];
            System.arraycopy(this.fAttValues, 0, stringArray, 0, this.fAttrsCount);
            this.fAttValues = stringArray;
        }
        ++this.fAttrsCount;
        this.fAttNames[this.fAttrsCount - 1] = this.createString(byArray, n, n + n2);
        this.fAttValues[this.fAttrsCount - 1] = "";
    }

    public void attributeValueCharacters(byte[] byArray, int n, int n2) {
        int n3 = this.fAttrsCount - 1;
        this.fAttValues[n3] = this.fAttValues[n3] + this.createString(byArray, n, n + n2);
    }

    public void attributeValueCharacter(int n, boolean bl) {
        String string;
        if (n < 65536) {
            this.fChars[0] = (char)n;
            string = new String(this.fChars, 0, 1);
        } else {
            int n2 = n - 65536;
            this.fChars[0] = (char)(55296 + (n2 >> 10));
            this.fChars[1] = (char)(56320 + (n2 & 0x3FF));
            string = new String(this.fChars, 0, 2);
        }
        int n3 = this.fAttrsCount - 1;
        this.fAttValues[n3] = this.fAttValues[n3] + string;
    }

    public void endOfAttributes(boolean bl) {
        try {
            this.fContentHandler.startElement("", "", this.fElementType, this);
            this.fAttrsCount = 0;
            if (bl) {
                this.fContentHandler.endElement("", "", this.fElementType);
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public boolean endElement(byte[] byArray, int n, int n2, int n3) {
        this.fElementType = this.createString(byArray, n, n + n2);
        try {
            this.fContentHandler.endElement("", "", this.fElementType);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        return true;
    }

    public boolean characters(byte[] byArray, int n, int n2) {
        String string = this.createString(byArray, n, n + n2);
        int n3 = string.length();
        if (n3 > this.fChars.length) {
            int n4 = this.fChars.length << 1;
            while (n3 > n4) {
                n4 <<= 1;
            }
            this.fChars = new char[n4];
        }
        string.getChars(0, n3, this.fChars, 0);
        try {
            this.fContentHandler.characters(this.fChars, 0, n3);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        return true;
    }

    public void character(int n, boolean bl) {
        int n2;
        if (n < 65536) {
            this.fChars[0] = (char)n;
            n2 = 1;
        } else {
            int n3 = n - 65536;
            this.fChars[0] = (char)(55296 + (n3 >> 10));
            this.fChars[1] = (char)(56320 + (n3 & 0x3FF));
            n2 = 2;
        }
        try {
            this.fContentHandler.characters(this.fChars, 0, n2);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void processingInstruction(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = this.createString(byArray, n, n + n2);
        String string2 = this.createString(byArray, n3, n3 + n4);
        try {
            this.fContentHandler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("getFeature() not supported");
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
            return;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotSupportedException("setFeature() not supported");
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("getProperty() not supported");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("setProperty() not supported");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fResolver = entityResolver != null ? entityResolver : this;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler != null ? dTDHandler : this;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler != null ? contentHandler : this;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler != null ? errorHandler : this;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    private void parseEntity(EntityInputSource entityInputSource) throws SAXException, IOException {
        try {
            ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, true);
            parsedEntity.getContent(this.fEntityContent);
            this.fEncoding = this.fEntityContent.encoding;
            this.fContentHandler.setDocumentLocator(this);
            this.fContentHandler.startDocument();
            L0DocumentScanner.scanDocument((L0DocumentEventHandler)this, null, (byte[])this.fEntityContent.bytes, (int)this.fEntityContent.endOffset, (int)this.fEntityContent.offset);
            this.fContentHandler.endDocument();
            parsedEntity.release();
        }
        catch (SAXExceptionWrapper sAXExceptionWrapper) {
            throw sAXExceptionWrapper.getSAXException();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception.getMessage());
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.fEntityInputSource.setPublicId(inputSource.getPublicId());
        this.fEntityInputSource.setSystemId(inputSource.getSystemId());
        this.fEntityInputSource.setEncoding(inputSource.getEncoding());
        this.fEntityInputSource.setByteStream(inputSource.getByteStream());
        this.fEntityInputSource.setCharacterStream(inputSource.getCharacterStream());
        this.fEntityInputSource.setBaseURI(null);
        this.fEntityInputSource.setContent(null);
        this.parseEntity(this.fEntityInputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.fEntityInputSource.clear();
        this.fEntityInputSource.setSystemId(string);
        this.parseEntity(this.fEntityInputSource);
        Reader reader = this.fEntityInputSource.getCharacterStream();
        if (reader != null) {
            reader.close();
        } else {
            InputStream inputStream = this.fEntityInputSource.getByteStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public int getLength() {
        return this.fAttrsCount;
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.fAttrsCount) {
            return null;
        }
        return "";
    }

    public String getLocalName(int n) {
        if (n < 0 || n >= this.fAttrsCount) {
            return null;
        }
        return "";
    }

    public String getQName(int n) {
        if (n < 0 || n >= this.fAttrsCount) {
            return null;
        }
        return this.fAttNames[n];
    }

    public String getType(int n) {
        if (n < 0 || n >= this.fAttrsCount) {
            return null;
        }
        return "CDATA";
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.fAttrsCount) {
            return null;
        }
        return this.fAttValues[n];
    }

    public int getIndex(String string, String string2) {
        return -1;
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.fAttrsCount) {
            if (string.equals(this.fAttNames[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        return null;
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return this.getType(n);
    }

    public String getValue(String string, String string2) {
        return null;
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return this.getValue(n);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }
}

