/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.IANACharset;
import com.ibm.xml.b2b.util.IOExceptionWrapper;
import com.ibm.xml.b2b.util.JavaEncodingSupport;
import com.ibm.xml.b2b.util.ReusableByteArrayInputStream;
import com.ibm.xml.b2b.util.UTF8EncodingSupport;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import java.io.CharArrayReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import test.PerfTestResults;

public abstract class PerfTestBase
extends Thread {
    protected static boolean TRACE_ITERATION_LOGIC = false;
    protected static int SECONDS_PER_SAMPLE = 1;
    protected static double MINIMUM_DURATION_PER_SAMPLE = SECONDS_PER_SAMPLE * 750;
    protected static int INITIAL_DOCS_PER_SEC = 2000 / SECONDS_PER_SAMPLE;
    private static final int MODE_URI = 0;
    private static final int MODE_STREAM = 1;
    private static final int MODE_READER = 2;
    private static final int MODE_BYTES = 3;
    private static final int MODE_CHARS = 4;
    private static final int MODE_STRING = 5;
    protected int fProcessingMode;
    protected String fSourceEncodingName;
    protected String fTargetEncodingName;
    protected boolean fUseSockets;
    protected int fWarmupIterations;
    protected int fIterations;
    protected ParsedEntityFactory fEntityFactory;
    protected XMLString fEntityContent;
    protected EntityInputSource fSource;
    protected ReusableByteArrayInputStream fByteStream;
    protected ReusableCharArrayReader fCharReader;
    protected byte[][] fBytes;
    protected int[] fBytesOffset;
    protected char[][] fChars;
    protected int[] fCharsOffset;
    private ServerSocket fServerSocket;

    protected abstract boolean runDocumentTest(EntityInputSource var1);

    private PerfTestBase() {
    }

    protected PerfTestBase(ParsedEntityFactory parsedEntityFactory) {
        this.fEntityFactory = parsedEntityFactory;
        this.fBytes = new byte[1][256];
        this.fBytesOffset = new int[1];
        this.fChars = new char[1][256];
        this.fCharsOffset = new int[1];
    }

    public void run() {
        EntityInputSource entityInputSource = new EntityInputSource();
        XMLString xMLString = new XMLString();
        byte[] byArray = new byte[262144];
        xMLString.bytes = byArray;
        xMLString.offset = 0;
        try {
            while (true) {
                Socket socket = this.fServerSocket.accept();
                socket.setTcpNoDelay(true);
                InputStream inputStream = socket.getInputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                Runtime.getRuntime().gc();
                long l = System.currentTimeMillis();
                while (true) {
                    int n;
                    int n2 = 0;
                    while (n2 < 4) {
                        n = inputStream.read(byArray, n2, 4 - n2);
                        if (n == -1) {
                            throw new RuntimeException("unexpected EOF");
                        }
                        n2 += n;
                    }
                    int n3 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 0;
                    if (n3 == 0) break;
                    n = byArray.length;
                    while (n3 + 1 > n) {
                        n <<= 1;
                    }
                    if (n > byArray.length) {
                        byArray = new byte[n];
                        xMLString.bytes = byArray;
                    }
                    n2 = 0;
                    while (n3 > 0) {
                        n = inputStream.read(byArray, n2, n3);
                        if (n == -1) {
                            throw new RuntimeException("unexpected EOF");
                        }
                        n2 += n;
                        n3 -= n;
                    }
                    byArray[n2] = 0;
                    xMLString.endOffset = n2;
                    entityInputSource.setContent(xMLString);
                    this.runDocumentTest(entityInputSource);
                }
                long l2 = System.currentTimeMillis();
                double d = l2 - l;
                dataOutputStream.writeDouble(d);
                dataOutputStream.flush();
                inputStream.close();
                dataOutputStream.close();
                socket.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private int getServicePort() {
        return this.fServerSocket.getLocalPort();
    }

    private double parse(int n) {
        double d;
        EntityInputSource entityInputSource = this.fSource;
        if (!this.fUseSockets) {
            long l;
            long l2;
            switch (this.fProcessingMode) {
                case 0: {
                    Runtime.getRuntime().gc();
                    l2 = System.currentTimeMillis();
                    int n2 = 0;
                    while (n2 < n) {
                        if (!this.runDocumentTest(entityInputSource)) {
                            return -1.0;
                        }
                        ++n2;
                    }
                    l = System.currentTimeMillis();
                    break;
                }
                case 1: {
                    if (this.fByteStream == null) {
                        this.fByteStream = new ReusableByteArrayInputStream(this.fEntityContent.bytes, this.fEntityContent.offset, this.fEntityContent.endOffset - this.fEntityContent.offset);
                    }
                    Runtime.getRuntime().gc();
                    l2 = System.currentTimeMillis();
                    int n3 = 0;
                    while (n3 < n) {
                        this.fByteStream.setBuffer(this.fEntityContent.bytes, this.fEntityContent.offset, this.fEntityContent.endOffset - this.fEntityContent.offset);
                        entityInputSource.setByteStream((InputStream)this.fByteStream);
                        if (!this.runDocumentTest(entityInputSource)) {
                            return -1.0;
                        }
                        ++n3;
                    }
                    l = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    if (this.fCharReader == null) {
                        this.fCharReader = new ReusableCharArrayReader(this.fEntityContent.chars, this.fEntityContent.offset, this.fEntityContent.endOffset - this.fEntityContent.offset);
                    }
                    Runtime.getRuntime().gc();
                    l2 = System.currentTimeMillis();
                    int n4 = 0;
                    while (n4 < n) {
                        this.fCharReader.setBuffer(this.fEntityContent.chars, this.fEntityContent.offset, this.fEntityContent.endOffset - this.fEntityContent.offset);
                        entityInputSource.setCharacterStream((Reader)this.fCharReader);
                        if (!this.runDocumentTest(entityInputSource)) {
                            return -1.0;
                        }
                        ++n4;
                    }
                    l = System.currentTimeMillis();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    Runtime.getRuntime().gc();
                    l2 = System.currentTimeMillis();
                    int n5 = 0;
                    while (n5 < n) {
                        entityInputSource.setContent(this.fEntityContent);
                        if (!this.runDocumentTest(entityInputSource)) {
                            return -1.0;
                        }
                        ++n5;
                    }
                    l = System.currentTimeMillis();
                    break;
                }
                default: {
                    throw new RuntimeException("illegal value for fProcessingMode");
                }
            }
            double d2 = l - l2;
            return d2;
        }
        byte[] byArray = this.fEntityContent.bytes;
        int n6 = this.fEntityContent.endOffset - this.fEntityContent.offset;
        byte[] byArray2 = new byte[4];
        try {
            Socket socket = new Socket("localhost", this.getServicePort());
            socket.setTcpNoDelay(true);
            OutputStream outputStream = socket.getOutputStream();
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byArray2[0] = (byte)(n6 >> 24 & 0xFF);
            byArray2[1] = (byte)(n6 >> 16 & 0xFF);
            byArray2[2] = (byte)(n6 >> 8 & 0xFF);
            byArray2[3] = (byte)(n6 >> 0 & 0xFF);
            int n7 = 0;
            while (n7 < n) {
                outputStream.write(byArray2, 0, 4);
                outputStream.write(byArray, 0, n6);
                outputStream.flush();
                ++n7;
            }
            byArray2[3] = 0;
            byArray2[2] = 0;
            byArray2[1] = 0;
            byArray2[0] = 0;
            outputStream.write(byArray2, 0, 4);
            outputStream.flush();
            d = dataInputStream.readDouble();
            dataInputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        return d;
    }

    protected int processSwitch(String[] stringArray, int n) throws Exception {
        String string = stringArray[n];
        if (string.charAt(0) != '-') {
            return n;
        }
        switch (string.charAt(1)) {
            case 'm': {
                string = stringArray[++n];
                if (string.equals("uri")) {
                    this.fProcessingMode = 0;
                } else if (string.equals("stream")) {
                    this.fProcessingMode = 1;
                } else if (string.equals("reader")) {
                    this.fProcessingMode = 2;
                } else if (string.equals("bytes")) {
                    this.fProcessingMode = 3;
                } else if (string.equals("chars")) {
                    this.fProcessingMode = 4;
                } else if (string.equals("string")) {
                    this.fProcessingMode = 5;
                } else {
                    return --n;
                }
                return ++n;
            }
            case 'T': {
                TRACE_ITERATION_LOGIC = !TRACE_ITERATION_LOGIC;
                return ++n;
            }
            case 'w': {
                string = stringArray[++n];
                this.fWarmupIterations = Integer.parseInt(string);
                return ++n;
            }
            case 'i': {
                string = stringArray[++n];
                this.fIterations = Integer.parseInt(string);
                return ++n;
            }
            case 's': {
                this.fUseSockets = true;
                return ++n;
            }
            case 'e': {
                this.fSourceEncodingName = stringArray[++n];
                return ++n;
            }
            case 't': {
                this.fTargetEncodingName = stringArray[++n];
                return ++n;
            }
        }
        return n;
    }

    protected void parseSetup(String string) throws Exception {
        EntityInputSource entityInputSource = this.fSource;
        EncodingSupport encodingSupport = null;
        if (this.fUseSockets && this.fServerSocket == null) {
            this.fServerSocket = new ServerSocket(0);
            this.setDaemon(true);
            this.start();
        }
        entityInputSource.clear();
        entityInputSource.setSystemId(string);
        if (!this.fSourceEncodingName.equals("auto-detect")) {
            entityInputSource.setEncoding(this.fSourceEncodingName);
        }
        if (this.fTargetEncodingName != null && (encodingSupport = IANACharset.getEncodingSupport((String)this.fTargetEncodingName.toUpperCase())) == null) {
            encodingSupport = new JavaEncodingSupport(this.fTargetEncodingName);
        }
        if (this.fProcessingMode != 0 || encodingSupport != null) {
            ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, true);
            parsedEntity.getContent(this.fEntityContent);
            switch (this.fProcessingMode) {
                case 0: {
                    if (this.fEntityContent.encoding == encodingSupport) break;
                    this.fProcessingMode = 3;
                }
                case 1: 
                case 3: {
                    if (encodingSupport == null) {
                        if (this.fEntityContent.bytes != null) break;
                        encodingSupport = UTF8EncodingSupport.getInstance();
                    }
                    if (this.fEntityContent.chars == null) {
                        this.fCharsOffset[0] = 0;
                        this.fEntityContent.encoding.convertBytesToChars(this.fEntityContent.bytes, this.fEntityContent.offset, this.fEntityContent.endOffset, this.fChars, this.fCharsOffset);
                        this.fEntityContent.setValues(this.fChars[0], 0, this.fCharsOffset[0]);
                    }
                    this.fBytesOffset[0] = 0;
                    encodingSupport.convertCharsToBytes(this.fEntityContent.chars, this.fEntityContent.offset, this.fEntityContent.endOffset, this.fBytes, this.fBytesOffset);
                    this.fEntityContent.setValues(this.fBytes[0], 0, this.fBytesOffset[0], encodingSupport);
                    if (this.fBytesOffset[0] == this.fEntityContent.bytes.length) {
                        this.fEntityContent.bytes = new byte[this.fBytesOffset[0] << 1];
                        System.arraycopy(this.fBytes[0], 0, this.fEntityContent.bytes, 0, this.fBytesOffset[0]);
                        this.fBytes[0] = this.fEntityContent.bytes;
                    }
                    this.fEntityContent.bytes[this.fBytesOffset[0]] = 0;
                    break;
                }
                case 2: 
                case 4: {
                    if (this.fEntityContent.chars != null) break;
                    this.fCharsOffset[0] = 0;
                    this.fEntityContent.getChars(this.fChars, this.fCharsOffset);
                    this.fEntityContent.setValues(this.fChars[0], 0, this.fCharsOffset[0]);
                    if (this.fCharsOffset[0] == this.fEntityContent.chars.length) {
                        this.fEntityContent.chars = new char[this.fCharsOffset[0] << 1];
                        System.arraycopy(this.fChars[0], 0, this.fEntityContent.chars, 0, this.fCharsOffset[0]);
                        this.fChars[0] = this.fEntityContent.chars;
                    }
                    this.fEntityContent.chars[this.fCharsOffset[0]] = '\u0000';
                    break;
                }
                case 5: {
                    this.fEntityContent.toString();
                    this.fEntityContent.bytes = null;
                    this.fEntityContent.chars = null;
                }
            }
            parsedEntity.release();
        }
    }

    protected void runPerfTest(String[] stringArray, PerfTestResults perfTestResults) throws Exception {
        int n = 0;
        int n2 = 0;
        if (this.fSource == null) {
            this.fSource = new EntityInputSource();
        }
        EntityInputSource entityInputSource = this.fSource;
        if (this.fEntityContent == null) {
            this.fEntityContent = new XMLString();
        }
        this.fProcessingMode = 0;
        this.fSourceEncodingName = "auto-detect";
        this.fTargetEncodingName = null;
        this.fIterations = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            double d;
            double d2;
            int n4 = this.processSwitch(stringArray, n3);
            if (n4 != n3) {
                n3 = n4;
                continue;
            }
            String string = stringArray[n3++];
            this.parseSetup(string);
            if (TRACE_ITERATION_LOGIC) {
                n = 1;
                n2 = 0;
                System.out.println("running 1 iteration for warmup");
            }
            if (this.parse(1) < 0.0) continue;
            int n5 = this.fIterations;
            if (n5 != 0) {
                if (TRACE_ITERATION_LOGIC) {
                    n = this.fWarmupIterations;
                    n2 = n5;
                    System.out.println("running " + n5 + " iteration(s) to collect the sample");
                }
                this.parse(this.fWarmupIterations);
                d2 = this.parse(n5);
            } else {
                int n6 = 0;
                d = INITIAL_DOCS_PER_SEC;
                while (true) {
                    double d3 = d;
                    n5 = (int)(d3 * (double)SECONDS_PER_SAMPLE);
                    while (true) {
                        if (TRACE_ITERATION_LOGIC) {
                            n2 += n5;
                            System.out.println("running " + n5 + " iteration(s) to collect a sample");
                        }
                        d2 = this.parse(n5);
                        if (TRACE_ITERATION_LOGIC) {
                            System.out.println("duration " + d2);
                        }
                        if (d2 > MINIMUM_DURATION_PER_SAMPLE) break;
                        n5 *= 10;
                    }
                    d = (double)n5 * 1000.0 / d2;
                    if (TRACE_ITERATION_LOGIC) {
                        System.out.println("docsPerSec " + d);
                    }
                    double d4 = d / d3;
                    if (TRACE_ITERATION_LOGIC) {
                        System.out.println("change " + d4);
                    }
                    if (d4 <= 0.99 || d4 >= 1.01) {
                        if (TRACE_ITERATION_LOGIC) {
                            System.out.println("resampling after " + n2 + " iterations (warmup " + n + ")");
                        }
                        n += n2;
                        n2 = 0;
                        n6 = 0;
                        continue;
                    }
                    if (++n6 >= 5 && d4 >= 1.0) break;
                }
                if (TRACE_ITERATION_LOGIC) {
                    System.out.println("duration " + d2);
                }
            }
            d = (double)n5 * 1000.0 / d2;
            if (TRACE_ITERATION_LOGIC) {
                System.out.println("docsPerSec " + d);
                System.out.println("warmup was " + n + " iterations");
                System.out.println("sampled " + n2 + " iterations");
            }
            perfTestResults.recordResult(entityInputSource, d2, n5);
        }
    }

    public final class ReusableCharArrayReader
    extends CharArrayReader {
        public ReusableCharArrayReader(char[] cArray, int n, int n2) {
            super(cArray, n, n2);
        }

        public void setBuffer(char[] cArray, int n, int n2) {
            this.buf = cArray;
            this.pos = n;
            this.count = n + n2;
            this.markedPos = n;
        }
    }
}

