/*
 * Decompiled with CFR 0.152.
 */
package trace;

import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import util.ParserBase;

public abstract class TracerBase
extends ParserBase {
    private static final boolean RETAIN_OBJECTS_ACROSS_RESET = true;
    private char[] fCharBuffer;
    private boolean fNeedReset;
    protected boolean fInElementContent;
    private boolean[] fInElementContentStack;
    private EntityInputSource fSource = new EntityInputSource();
    private boolean fNamespacePrefixes;
    protected boolean warmup;
    private boolean needEndPrintCharacters;
    private PrintWriter log;
    private static final boolean NORMALIZE_UNKNOWN_STATES = true;
    private static final boolean FIXUP_BAD_LOCAL_NAMES = false;
    private static final boolean FLUSH_CHARDATA_IMMEDIATELY = false;

    protected TracerBase() {
        this.fCharBuffer = new char[2];
        this.fInElementContentStack = new boolean[16];
    }

    public void startEntity(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("startEntity");
        TracerBase.printParameter("name", string);
        TracerBase.endPrint();
    }

    public void endEntity(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("endEntity");
        TracerBase.printParameter("name", string);
        TracerBase.endPrint();
    }

    public void character(int n, int n2, boolean bl) {
        String string = this.fSymbolTable.toString(n);
        this.startEntity(string);
        this.character(n2, bl);
        this.endEntity(string);
    }

    public boolean scanContent(int n, ParsedEntity parsedEntity) {
        String string = this.fSymbolTable.toString(n);
        this.startEntity(string);
        boolean bl = this.scanContent(parsedEntity);
        this.endEntity(string);
        return bl;
    }

    protected void preScanExternalSubset() {
        String string = "[dtd]";
        this.startEntity(string);
    }

    protected void postScanExternalSubset() {
        String string = "[dtd]";
        this.endEntity(string);
    }

    protected void startPrefixMapping(String string, String string2) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("startPrefixMapping");
        TracerBase.printParameter("prefix", string);
        TracerBase.printParameter("uri", string2);
        TracerBase.endPrint();
    }

    protected void endPrefixMapping(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("endPrefixMapping");
        TracerBase.printParameter("prefix", string);
        TracerBase.endPrint();
    }

    public void startElementEvent(boolean bl) {
        super.startElementEvent(bl);
        if (!bl && this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            QName qName = this.fDocumentScannerSupport.currentElement;
            this.pushInElementContent();
            this.fInElementContent = this.fDTDGrammar.hasElementContent(qName.handle);
        }
    }

    protected void startElementAction(boolean bl) {
        QName qName = this.fDocumentScannerSupport.currentElement;
        super.startPrefixMappings();
        this.startElement(qName.namespaceURI, qName.localPart, qName.toString());
        if (bl) {
            this.endElement(qName.namespaceURI, qName.localPart, qName.toString());
            super.endPrefixMappings();
        }
    }

    public void endElementEvent() {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.popInElementContent();
        }
        super.endElementEvent();
    }

    protected void endElementAction() {
        QName qName = this.fDocumentScannerSupport.currentElement;
        this.endElement(qName.namespaceURI, qName.localPart, qName.toString());
        super.endPrefixMappings();
    }

    public void characters(XMLString xMLString) {
        if (this.fInElementContent) {
            this.ignorableWhitespace(xMLString.toString());
        } else {
            this.characters(xMLString.toString());
        }
    }

    public void character(int n, boolean bl) {
        int n2;
        if (n < 65536) {
            this.fCharBuffer[0] = (char)n;
            n2 = 1;
        } else {
            int n3 = n - 65536;
            this.fCharBuffer[0] = (char)(55296 + (n3 >> 10));
            this.fCharBuffer[1] = (char)(56320 + (n3 & 0x3FF));
            n2 = 2;
        }
        String string = new String(this.fCharBuffer, 0, n2);
        if (this.fInElementContent) {
            this.ignorableWhitespace(string);
        } else {
            this.characters(string);
        }
    }

    public void processingInstruction(XMLName xMLName, XMLString xMLString) {
        this.fSymbolTable.addSymbol((XMLString)xMLName);
        this.processingInstruction(xMLName.str, xMLString.toString());
    }

    private void pushInElementContent() {
        int n = this.fDocumentScannerSupport.elementDepth;
        if (n == this.fInElementContentStack.length) {
            boolean[] blArray = new boolean[n << 1];
            System.arraycopy(this.fInElementContentStack, 0, blArray, 0, n);
            this.fInElementContentStack = blArray;
        }
        this.fInElementContentStack[n] = this.fInElementContent;
    }

    private void popInElementContent() {
        int n = this.fDocumentScannerSupport.elementDepth;
        this.fInElementContent = this.fInElementContentStack[n];
    }

    public boolean scanExternalSubset() {
        boolean bl = super.scanExternalSubset();
        if (!this.warmup) {
            TracerBase.printMethod("endDTD");
        }
        return bl;
    }

    public boolean skippedExternalSubsetEntity() {
        String string = "[dtd]";
        this.skippedEntity(string);
        return true;
    }

    public void startCDATA() {
        super.startCDATA();
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethod("startCDATA");
    }

    public void endCDATA() {
        super.endCDATA();
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethod("endCDATA");
    }

    public void comment(XMLString xMLString) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("comment");
        TracerBase.printParameter("content", xMLString.toString());
        TracerBase.endPrint();
    }

    public boolean skippedEntityInContent(int n) {
        this.skippedEntity(this.fSymbolTable.toString(n));
        return true;
    }

    public void doctype(QName qName, XMLString xMLString, XMLString xMLString2, boolean bl) {
        super.doctype(qName, xMLString, xMLString2, bl);
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("startDTD");
        TracerBase.printParameter("name", qName.toString());
        TracerBase.printParameter("publicId", xMLString == null ? null : xMLString.toString());
        TracerBase.printParameter("systemId", xMLString2 == null ? null : xMLString2.toString());
        TracerBase.endPrint();
    }

    protected void parse(EntityInputSource entityInputSource) {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        this.setDocumentLocator();
        this.startDocument();
        super.parse(entityInputSource);
        this.endDocument();
    }

    public boolean resolveExternalEntity(EntityInputSource entityInputSource) {
        if (this.warmup) {
            return true;
        }
        this.flushCharData();
        TracerBase.printMethodName("resolveEntity");
        TracerBase.printParameter("publicId", entityInputSource.getPublicId());
        TracerBase.printParameter("systemId", entityInputSource.getSystemId());
        TracerBase.endPrint();
        return true;
    }

    private void setDocumentLocator() {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethod("setDocumentLocator");
    }

    private void startDocument() {
        if (this.warmup) {
            return;
        }
        this.needEndPrintCharacters = false;
        TracerBase.printMethod("startDocument");
    }

    private void endDocument() {
        if (this.warmup) {
            this.warmup = false;
            return;
        }
        this.flushCharData();
        TracerBase.printMethod("endDocument");
    }

    private void startElement(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("startElement");
        if (!this.fNamespacePrefixes) {
            string3 = "";
        }
        TracerBase.printParameter("uri", string);
        TracerBase.printParameter("localName", string2);
        TracerBase.printParameter("qName", string3);
        int n = this.fDocumentScannerSupport.attrCount;
        if (n == 0) {
            TracerBase.endPrint();
        } else {
            System.out.println(">");
            System.out.println(" <attributes>");
            System.out.flush();
            int n2 = 0;
            while (n2 < n) {
                System.out.print("  ");
                TracerBase.printMethodName("attribute");
                string = this.fDocumentScannerSupport.attrNames[n2].namespaceURI;
                string2 = this.fDocumentScannerSupport.attrNames[n2].localPart;
                string3 = this.fDocumentScannerSupport.attrNames[n2].toString();
                if (!this.fNamespacePrefixes) {
                    string3 = "";
                } else if (string2.length() != 0 && string3.startsWith("xmlns") && (string3.length() == 5 || string3.charAt(5) == ':')) {
                    string2 = "";
                }
                TracerBase.printParameter("uri", string);
                TracerBase.printParameter("localName", string2);
                TracerBase.printParameter("qName", string3);
                String string4 = this.fDocumentScannerSupport.attTypes[n2];
                if (string4 == null) {
                    string4 = "NMTOKEN";
                } else if (string4.length() == 0) {
                    string4 = "CDATA";
                }
                TracerBase.printParameter("type", string4);
                XMLString xMLString = this.fDocumentScannerSupport.attValues[n2];
                String string5 = xMLString.toString();
                TracerBase.printParameter("value", string5);
                TracerBase.endPrint();
                ++n2;
            }
            System.out.println(" </attributes>");
            System.out.println("</startElement>");
            System.out.flush();
        }
    }

    private void endElement(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("endElement");
        if (!this.fNamespacePrefixes) {
            string3 = "";
        }
        TracerBase.printParameter("uri", string);
        TracerBase.printParameter("localName", string2);
        TracerBase.printParameter("qName", string3);
        TracerBase.endPrint();
    }

    private void characters(String string) {
        if (this.warmup) {
            return;
        }
        String string2 = TracerBase.quote(string);
        if (this.needEndPrintCharacters) {
            System.out.print(string2);
        } else {
            TracerBase.printMethodName("characters");
            System.out.print(" content=\"" + string2);
            this.needEndPrintCharacters = true;
        }
    }

    private void ignorableWhitespace(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("ignorableWhitespace");
        TracerBase.printParameter("content", string);
        TracerBase.endPrint();
    }

    private void processingInstruction(String string, String string2) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("processingInstruction");
        TracerBase.printParameter("target", string);
        TracerBase.printParameter("data", string2);
        TracerBase.endPrint();
    }

    private void skippedEntity(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        TracerBase.printMethodName("skippedEntity");
        TracerBase.printParameter("entityName", string);
        TracerBase.endPrint();
    }

    public void notationDecl(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("notationDecl");
        TracerBase.printParameter("name", string);
        TracerBase.printParameter("publicId", string2);
        TracerBase.printParameter("systemId", string3);
        TracerBase.endPrint();
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("unparsedEntityDecl");
        TracerBase.printParameter("name", string);
        TracerBase.printParameter("publicId", string2);
        TracerBase.printParameter("systemId", string3);
        TracerBase.printParameter("notationName", string4);
        TracerBase.endPrint();
    }

    public void elementDecl(String string, String string2) {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("elementDecl");
        TracerBase.printParameter("name", string);
        TracerBase.printParameter("model", string2);
        TracerBase.endPrint();
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("attributeDecl");
        TracerBase.printParameter("eName", string);
        TracerBase.printParameter("aName", string2);
        TracerBase.printParameter("type", string3);
        TracerBase.printParameter("valueDefault", string4);
        TracerBase.printParameter("value", string5);
        TracerBase.endPrint();
    }

    public void internalEntityDecl(String string, String string2) {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("internalEntityDecl");
        TracerBase.printParameter("name", string);
        TracerBase.printParameter("value", string2);
        TracerBase.endPrint();
    }

    public void externalEntityDecl(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        TracerBase.printMethodName("externalEntityDecl");
        TracerBase.printParameter("name", string);
        TracerBase.printParameter("publicId", string2);
        TracerBase.printParameter("systemId", string3);
        TracerBase.endPrint();
    }

    private static void printMethod(String string) {
        System.out.println("<" + string + "/>");
        System.out.flush();
    }

    private static void printMethodName(String string) {
        System.out.print("<" + string);
    }

    private static void printParameter(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = TracerBase.quote(string2);
        System.out.print(" " + string + "=\"" + string3 + "\"");
    }

    private static void printParameter(String string, char[] cArray, int n, int n2) {
        TracerBase.printParameter(string, new String(cArray, n, n2));
    }

    private static void endPrint() {
        System.out.println("/>");
        System.out.flush();
    }

    protected void flushCharData() {
        if (this.needEndPrintCharacters) {
            System.out.println("\"/>");
            System.out.flush();
            this.needEndPrintCharacters = false;
        }
    }

    private static String quote(String string) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&amp;");
                    break;
                }
                case '<': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&lt;");
                    break;
                }
                case '>': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&quot;");
                    break;
                }
                case '\t': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&#9;");
                    break;
                }
                case '\n': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&#10;");
                    break;
                }
                case '\r': {
                    stringBuffer = TracerBase.append(stringBuffer, string, n2, "&#13;");
                    break;
                }
                default: {
                    if (c >= '\u0080') {
                        String string2 = "&#" + c + ";";
                        stringBuffer = TracerBase.append(stringBuffer, string, n2, string2);
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer append(StringBuffer stringBuffer, String string, int n, String string2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private int processSwitch(String[] stringArray, int n) throws Exception {
        String string = stringArray[n];
        if (!string.startsWith("-")) {
            return n;
        }
        if (string.equals("-w")) {
            this.warmup = true;
            return ++n;
        }
        if (string.equals("-np")) {
            this.fNamespacePrefixes = true;
            return ++n;
        }
        if (string.equals("-NP")) {
            this.fNamespacePrefixes = false;
            return ++n;
        }
        if (string.equals("-L")) {
            if (n == stringArray.length - 1) {
                System.err.println("error: missing logfile name");
                System.exit(1);
            }
            this.log = new PrintWriter((Writer)new FileWriter(stringArray[++n], false), true);
            return ++n;
        }
        TracerBase.printUsage();
        System.exit(1);
        return n;
    }

    private static void printUsage() {
        System.err.println("usage: java trace.TracerBase (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -s       Use sockets.");
        System.err.println("  -w       Warmup the parser before timing.");
        System.err.println("  -h       This help screen.");
    }

    protected void trace(String[] stringArray) throws Exception {
        int n = 0;
        System.out.println("<trace>");
        while (n < stringArray.length) {
            int n2 = this.processSwitch(stringArray, n);
            if (n2 != n) {
                n = n2;
                continue;
            }
            String string = stringArray[n++];
            this.fSource.setSystemId(string);
            if (this.warmup) {
                this.parse(this.fSource);
            }
            System.out.println("<parse systemId=\"" + string + "\">");
            System.out.flush();
            this.parse(this.fSource);
            System.out.println("</parse>");
            System.out.flush();
        }
        System.out.println("</trace>");
        System.out.flush();
    }
}

