/*
 * Decompiled with CFR 0.152.
 */
package trace.sax;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAX2Tracer
implements ErrorHandler,
EntityResolver,
ContentHandler,
DTDHandler,
DeclHandler,
LexicalHandler {
    private static final boolean NORMALIZE_UNKNOWN_STATES = true;
    private static final boolean FIXUP_BAD_LOCAL_NAMES = false;
    private static final boolean FLUSH_CHARDATA_IMMEDIATELY = false;
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private String fParserName = "org.apache.xerces.parsers.SAXParser";
    private XMLReader fXMLReader;
    private InputSource fSource = new InputSource();
    private String fLabel;
    private Locator fDocumentLocator;
    private boolean fNamespacePrefixes;
    private boolean validate;
    private boolean extGE = true;
    private boolean extPE = true;
    private boolean warmup;
    private boolean needEndPrintCharacters;
    private PrintWriter log;

    private SAX2Tracer() {
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) {
        if (this.warmup) {
            return null;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("resolveEntity");
        SAX2Tracer.printParameter("publicId", string);
        SAX2Tracer.printParameter("systemId", string2);
        SAX2Tracer.endPrint();
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.warmup) {
            return;
        }
        this.fDocumentLocator = locator;
        SAX2Tracer.printMethod("setDocumentLocator");
    }

    public void startDocument() {
        if (this.warmup) {
            return;
        }
        this.needEndPrintCharacters = false;
        SAX2Tracer.printMethod("startDocument");
    }

    public void endDocument() {
        if (this.warmup) {
            this.warmup = false;
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethod("endDocument");
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("startPrefixMapping");
        SAX2Tracer.printParameter("prefix", string);
        SAX2Tracer.printParameter("uri", string2);
        SAX2Tracer.endPrint();
    }

    public void endPrefixMapping(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("endPrefixMapping");
        SAX2Tracer.printParameter("prefix", string);
        SAX2Tracer.endPrint();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("startElement");
        if (!this.fNamespacePrefixes) {
            string3 = "";
        }
        SAX2Tracer.printParameter("uri", string);
        SAX2Tracer.printParameter("localName", string2);
        SAX2Tracer.printParameter("qName", string3);
        int n = attributes.getLength();
        if (n == 0) {
            SAX2Tracer.endPrint();
        } else {
            System.out.println(">");
            System.out.println(" <attributes>");
            System.out.flush();
            int n2 = 0;
            while (n2 < n) {
                System.out.print("  ");
                SAX2Tracer.printMethodName("attribute");
                string = attributes.getURI(n2);
                string2 = attributes.getLocalName(n2);
                string3 = attributes.getQName(n2);
                if (!this.fNamespacePrefixes) {
                    string3 = "";
                } else if (string2.length() != 0 && string3.startsWith("xmlns") && (string3.length() == 5 || string3.charAt(5) == ':')) {
                    string2 = "";
                }
                SAX2Tracer.printParameter("uri", string);
                SAX2Tracer.printParameter("localName", string2);
                SAX2Tracer.printParameter("qName", string3);
                SAX2Tracer.printParameter("type", attributes.getType(n2));
                SAX2Tracer.printParameter("value", attributes.getValue(n2));
                SAX2Tracer.endPrint();
                ++n2;
            }
            System.out.println(" </attributes>");
            System.out.println("</startElement>");
            System.out.flush();
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("endElement");
        if (!this.fNamespacePrefixes) {
            string3 = "";
        }
        SAX2Tracer.printParameter("uri", string);
        SAX2Tracer.printParameter("localName", string2);
        SAX2Tracer.printParameter("qName", string3);
        SAX2Tracer.endPrint();
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.warmup) {
            return;
        }
        String string = new String(cArray, n, n2);
        String string2 = SAX2Tracer.quote(string);
        if (this.needEndPrintCharacters) {
            System.out.print(string2);
        } else {
            SAX2Tracer.printMethodName("characters");
            System.out.print(" content=\"" + string2);
            this.needEndPrintCharacters = true;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("ignorableWhitespace");
        String string = new String(cArray, n, n2);
        SAX2Tracer.printParameter("content", string);
        SAX2Tracer.endPrint();
    }

    public void processingInstruction(String string, String string2) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("processingInstruction");
        SAX2Tracer.printParameter("target", string);
        SAX2Tracer.printParameter("data", string2);
        SAX2Tracer.endPrint();
    }

    public void skippedEntity(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("skippedEntity");
        SAX2Tracer.printParameter("entityName", string);
        SAX2Tracer.endPrint();
    }

    public void notationDecl(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("notationDecl");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.printParameter("publicId", string2);
        SAX2Tracer.printParameter("systemId", string3);
        SAX2Tracer.endPrint();
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("unparsedEntityDecl");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.printParameter("publicId", string2);
        SAX2Tracer.printParameter("systemId", string3);
        SAX2Tracer.printParameter("notationName", string4);
        SAX2Tracer.endPrint();
    }

    public void elementDecl(String string, String string2) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("elementDecl");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.printParameter("model", string2);
        SAX2Tracer.endPrint();
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("attributeDecl");
        SAX2Tracer.printParameter("eName", string);
        SAX2Tracer.printParameter("aName", string2);
        SAX2Tracer.printParameter("type", string3);
        SAX2Tracer.printParameter("valueDefault", string4);
        SAX2Tracer.printParameter("value", string5);
        SAX2Tracer.endPrint();
    }

    public void internalEntityDecl(String string, String string2) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("internalEntityDecl");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.printParameter("value", string2);
        SAX2Tracer.endPrint();
    }

    public void externalEntityDecl(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("externalEntityDecl");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.printParameter("publicId", string2);
        SAX2Tracer.printParameter("systemId", string3);
        SAX2Tracer.endPrint();
    }

    public void startDTD(String string, String string2, String string3) {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethodName("startDTD");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.printParameter("publicId", string2);
        SAX2Tracer.printParameter("systemId", string3);
        SAX2Tracer.endPrint();
    }

    public void endDTD() {
        if (this.warmup) {
            return;
        }
        SAX2Tracer.printMethod("endDTD");
    }

    public void startEntity(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("startEntity");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.endPrint();
    }

    public void endEntity(String string) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("endEntity");
        SAX2Tracer.printParameter("name", string);
        SAX2Tracer.endPrint();
    }

    public void startCDATA() {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethod("startCDATA");
    }

    public void endCDATA() {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethod("endCDATA");
    }

    public void comment(char[] cArray, int n, int n2) {
        if (this.warmup) {
            return;
        }
        this.flushCharData();
        SAX2Tracer.printMethodName("comment");
        String string = new String(cArray, n, n2);
        SAX2Tracer.printParameter("content", string);
        SAX2Tracer.endPrint();
    }

    private static void printMethod(String string) {
        System.out.println("<" + string + "/>");
        System.out.flush();
    }

    private static void printMethodName(String string) {
        System.out.print("<" + string);
    }

    private static void printParameter(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = SAX2Tracer.quote(string2);
        System.out.print(" " + string + "=\"" + string3 + "\"");
    }

    private static void endPrint() {
        System.out.println("/>");
        System.out.flush();
    }

    private void flushCharData() {
        if (this.needEndPrintCharacters) {
            System.out.println("\"/>");
            System.out.flush();
            this.needEndPrintCharacters = false;
        }
    }

    private static String quote(String string) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&amp;");
                    break;
                }
                case '<': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&lt;");
                    break;
                }
                case '>': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&quot;");
                    break;
                }
                case '\t': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&#9;");
                    break;
                }
                case '\n': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&#10;");
                    break;
                }
                case '\r': {
                    stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, "&#13;");
                    break;
                }
                default: {
                    if (c >= '\u0080') {
                        String string2 = "&#" + c + ";";
                        stringBuffer = SAX2Tracer.append(stringBuffer, string, n2, string2);
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer append(StringBuffer stringBuffer, String string, int n, String string2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private int processSwitch(String[] stringArray, int n) throws Exception {
        String string = stringArray[n];
        if (!string.startsWith("-")) {
            return n;
        }
        if (string.equals("-l")) {
            this.fLabel = stringArray[++n];
            return ++n;
        }
        if (string.equals("-p")) {
            if (n == stringArray.length - 1) {
                System.err.println("error: missing parser name");
                System.exit(1);
            }
            this.fParserName = stringArray[++n];
            this.fXMLReader = null;
            return ++n;
        }
        if (string.equals("-w")) {
            this.warmup = true;
            return ++n;
        }
        if (string.equals("-v")) {
            this.validate = true;
            return ++n;
        }
        if (string.equals("-np")) {
            this.fNamespacePrefixes = true;
            return ++n;
        }
        if (string.equals("-NP")) {
            this.fNamespacePrefixes = false;
            return ++n;
        }
        if (string.equals("-noge")) {
            this.extGE = false;
            return ++n;
        }
        if (string.equals("-nope")) {
            this.extPE = false;
            return ++n;
        }
        if (string.equals("-L")) {
            if (n == stringArray.length - 1) {
                System.err.println("error: missing logfile name");
                System.exit(1);
            }
            this.log = new PrintWriter((Writer)new FileWriter(stringArray[++n], false), true);
            return ++n;
        }
        SAX2Tracer.printUsage();
        System.exit(1);
        return n;
    }

    private boolean scanDocument(InputSource inputSource) {
        try {
            this.fXMLReader.parse(inputSource);
            return true;
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
            return false;
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return false;
        }
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(Integer.toString(sAXParseException.getLineNumber()));
        stringBuffer.append(':');
        stringBuffer.append(Integer.toString(sAXParseException.getColumnNumber()));
        return stringBuffer.toString();
    }

    private static void printUsage() {
        System.err.println("usage: java trace.SAX2Tracer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify SAX parser by name.");
        System.err.println("           Default parser: org.apache.xerces.parsers.SAXParser");
        System.err.println("  -s       Use sockets.");
        System.err.println("  -v       Turn on validation.");
        System.err.println("  -noge    Turn off external general entities.");
        System.err.println("  -nope    Turn off external parameter entities.");
        System.err.println("  -w       Warmup the parser before timing.");
        System.err.println("  -h       This help screen.");
    }

    private void parse(String string) {
        this.fSource.setSystemId(string);
        this.scanDocument(this.fSource);
    }

    private void trace(String[] stringArray) throws Exception {
        int n = 0;
        System.out.println("<trace>");
        while (n < stringArray.length) {
            int n2 = this.processSwitch(stringArray, n);
            if (n2 != n) {
                n = n2;
                continue;
            }
            String string = stringArray[n++];
            this.fSource.setSystemId(string);
            if (this.fXMLReader == null) {
                this.fXMLReader = XMLReaderFactory.createXMLReader(this.fParserName);
                this.fXMLReader.setErrorHandler(this);
                this.fXMLReader.setEntityResolver(this);
                this.fXMLReader.setContentHandler(this);
                this.fXMLReader.setDTDHandler(this);
                try {
                    this.fXMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", this);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                try {
                    this.fXMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            try {
                this.fXMLReader.setFeature("http://xml.org/sax/features/validation", this.validate);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                this.fXMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.extGE);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                this.fXMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", this.extPE);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                this.fXMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                this.fXMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.fNamespacePrefixes);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            if (this.warmup) {
                this.parse(string);
            }
            System.out.println("<parse systemId=\"" + string + "\">");
            System.out.flush();
            this.parse(string);
            System.out.println("</parse>");
            System.out.flush();
        }
        System.out.println("</trace>");
        System.out.flush();
    }

    public static void main(String[] stringArray) {
        try {
            SAX2Tracer sAX2Tracer = new SAX2Tracer();
            sAX2Tracer.trace(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

