/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.DataStore;
import com.ibm.xml.b2b.util.IntegerHashtable;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.EntityDeclPool;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import util.DTDGrammarCache;

public class DTDGrammar {
    public static final int ATTDEF_ATTRNAME_OFFSET = 0;
    public static final int ATTDEF_ATTTYPE_OFFSET = 1;
    public static final int ATTDEF_DEFAULTTYPE_OFFSET = 2;
    public static final int ATTDEF_ENUMTYPE_OFFSET = 3;
    public static final int ATTDEF_ATTVALUE_OFFSET = 4;
    public static final int ATTDEF_EXTERNAL_OFFSET = 5;
    public static final int ATTDEF_RECORD_SIZE = 6;
    protected SymbolTable fSymbolTable;
    protected XMLStringBuffer fStringBuffer;
    protected DataStore fDataStore;
    protected EntityDeclPool fEntityDeclPool;
    protected int fRootElementTypeHandle;
    protected int fPublicIDHandle;
    protected int fSystemIDHandle;
    protected int fEnumerationTypeList;
    protected QName[] fDefaultAttrNames;
    protected int fDefaultAttrNamesCount;
    protected XMLString[] fDefaultAttValues;
    protected int fDefaultAttValuesCount;
    protected int fCDATASymbol;
    protected int fREQUIREDSymbol;
    protected int fFIXEDSymbol;
    protected boolean fHaveAttDefs;
    protected IntegerHashtable fAttDefs;
    protected boolean fHaveElementContentElements;
    protected IntegerHashtable fElementContentElements;

    public DTDGrammar(SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
        this.fSymbolTable = symbolTable;
        this.fEntityDeclPool = new EntityDeclPool(this.fSymbolTable);
        this.fStringBuffer = parsedEntityFactory.createStringBuffer();
        this.fDataStore = new DataStore();
        this.fDefaultAttrNames = new QName[16];
        this.fDefaultAttValues = new XMLString[16];
        this.fCDATASymbol = this.fSymbolTable.addSymbol("CDATA");
        this.fFIXEDSymbol = this.fSymbolTable.addSymbol("#FIXED");
        this.fREQUIREDSymbol = this.fSymbolTable.addSymbol("#REQUIRED");
    }

    public void reset(boolean bl) {
        this.fEntityDeclPool.reset(bl);
        this.fStringBuffer.reset(bl);
        this.fDataStore.reset(bl);
        if (this.fHaveElementContentElements) {
            this.fElementContentElements.clear(bl);
            this.fHaveElementContentElements = false;
            if (!bl) {
                this.fElementContentElements = null;
            }
        }
        if (this.fHaveAttDefs) {
            this.fAttDefs.clear(bl);
            this.fHaveAttDefs = false;
            if (!bl) {
                int n = 0;
                while (n < this.fDefaultAttrNamesCount) {
                    this.fDefaultAttrNames[n] = null;
                    ++n;
                }
                n = 0;
                while (n < this.fDefaultAttValuesCount) {
                    this.fDefaultAttValues[n] = null;
                    ++n;
                }
            }
            this.fDefaultAttrNamesCount = 0;
            this.fDefaultAttValuesCount = 0;
        }
        this.fCDATASymbol = this.fSymbolTable.addSymbol("CDATA");
        this.fFIXEDSymbol = this.fSymbolTable.addSymbol("#FIXED");
        this.fREQUIREDSymbol = this.fSymbolTable.addSymbol("#REQUIRED");
    }

    public EntityDeclPool getEntityDeclPool() {
        return this.fEntityDeclPool;
    }

    public XMLStringBuffer getStringBuffer() {
        return this.fStringBuffer;
    }

    public void setDescription(QName qName, int n, int n2) {
        if (qName != null) {
            this.fRootElementTypeHandle = this.fSymbolTable.addSymbol((XMLString)qName);
        }
        this.fPublicIDHandle = n;
        this.fSystemIDHandle = n2;
    }

    public void addGrammarToCache(DTDGrammarCache dTDGrammarCache) {
        dTDGrammarCache.addGrammar(this, this.fRootElementTypeHandle, this.fPublicIDHandle, this.fSystemIDHandle);
    }

    public boolean hasElementContentElements() {
        return this.fHaveElementContentElements;
    }

    public boolean hasElementContent(int n) {
        return this.fElementContentElements.get(n) != -1;
    }

    public void setElementContentElement(int n) {
        if (this.fElementContentElements == null) {
            this.fElementContentElements = new IntegerHashtable();
        }
        this.fElementContentElements.put(n, 1);
        this.fHaveElementContentElements = true;
    }

    public boolean hasAttDefs() {
        return this.fHaveAttDefs;
    }

    public void addDefaultAttributes(DocumentScannerSupport documentScannerSupport, int n) {
        int n2 = this.getAttDefs(n);
        if (n2 == -1) {
            return;
        }
        int n3 = this.attDefsCount(n2);
        int[] nArray = this.attDefsArray(n2);
        int n4 = this.attDefsBase(n2);
        String string = documentScannerSupport.nsDeclPrefix;
        int n5 = documentScannerSupport.attrCount;
        int n6 = 0;
        while (n6 < n3) {
            boolean bl;
            int n7 = nArray[n4 + n6];
            int[] nArray2 = this.attDefArray(n7);
            int n8 = this.attDefBase(n7);
            int n9 = nArray2[n8 + 1];
            int n10 = nArray2[n8 + 2];
            int n11 = nArray2[n8 + 4];
            boolean bl2 = n11 != -1;
            boolean bl3 = n9 != this.fCDATASymbol;
            boolean bl4 = bl = n10 == this.fREQUIREDSymbol;
            if (bl2 || bl3 || bl) {
                int n12;
                int n13 = nArray2[n8 + 0];
                QName qName = this.defaultAttrName(n13);
                boolean bl5 = qName.localPart == string || qName.prefix == string;
                XMLString xMLString = this.defaultAttValue(n11);
                boolean bl6 = false;
                if (bl5) {
                    int n14 = documentScannerSupport.firstMapping;
                    int n15 = documentScannerSupport.lastMapping;
                    n12 = n14;
                    while (n12 < n15) {
                        String string2 = documentScannerSupport.nsDeclQNames[n12];
                        if (qName.str == string2) {
                            if (n10 == this.fFIXEDSymbol) {
                                String string3 = documentScannerSupport.namespaceURIs[n12];
                                XMLString xMLString2 = xMLString;
                                this.checkFixedAttValue(qName, string3, xMLString2.toString());
                            }
                            if (bl3) {
                                int n16 = this.fStringBuffer.getOffset();
                                this.fStringBuffer.append(documentScannerSupport.namespaceURIs[n12]);
                                int n17 = this.fStringBuffer.getOffset();
                                this.fStringBuffer.setStringValues(n16, n17, documentScannerSupport.content);
                                this.fStringBuffer.normalizeTextValue(documentScannerSupport.content, null);
                                documentScannerSupport.nsHandles[n12] = this.fSymbolTable.addSymbol(documentScannerSupport.content);
                                documentScannerSupport.namespaceURIs[n12] = documentScannerSupport.content.str;
                            }
                            bl6 = true;
                            break;
                        }
                        ++n12;
                    }
                } else {
                    n12 = 0;
                    while (n12 < n5) {
                        if (qName.handle == documentScannerSupport.attrNames[n12].handle) {
                            if (n10 == this.fFIXEDSymbol) {
                                XMLString xMLString3 = documentScannerSupport.attValues[n12];
                                XMLString xMLString4 = xMLString;
                                this.checkFixedAttValue(qName, xMLString3.toString(), xMLString4.toString());
                            }
                            if (bl3) {
                                documentScannerSupport.attValueNormalized[n12] = false;
                                documentScannerSupport.attTypes[n12] = this.fSymbolTable.toString(n9);
                            }
                            bl6 = true;
                            break;
                        }
                        ++n12;
                    }
                }
                if (!bl6) {
                    if (bl) {
                        this.requiredAttributeNotSpecified(qName);
                    }
                    if (bl2) {
                        this.addDefaultAttribute(documentScannerSupport, qName, this.fSymbolTable.toString(n9), xMLString, n7);
                    }
                }
            }
            ++n6;
        }
    }

    protected void checkFixedAttValue(QName qName, String string, String string2) {
    }

    protected void requiredAttributeNotSpecified(QName qName) {
    }

    protected void addDefaultAttribute(DocumentScannerSupport documentScannerSupport, QName qName, String string, XMLString xMLString, int n) {
        documentScannerSupport.addDefaultAttribute(qName, string, xMLString);
    }

    public int getAttDefs(int n) {
        return this.fHaveAttDefs ? this.fAttDefs.get(n) : -1;
    }

    public int attDefsCount(int n) {
        return this.fDataStore.getListCount(n);
    }

    public int[] attDefsArray(int n) {
        return this.fDataStore.getListArray(n);
    }

    public int attDefsBase(int n) {
        return this.fDataStore.getListBase(n);
    }

    public int[] attDefArray(int n) {
        return this.fDataStore.getRecordArray(n);
    }

    public int attDefBase(int n) {
        return this.fDataStore.getRecordBase(n);
    }

    public QName attDefAttrName(int n) {
        int[] nArray = this.attDefArray(n);
        int n2 = this.attDefBase(n);
        int n3 = nArray[n2 + 0];
        QName qName = this.defaultAttrName(n3);
        return qName;
    }

    public XMLString attDefAttValue(int n) {
        int[] nArray = this.attDefArray(n);
        int n2 = this.attDefBase(n);
        int n3 = nArray[n2 + 4];
        XMLString xMLString = this.defaultAttValue(n3);
        return xMLString;
    }

    public boolean attDefIsExternal(int n) {
        int n2;
        int[] nArray = this.fDataStore.getRecordArray(n);
        return nArray[(n2 = this.fDataStore.getRecordBase(n)) + 5] != 0;
    }

    private QName defaultAttrName(int n) {
        return this.fDefaultAttrNames[n];
    }

    private XMLString defaultAttValue(int n) {
        return n != -1 ? this.fDefaultAttValues[n] : null;
    }

    public int lookupAttDef(QName qName, QName qName2) {
        int n;
        int n2;
        if (this.fHaveAttDefs && (n2 = this.fAttDefs.get(n = this.fSymbolTable.addSymbol((XMLString)qName))) != -1) {
            int n3 = this.fDataStore.getListCount(n2);
            int[] nArray = this.fDataStore.getListArray(n2);
            int n4 = this.fDataStore.getListBase(n2);
            int n5 = this.fSymbolTable.addSymbol((XMLString)qName2);
            int n6 = 0;
            while (n6 < n3) {
                int n7 = nArray[n4 + n6];
                int[] nArray2 = this.fDataStore.getRecordArray(n7);
                int n8 = this.fDataStore.getRecordBase(n7);
                int n9 = nArray2[n8 + 0];
                if (n5 == this.fDefaultAttrNames[n9].handle) {
                    return n7;
                }
                ++n6;
            }
        }
        return -1;
    }

    public void startAttDef(QName qName, XMLString xMLString) {
        this.fEnumerationTypeList = -1;
    }

    public void enumerationType(XMLString xMLString) {
        this.fEnumerationTypeList = this.fDataStore.addToList(this.fEnumerationTypeList, this.fSymbolTable.addSymbol(xMLString));
    }

    public void saveAttDef(QName qName, QName qName2, XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        QName[] qNameArray;
        int n;
        int n2 = this.fSymbolTable.addSymbol((XMLString)qName);
        int n3 = this.fSymbolTable.addSymbol((XMLString)qName2);
        int n4 = n = this.fHaveAttDefs ? this.fAttDefs.get(n2) : -1;
        if (qName2.localPart == XMLString.EMPTY_STRING) {
            if (qName2.sepOffset == -1) {
                qName2.localPart = this.fSymbolTable.toString(n3);
            } else {
                this.fSymbolTable.addQNameSymbols(qName2);
            }
        }
        int n5 = this.fDataStore.allocateRecord(6);
        int[] nArray = this.fDataStore.getRecordArray(n5);
        int n6 = this.fDataStore.getRecordBase(n5);
        if ((n3 = this.fDefaultAttrNamesCount++) == this.fDefaultAttrNames.length) {
            qNameArray = new QName[n3 << 1];
            System.arraycopy(this.fDefaultAttrNames, 0, qNameArray, 0, n3);
            this.fDefaultAttrNames = qNameArray;
            this.fDefaultAttrNames[n3] = new QName(qName2);
        } else if (this.fDefaultAttrNames[n3] == null) {
            this.fDefaultAttrNames[n3] = new QName(qName2);
        } else {
            this.fDefaultAttrNames[n3].setValues(qName2);
        }
        nArray[n6 + 0] = n3;
        int n7 = xMLString != null ? this.fSymbolTable.addSymbol(xMLString) : -1;
        int n8 = xMLString2 != null ? this.fSymbolTable.addSymbol(xMLString2) : -1;
        nArray[n6 + 1] = n7;
        nArray[n6 + 2] = n8;
        nArray[n6 + 3] = this.fEnumerationTypeList;
        if (xMLString3 != null) {
            if (n7 != this.fCDATASymbol) {
                this.normalizeDefaultAttValue(qName2, xMLString3, n7, n5);
            }
            if (this.fDefaultAttValuesCount == this.fDefaultAttValues.length) {
                qNameArray = new XMLString[this.fDefaultAttValuesCount << 1];
                System.arraycopy(this.fDefaultAttValues, 0, qNameArray, 0, this.fDefaultAttValuesCount);
                this.fDefaultAttValues = qNameArray;
                this.fDefaultAttValues[this.fDefaultAttValuesCount] = new XMLString(xMLString3);
            } else if (this.fDefaultAttValues[this.fDefaultAttValuesCount] == null) {
                this.fDefaultAttValues[this.fDefaultAttValuesCount] = new XMLString(xMLString3);
            } else {
                this.fDefaultAttValues[this.fDefaultAttValuesCount].setValues(xMLString3);
            }
            nArray[n6 + 4] = n3 = this.fDefaultAttValuesCount++;
        } else {
            nArray[n6 + 4] = -1;
        }
        int n9 = nArray[n6 + 5] = bl ? 1 : 0;
        if (n == -1) {
            n = this.fDataStore.addToList(-1, n5);
            if (this.fAttDefs == null) {
                this.fAttDefs = new IntegerHashtable();
            }
            this.fAttDefs.put(n2, n);
            this.fHaveAttDefs = true;
        } else {
            this.fDataStore.addToList(n, n5);
        }
    }

    protected void normalizeDefaultAttValue(QName qName, XMLString xMLString, int n, int n2) {
        this.fStringBuffer.normalizeTextValue(xMLString, null);
    }
}

