/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.ibm.xml.b2b.util.SymbolTable;

public final class XercesContentModel {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final int CONTENTSPECNODE_LEAF = 0;
    private static final int CONTENTSPECNODE_OCCURRENCE = 4;
    private static final int CONTENTSPECNODE_ZERO_OR_ONE = 4;
    private static final int CONTENTSPECNODE_ZERO_OR_MORE = 5;
    private static final int CONTENTSPECNODE_ONE_OR_MORE = 6;
    private static final int CONTENTSPECNODE_SEPARATOR = 8;
    private static final int CONTENTSPECNODE_CHOICE = 8;
    private static final int CONTENTSPECNODE_SEQ = 9;
    private boolean fContentModelMixed;
    private int fContentModelDepth;
    private int fOp;
    private int fNodeIndex;
    private int fPrevNodeIndex;
    private int[] fOpStack;
    private int[] fNodeIndexStack;
    private int[] fPrevNodeIndexStack;
    private int fContentSpecNodeCount;
    private int[][] fContentSpecNodeType = new int[4][];
    private int[][] fContentSpecNodeValue = new int[4][];
    private int[][] fContentSpecNodeValue2 = new int[4][];

    public void reset() {
        this.fContentModelMixed = false;
        this.fContentModelDepth = 0;
        this.fNodeIndex = -1;
    }

    public void startGroup() {
        ++this.fContentModelDepth;
        this.initializeContentModelStack(this.fContentModelDepth);
        this.fOp = -1;
        this.fNodeIndex = -1;
        this.fPrevNodeIndex = -1;
    }

    public void pcdata() {
        this.fContentModelMixed = true;
        this.fNodeIndex = this.addUniqueLeafNode(-1);
    }

    public void element(int n) {
        this.fNodeIndex = this.addUniqueLeafNode(n);
        if (!this.fContentModelMixed) {
            this.fNodeIndexStack[this.fContentModelDepth] = this.fNodeIndex;
        }
    }

    public void separator(int n) {
        if (this.fPrevNodeIndex != -1) {
            this.fNodeIndex = this.addBinaryContentSpecNode(this.fOp, this.fPrevNodeIndex, this.fNodeIndex);
        }
        this.fPrevNodeIndex = this.fNodeIndex;
        this.fOp = n == 0 ? 8 : 9;
        if (!this.fContentModelMixed) {
            this.fNodeIndexStack[this.fContentModelDepth] = this.fNodeIndex;
            this.fPrevNodeIndexStack[this.fContentModelDepth] = this.fPrevNodeIndex;
            this.fOpStack[this.fContentModelDepth] = this.fOp;
        }
    }

    public void occurrence(int n) {
        this.fNodeIndex = n == 0 ? this.addUnaryContentSpecNode(4, this.fNodeIndex) : (n == 1 ? this.addUnaryContentSpecNode(5, this.fNodeIndex) : this.addUnaryContentSpecNode(6, this.fNodeIndex));
        if (!this.fContentModelMixed) {
            this.fNodeIndexStack[this.fContentModelDepth] = this.fNodeIndex;
        }
    }

    public void endGroup() {
        if (this.fNodeIndex == -1) {
            this.fNodeIndex = this.fPrevNodeIndex;
        } else if (this.fPrevNodeIndex != -1) {
            this.fNodeIndex = this.addBinaryContentSpecNode(this.fOp, this.fPrevNodeIndex, this.fNodeIndex);
        }
        if (!this.fContentModelMixed) {
            --this.fContentModelDepth;
            this.fNodeIndexStack[this.fContentModelDepth] = this.fNodeIndex;
            this.fPrevNodeIndex = this.fPrevNodeIndexStack[this.fContentModelDepth];
            this.fOp = this.fOpStack[this.fContentModelDepth];
        }
    }

    public String toString(SymbolTable symbolTable) {
        if (this.fNodeIndex == -1) {
            return null;
        }
        return this.getContentSpecNodeAsString(symbolTable, this.fNodeIndex);
    }

    private void initializeContentModelStack(int n) {
        if (this.fOpStack == null) {
            this.fOpStack = new int[8];
            this.fNodeIndexStack = new int[8];
            this.fPrevNodeIndexStack = new int[8];
        } else if (n == this.fOpStack.length) {
            int[] nArray = new int[n << 1];
            System.arraycopy(this.fOpStack, 0, nArray, 0, n);
            this.fOpStack = nArray;
            nArray = new int[n << 1];
            System.arraycopy(this.fNodeIndexStack, 0, nArray, 0, n);
            this.fNodeIndexStack = nArray;
            nArray = new int[n << 1];
            System.arraycopy(this.fPrevNodeIndexStack, 0, nArray, 0, n);
            this.fPrevNodeIndexStack = nArray;
        }
        this.fOpStack[n] = -1;
        this.fNodeIndexStack[n] = -1;
        this.fPrevNodeIndexStack[n] = -1;
    }

    private void ensureContentSpecCapacity(int n) {
        if (n == this.fContentSpecNodeType.length) {
            int n2 = n << 1;
            int[][] nArrayArray = new int[n2][];
            System.arraycopy(this.fContentSpecNodeType, 0, nArrayArray, 0, n);
            this.fContentSpecNodeType = nArrayArray;
            nArrayArray = new int[n2][];
            System.arraycopy(this.fContentSpecNodeValue, 0, nArrayArray, 0, n);
            this.fContentSpecNodeValue = nArrayArray;
            nArrayArray = new int[n2][];
            System.arraycopy(this.fContentSpecNodeValue2, 0, nArrayArray, 0, n);
            this.fContentSpecNodeValue2 = nArrayArray;
            this.fContentSpecNodeType[n] = new int[256];
            this.fContentSpecNodeValue[n] = new int[256];
            this.fContentSpecNodeValue2[n] = new int[256];
        } else if (this.fContentSpecNodeType[n] == null) {
            this.fContentSpecNodeType[n] = new int[256];
            this.fContentSpecNodeValue[n] = new int[256];
            this.fContentSpecNodeValue2[n] = new int[256];
        }
    }

    private int createContentSpecNode(int n, int n2, int n3) {
        int n4 = this.fContentSpecNodeCount >>> 8;
        int n5 = this.fContentSpecNodeCount & 0xFF;
        this.ensureContentSpecCapacity(n4);
        this.fContentSpecNodeType[n4][n5] = n;
        this.fContentSpecNodeValue[n4][n5] = n2;
        this.fContentSpecNodeValue2[n4][n5] = n3;
        return this.fContentSpecNodeCount++;
    }

    private int addUniqueLeafNode(int n) {
        int n2 = this.createContentSpecNode(0, n, -1);
        return n2;
    }

    private int addUnaryContentSpecNode(int n, int n2) {
        int n3 = this.createContentSpecNode(n, n2, -1);
        return n3;
    }

    private int addBinaryContentSpecNode(int n, int n2, int n3) {
        int n4 = this.createContentSpecNode(n, n2, n3);
        return n4;
    }

    private int getContentSpecType(int n) {
        int n2 = n >>> 8;
        int n3 = n & 0xFF;
        return this.fContentSpecNodeType[n2][n3];
    }

    private int getContentSpecValue(int n) {
        int n2 = n >>> 8;
        int n3 = n & 0xFF;
        return this.fContentSpecNodeValue[n2][n3];
    }

    private int getContentSpecValue2(int n) {
        int n2 = n >>> 8;
        int n3 = n & 0xFF;
        return this.fContentSpecNodeValue2[n2][n3];
    }

    private void appendContentSpec(SymbolTable symbolTable, int n, int n2, int n3, StringBuffer stringBuffer, boolean bl, int n4) {
        if (n == 0) {
            if (n2 == -1) {
                stringBuffer.append("#PCDATA");
            } else {
                stringBuffer.append(symbolTable.toString(n2));
            }
        } else if ((n & 4) != 0) {
            boolean bl2 = (n4 & 4) != 0;
            n4 = n;
            n3 = n2;
            n = this.getContentSpecType(n3);
            n2 = this.getContentSpecValue(n3);
            if (bl2) {
                stringBuffer.append('(');
                this.appendContentSpec(symbolTable, n, n2, n3, stringBuffer, true, n4);
                stringBuffer.append(')');
            } else {
                this.appendContentSpec(symbolTable, n, n2, n3, stringBuffer, true, n4);
            }
            if (n4 == 4) {
                stringBuffer.append('?');
            } else if (n4 == 5) {
                stringBuffer.append('*');
            } else {
                stringBuffer.append('+');
            }
        } else {
            int n5 = this.getContentSpecValue2(n3);
            n4 = n;
            n3 = n2;
            n = this.getContentSpecType(n3);
            n2 = this.getContentSpecValue(n3);
            if (bl) {
                stringBuffer.append('(');
            }
            this.appendContentSpec(symbolTable, n, n2, n3, stringBuffer, n != n4, n4);
            if (n4 == 8) {
                stringBuffer.append('|');
            } else {
                stringBuffer.append(',');
            }
            n3 = n5;
            n = this.getContentSpecType(n3);
            n2 = this.getContentSpecValue(n3);
            this.appendContentSpec(symbolTable, n, n2, n3, stringBuffer, true, n4);
            if (bl) {
                stringBuffer.append(')');
            }
        }
    }

    private String getContentSpecNodeAsString(SymbolTable symbolTable, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getContentSpecType(n);
        int n3 = this.getContentSpecValue(n);
        int n4 = n2;
        if (n2 == 0) {
            stringBuffer.append('(');
            if (n3 == -1) {
                stringBuffer.append("#PCDATA");
            } else {
                stringBuffer.append(symbolTable.toString(n3));
            }
            stringBuffer.append(')');
        } else if ((n2 & 4) != 0) {
            n = n3;
            n2 = this.getContentSpecType(n);
            n3 = this.getContentSpecValue(n);
            if (n2 == 0) {
                stringBuffer.append('(');
                if (n4 == 5 && n3 == -1) {
                    stringBuffer.append("#PCDATA");
                } else {
                    stringBuffer.append(symbolTable.toString(n3));
                }
                stringBuffer.append(')');
            } else if ((n2 & 4) != 0) {
                stringBuffer.append('(');
                this.appendContentSpec(symbolTable, n2, n3, n, stringBuffer, true, n4);
                stringBuffer.append(')');
            } else {
                this.appendContentSpec(symbolTable, n2, n3, n, stringBuffer, true, n4);
            }
            if (n4 == 4) {
                stringBuffer.append('?');
            } else if (n4 == 5) {
                stringBuffer.append('*');
            } else {
                stringBuffer.append('+');
            }
        } else {
            this.appendContentSpec(symbolTable, n2, n3, n, stringBuffer, true, -1);
        }
        return stringBuffer.toString();
    }
}

