/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

public class PKCS11Exception
extends RuntimeException {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_PARALLEL = 82;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_EXCLUSIVE_EXISTS = 178;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int INSERTION_CALLBACK_SET = 320;
    public static final int INSERTION_CALLBACK_NOT_SUPPORTED = 321;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    static final int[] codes;
    static final String[] messages;
    int code;

    public PKCS11Exception(int n2) {
        super(PKCS11Exception.errorMessage(n2));
        this.code = n2;
    }

    public PKCS11Exception(String string) {
        super(string);
        this.code = Integer.MIN_VALUE;
    }

    public int getCode() {
        return this.code;
    }

    static String errorMessage(int n2) {
        if ((n2 & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return PKCS11Exception.a("\u007f\u0017 3b[R*2k@\u001c+3-L\u0000<8\u007f");
        }
        int n3 = 0;
        while (n3 < messages.length) {
            if (codes[n3] == n2) {
                return messages[n3];
            }
            ++n3;
        }
        return PKCS11Exception.a("|\u001c%9b^\u001cn2\u007f[\u001d<w%\u0019\n") + Integer.toHexString(n2) + ")";
    }

    static {
        int[] nArray = new int[88];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 6;
        nArray[6] = 7;
        nArray[7] = 8;
        nArray[8] = 9;
        nArray[9] = 10;
        nArray[10] = 16;
        nArray[11] = 17;
        nArray[12] = 18;
        nArray[13] = 19;
        nArray[14] = 32;
        nArray[15] = 33;
        nArray[16] = 48;
        nArray[17] = 49;
        nArray[18] = 50;
        nArray[19] = 64;
        nArray[20] = 65;
        nArray[21] = 80;
        nArray[22] = 81;
        nArray[23] = 82;
        nArray[24] = 84;
        nArray[25] = 96;
        nArray[26] = 98;
        nArray[27] = 99;
        nArray[28] = 100;
        nArray[29] = 101;
        nArray[30] = 102;
        nArray[31] = 103;
        nArray[32] = 104;
        nArray[33] = 105;
        nArray[34] = 106;
        nArray[35] = 112;
        nArray[36] = 113;
        nArray[37] = 130;
        nArray[38] = 144;
        nArray[39] = 145;
        nArray[40] = 160;
        nArray[41] = 161;
        nArray[42] = 162;
        nArray[43] = 163;
        nArray[44] = 164;
        nArray[45] = 176;
        nArray[46] = 177;
        nArray[47] = 178;
        nArray[48] = 179;
        nArray[49] = 180;
        nArray[50] = 181;
        nArray[51] = 182;
        nArray[52] = 183;
        nArray[53] = 184;
        nArray[54] = 192;
        nArray[55] = 193;
        nArray[56] = 208;
        nArray[57] = 209;
        nArray[58] = 224;
        nArray[59] = 225;
        nArray[60] = 226;
        nArray[61] = 240;
        nArray[62] = 241;
        nArray[63] = 242;
        nArray[64] = 256;
        nArray[65] = 257;
        nArray[66] = 258;
        nArray[67] = 259;
        nArray[68] = 260;
        nArray[69] = 261;
        nArray[70] = 272;
        nArray[71] = 274;
        nArray[72] = 275;
        nArray[73] = 276;
        nArray[74] = 277;
        nArray[75] = 288;
        nArray[76] = 289;
        nArray[77] = 320;
        nArray[78] = 321;
        nArray[79] = 336;
        nArray[80] = 352;
        nArray[81] = 368;
        nArray[82] = 384;
        nArray[83] = 400;
        nArray[84] = 401;
        nArray[85] = 416;
        nArray[86] = 417;
        nArray[87] = Integer.MIN_VALUE;
        codes = nArray;
        messages = new String[]{PKCS11Exception.a("o\u0007 4y@\u001d weH\u0001n4bD\u0002\"2yL\u0016n$xJ\u0011+$~O\u0007\";t"), PKCS11Exception.a("o\u0007 4y@\u001d w~A\u001d;;i\t\u0010+wnH\u001c-2aL\u0016"), PKCS11Exception.a("g\u001d:whG\u001d;0e\t\u001f+:b[\u000bn8c\t\u001a!$y"), PKCS11Exception.a("z\u001e!#-`6n>~\t\u001b !lE\u001b*"), PKCS11Exception.a("|\u001c<2nF\u0004+%lK\u001e+wh[\u0000!%"), PKCS11Exception.a("}\u001a+w\u007fL\u0003;2~]\u0017*wk\\\u001c-#dF\u001cn4b\\\u001e*wcF\u0006n5h\t\u0002+%kF\u0000#2i"), PKCS11Exception.a("z\u0007>'a@\u0017*wl[\u0015;:hG\u0006=wcF\u0006n6}Y\u0000!'\u007f@\u0013:2"), PKCS11Exception.a("g\u001dn9h^R+!hG\u0006=wl_\u0013';lK\u001e+"), PKCS11Exception.a("g\u0013:>{LR:?\u007fL\u0013*w~\\\u0002>8\u007f]R<2|\\\u001b<2i"), PKCS11Exception.a("e\u001d-<dG\u0015n9b]R/!l@\u001e/5aL"), PKCS11Exception.a("h\u0006:%dK\u0007:2-@\u0001n%hH\u0016c8cE\u000b"), PKCS11Exception.a("h\u0006:%dK\u0007:2-@\u0001n$hG\u0001'#d_\u0017n6cMR-6cG\u001d:woLR<2{L\u0013\"2i"), PKCS11Exception.a("h\u0006:%dK\u0007:2-]\u000b>2-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("h\u0006:%dK\u0007:2-_\u0013\"\"h\t\u001b=wdG\u0004/;dM"), PKCS11Exception.a("m\u0013:6-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("`\u001c86a@\u0016n3l]\u0013n;hG\u0015:?"), PKCS11Exception.a("m\u00178>nLR+%\u007fF\u0000"), PKCS11Exception.a("g\u001d:whG\u001d;0e\t\u001f+:b[\u000bn8c\t\u0016+!dJ\u0017"), PKCS11Exception.a("m\u00178>nLR&6~\t\u0010+2c\t\u0000+:b_\u0017*"), PKCS11Exception.a("l\u001c-%tY\u0006+3-M\u0013:6-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("l\u001c-%tY\u0006+3-M\u0013:6-E\u0017 0yAR'$-F\u0007:wbOR<6cN\u0017"), PKCS11Exception.a("o\u0007 4y@\u001d weH\u0001n5hL\u001cn4lG\u0011+;hM"), PKCS11Exception.a("g\u001dn1xG\u0011:>bGR'$-L\n+4x]\u001b 0-@\u001cn'l[\u0013\";hE"), PKCS11Exception.a("o\u0007 4y@\u001d wdZR+/hJ\u0007:>cNR'9-Y\u0013<6aE\u0017\""), PKCS11Exception.a("}\u001a+w\u007fL\u0003;2~]\u0017*wk\\\u001c-#dF\u001cn>~\t\u001c!#-Z\u0007>'b[\u0006+3"), PKCS11Exception.a("b\u00177weH\u001c*;h\t\u001b=wdG\u0004/;dM"), PKCS11Exception.a("b\u00177w~@\b+wdZR!\"y\t\u001d(w\u007fH\u001c)2"), PKCS11Exception.a("b\u00177wyP\u0002+wdZR'9nF\u001c=>~]\u0017 #-^\u001b:?-D\u0017-?lG\u001b=:"), PKCS11Exception.a("b\u00177wcF\u0006n9hL\u0016+3!\t\u00176#\u007fH\u001c+8xZR%2t\t\u0001;'}E\u001b+3"), PKCS11Exception.a("b\u00177weH\u0001n5hL\u001cn4eH\u001c)2i"), PKCS11Exception.a("b\u00177wcL\u0017*2i\u0005R 8-B\u00177w~\\\u0002>;dL\u0016"), PKCS11Exception.a("}\u001a+w{H\u001e;2-F\u0014n#eLR='hJ\u001b(>hMR%2t\t\u0011/9cF\u0006n5h\t\u0016'0hZ\u0006+3"), PKCS11Exception.a("o\u0007 4y@\u001d wcF\u0006n'h[\u001f'#yL\u0016n1b[R:?dZR%2t"), PKCS11Exception.a("b\u00177wnH\u001c 8y\t\u0010+wz[\u0013>'hM"), PKCS11Exception.a("b\u00177wdZR;9hQ\u0006<6n]\u0013,;h"), PKCS11Exception.a("d\u0017-?lG\u001b=:-@\u001c86a@\u0016"), PKCS11Exception.a("d\u0017-?lG\u001b=:-Y\u0013<6`L\u0006+%-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("f\u0010$2n]R&6cM\u001e+wdZR'9{H\u001e'3"), PKCS11Exception.a("h\u001c!#eL\u0000n8}L\u0000/#dF\u001cn>~\t\u0013\"%hH\u00167wlJ\u0006'!h"), PKCS11Exception.a("f\u0002+%l]\u001b!9-A\u0013=wcF\u0006n5hL\u001cn>c@\u0006'6a@\b+3"), PKCS11Exception.a("y\u001b wdZR'9nF\u0000<2n]"), PKCS11Exception.a("g\u00179w]`<n4b]\u0013'9~\t\u001b !lE\u001b*wnA\u0013<6n]\u0017<$"), PKCS11Exception.a("g\u00179w]`<n;hG\u0015:?-@\u0001n8x]R!1-[\u0013 0h"), PKCS11Exception.a("y\u001b weH\u0001n2uY\u001b<2i"), PKCS11Exception.a("y\u001b wdZR\"8nB\u0017*"), PKCS11Exception.a("z\u0017=$dF\u001cn?lZR,2hGR-;bZ\u0017*"), PKCS11Exception.a("z\u0017=$dF\u001cn;dD\u001b:$-A\u001382-K\u0017+9-[\u0017/4eL\u0016"), PKCS11Exception.a("h\u001cn2uJ\u001e;$d_\u0017n$hZ\u0001'8c\t\u0013\"%hH\u00167whQ\u001b=#~"), PKCS11Exception.a("z\u0017=$dF\u001cn?lG\u0016\"2-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("y\u0013<6aE\u0017\"whQ\u0017-\"y@\u001d wdZR 8y\t\u0001;'}F\u0000:2i"), PKCS11Exception.a("z\u0017=$dF\u001cn>~\t\u0000+6i\u0004\u001d ;t"), PKCS11Exception.a("hR=2~Z\u001b!9-^\u001b:?-]\u001a+wyF\u0019+9-@\u0001n6a[\u0017/3t\t\u001d>2c"), PKCS11Exception.a("hR<2lM_!9aPR=2~Z\u001b!9-H\u001e<2lM\u000bn2u@\u0001:$-H\u001c*wyA\u0017n\u0004B\t\u0011/9cF\u0006n5h\t\u001e!0jL\u0016n>c"), PKCS11Exception.a("hR<2lM]9%d]\u0017n\u0004B\t\u0001+$~@\u001d wlE\u0000+6iPR+/dZ\u0006=wlG\u0016n#eLR\u001d\u0018-J\u0013 9b]R,2-E\u001d)0hMR'9"), PKCS11Exception.a("z\u001b)9l]\u0007<2-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("z\u001b)9l]\u0007<2-E\u0017 0yAR'$-F\u0007:wbOR<6cN\u0017"), PKCS11Exception.a("}\u0017#'aH\u0006+wdZR'9nF\u001f>;h]\u0017"), PKCS11Exception.a("}\u0017#'aH\u0006+wdZR'9nF\u001c=>~]\u0017 #"), PKCS11Exception.a("z\u001e!#-M\u001d+$-G\u001d:wnF\u001c:6dGR/wyF\u0019+9"), PKCS11Exception.a("}\u001a+wyF\u0019+9-^\u0013=wcF\u0006n%hJ\u001d)9dS\u0017*"), PKCS11Exception.a("}\u001d%2c\t\u001b=wz[\u001b:2 Y\u0000!#hJ\u0006+3"), PKCS11Exception.a("|\u001c9%lY\u0002'9j\t\u0019+.-A\u0013 3aLR'$-@\u001c86a@\u0016"), PKCS11Exception.a("|\u001c9%lY\u0002'9j\t\u0019+.-Z\u001b42-@\u0001n8x]R!1-[\u0013 0h"), PKCS11Exception.a("|\u001c9%lY\u0002'9j\t\u0019+.-@\u0001n>cJ\u001d $dZ\u0006+9y\t\u0005'#e\t\u001f+4eH\u001c'$`"), PKCS11Exception.a("hR;$h[R'$-H\u001e<2lM\u000bn;bN\u0015+3-@\u001c"), PKCS11Exception.a("hR;$h[R'$-G\u001d:waF\u0015)2i\t\u001b "), PKCS11Exception.a("}\u001a+wxZ\u0017<p~\t\"\u0007\u0019-A\u0013=wcF\u0006n5hL\u001cn>c@\u0006'6a@\b+3"), PKCS11Exception.a("|\u0001+%-]\u000b>2-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("h\u001c!#eL\u0000n\"~L\u0000n>~\t\u0013\"%hH\u00167waF\u0015)2i\t\u001b "), PKCS11Exception.a("}\u001d!w`H\u001c7wxZ\u0017<$-E\u001d)0hMR'9"), PKCS11Exception.a("~\u0000/'}L\u0016n<hPR'$-@\u001c86a@\u0016"), PKCS11Exception.a("~\u0000/'}L\u0016n<hPR\"2cN\u0006&wdZR!\"y\t\u001d(w\u007fH\u001c)2"), PKCS11Exception.a("~\u0000/'}@\u001c)wfL\u000bn?lG\u0016\"2-@\u0001n>c_\u0013\">i"), PKCS11Exception.a("~\u0000/'}@\u001c)wfL\u000bn$dS\u0017n>~\t\u001b !lE\u001b*"), PKCS11Exception.a("~\u0000/'}@\u001c)wfL\u000bn#tY\u0017n>~\t\u001b 4bG\u0001'$yL\u001c:wz@\u0006&w`L\u0011&6c@\u0001#"), PKCS11Exception.a("{\u0013 3bDR \"`K\u0017<wjL\u001c+%l]\u001d<wiF\u0017=wcF\u0006n6nJ\u0017>#-Z\u0017+3dG\u0015"), PKCS11Exception.a("}\u001a+wyF\u0019+9-M\u001d+$-G\u001d:weH\u0004+wl\t\u0000/9iF\u001fn9xD\u0010+%-N\u0017 2\u007fH\u0006!%"), PKCS11Exception.a("`\u001c=2\u007f]\u001b!9Rj3\u0002\u001bOh1\u0005\b^l&"), PKCS11Exception.a("}\u001a+w~E\u001d:wiF\u0017=wcF\u0006n$xY\u0002!%y\t\u0006!<hGR'9~L\u0000:>bGR-6aE\u0010/4fZ"), PKCS11Exception.a("k\u0007(1h[R:8b\t\u0001#6aE"), PKCS11Exception.a("}\u001a+w~H\u0004+3-F\u0002+%l]\u001b!9~\t\u0001:6yLR'$-@\u001c86a@\u0016n6cMR-6cG\u001d:woLR<2~]\u001d<2i"), PKCS11Exception.a("}\u001a+w\u007fL\u0003;2~]\u0017*wdG\u0014!%`H\u0006'8c\t\u001b=w~L\u001c=>y@\u0004+wlG\u0016n4lG\u001c!#-K\u0017n%h_\u0017/;hM"), PKCS11Exception.a("}\u001a+wbY\u0017<6y@\u001d $-Z\u0006/#h\t\u0011/9cF\u0006n5h\t\u0001/!hM"), PKCS11Exception.a("j\u00007'yF\u0019'wdZR 8y\t\u000b+#-@\u001c'#dH\u001e'-hM"), PKCS11Exception.a("j\u00007'yF\u0019'wdZR/;\u007fL\u0013*.-@\u001c'#dH\u001e'-hM"), PKCS11Exception.a("d\u0007:2u\t\u001d,=hJ\u0006n>~\t\u0010/3"), PKCS11Exception.a("d\u0007:2u\t\u001b=wcF\u0006n;bJ\u0019+3")};
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 41;
                        break;
                    }
                    case 1: {
                        n5 = 114;
                        break;
                    }
                    case 2: {
                        n5 = 78;
                        break;
                    }
                    case 3: {
                        n5 = 87;
                        break;
                    }
                    default: {
                        n5 = 13;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

