/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11MechanismInfo {
    public static final int HW = 1;
    public static final int ENCRYPT = 256;
    public static final int DECRYPT = 512;
    public static final int DIGEST = 1024;
    public static final int SIGN = 2048;
    public static final int SIGN_RECOVER = 4096;
    public static final int VERIFY = 8192;
    public static final int VERIFY_RECOVER = 16384;
    public static final int GENERATE = 32768;
    public static final int GENERATE_KEY_PAIR = 65536;
    public static final int WRAP = 131072;
    public static final int UNWRAP = 262144;
    public static final int DERIVE = 524288;
    public static final int EXTENSION = Integer.MIN_VALUE;
    static final int[] flagList = new int[]{1, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, Integer.MIN_VALUE};
    static final String[] flagNames = new String[]{PKCS11MechanismInfo.a("\u0002\u0006"), PKCS11MechanismInfo.a("\u000f\u001f-V\u0019\u001a\u0005"), PKCS11MechanismInfo.a("\u000e\u0014-V\u0019\u001a\u0005"), PKCS11MechanismInfo.a("\u000e\u0018)A\u0013\u001e"), PKCS11MechanismInfo.a("\u0019\u0018)J"), PKCS11MechanismInfo.a("\u0019\u0018)J\u001f\u0018\u0014-K\u0016\u000f\u0003"), PKCS11MechanismInfo.a("\u001c\u0014<M\u0006\u0013"), PKCS11MechanismInfo.a("\u001c\u0014<M\u0006\u0013\u000e<A\u0003\u0005\u0007+V"), PKCS11MechanismInfo.a("\r\u0014 A\u0012\u000b\u0005+"), PKCS11MechanismInfo.a("\r\u0014 A\u0012\u000b\u0005+[\u000b\u000f\b1T\u0001\u0003\u0003"), PKCS11MechanismInfo.a("\u001d\u0003/T"), PKCS11MechanismInfo.a("\u001f\u001f9V\u0001\u001a"), PKCS11MechanismInfo.a("\u000e\u0014<M\u0016\u000f"), PKCS11MechanismInfo.a("\u000f\t:A\u000e\u0019\u0018!J")};
    private int minKeySize;
    private int maxKeySize;
    private int flags;

    public PKCS11MechanismInfo(int n2, int n3, int n4) {
        this.minKeySize = n2;
        this.maxKeySize = n3;
        this.flags = n4;
    }

    public int minKeySize() {
        return this.minKeySize;
    }

    public int maxKeySize() {
        return this.maxKeySize;
    }

    public int flags() {
        return this.flags;
    }

    public String toString() {
        return PKCS11MechanismInfo.a("'8\u0000O%3\u0002\u0007~%w") + this.minKeySize + PKCS11MechanismInfo.a("fq\u0003e8\u00014\u0017W)04S") + this.maxKeySize + PKCS11MechanismInfo.a("fq\bh!-\"S") + this.flagsToString("|");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 74;
                        break;
                    }
                    case 1: {
                        n5 = 81;
                        break;
                    }
                    case 2: {
                        n5 = 110;
                        break;
                    }
                    case 3: {
                        n5 = 4;
                        break;
                    }
                    default: {
                        n5 = 64;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

