/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int OBJECT_ID = 18;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int AC_ISSUER = 131;
    public static final int OWNER = 132;
    public static final int ATTR_TYPES = 133;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int MODIFIABLE = 368;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int SECONDARY_AUTH = 512;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int RESET_ON_INIT = 769;
    public static final int HAS_RESET = 770;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer HW_FEATURE = new Integer(5);
    public static final Integer MONOTONIC_COUNTER = new Integer(1);
    public static final Integer CLOCK = new Integer(2);
    public static final Integer RSA = new Integer(0);
    public static final Integer DSA = new Integer(1);
    public static final Integer DH = new Integer(2);
    public static final Integer ECDSA = new Integer(3);
    public static final Integer MAYFLY = new Integer(4);
    public static final Integer KEA = new Integer(5);
    public static final Integer GENERIC_SECRET = new Integer(16);
    public static final Integer RC2 = new Integer(17);
    public static final Integer RC4 = new Integer(18);
    public static final Integer DES = new Integer(19);
    public static final Integer DES2 = new Integer(20);
    public static final Integer DES3 = new Integer(21);
    public static final Integer CAST = new Integer(22);
    public static final Integer CAST3 = new Integer(23);
    public static final Integer CAST5 = new Integer(24);
    public static final Integer CAST128 = new Integer(24);
    public static final Integer RC5 = new Integer(25);
    public static final Integer IDEA = new Integer(26);
    public static final Integer SKIPJACK = new Integer(27);
    public static final Integer BATON = new Integer(28);
    public static final Integer JUNIPER = new Integer(29);
    public static final Integer CDMF = new Integer(30);
    public static final Integer X_509 = new Integer(0);
    public static final Integer X_509_ATTR_CERT = new Integer(1);
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    private static final String[] objclassNames = new String[]{PKCS11Object.a("\u001e\u0013C\u0001"), PKCS11Object.a("\u0019\u0017E\u0014*\u001c\u001bT\u00017\u001f"), PKCS11Object.a("\n\u0007U\f*\u0019\r\\\u0005:"), PKCS11Object.a("\n\u0000^\u0016\"\u000e\u0017H\u000b&\u0003"), PKCS11Object.a("\t\u0017T\u0012&\u000e\r\\\u0005:"), PKCS11Object.a("\u0012\u0005H\u0006&\u001b\u0006B\u0012&")};
    private static final int[] attrtypeList;
    private static final String[] attrtypeNames;
    private static final Class[] attrValueClasses;
    private static final Integer[] keytypeList;
    private static final String[] keytypeNames;
    private static final int[] pinflagList;
    static final String[] pinflagNames;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            objectArray[n2] = this.getAttributeValue(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))))) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n2);
    }

    public int getIntAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))))) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n2);
    }

    public String getStringAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\t&e)\r="))))) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n2);
    }

    public byte[] getByteArrayAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))))) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n2);
    }

    public Date getDateAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("03a!M/&~,M\u001e3c%"))))) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n2);
    }

    public BigInteger getBigIntegerAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))))) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n2);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int n2, boolean bl2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))))) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Boolean(bl2));
    }

    public void setIntAttributeValue(int n2, int n3) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))))) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Integer(n3));
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(512);
        String string = PKCS11Object.a("zr7`Czr7`Czr7`Czr7`C");
        stringBuffer.append(PKCS11Object.a("50}%\u0000.h\u001d"));
        int n3 = 0;
        while (n3 < attrtypeList.length) {
            String string2;
            String string3;
            block6: {
                n2 = attrtypeList[n3];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    Object object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Exception.getCode() != 17) break block6;
                    string2 = PKCS11Object.a("r\u0013C\u00141\u0013\u0010B\u0014&\u0005\u0001R\u000e0\u0013\u0006^\u0016&s");
                }
            }
            if (string2 != null) {
                stringBuffer.append("\t").append(string3).append(":");
                stringBuffer.append(string.substring(string3.length()));
                stringBuffer.append(string2).append("\n");
            }
            ++n3;
        }
        try {
            n2 = this.size();
            stringBuffer.append(PKCS11Object.a("S\u0001^\u001a&`")).append(string.substring(4)).append(n2).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {}
        return stringBuffer.toString();
    }

    public static Class valueClass(int n2) {
        int n3 = 0;
        while (n3 < attrtypeList.length) {
            if (attrtypeList[n3] == n2) {
                return attrValueClasses[n3];
            }
            ++n3;
        }
        return null;
    }

    public static String typeToString(int n2) {
        int n3 = 0;
        while (n3 < attrtypeList.length) {
            if (attrtypeList[n3] == n2) {
                return attrtypeNames[n3];
            }
            ++n3;
        }
        return PKCS11Object.a("j*") + Integer.toString(n2, 16);
    }

    public static String classToString(Integer n2) {
        int n3 = n2;
        if (n3 >= 0 && n3 < objclassNames.length) {
            return objclassNames[n3];
        }
        return PKCS11Object.a("j*") + Integer.toString(n3, 16);
    }

    public static String keyToString(Integer n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < keytypeList.length) {
            if (keytypeList[n4] == n3) {
                return keytypeNames[n4];
            }
            ++n4;
        }
        return PKCS11Object.a("j*") + Integer.toHexString(n3);
    }

    public static String certToString(Integer n2) {
        if (n2.equals(X_509)) {
            return PKCS11Object.a("\u0002\r\"pZ");
        }
        if (n2.equals(X_509_ATTR_CERT)) {
            return PKCS11Object.a("\u0002\r\"pZ\u0005\u0013C\u00141\u0005\u0011R\u00127");
        }
        return PKCS11Object.a("j*") + Integer.toHexString(n2);
    }

    public static String hwfeatureToString(Integer n2) {
        if (n2.equals(MONOTONIC_COUNTER)) {
            return PKCS11Object.a("\u0017\u001dY\u000f7\u0015\u001c^\u0003<\u0019\u001dB\u000e7\u001f\u0000");
        }
        if (n2.equals(CLOCK)) {
            return PKCS11Object.a("\u0019\u001eX\u0003(");
        }
        return PKCS11Object.a("j*") + Integer.toHexString(n2);
    }

    public static String pinflagsToString(Integer n2) {
        return PKCS11.flagsToString(n2, pinflagList, pinflagNames, PKCS11Object.a("z.7"));
    }

    public static String attrToString(int n2, Object object) {
        if (object == null) {
            return PKCS11Object.a("4'{,");
        }
        switch (n2) {
            case 0: {
                return PKCS11Object.classToString((Integer)object);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)object);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)object);
            }
            case 513: {
                return PKCS11Object.pinflagsToString((Integer)object);
            }
            case 768: {
                return PKCS11Object.hwfeatureToString((Integer)object);
            }
            case 17: 
            case 18: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])object, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return PKCS11Object.a("j*") + ((BigInteger)object).toString(16);
            }
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n2) {
        if (byArray == null) {
            return PKCS11Object.a("4'{,");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (n2 != 0 && n4 > n2) {
                stringBuffer.append(PKCS11Object.a("z|9nCr")).append(byArray.length).append(PKCS11Object.a("z0n4\u0006){"));
                break;
            }
            if (n3 == 16) {
                stringBuffer.append('\n');
                n3 = 0;
            }
            if (n3 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(PKCS11Object.a("jc%sWod xZ;0t$\u0006<").charAt(byArray[n4] >> 4 & 0xF));
            stringBuffer.append(PKCS11Object.a("jc%sWod xZ;0t$\u0006<").charAt(byArray[n4] & 0xF));
            ++n4;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(PKCS11Object.a("zr=`_\u000e\u0013U\f&z\u0010X\u0012'\u001f\u00007\u00126\u0016\u0017D}\"\u0016\u001e7\u0003&\u0016\u001eG\u0001'\u001e\u001bY\u0007^il\u001d"));
        stringBuffer.append(PKCS11Object.a("zr=`_\u000e\u0000)`_\u000e\u001a)`\u0002.&e)\u0001/&r`\u0017#\"r`Czr7|7\u0012l7/\u000107t4C.+g%i"));
        int n2 = 0;
        while (n2 < attrtypeList.length) {
            String string = attrValueClasses[n2].getName();
            string = string.endsWith(PKCS11Object.a("\u0001\u0010")) ? PKCS11Object.a("8+c%8\u0007") : string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append(PKCS11Object.a("zr=`_\u000e\u0000)`_\u000e\u0016)`_\u000e\u0006)")).append(attrtypeNames[n2]);
            stringBuffer.append(PKCS11Object.a("f}C\u0014]znC\u0004]znC\u0014]")).append(string).append(PKCS11Object.a("f}C\u0014]P"));
            ++n2;
        }
        stringBuffer.append(PKCS11Object.a("zr=`_u\u0006V\u0002/\u001fl7|3dX"));
        System.out.println(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int[] nArray = new int[54];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 16;
        nArray[5] = 768;
        nArray[6] = 18;
        nArray[7] = 17;
        nArray[8] = 128;
        nArray[9] = 129;
        nArray[10] = 130;
        nArray[11] = 131;
        nArray[12] = 132;
        nArray[13] = 133;
        nArray[14] = 256;
        nArray[15] = 257;
        nArray[16] = 258;
        nArray[17] = 259;
        nArray[18] = 260;
        nArray[19] = 261;
        nArray[20] = 262;
        nArray[21] = 263;
        nArray[22] = 264;
        nArray[23] = 265;
        nArray[24] = 266;
        nArray[25] = 267;
        nArray[26] = 268;
        nArray[27] = 272;
        nArray[28] = 273;
        nArray[29] = 288;
        nArray[30] = 289;
        nArray[31] = 290;
        nArray[32] = 291;
        nArray[33] = 292;
        nArray[34] = 293;
        nArray[35] = 294;
        nArray[36] = 295;
        nArray[37] = 296;
        nArray[38] = 304;
        nArray[39] = 305;
        nArray[40] = 306;
        nArray[41] = 352;
        nArray[42] = 353;
        nArray[43] = 354;
        nArray[44] = 355;
        nArray[45] = 356;
        nArray[46] = 357;
        nArray[47] = 368;
        nArray[48] = 384;
        nArray[49] = 385;
        nArray[50] = 512;
        nArray[51] = 513;
        nArray[52] = 769;
        nArray[53] = 770;
        attrtypeList = nArray;
        attrtypeNames = new String[]{PKCS11Object.a("\u0019\u001eV\u00130"), PKCS11Object.a("\u000e\u001d\\\u0005-"), PKCS11Object.a("\n\u0000^\u0016\"\u000e\u0017"), PKCS11Object.a("\u0016\u0013U\u0005/"), PKCS11Object.a("\u001b\u0002G\f*\u0019\u0013C\t,\u0014"), PKCS11Object.a("\u0012\u0005H\u0006&\u001b\u0006B\u0012&\u0005\u0006N\u0010&"), PKCS11Object.a("\u0015\u0010]\u0005 \u000e\r^\u0004"), PKCS11Object.a("\f\u0013[\u0015&"), PKCS11Object.a("\u0019\u0017E\u0014*\u001c\u001bT\u00017\u001f\rC\u00193\u001f"), PKCS11Object.a("\u0013\u0001D\u0015&\b"), PKCS11Object.a("\t\u0017E\t\"\u0016\rY\u0015.\u0018\u0017E"), PKCS11Object.a("\u001b\u0011H\t0\t\u0007R\u0012"), PKCS11Object.a("\u0015\u0005Y\u00051"), PKCS11Object.a("\u001b\u0006C\u0012<\u000e\u000bG\u00050"), PKCS11Object.a("\u0011\u0017N\u001f7\u0003\u0002R"), PKCS11Object.a("\t\u0007U\n&\u0019\u0006"), PKCS11Object.a("\u0013\u0016"), PKCS11Object.a("\t\u0017Y\u0013*\u000e\u001bA\u0005"), PKCS11Object.a("\u001f\u001cT\u0012:\n\u0006"), PKCS11Object.a("\u001e\u0017T\u0012:\n\u0006"), PKCS11Object.a("\r\u0000V\u0010"), PKCS11Object.a("\u000f\u001c@\u0012\"\n"), PKCS11Object.a("\t\u001bP\u000e"), PKCS11Object.a("\t\u001bP\u000e<\b\u0017T\u000f5\u001f\u0000"), PKCS11Object.a("\f\u0017E\t%\u0003"), PKCS11Object.a("\f\u0017E\t%\u0003\rE\u0005 \u0015\u0004R\u0012"), PKCS11Object.a("\u001e\u0017E\t5\u001f"), PKCS11Object.a("\t\u0006V\u00127\u0005\u0016V\u0014&"), PKCS11Object.a("\u001f\u001cS\u001f'\u001b\u0006R"), PKCS11Object.a("\u0017\u001dS\u0015/\u000f\u0001"), PKCS11Object.a("\u0017\u001dS\u0015/\u000f\u0001H\u0002*\u000e\u0001"), PKCS11Object.a("\n\u0007U\f*\u0019\rR\u00183\u0015\u001cR\u000e7"), PKCS11Object.a("\n\u0000^\u0016\"\u000e\u0017H\u0005;\n\u001dY\u0005-\u000e"), PKCS11Object.a("\n\u0000^\r&\u0005c"), PKCS11Object.a("\n\u0000^\r&\u0005`"), PKCS11Object.a("\u001f\nG\u000f-\u001f\u001cC\u001fR"), PKCS11Object.a("\u001f\nG\u000f-\u001f\u001cC\u001fQ"), PKCS11Object.a("\u0019\u001dR\u0006%\u0013\u0011^\u0005-\u000e"), PKCS11Object.a("\n\u0000^\r&"), PKCS11Object.a("\t\u0007U\u00101\u0013\u001fR"), PKCS11Object.a("\u0018\u0013D\u0005"), PKCS11Object.a("\f\u0013[\u0015&\u0005\u0010^\u00140"), PKCS11Object.a("\f\u0013[\u0015&\u0005\u001eR\u000e"), PKCS11Object.a("\u001f\nC\u0012\"\u0019\u0006V\u0002/\u001f"), PKCS11Object.a("\u0016\u001dT\u0001/"), PKCS11Object.a("\u0014\u0017A\u00051\u0005\u0017O\u00141\u001b\u0011C\u0001!\u0016\u0017"), PKCS11Object.a("\u001b\u001e@\u0001:\t\rD\u0005-\t\u001bC\t5\u001f"), PKCS11Object.a("\u0017\u001dS\t%\u0013\u0013U\f&"), PKCS11Object.a("\u001f\u0011S\u0013\"\u0005\u0002V\u0012\"\u0017\u0001"), PKCS11Object.a("\u001f\u0011H\u0010,\u0013\u001cC"), PKCS11Object.a("\t\u0017T\u000f-\u001e\u0013E\u0019<\u001b\u0007C\b"), PKCS11Object.a("\u001b\u0007C\b<\n\u001bY\u001f%\u0016\u0013P\u0013"), PKCS11Object.a("\b\u0017D\u00057\u0005\u001dY\u001f*\u0014\u001bC"), PKCS11Object.a("\u0012\u0013D\u001f1\u001f\u0001R\u0014")};
        attrValueClasses = new Class[]{class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\t&e)\r="))), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\t&e)\r="))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("03a!M/&~,M\u001e3c%"))), class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("03a!M/&~,M\u001e3c%"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("03a!M73c(M\u0018;p\t\r.7p%\u0011"))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), array$B != null ? array$B : (array$B = PKCS11Object.class$(PKCS11Object.a("\u0001\u0010"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0013<c%\u0004? "))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<"))), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("03a!M63y'M\u0018=x,\u0006;<")))};
        keytypeList = new Integer[]{RSA, DSA, DH, ECDSA, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF};
        keytypeNames = new String[]{PKCS11Object.a("\b\u0001V"), PKCS11Object.a("\u001e\u0001V"), PKCS11Object.a("\u001e\u001a"), PKCS11Object.a("\u001f\u0011S\u0013\""), PKCS11Object.a("\u0017\u0013N\u0006/\u0003"), PKCS11Object.a("\u0011\u0017V"), PKCS11Object.a("\u001d\u0017Y\u00051\u0013\u0011H\u0013&\u0019\u0000R\u0014"), PKCS11Object.a("\b\u0011%"), PKCS11Object.a("\b\u0011#"), PKCS11Object.a("\u001e\u0017D"), PKCS11Object.a("\u001e\u0017Dr"), PKCS11Object.a("\u001e\u0017Ds"), PKCS11Object.a("\u0019\u0013D\u0014"), PKCS11Object.a("\u0019\u0013D\u0014P"), PKCS11Object.a("\u0019\u0013D\u0014V"), PKCS11Object.a("\b\u0011\""), PKCS11Object.a("\u0013\u0016R\u0001"), PKCS11Object.a("\t\u0019^\u0010)\u001b\u0011\\"), PKCS11Object.a("\u0018\u0013C\u000f-"), PKCS11Object.a("\u0010\u0007Y\t3\u001f\u0000"), PKCS11Object.a("\u0019\u0016Z\u0006")};
        pinflagList = new int[]{65536, 131072, 262144, 524288};
        pinflagNames = new String[]{PKCS11Object.a("\u000f\u0001R\u0012<\n\u001bY\u001f \u0015\u0007Y\u0014<\u0016\u001d@"), PKCS11Object.a("\u000f\u0001R\u0012<\n\u001bY\u001f%\u0013\u001cV\f<\u000e\u0000N"), PKCS11Object.a("\u000f\u0001R\u0012<\n\u001bY\u001f/\u0015\u0011\\\u0005'"), PKCS11Object.a("\u000f\u0001R\u0012<\n\u001bY\u001f7\u0015\rU\u0005<\u0019\u001aV\u000e$\u001f\u0016")};
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 90;
                        break;
                    }
                    case 1: {
                        n5 = 82;
                        break;
                    }
                    case 2: {
                        n5 = 23;
                        break;
                    }
                    case 3: {
                        n5 = 64;
                        break;
                    }
                    default: {
                        n5 = 99;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

