/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
    static final String[] flagNames = new String[]{PKCS11TokenInfo.a("<e\\"), PKCS11TokenInfo.a("9yR5z1{I.k+hO${"), PKCS11TokenInfo.a("\"d\\(q1y^0j'y^%"), PKCS11TokenInfo.a(";x^3`>bU>v bO(~\"bA${"), PKCS11TokenInfo.a("+sX-j=bM$`+sR2k="), PKCS11TokenInfo.a("<nH5p<nD*z7tU.k1e^${+o"), PKCS11TokenInfo.a("-gT\"t1dU>k!`^/"), PKCS11TokenInfo.a("=~K1p<\u007fH>o/yZ-s+g"), PKCS11TokenInfo.a(">yT5z-\u007f^%`/~O)z \u007fR\"~:bT/`>jO)"), PKCS11TokenInfo.a("*~Z-`-yB1k!tT1z<jO(p x"), PKCS11TokenInfo.a(":dP$q1bU(k'jW(e+o"), PKCS11TokenInfo.a("=nX.q*jI8`/~O)z \u007fR\"~:bT/"), PKCS11TokenInfo.a(";x^3`>bU>|!~U5`\"dL"), PKCS11TokenInfo.a(";x^3`>bU>y'eZ-`:yB"), PKCS11TokenInfo.a(";x^3`>bU>s!hP${"), PKCS11TokenInfo.a(";x^3`>bU>k!tY$`-cZ/x+o"), PKCS11TokenInfo.a("=dD1v tX.j \u007fD-p9"), PKCS11TokenInfo.a("=dD1v t](q/gD5m7"), PKCS11TokenInfo.a("=dD1v tW.|%n_"), PKCS11TokenInfo.a("=dD1v tO.`,nD\"w/e\\${")};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, String string5) {
        this.label = string;
        this.manufacturer = string2;
        this.model = string3;
        this.serialNumber = string4;
        this.flags = n2;
        this.maxSessionCount = n3;
        this.sessionCount = n4;
        this.maxRwSessionCount = n5;
        this.rwSessionCount = n6;
        this.maxPinLen = n7;
        this.minPinLen = n8;
        this.totalPublicMemory = n9;
        this.freePublicMemory = n10;
        this.totalPrivateMemory = n11;
        this.freePrivateMemory = n12;
        this.hardwareVersion = n13;
        this.firmwareVersion = n14;
        this.utcTime = string5;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return PKCS11TokenInfo.a(">`X2\u000e_\u007ft\nZ\u0000bu\u0007PT!;A\u001fNgz\u0003Z\u0002\u0011;A\u001fN\u000b;A\u001fN\u000b;A\u001f") + this.label + PKCS11TokenInfo.a("d\u000b;A\u001f#Ju\u0014Y\u000fHo\u0014M\u000bY!A\u001fN\u000b;A") + this.manufacturer + PKCS11TokenInfo.a("d\u000b;A\u001f#D\u007f\u0004ST\u000b;A\u001fN\u000b;A\u001fN\u000b;A") + this.model + PKCS11TokenInfo.a("d\u000b;A\u001f=Ni\b^\u0002\u0011;A\u001fN\u000b;A\u001fN\u000b;A") + this.serialNumber + PKCS11TokenInfo.a("d\u000b;A\u001f(Gz\u0006LT\u000b;A\u001fN\u000b;A\u001fN\u000b;A") + this.flagsToString(PKCS11TokenInfo.a("NW;")) + PKCS11TokenInfo.a("d\u000b;A\u001f#JcAL\u000bXh\bP\u0000X!A\u001fN\u000b;A") + this.infinite(this.maxSessionCount) + PKCS11TokenInfo.a("d\u000b;A\u001f=Nh\u0012V\u0001Eh[\u001fN\u000b;A\u001fN\u000b;A") + this.unavailable(this.sessionCount) + PKCS11TokenInfo.a("d\u000b;A\u001f#JcAm9\u000bh\u0004L\u001dBt\u000fLT\u000b;A") + this.infinite(this.maxRwSessionCount) + PKCS11TokenInfo.a("d\u000b;A\u001f<|;\u0012Z\u001dXr\u000eQ\u001d\u0011;A\u001fN\u000b;A") + this.unavailable(this.rwSessionCount) + PKCS11TokenInfo.a("d\u000b;A\u001f#JcAo'e;\rZ\u0000\u0011;A\u001fN\u000b;A") + this.maxPinLen + PKCS11TokenInfo.a("d\u000b;A\u001f#BuAo'e;\rZ\u0000\u0011;A\u001fN\u000b;A") + this.minPinLen + PKCS11TokenInfo.a("d\u000b;A\u001f:Do\u0000SN[n\u0003S\u0007H;\fZ\u0003\u0011;A") + this.unavailable(this.totalPublicMemory) + PKCS11TokenInfo.a("d\u000b;A\u001f(Y~\u0004\u001f\u001e^y\rV\r\u000bv\u0004RT\u000b;A") + this.unavailable(this.freePublicMemory) + PKCS11TokenInfo.a("d\u000b;A\u001f:Do\u0000SN[i\bI\u000f_~AR\u000bF!A") + this.unavailable(this.totalPrivateMemory) + PKCS11TokenInfo.a("d\u000b;A\u001f(Y~\u0004\u001f\u001eYr\u0017^\u001aN;\fZ\u0003\u0011;A") + this.unavailable(this.freePrivateMemory) + PKCS11TokenInfo.a("d\u000b;A\u001f&Ji\u0005H\u000fY~AI\u000bYh\bP\u0000\u0011;A") + PKCS11.versionString(this.hardwareVersion) + PKCS11TokenInfo.a("d\u000b;A\u001f(Bi\fH\u000fY~AI\u000bYh\bP\u0000\u0011;A") + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? PKCS11TokenInfo.a("d\u000b;A\u001f;\u007fXAK\u0007F~[\u001fN\u000b;A\u001fN\u000b;A") + this.utcTime : "");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    String infinite(int n2) {
        if (n2 == 0) {
            return PKCS11TokenInfo.a("+m]$|:bM$s7tR/y'eR5z");
        }
        return this.unavailable(n2);
    }

    String unavailable(int n2) {
        if (n2 == -1) {
            return PKCS11TokenInfo.a(";eZ7~'gZ#s+tR/y!yV k'dU");
        }
        return Integer.toString(n2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 110;
                        break;
                    }
                    case 1: {
                        n5 = 43;
                        break;
                    }
                    case 2: {
                        n5 = 27;
                        break;
                    }
                    case 3: {
                        n5 = 97;
                        break;
                    }
                    default: {
                        n5 = 63;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

