/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.security.auth.NTDomainPrincipal;
import com.ibm.security.auth.NTNumericCredential;
import com.ibm.security.auth.NTSidDomainPrincipal;
import com.ibm.security.auth.NTSidGroupPrincipal;
import com.ibm.security.auth.NTSidPrimaryGroupPrincipal;
import com.ibm.security.auth.NTSidUserPrincipal;
import com.ibm.security.auth.NTUserPrincipal;
import com.ibm.security.auth.module.NTSystem;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class NTLoginModule
implements LoginModule {
    private NTSystem ntSystem;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean debugNative = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private NTUserPrincipal userPrincipal;
    private NTSidUserPrincipal userSID;
    private NTDomainPrincipal userDomain;
    private NTSidDomainPrincipal domainSID;
    private NTSidPrimaryGroupPrincipal primaryGroup;
    private NTSidGroupPrincipal[] groups;
    private NTNumericCredential numericCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        this.debugNative = "true".equalsIgnoreCase((String)map2.get("debugNative"));
        if (this.debugNative) {
            this.debug = true;
        }
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        this.ntSystem = new NTSystem(this.debugNative);
        if (this.ntSystem == null) {
            if (this.debug) {
                System.out.println("\t\t[NTLoginModule] Failed in NT login");
            }
            throw new FailedLoginException("Failed in attempt to import the underlying NT system identity information");
        }
        if (this.ntSystem.getName() == null) {
            throw new FailedLoginException("Failed in attempt to import the underlying NT system identity information");
        }
        this.userPrincipal = new NTUserPrincipal(this.ntSystem.getName());
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule] succeeded importing info: ");
            System.out.println("\t\t\tuser name = " + this.userPrincipal.getName());
        }
        if (this.ntSystem.getUserSID() != null) {
            this.userSID = new NTSidUserPrincipal(this.ntSystem.getUserSID());
            if (this.debug) {
                System.out.println("\t\t\tuser SID = " + this.userSID.getName());
            }
        }
        if (this.ntSystem.getDomain() != null) {
            this.userDomain = new NTDomainPrincipal(this.ntSystem.getDomain());
            if (this.debug) {
                System.out.println("\t\t\tuser domain = " + this.userDomain.getName());
            }
        }
        if (this.ntSystem.getDomainSID() != null) {
            this.domainSID = new NTSidDomainPrincipal(this.ntSystem.getDomainSID());
            if (this.debug) {
                System.out.println("\t\t\tuser domain SID = " + this.domainSID.getName());
            }
        }
        if (this.ntSystem.getPrimaryGroupID() != null) {
            this.primaryGroup = new NTSidPrimaryGroupPrincipal(this.ntSystem.getPrimaryGroupID());
            if (this.debug) {
                System.out.println("\t\t\tuser primary group = " + this.primaryGroup.getName());
            }
        }
        if (this.ntSystem.getGroupIDs() != null && this.ntSystem.getGroupIDs().length > 0) {
            String[] stringArray = this.ntSystem.getGroupIDs();
            this.groups = new NTSidGroupPrincipal[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.groups[i] = new NTSidGroupPrincipal(stringArray[i]);
                if (!this.debug) continue;
                System.out.println("\t\t\tuser group = " + this.groups[i].getName());
            }
        }
        if (this.ntSystem.getImpersonationToken() != 0L) {
            this.numericCredential = new NTNumericCredential((int)this.ntSystem.getImpersonationToken());
            if (this.debug) {
                System.out.println("\t\t\tnumeric credential = " + this.numericCredential.getToken());
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[NTLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.userPrincipal)) {
            set.add((Principal)this.userPrincipal);
        }
        if (this.userSID != null && !set.contains(this.userSID)) {
            set.add((Principal)this.userSID);
        }
        if (this.userDomain != null && !set.contains(this.userDomain)) {
            set.add((Principal)this.userDomain);
        }
        if (this.domainSID != null && !set.contains(this.domainSID)) {
            set.add((Principal)this.domainSID);
        }
        if (this.primaryGroup != null && !set.contains(this.primaryGroup)) {
            set.add((Principal)this.primaryGroup);
        }
        for (int i = 0; this.groups != null && i < this.groups.length; ++i) {
            if (set.contains(this.groups[i])) continue;
            set.add((Principal)this.groups[i]);
        }
        if (this.numericCredential != null && !this.subject.getPublicCredentials().contains(this.numericCredential)) {
            this.subject.getPublicCredentials().add(this.numericCredential);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.ntSystem = null;
            this.userPrincipal = null;
            this.userSID = null;
            this.userDomain = null;
            this.domainSID = null;
            this.primaryGroup = null;
            this.groups = null;
            this.numericCredential = null;
            this.succeeded = false;
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (set.contains(this.userPrincipal)) {
            set.remove(this.userPrincipal);
        }
        if (set.contains(this.userSID)) {
            set.remove(this.userSID);
        }
        if (set.contains(this.userDomain)) {
            set.remove(this.userDomain);
        }
        if (set.contains(this.domainSID)) {
            set.remove(this.domainSID);
        }
        if (set.contains(this.primaryGroup)) {
            set.remove(this.primaryGroup);
        }
        for (int i = 0; this.groups != null && i < this.groups.length; ++i) {
            if (!set.contains(this.groups[i])) continue;
            set.remove(this.groups[i]);
        }
        Set<Object> set2 = this.subject.getPublicCredentials();
        if (set2.contains(this.numericCredential)) {
            set2.remove(this.numericCredential);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.userDomain = null;
        this.userSID = null;
        this.domainSID = null;
        this.groups = null;
        this.primaryGroup = null;
        this.numericCredential = null;
        this.ntSystem = null;
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule] completed logout processing");
        }
        return true;
    }
}

