/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public abstract class ThreadSubject {
    static String tsubjectClass = null;
    static ClassLoader sysClassLoader = null;
    static boolean alreadyLoaded;

    protected abstract void set(Subject var1) throws UnsupportedOperationException, SecurityException;

    protected abstract void restore() throws UnsupportedOperationException, SecurityException;

    private native Object doAsThreadSubject(Subject var1, PrivilegedAction var2);

    private native Object doAsThreadSubject(Subject var1, PrivilegedExceptionAction var2) throws PrivilegedActionException;

    private native Object doAsThreadSubjectPrivileged(Subject var1, PrivilegedAction var2, AccessControlContext var3);

    private native Object doAsThreadSubjectPrivileged(Subject var1, PrivilegedExceptionAction var2, AccessControlContext var3) throws PrivilegedActionException;

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        return ThreadSubject.privateDoAs(subject, privilegedAction, null, false);
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return ThreadSubject.privateDoAs(subject, privilegedExceptionAction, null, false);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return ThreadSubject.privateDoAs(subject, privilegedAction, accessControlContext, true);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        return ThreadSubject.privateDoAs(subject, privilegedExceptionAction, accessControlContext, true);
    }

    static ThreadSubject getThreadSubject() {
        ThreadSubject threadSubject = null;
        if (tsubjectClass == null) {
            tsubjectClass = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("thread.subject.provider");
                }
            });
        }
        if (tsubjectClass == null) {
            tsubjectClass = "com.ibm.security.auth.NTThreadSubject";
        }
        if (sysClassLoader == null) {
            sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
        }
        try {
            threadSubject = (ThreadSubject)Class.forName(tsubjectClass, true, sysClassLoader).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return threadSubject;
    }

    private static Object privateDoAs(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext, boolean bl) {
        ThreadSubject threadSubject = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAsPrivileged"));
            } else {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAs"));
            }
        }
        if (privilegedAction == null) {
            throw new NullPointerException("invalid null action");
        }
        threadSubject = ThreadSubject.getThreadSubject();
        if (threadSubject != null) {
            if (!alreadyLoaded) {
                ThreadSubject.ensureLoaded();
            }
            if (bl) {
                return threadSubject.doAsThreadSubjectPrivileged(subject, privilegedAction, accessControlContext);
            }
            return threadSubject.doAsThreadSubject(subject, privilegedAction);
        }
        throw new UnsupportedOperationException("no ThreadSubject implementation found");
    }

    private static Object privateDoAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext, boolean bl) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAsPrivileged"));
            } else {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAs"));
            }
        }
        ThreadSubject threadSubject = null;
        if (privilegedExceptionAction == null) {
            throw new NullPointerException("invalid null action");
        }
        threadSubject = ThreadSubject.getThreadSubject();
        if (threadSubject != null) {
            try {
                if (!alreadyLoaded) {
                    ThreadSubject.ensureLoaded();
                }
                if (bl) {
                    return threadSubject.doAsThreadSubjectPrivileged(subject, privilegedExceptionAction, accessControlContext);
                }
                return threadSubject.doAsThreadSubject(subject, privilegedExceptionAction);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new PrivilegedActionException(exception);
            }
        }
        throw new UnsupportedOperationException("no ThreadSubject implementation found");
    }

    private static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("ThreadSubject");
                return null;
            }
        });
        alreadyLoaded = true;
    }
}

