/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.olt.ivbtrutil;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class DEBUGER {
    private static final String kCBIBMCopyright = "THIS PRODUCT CONTAINS RESTRICTED MATERIALS OF IBM\n5639-D57 (C)  COPYRIGHT International Business Machines Corp. 1993,2001\nAll Rights Reserved *  Licensed Materials - Property of IBM\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.";
    public static PrintStream out = System.out;
    public static PrintStream err = System.err;
    public static PrintWriter fout = null;
    private static String displayFilePropertyString = new String("SD_debug.txt");
    private static String displayFile = System.getProperty(displayFilePropertyString);
    public static boolean display = false;
    public static String _curMethod = null;

    public static void initfout() {
        if (displayFile == null) {
            return;
        }
        try {
            fout = new PrintWriter((Writer)new BufferedWriter(new FileWriter(displayFile)), true);
        }
        catch (IOException iOException) {
            System.err.println("Exception " + iOException);
        }
    }

    public static void printStackTrace(Throwable throwable) {
        if (fout == null) {
            DEBUGER.initfout();
        }
        if (fout != null) {
            throwable.printStackTrace(fout);
        }
    }

    public static void Assert(boolean bl) {
        if (!bl) {
            DEBUGER.Writeln("*** DEBUGER.Assert - ASSERTION FAILED: ");
            DEBUGER.printStackTrace(new Throwable());
        }
    }

    public static void Enter(String string) {
        _curMethod = new String(string);
        if (display) {
            out.println(_curMethod + ": Entering");
        }
    }

    public static void Leave() {
        if (display) {
            out.println(_curMethod + ": Leaving");
        }
        _curMethod = null;
    }

    public static void setStream(PrintStream printStream) {
        display = true;
        out = printStream;
    }

    public static void Pause(String string) {
        byte[] byArray = new byte[1024];
        if (!display) {
            return;
        }
        out.println(" \n PAUSE : " + string);
        try {
            System.in.read(byArray, 0, 1024);
        }
        catch (IOException iOException) {
            DEBUGER.Error(" Can not read from client buffer :" + iOException);
            return;
        }
    }

    public static void dumpStream(ByteArrayOutputStream byteArrayOutputStream) {
        if (!display) {
            return;
        }
        out.println(" \n dumping stream ");
        DEBUGER.dump_bytes(byteArrayOutputStream.toByteArray());
        out.println("\n -------------------------------");
        try {
            byteArrayOutputStream.writeTo(out);
        }
        catch (Exception exception) {
            out.println(" can not write buf to strem : " + exception);
        }
        out.println("\n ------------------- end of stream");
    }

    public static void Error(String string) {
        if (display) {
            out.println("\n ...... \n OLT RI ERROR : " + string + " \n......\n");
        }
    }

    public static void Write(String string) {
        if (display) {
            out.print(string);
        }
    }

    public static void Writeln(String string) {
        if (fout == null) {
            DEBUGER.initfout();
        }
        if (fout != null) {
            fout.println(string);
        }
        if (display) {
            if (_curMethod != null) {
                out.println(_curMethod + ": " + string);
            } else {
                out.println(string);
            }
        }
    }

    public static void dump_bytes(byte[] byArray) {
        String string;
        int n = byArray.length;
        int n2 = 1;
        int n3 = 0;
        if (!display) {
            return;
        }
        int n4 = 0;
        while (n4 < n) {
            n3 = -1;
            n3 &= byArray[n4];
            String string2 = Integer.toHexString(n3 &= 0xFF);
            if (string2.length() == 1) {
                out.print("0");
            }
            out.print(string2 + " ");
            if (n2 == 4 || n2 == 8 || n2 == 12 || n2 == 16) {
                out.print("|");
            }
            if (n2 == 16) {
                n2 = 0;
                string = new String(byArray, n4 - 15, 16);
                out.print(" " + string + "\n");
            }
            ++n4;
            ++n2;
        }
        if (n2 < 16) {
            // empty if block
        }
        int n5 = n2;
        while (n5 <= 16) {
            out.print("xx ");
            if (n5 == 4 || n5 == 8 || n5 == 12 || n5 == 16) {
                out.print("|");
            }
            if (n5 == 16) {
                string = n4 > 16 ? new String(byArray, n4 - 15, n2 - 1) : new String(byArray, 0, n2 - 1);
                out.print(" " + string + "\n");
            }
            ++n5;
        }
    }

    public static void dump_bytes(byte[] byArray, int n) {
        String string;
        int n2 = 1;
        int n3 = 0;
        if (!display) {
            return;
        }
        DEBUGER.Writeln(" printing " + n + " Bytes : .........");
        int n4 = 0;
        while (n4 < n) {
            n3 = -1;
            n3 &= byArray[n4];
            String string2 = Integer.toHexString(n3 &= 0xFF);
            out.print(string2 + " ");
            if (n2 == 4 || n2 == 8 || n2 == 12 || n2 == 16) {
                out.print("|");
            }
            if (n2 == 16) {
                n2 = 0;
                string = new String(byArray, n4 - 15, 16);
                out.print(" " + string + "\n");
            }
            ++n4;
            ++n2;
        }
        if (n2 < 16) {
            // empty if block
        }
        int n5 = n2;
        while (n5 <= 16) {
            out.print("xx ");
            if (n5 == 4 || n5 == 8 || n5 == 12 || n5 == 16) {
                out.print("|");
            }
            if (n5 == 16) {
                string = n4 > 16 ? new String(byArray, n4 - 15, n2 - 1) : new String(byArray, 0, n2 - 1);
                out.print(" " + string + "\n");
            }
            ++n5;
        }
    }
}

