/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime;

import com.ibm.etools.pd.sd.runtime.MethodRecord;
import com.ibm.etools.pd.sd.runtime.ObjRecord;
import com.ibm.etools.pd.sd.runtime.RecordImpl;
import com.ibm.etools.pd.sd.runtime.SDRTLogger;
import com.ibm.etools.pd.sd.runtime.ThreadRecord;

public class MethodAccessRecord
extends RecordImpl {
    public static final int METHOD_UNKWN = 0;
    public static final int METHOD_ENTRY = 1;
    public static final int METHOD_EXIT = 2;
    public static final int METHOD_CALL = 3;
    public static final int METHOD_RETURN = 4;
    public static final String[] _recordHeader = new String[]{"", "<methodEntry", "<methodExit", "<methodCall", "<methodReturn"};
    public static final String[] _recordTrailer = new String[]{"", "</methodEntry>", "</methodExit>", "</methodCall>", "</methodReturn>"};
    private String _time;
    private MethodRecord _method;
    private ObjRecord _object;
    private ThreadRecord _thread;
    private long _ticket;
    private long _sequenceCounter;
    private String contextData;
    private int _stackDepth = 1;
    private String collationValue;
    private int _traceIdRef;
    private int _accessType;
    private String _dcsContext;
    private boolean _isLocal = true;
    private String _threadCpuTime;

    public MethodAccessRecord(SDRTLogger sDRTLogger, int n, ThreadRecord threadRecord, MethodRecord methodRecord, ObjRecord objRecord, int n2) {
        super(sDRTLogger);
        this._accessType = n;
        this._thread = threadRecord;
        this._time = "";
        this._method = methodRecord;
        this._object = objRecord;
        this._ticket = 0L;
        this.contextData = "";
        this._stackDepth = n2;
        this.collationValue = "";
        this._traceIdRef = -1;
        this._dcsContext = null;
        this._isLocal = true;
    }

    public int getAccessType() {
        return this._accessType;
    }

    public String getTime() {
        return this._time;
    }

    public long getTicket() {
        return this._ticket;
    }

    public String threadCpuTime() {
        return this._threadCpuTime;
    }

    public long getSequenceCounter() {
        return this._sequenceCounter;
    }

    public void incCounter() {
        ++this._sequenceCounter;
    }

    public String getContext() {
        return this.contextData;
    }

    public int getStackDepth() {
        return this._stackDepth;
    }

    public String getCollationValue() {
        return this.collationValue;
    }

    public int getTraceIdRef() {
        return this._traceIdRef;
    }

    public ThreadRecord getThread() {
        return this._thread;
    }

    public void setTime(String string) {
        this._time = string;
    }

    public void setTicket(long l) {
        this._ticket = l;
    }

    public void setThreadCpuTime(String string) {
        this._threadCpuTime = string;
    }

    public void setSequenceCounter(long l) {
        this._sequenceCounter = l;
    }

    public void setContext(String string) {
        this.contextData = string;
    }

    public void setStackDepth(int n) {
        this._stackDepth = n;
    }

    public void setCollationValue(String string) {
        this.collationValue = string;
    }

    public void setTraceIdRef(int n) {
        this._traceIdRef = n;
    }

    public void addDCSContext(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this._dcsContext = this._dcsContext == null ? string : this._dcsContext + string;
    }

    public void setLocal(boolean bl) {
        this._isLocal = bl;
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public MethodRecord getMethod() {
        return this._method;
    }

    public ObjRecord getObject() {
        return this._object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(_recordHeader[this._accessType]);
        stringBuffer.append(" threadIdRef=\"");
        stringBuffer.append(this._thread.getThreadId());
        stringBuffer.append("\" time=\"");
        stringBuffer.append(this._time);
        if (this._method != null) {
            stringBuffer.append("\" methodIdRef=\"");
            stringBuffer.append(this._method.getId());
            if (this._method.getClassRecord() != null) {
                stringBuffer.append("\" classIdRef=\"");
                stringBuffer.append(this._method.getClassRecord().getId());
            }
            if (this._object != null) {
                stringBuffer.append("\" objIdRef=\"");
                stringBuffer.append(this._object.getId());
            }
        }
        stringBuffer.append("\" ticket=\"");
        stringBuffer.append(this._ticket);
        if (this._sequenceCounter >= 0L) {
            stringBuffer.append("\" sequenceCounter=\"");
            stringBuffer.append(this._sequenceCounter);
        }
        stringBuffer.append("\" stackDepth=\"");
        stringBuffer.append(this._stackDepth);
        if (this._traceIdRef != -1) {
            stringBuffer.append("\" traceIdRef=\"");
            stringBuffer.append(this._traceIdRef);
        }
        if (this._dcsContext == null) {
            stringBuffer.append("\"/>");
        } else {
            stringBuffer.append("\">\n");
            stringBuffer.append(this._dcsContext);
            stringBuffer.append('\n');
            stringBuffer.append(_recordTrailer[this._accessType]);
        }
        return stringBuffer.toString();
    }

    public void print() {
        if (this._thread != null) {
            this._thread.print();
        }
        if (this._method != null) {
            this._method.print();
        }
        if (this._object != null) {
            this._object.print();
        }
        super.print();
    }
}

