/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime;

import com.ibm.etools.pd.sd.runtime.TimeStamps;
import java.net.InetAddress;
import java.util.TimeZone;

public class NodeRecord {
    private String nodeId;
    private String hostname;
    private String ipaddress;
    private String timezone;
    private String time;

    public NodeRecord() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.ipaddress = inetAddress.getHostAddress();
            this.hostname = inetAddress.getHostName();
            byte[] byArray = inetAddress.getAddress();
            int n = byArray.length;
            this.nodeId = "";
            int n2 = 0;
            while (n2 < n) {
                this.nodeId = this.nodeId + byArray[n2];
                ++n2;
            }
        }
        catch (Exception exception) {
            this.hostname = "localhost";
            this.ipaddress = "127.0.0.1";
            this.nodeId = "UnknownHost";
        }
        this.time = TimeStamps.currentTimeStamps();
        this.timezone = TimeZone.getDefault().getID();
    }

    public NodeRecord(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ipaddress = inetAddress.getHostAddress();
            this.hostname = inetAddress.getHostName();
            byte[] byArray = inetAddress.getAddress();
            int n = byArray.length;
            this.nodeId = "";
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray[n2];
                this.nodeId = this.nodeId + by;
                ++n2;
            }
        }
        catch (Exception exception) {
            this.hostname = "UnknownHost";
            this.ipaddress = "???.???.???.???";
            this.nodeId = "UnknownHost";
        }
        this.time = TimeStamps.currentTimeStamps();
        this.timezone = "";
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<node nodeId=\"");
        stringBuffer.append(this.nodeId);
        stringBuffer.append("\" hostname=\"");
        stringBuffer.append(this.hostname);
        stringBuffer.append("\" ipaddress=\"");
        stringBuffer.append(this.ipaddress);
        stringBuffer.append("\" ");
        if (this.timezone.length() != 0) {
            stringBuffer.append("timezone=\"");
            stringBuffer.append(this.timezone);
            stringBuffer.append("\" ");
        }
        stringBuffer.append("time=\"");
        stringBuffer.append(this.time);
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }
}

