/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime;

import com.ibm.debug.olt.ivbtrjrt.OLT;
import com.ibm.etools.logging.tracing.agent.AgentControllerListener;
import com.ibm.etools.logging.tracing.agent.AgentNotRegisteredException;
import com.ibm.etools.logging.tracing.agent.LoggingAgent;
import com.ibm.etools.logging.tracing.agent.MonitorListener;
import com.ibm.etools.logging.tracing.agent.QueueManager;
import com.ibm.etools.logging.tracing.agent.RemoteClientListener;
import com.ibm.etools.pd.sd.runtime.AgentRecord;
import com.ibm.etools.pd.sd.runtime.TimeStamps;
import com.ibm.etools.pd.sd.runtime.TrcStartRecord;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;

public class SDRTLogger
implements MonitorListener,
AgentControllerListener,
RemoteClientListener {
    private static SDRTLogger _logger = null;
    private LoggingAgent _agent = null;
    private final long REQUEST_TIMEOUT = 10000L;
    private String _name = "J2EE Request Profiler";
    private String _type = "Profiler";
    private boolean _controllerAvailable = false;
    private QueueManager _queue = new QueueManager();
    private boolean _isMonitored = false;
    private PrintWriter _out = null;
    private String _outputFileName = null;
    private boolean _loggingActive = false;
    private boolean _firstWrite = true;
    private AgentRecord _agentRecord;

    private SDRTLogger() {
        this.initialize();
    }

    public static SDRTLogger instance() {
        if (_logger == null) {
            _logger = new SDRTLogger();
        }
        return _logger;
    }

    protected final void initialize() {
        SDRTLogger sDRTLogger = this;
        synchronized (sDRTLogger) {
            if (this._agent == null) {
                try {
                    this._agent = new LoggingAgent(this._name, this._type);
                    this._agent.addAgentControllerListener((AgentControllerListener)this);
                    this._agent.addMonitorListener((MonitorListener)this);
                    this._agent.addRemoteClientListener((RemoteClientListener)this);
                    this._agent.initializeFast();
                    this._controllerAvailable = true;
                    this._name = this._agent.getName();
                }
                catch (Throwable throwable) {
                    this._controllerAvailable = false;
                }
            }
        }
    }

    public final void agentControllerActive() {
        try {
            SDRTLogger sDRTLogger = this;
            synchronized (sDRTLogger) {
                this._agentRecord = new AgentRecord(this, this._agent.getAgentUUID(), this._agent.getJVMUUID(), this._agent.getName(), this._agent.getType(), TimeStamps.currentTimeStamps());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._controllerAvailable = true;
    }

    public final void agentControllerInactive() {
        this._controllerAvailable = false;
        this._isMonitored = false;
        this._firstWrite = true;
    }

    public final void finalize() {
        this._agent.deregister();
    }

    public final void monitorActive() {
        this._isMonitored = true;
    }

    public final void monitorInactive() {
        this._isMonitored = false;
        this._firstWrite = true;
        OLT.trace.cleanup();
    }

    public void clientInactive() {
        this.monitorInactive();
    }

    public final boolean isLogging() {
        return this._loggingActive;
    }

    public final boolean isMonitored() {
        return this._isMonitored;
    }

    private synchronized void outputFileWrite(String string) {
        try {
            this._out.println(string);
            this._out.flush();
        }
        catch (Exception exception) {
            System.out.println("Error writing to file " + this._outputFileName);
            System.out.println("REASON: " + exception);
            System.out.println("NOTE: Logging output now set to standard out.");
            this.setFileName(null);
            System.out.println(string);
        }
    }

    public final boolean write(String string) {
        String string2 = "";
        boolean bl = false;
        try {
            if (this._controllerAvailable && this._isMonitored) {
                if (this._firstWrite) {
                    this._agent.logMessageUTF8(this._agentRecord.toString());
                    TrcStartRecord trcStartRecord = new TrcStartRecord();
                    this._agent.logMessageUTF8(trcStartRecord.toString());
                    if (this._outputFileName != null) {
                        this.outputFileWrite(this._agentRecord.toString());
                        this.outputFileWrite(trcStartRecord.toString());
                    }
                    this._firstWrite = false;
                }
                this._agent.logMessageUTF8(string);
                bl = true;
                if (this._outputFileName != null) {
                    this.outputFileWrite(string);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception caught when logging messages to Trace Agent: " + exception);
        }
        return bl;
    }

    public final String getName() {
        return this._name;
    }

    public final String getAgentUUID() {
        return this._agent.getAgentUUID();
    }

    public final String getAgentJVMUUID() {
        String string = null;
        try {
            string = this._agent.getJVMUUID();
        }
        catch (AgentNotRegisteredException agentNotRegisteredException) {
            // empty catch block
        }
        return string;
    }

    public final String getAgentNodeUUID() {
        String string = null;
        try {
            string = this._agent.getNodeUUID();
        }
        catch (AgentNotRegisteredException agentNotRegisteredException) {
            // empty catch block
        }
        return string;
    }

    public String getFileName() {
        return this._outputFileName;
    }

    public synchronized void setFileName(String string) {
        if (string != null && string.length() != 0) {
            try {
                this._out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(string)), true);
                this._outputFileName = string;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._firstWrite = true;
        } else {
            this.closeFile();
            this._outputFileName = null;
        }
    }

    private synchronized void closeFile() {
        if (this._outputFileName != null) {
            this._out.close();
        }
        this._out = null;
        this._outputFileName = null;
    }

    public final boolean isActive() {
        return this._loggingActive;
    }

    public void setActive(boolean bl) {
        this._loggingActive = bl;
        if (!this._loggingActive) {
            this.closeFile();
        }
    }

    public void requestMonitorThroughPeer(InetAddress inetAddress, String string) {
        this._agent.requestMonitorThroughPeer(inetAddress, string, 10000L);
    }

    public boolean isRegisteredWithAgentController() {
        return this._controllerAvailable;
    }
}

