/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.servlet;

import com.ibm.servlet.ClientList;
import com.ibm.servlet.MLNotFoundException;
import com.ibm.servlet.PageNotFoundException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.metadata.PageListMetaData;
import com.ibm.ws.webcontainer.metadata.PageMetaData;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PageListServlet
extends HttpServlet {
    public static final String ERROR_REQUESTATTR = "error";
    public static final String PAGELIST_RELATIVE_MODE_PROP = "com.ibm.servlet.pagelist.relative.uri.mode";
    public static final String MLNAME_REQUEST_PARAMETER = "mlname";
    private String m_servletName;
    private WebComponentMetaDataImpl m_WebComponentMetaData;
    private ArrayList m_PageListMetaDataList;
    boolean m_UseRelativeURIs = false;
    private ClientList clientList;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            Object object;
            ServletContext servletContext = servletConfig.getServletContext();
            this.setServletName(servletConfig.getServletName());
            WebComponentMetaDataImpl webComponentMetaDataImpl = ((WebApp)servletContext).getWebComponentMetaData(this.getServletName());
            boolean bl = false;
            if (webComponentMetaDataImpl != null) {
                this.m_PageListMetaDataList = webComponentMetaDataImpl.getPageListMetaData();
                if (this.m_PageListMetaDataList != null) {
                    String string;
                    bl = true;
                    object = webComponentMetaDataImpl.getWebComponentInitParameters();
                    if (((HashMap)object).containsKey(PAGELIST_RELATIVE_MODE_PROP) && (string = (String)((HashMap)object).get(PAGELIST_RELATIVE_MODE_PROP)) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false"))) {
                        this.m_UseRelativeURIs = new Boolean(string);
                    }
                    super.init(servletConfig);
                }
            }
            if (!bl) {
                object = "No PageList information is configured for servlet " + this.getServletName();
                servletConfig.getServletContext().log("[Initialization Error] " + (String)object);
                throw new ServletException((String)object);
            }
            this.clientList = new ClientList();
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, "com.ibm.servlet.PageListServlet.init", "261", (Object)this);
            servletConfig.getServletContext().log("Servlet initialization Error", (Throwable)servletException);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.servlet.PageListServlet.init", "267", (Object)this);
            throwable.printStackTrace();
            servletConfig.getServletContext().log("Servlet initialization error", throwable);
            throw new ServletException(throwable);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doResponse(httpServletRequest, httpServletResponse);
    }

    public void doResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.getMLNameFromRequest(httpServletRequest);
        String string2 = this.getPageNameFromRequest(httpServletRequest);
        if (string != null) {
            try {
                this.callPage(string, string2, httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.servlet.PageListServlet.doResponse", "446", (Object)this);
                this.handleError(string, httpServletRequest, httpServletResponse, exception);
            }
        } else {
            try {
                this.callPage(string2, httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.servlet.PageListServlet.doResponse", "458", (Object)this);
                this.handleError(httpServletRequest, httpServletResponse, exception);
            }
        }
    }

    public void callPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block7: {
            try {
                if (string != null) {
                    this.callPageNamed(string, httpServletRequest, httpServletResponse);
                    break block7;
                }
                try {
                    this.callDefaultPage(httpServletRequest, httpServletResponse);
                }
                catch (PageNotFoundException pageNotFoundException) {
                    FFDCFilter.processException((Throwable)((Object)pageNotFoundException), "com.ibm.servlet.PageListServlet.callPage", "492", (Object)this);
                    throw new PageNotFoundException(string, MessageFormat.format("{0} is not a configured page.", string));
                }
            }
            catch (PageNotFoundException pageNotFoundException) {
                FFDCFilter.processException((Throwable)((Object)pageNotFoundException), "com.ibm.servlet.PageListServlet.callPage", "500", (Object)this);
                try {
                    this.callDefaultPage(httpServletRequest, httpServletResponse);
                }
                catch (PageNotFoundException pageNotFoundException2) {
                    FFDCFilter.processException((Throwable)((Object)pageNotFoundException2), "com.ibm.servlet.PageListServlet.callPage", "507", (Object)this);
                    throw new PageNotFoundException(string, MessageFormat.format("{0} is not a configured page.", string));
                }
            }
        }
    }

    public void callPage(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block8: {
            try {
                PageListMetaData pageListMetaData = this.getPageListFromMLName(string);
                if (pageListMetaData == null) {
                    throw new MLNotFoundException("PageList not configured for input Markup Langauge (name=" + string + ").");
                }
                if (string2 != null) {
                    this.callPageNamed(string, string2, httpServletRequest, httpServletResponse);
                    break block8;
                }
                try {
                    this.callDefaultPage(string, httpServletRequest, httpServletResponse);
                }
                catch (PageNotFoundException pageNotFoundException) {
                    FFDCFilter.processException((Throwable)((Object)pageNotFoundException), "com.ibm.servlet.PageListServlet.callPage", "555", (Object)this);
                    throw new PageNotFoundException(string2, MessageFormat.format("There is no PageList default page available for Markup Language (name={0}).", string));
                }
            }
            catch (PageNotFoundException pageNotFoundException) {
                FFDCFilter.processException((Throwable)((Object)pageNotFoundException), "com.ibm.servlet.PageListServlet.callPage", "563", (Object)this);
                try {
                    this.callDefaultPage(string, httpServletRequest, httpServletResponse);
                }
                catch (PageNotFoundException pageNotFoundException2) {
                    FFDCFilter.processException((Throwable)((Object)pageNotFoundException2), "com.ibm.servlet.PageListServlet.callPage", "570", (Object)this);
                    throw new PageNotFoundException(string2, MessageFormat.format("There is no PageList default page available for Markup Language (name={0}).", string));
                }
            }
        }
    }

    protected void callPageNamed(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string2 = this.getURIFromDefaultPageList(string);
        if (string2 == null) {
            throw new PageNotFoundException(string, MessageFormat.format("{0} is not a configured page.", string));
        }
        this.callURI(string2, httpServletRequest, httpServletResponse);
    }

    protected void callPageNamed(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PageListMetaData pageListMetaData = this.getPageListFromMLName(string);
        if (pageListMetaData == null) {
            throw new MLNotFoundException("PageList not configured for input Markup Langauge (name=" + string + ").");
        }
        String string3 = this.getURIFromPageList(pageListMetaData, string2);
        if (string3 == null) {
            throw new PageNotFoundException(string2, MessageFormat.format("{0} is not a configured PageList for Markup Language (name=" + string + ").", string2, string));
        }
        this.callURI(string3, httpServletRequest, httpServletResponse);
    }

    public void callDefaultPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.getDefaultPageURIFromDefaultPageList();
        if (string == null) {
            string = this.getErrorPageURIFromDefaultPageList();
        }
        if (string == null) {
            throw new PageNotFoundException(null, "There is no default page or error page PageList configured.");
        }
        this.callURI(string, httpServletRequest, httpServletResponse);
    }

    public void callDefaultPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PageListMetaData pageListMetaData = this.getPageListFromMLName(string);
        if (pageListMetaData == null) {
            throw new MLNotFoundException("PageList not configured for input Markup Langauge (name=" + string + ").");
        }
        String string2 = this.getURIFromDefaultPageList(pageListMetaData);
        if (string2 == null) {
            string2 = this.getDefaultPageURIFromDefaultPageList();
        }
        if (string2 == null) {
            string2 = this.getURIFromErrorPageList(pageListMetaData);
        }
        if (string2 == null) {
            string2 = this.getErrorPageURIFromDefaultPageList();
        }
        if (string2 == null) {
            throw new PageNotFoundException(null, "There is no default page or error page PageList configured.");
        }
        this.callURI(string2, httpServletRequest, httpServletResponse);
    }

    public void callErrorPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.getErrorPageURIFromDefaultPageList();
        if (string == null) {
            throw new PageNotFoundException(null, "No error page PageList is configured.");
        }
        this.callURI(string, httpServletRequest, httpServletResponse);
    }

    public void callErrorPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PageListMetaData pageListMetaData = this.getPageListFromMLName(string);
        if (pageListMetaData == null) {
            throw new MLNotFoundException("PageList not configured for input Markup Langauge (name=" + string + ").");
        }
        String string2 = this.getURIFromErrorPageList(pageListMetaData);
        if (string2 == null) {
            string2 = this.getErrorPageURIFromDefaultPageList();
        }
        if (string2 == null) {
            throw new PageNotFoundException(null, "No error page PageList is configured.");
        }
        this.callURI(string2, httpServletRequest, httpServletResponse);
    }

    public void callErrorPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException, ServletException {
        PageListServlet.setRequestAttribute(ERROR_REQUESTATTR, object, httpServletRequest);
        this.callErrorPage(httpServletRequest, httpServletResponse);
    }

    public void callErrorPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException, ServletException {
        PageListMetaData pageListMetaData = this.getPageListFromMLName(string);
        if (pageListMetaData == null) {
            throw new MLNotFoundException("PageList not configured for input Markup Langauge (name=" + string + ").");
        }
        PageListServlet.setRequestAttribute(ERROR_REQUESTATTR, object, httpServletRequest);
        this.callErrorPage(string, httpServletRequest, httpServletResponse);
    }

    public void callURI(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ServletContext servletContext;
        String string2 = string;
        if (this.m_UseRelativeURIs) {
            servletContext = this.getServletContext();
        } else {
            boolean bl = true;
            servletContext = this.getServletContext().getContext(string);
            if (servletContext != null) {
                WebApp webApp = (WebApp)servletContext;
                String string3 = webApp.getRootURI();
                if (string.startsWith(string3)) {
                    string2 = string.substring(webApp.getRootURI().length());
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                servletContext = this.getServletContext();
            }
        }
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string2);
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) {
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            this.logError(throwable, throwable.getMessage());
        } else {
            this.logError(object.toString());
        }
        try {
            this.callErrorPage(httpServletRequest, httpServletResponse, object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.servlet.PageListServlet.handleError", "889", (Object)this);
            this.logError(exception, exception.getMessage());
            try {
                if (object == null) {
                    httpServletResponse.sendError(500);
                } else {
                    httpServletResponse.sendError(500, object.toString());
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.servlet.PageListServlet.handleError", "904", (Object)this);
                this.logError(iOException, iOException.getMessage());
            }
        }
    }

    public void handleError(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) {
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            this.logError(throwable, throwable.getMessage());
        } else {
            this.logError(object.toString());
        }
        try {
            this.callErrorPage(string, httpServletRequest, httpServletResponse, object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.servlet.PageListServlet.handleError", "935", (Object)this);
            this.logError(exception, exception.getMessage());
            try {
                if (object == null) {
                    httpServletResponse.sendError(500);
                } else {
                    httpServletResponse.sendError(500, object.toString());
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.servlet.PageListServlet.handleError", "950", (Object)this);
                this.logError(iOException, iOException.getMessage());
            }
        }
    }

    public static void setRequestAttribute(String string, Object object, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        httpServletRequest.setAttribute(string, object);
    }

    protected String getDefaultServletName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getServletName() {
        return this.m_servletName;
    }

    public void setServletName(String string) {
        this.m_servletName = string;
    }

    public String getServletInfo() {
        return this.m_WebComponentMetaData.getWebComponentDescription();
    }

    protected String getMLNameFromRequest(HttpServletRequest httpServletRequest) {
        String string = null;
        String string2 = MLNAME_REQUEST_PARAMETER;
        String[] stringArray = null;
        stringArray = httpServletRequest.getParameterValues(string2);
        if (stringArray != null) {
            string = stringArray[0];
        }
        return string;
    }

    protected String getPageNameFromRequest(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = httpServletRequest.getPathInfo();
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(47, 1);
        if (n == -1) {
            n = string2.length();
        }
        if ((string = string2.substring(1, n).trim()).equals("")) {
            string = null;
        }
        return string;
    }

    public Vector getMLNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.m_PageListMetaDataList.size(); ++i) {
            PageListMetaData pageListMetaData = (PageListMetaData)this.m_PageListMetaDataList.get(i);
            vector.addElement(pageListMetaData.getMarkupLanguageName());
        }
        return vector;
    }

    public String getMLMIME(String string) {
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < this.m_PageListMetaDataList.size() && !bl; ++i) {
            PageListMetaData pageListMetaData = (PageListMetaData)this.m_PageListMetaDataList.get(i);
            String string3 = pageListMetaData.getMarkupLanguageName();
            if (!string3.equals(string)) continue;
            string2 = pageListMetaData.getMarkupLanguageMimeType();
            bl = true;
        }
        return string2;
    }

    public String getMLTypeFromRequest(HttpServletRequest httpServletRequest) {
        String string = null;
        string = this.clientList.getClientType(httpServletRequest);
        if (string == null) {
            string = this.getMLTypeFromDefaultPageList();
        }
        if (string == null) {
            string = "HTML";
        }
        return string;
    }

    private String getURIFromDefaultPageList(String string) {
        String string2 = null;
        PageListMetaData pageListMetaData = null;
        if (!this.m_PageListMetaDataList.isEmpty()) {
            pageListMetaData = (PageListMetaData)this.m_PageListMetaDataList.get(0);
            ArrayList arrayList = pageListMetaData.getPages();
            boolean bl = false;
            for (int i = 0; i < arrayList.size() && !bl; ++i) {
                PageMetaData pageMetaData = (PageMetaData)arrayList.get(i);
                String string3 = pageMetaData.getPageName();
                if (!string3.equals(string)) continue;
                string2 = pageMetaData.getPageURI();
                bl = true;
            }
        }
        return string2;
    }

    private String getDefaultPageURIFromDefaultPageList() {
        PageListMetaData pageListMetaData;
        PageMetaData pageMetaData;
        String string = null;
        if (!this.m_PageListMetaDataList.isEmpty() && (pageMetaData = (pageListMetaData = (PageListMetaData)this.m_PageListMetaDataList.get(0)).getDefaultPage()) != null) {
            string = pageMetaData.getPageURI();
        }
        return string;
    }

    private String getErrorPageURIFromDefaultPageList() {
        PageListMetaData pageListMetaData;
        PageMetaData pageMetaData;
        String string = null;
        if (!this.m_PageListMetaDataList.isEmpty() && (pageMetaData = (pageListMetaData = (PageListMetaData)this.m_PageListMetaDataList.get(0)).getErrorPage()) != null) {
            string = pageMetaData.getPageURI();
        }
        return string;
    }

    private PageListMetaData getPageListFromMLName(String string) {
        PageListMetaData pageListMetaData = null;
        boolean bl = false;
        for (int i = 0; i < this.m_PageListMetaDataList.size() && !bl; ++i) {
            PageListMetaData pageListMetaData2 = (PageListMetaData)this.m_PageListMetaDataList.get(i);
            String string2 = pageListMetaData2.getMarkupLanguageName();
            if (!string2.equals(string)) continue;
            pageListMetaData = pageListMetaData2;
            bl = true;
        }
        return pageListMetaData;
    }

    private String getURIFromPageList(PageListMetaData pageListMetaData, String string) {
        String string2 = null;
        boolean bl = false;
        ArrayList arrayList = pageListMetaData.getPages();
        for (int i = 0; i < arrayList.size() && !bl; ++i) {
            PageMetaData pageMetaData = (PageMetaData)arrayList.get(i);
            String string3 = pageMetaData.getPageName();
            if (!string3.equals(string)) continue;
            string2 = pageMetaData.getPageURI();
            bl = true;
        }
        return string2;
    }

    private String getURIFromDefaultPageList(PageListMetaData pageListMetaData) {
        String string = null;
        PageMetaData pageMetaData = pageListMetaData.getDefaultPage();
        if (pageMetaData != null) {
            string = pageMetaData.getPageURI();
        }
        return string;
    }

    private String getURIFromErrorPageList(PageListMetaData pageListMetaData) {
        String string = null;
        PageMetaData pageMetaData = pageListMetaData.getErrorPage();
        if (pageMetaData != null) {
            string = pageMetaData.getPageURI();
        }
        return string;
    }

    private String getMLTypeFromDefaultPageList() {
        String string = null;
        if (!this.m_PageListMetaDataList.isEmpty()) {
            PageListMetaData pageListMetaData = (PageListMetaData)this.m_PageListMetaDataList.get(0);
            string = pageListMetaData.getMarkupLanguageName();
        }
        return string;
    }

    public void logError(Throwable throwable, String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        this.logError(string + "\n" + stringWriter.toString());
    }

    public void logError(String string) {
        super.log("[" + this.getServletName() + "-error]" + string);
    }

    public void log(String string) {
        super.log("[" + this.getServletName() + "]" + string);
    }
}

