/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.agent.hmc.NISecurityServiceAgent;
import com.ibm.storage.ess.ni.commandagent.NICommandAgent;
import com.ibm.storage.ess.ni.commandagent.NICommandAgentStartupException;
import com.ibm.storage.ess.ni.eventManager.client.NIEventServer;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.security.NIOverwriteBackgroundRequest;
import com.ibm.storage.ess.ni.security.NIRecoveryToolListener;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import java.io.File;
import java.net.InetAddress;

public class NIManagementCommandAgent {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer == null ? (class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer = NIManagementCommandAgent.class$("com.ibm.storage.ess.ni.security.NISecuritySynchronizer")) : class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer);
    protected NIEventServer eventServer;
    protected NICommandAgent cmdAgent = null;
    protected NICommandAgent securityAgent = null;
    protected Object[] serviceClasses = null;
    protected static final String SIMULATOR_PROPERTY = "com.ibm.storage.ess.ni.agent.SimulatorProperty";
    private NISecurityServiceAgent ssa = null;
    private NIMessageRouterAddress localAddress;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer;

    public NIManagementCommandAgent(NIEventServer nIEventServer, NIMessageRouterAddress nIMessageRouterAddress) {
        this.eventServer = nIEventServer;
        this.localAddress = nIMessageRouterAddress;
        this.cmdAgent = new NICommandAgent();
    }

    public void start() throws NICommandAgentStartupException {
        Object var1_1 = null;
        this.cmdAgent.setLocalNodeAddress(this.localAddress);
        this.cmdAgent.startup();
        this.initializeSecurity();
    }

    private void initializeSecurity() throws NICommandAgentStartupException {
        Object object;
        this.securityAgent = new NICommandAgent();
        String string = "NO_ALTERNATE";
        boolean bl = this.localAddress.getEssServerName().equals("HMC1");
        if (this.dualHMCsConfigured()) {
            string = bl ? "HMC2" : "HMC1";
        }
        NISecuritySynchronizer nISecuritySynchronizer = NISecuritySynchronizer.getSecuritySynchronizer();
        nISecuritySynchronizer.setAlternateServer(string);
        nISecuritySynchronizer.start();
        if (!string.equals("NO_ALTERNATE") && NIAgentProperties.getAgentType() == 3 && bl) {
            object = NISecurityDatabaseManager.getDatabaseHelper();
            NISecurityTableEntry nISecurityTableEntry = ((NISecurityDatabaseHelper)object).getSecurityEntry();
            NIOverwriteBackgroundRequest nIOverwriteBackgroundRequest = NIOverwriteBackgroundRequest.getOverwriteBackgroundRequest();
            if (nISecurityTableEntry.getOutOfSyncHMCs()) {
                if (nIOverwriteBackgroundRequest.needToRun()) {
                    try {
                        nIOverwriteBackgroundRequest.start();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        logger.throwable((Throwable)illegalThreadStateException);
                    }
                } else {
                    nIOverwriteBackgroundRequest.notifyPeerIsUp();
                }
            }
        }
        object = new NIRecoveryToolListener(nISecuritySynchronizer);
        ((Thread)object).start();
        this.securityAgent.setMinimumThreadPoolSize(1);
        this.securityAgent.setMaximumThreadPoolSize(1);
        this.securityAgent.setLocalNodeAddress(new NIMessageRouterAddress(6, this.localAddress.getEssServerName()));
        this.ssa = new NISecurityServiceAgent();
        this.securityAgent.setServiceClasses(new Object[]{this.ssa});
        this.securityAgent.startup();
    }

    private boolean dualHMCsConfigured() {
        boolean bl = false;
        if (NIAgentProperties.getAgentType() == 3) {
            File file = new File("/opt/essni/etc/dualHMCsConfigured");
            if (file.exists()) {
                bl = true;
            }
        } else {
            NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
            InetAddress[] inetAddressArray = nIMessageRouter.getPeerIPAddresses();
            if (inetAddressArray != null && inetAddressArray.length >= 1) {
                bl = true;
            }
        }
        return bl;
    }

    public void stop() {
        this.cmdAgent.shutdown();
        this.securityAgent.shutdown();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

