/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.cache;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCache;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCacheHeartbeat;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCacheMessage;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCacheUpdatedMessage;
import com.ibm.storage.ess.ni.agent.cache.NIAgentState;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandAddress;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandCommunicator;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NIMRCommandCommunicator;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;

public class NIPeerMonitor
extends Thread {
    private int agentType;
    private static final long HEART_BEAT_WAIT_TIME_NORMAL = 60000L;
    private static final long HEART_BEAT_WAIT_TIME_PEER_DOWN = 600000L;
    private static final char SERVER_NUMBER_1 = '1';
    private static final char SERVER_NUMBER_0 = '0';
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$cache$NIPeerMonitor == null ? (class$com$ibm$storage$ess$ni$agent$cache$NIPeerMonitor = NIPeerMonitor.class$("com.ibm.storage.ess.ni.agent.cache.NIPeerMonitor")) : class$com$ibm$storage$ess$ni$agent$cache$NIPeerMonitor);
    private static final NIAgentState UNKNOWN_PEER_STATE = new NIAgentState();
    public static final NIPeerMonitor PEER_MONITOR = new NIPeerMonitor();
    private long lastHeartbeatTime = 0L;
    private long heartBeatWaitTime = 60000L;
    private boolean connected = false;
    private NIMessageRouterAddress peerAddress = null;
    private NICommandCommunicator communicator = null;
    private char serverNumber = (char)57;
    private NICommandAddress commandAddress;
    private NIMessageRouterAddress localAddress;
    private boolean enabled = false;
    private NIAgentState peerState = UNKNOWN_PEER_STATE;
    private NIAgentCacheHeartbeat hb = null;
    private boolean updateFromPeer = false;
    private Thread heartBeatThread = new Thread(){

        public void run() {
            boolean bl = false;
            while (NIPeerMonitor.this.enabled) {
                if (System.currentTimeMillis() - NIPeerMonitor.this.lastHeartbeatTime > 60000L) {
                    NIPeerMonitor.this.heartbeat();
                    bl = true;
                } else {
                    bl = false;
                }
                try {
                    Thread.sleep(NIPeerMonitor.this.heartBeatWaitTime);
                }
                catch (InterruptedException interruptedException) {
                    logger.throwable((Throwable)interruptedException);
                    logger.warning("heartbeat interrupted");
                }
                if (!bl || System.currentTimeMillis() - NIPeerMonitor.this.lastHeartbeatTime <= 60000L) continue;
                NIPeerMonitor.this.setPeerState(UNKNOWN_PEER_STATE);
            }
        }
    };
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$cache$NIPeerMonitor;

    private NIPeerMonitor() {
        super("NIPeerMonitor");
        this.localAddress = new NIMessageRouterAddress(5, NIMessageRouterFactory.getInstanceOf().getEssServerName());
        this.agentType = NIAgentProperties.getAgentType();
        boolean bl = this.enabled = this.agentType == 2 || this.agentType == 4;
        if (this.enabled) {
            this.communicator = new NIMRCommandCommunicator(this.localAddress);
            this.connect();
            String string = this.localAddress.getEssServerName();
            String string2 = string.substring(0, string.length() - 1);
            this.serverNumber = string.charAt(string.length() - 1);
            char c = this.serverNumber == '0' ? (char)'1' : '0';
            string2 = string2 + c;
            this.peerAddress = new NIMessageRouterAddress(5, string2);
            this.commandAddress = new NICommandAddress();
            this.commandAddress.setDestinationAddress(this.peerAddress);
            this.commandAddress.setReturnAddress(this.localAddress);
            this.hb = new NIAgentCacheHeartbeat(this.localAddress.getEssServerName(), UNKNOWN_PEER_STATE);
        }
    }

    private void connect() {
        this.connected = false;
        try {
            logger.debug_general("attempting to connect");
            this.communicator.connect();
            this.connected = true;
            logger.debug_general("connected successfully");
        }
        catch (Exception exception) {
            logger.error("Could not connect to MR.  Assuming single server mode.  Will attempt to reconnect later");
            logger.throwable((Throwable)exception);
            this.connected = false;
        }
    }

    private void heartbeat() {
        this.hb.setState(NIAgentCache.CACHE.getState());
        this.sendMessage(this.hb);
    }

    public void run() {
        if (this.enabled) {
            while (!this.connected) {
                try {
                    Thread.sleep(60000L);
                    this.connect();
                }
                catch (InterruptedException interruptedException) {
                    logger.throwable((Throwable)interruptedException);
                    logger.warning("sleeping interrupted...continuing");
                }
            }
            if (this.agentType == 2) {
                this.heartBeatThread.start();
            }
        }
        while (this.enabled) {
            this.processMessage();
        }
    }

    private void processMessage() {
        block7: {
            NICommand nICommand = null;
            try {
                NIAgentCacheMessage nIAgentCacheMessage = null;
                nICommand = this.communicator.receive();
                nIAgentCacheMessage = (NIAgentCacheMessage)nICommand;
                logger.debug_general("received message: " + nIAgentCacheMessage, "NIPeerMonitor", "processMessage", null);
                if (nIAgentCacheMessage.isResponse()) {
                    nIAgentCacheMessage.processResponse(this);
                    this.setPeerState(nIAgentCacheMessage.getState());
                    break block7;
                }
                if (nIAgentCacheMessage.isRejected()) {
                    logger.error("rejected message: " + nIAgentCacheMessage, "NIPeerMonitor", "processMessage", null);
                    this.setPeerState(UNKNOWN_PEER_STATE);
                    break block7;
                }
                if (nIAgentCacheMessage.getOriginatingAddress().equals(this.peerAddress.getEssServerName())) {
                    nIAgentCacheMessage.execute(this);
                    this.setPeerState(nIAgentCacheMessage.getState());
                    nIAgentCacheMessage.getAddress().reverseAddress();
                    nIAgentCacheMessage.setState(NIAgentCache.CACHE.getState());
                    logger.debug_general("sending: " + nIAgentCacheMessage);
                    this.communicator.send(nIAgentCacheMessage);
                    break block7;
                }
                nIAgentCacheMessage.setRejected();
                nIAgentCacheMessage.getAddress().reverseAddress();
                logger.debug_general("sending: " + nIAgentCacheMessage);
                this.communicator.send(nIAgentCacheMessage);
            }
            catch (InterruptedException interruptedException) {
                this.enabled = false;
            }
            catch (ClassCastException classCastException) {
                logger.error("Unexpected object read from stream", "NIPeerMonitor", "processMessage", new Object[]{nICommand});
                logger.throwable((Throwable)classCastException);
            }
            catch (Exception exception) {
                logger.error("Exception reading message", "NIPeerMonitor", "processMessage", null);
                logger.throwable((Throwable)exception);
            }
        }
    }

    synchronized void update() {
        this.updateFromPeer = true;
        NIAgentCache.CACHE.scheduleUpdate();
    }

    public synchronized void notifyPeerOfUpdate() {
        if (!this.updateFromPeer) {
            this.sendMessage(new NIAgentCacheUpdatedMessage(this.localAddress.getEssServerName(), NIAgentCache.CACHE.getState()));
        }
        this.updateFromPeer = false;
    }

    void setPeerState(NIAgentState nIAgentState) {
        NIAgentState nIAgentState2 = this.peerState;
        this.peerState = nIAgentState;
        if (!nIAgentState2.equals(nIAgentState)) {
            this.heartBeatWaitTime = nIAgentState.getState() == 0 ? 600000L : 60000L;
            logger.debug_general("peer running state changed to: " + nIAgentState, "NIPeerMonitor", "setPeerRunning", null);
            this.update();
        }
    }

    private void sendMessage(NIAgentCacheMessage nIAgentCacheMessage) {
        logger.debug_general("message: " + nIAgentCacheMessage, "NIPeerMonitor", "sendMessage", null);
        nIAgentCacheMessage.setAddress(this.commandAddress);
        boolean bl = this.communicator.send(nIAgentCacheMessage);
        if (!bl) {
            logger.warning("Couldn't communicate with peer.  Running in single server mode", "NIPeerMonitor", "sendMessage", null);
            this.setPeerState(UNKNOWN_PEER_STATE);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPeerRunning() {
        return this.peerState.getState() == 1;
    }

    void heartBeatReceived() {
        this.lastHeartbeatTime = System.currentTimeMillis();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PEER_MONITOR.start();
    }
}

