/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert;

import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtBinary;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtFloat32;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtInt64;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtUint32;
import com.ibm.rsct.util.CtUint64;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIConverterValues;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnclosureID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIFRUID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStorageServerID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NIConfigOptionFactory;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIESSState;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRequestedPortState;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlMode;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupSCSIMapImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import com.ibm.storage.ess.ni.util.NIMtmsParser;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NIfromMcConverter
implements NIConverterValues {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter = NIfromMcConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeIndetermined;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeLocal;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCAuto;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCManual;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduled;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduledAuto;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteS390PowerControl;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIESSStateOnline;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIESSStateOffline;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIESSStateResuming;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescing;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescingException;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateFenced;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOnline;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOffline;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeFB;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeCKD;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3TPF;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model6;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUTypeBS2000;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDBase;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDSingleCuAlias;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockBase;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockMap;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDataType3380;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDataType3390;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock512;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Protected;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Unprotected;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIDataTypeUnknown;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIRaidType10;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIRaidType5;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIExtentTypeFB;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIExtentTypeCKD;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFicon;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcpFicon;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeCopyServices;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconAll;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMask;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMixedMask;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520All;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Map256;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Mask;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIAll;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMap256;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMask;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMixedMask;

    private NIfromMcConverter() {
    }

    public static String toString(CtDataType ctDataType) {
        String string = null;
        if (ctDataType == null) {
            string = null;
        } else if (ctDataType instanceof CtString) {
            CtString ctString = (CtString)ctDataType;
            string = ctString.getData();
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return string;
    }

    public static String[] toStringArray(CtArray ctArray) {
        String[] stringArray = null;
        if (ctArray != null) {
            CtDataType[] ctDataTypeArray = ctArray.getData();
            stringArray = new String[ctDataTypeArray.length];
            if (ctDataTypeArray != null && ctDataTypeArray instanceof CtString[]) {
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    stringArray[n] = ((CtString)ctDataTypeArray[n]).getData();
                    ++n;
                }
            } else {
                logger.error("Bad data was passed into a convert method: " + ctDataTypeArray);
            }
        } else {
            logger.error("Null object passes in.");
        }
        return stringArray;
    }

    public static int toInteger(CtDataType ctDataType) {
        int n = -1;
        if (ctDataType != null) {
            if (ctDataType instanceof CtInt32) {
                CtInt32 ctInt32 = (CtInt32)ctDataType;
                n = ctInt32.getData();
            } else if (ctDataType instanceof CtUint32) {
                CtUint32 ctUint32 = (CtUint32)ctDataType;
                n = ctUint32.getData().intValue();
            } else if (ctDataType instanceof CtString) {
                CtString ctString = (CtString)ctDataType;
                String string = ctString.getData();
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                if (string.equals("")) {
                    logger.error("An empty string was passed into toInteger()");
                } else {
                    int n2 = 0;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        if (Character.isDigit(c)) {
                            bl = true;
                            stringBuffer.append(c);
                        } else if (bl) break;
                        ++n2;
                    }
                    if ("".equals(stringBuffer.toString())) {
                        logger.error("String passed to toInteger() contains no number. String = " + string);
                    } else {
                        n = Integer.parseInt(stringBuffer.toString());
                    }
                }
            } else {
                logger.error("Bad data was passed into a convert method: ");
            }
        } else {
            logger.error("A null was passed into a convert method");
        }
        return n;
    }

    public static int[] toIntegerArray(CtArray ctArray) {
        int[] nArray = null;
        if (ctArray != null) {
            CtDataType[] ctDataTypeArray = ctArray.getData();
            nArray = new int[ctDataTypeArray.length];
            if (ctDataTypeArray != null && ctDataTypeArray instanceof CtInt32[]) {
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    nArray[n] = ((CtInt32)ctDataTypeArray[n]).getData();
                    ++n;
                }
            } else {
                logger.error("Bad data was passed into a convert method: " + ctDataTypeArray);
            }
        } else {
            logger.error("Null object passes in.");
        }
        return nArray;
    }

    public static int toIntfromHexString(CtDataType ctDataType) {
        int n = -1;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            n = Integer.parseInt(string, 16);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return n;
    }

    public static long byteArrayToLong(CtDataType ctDataType) {
        long l = -1L;
        if (ctDataType != null && ctDataType instanceof CtBinary) {
            byte[] byArray = ((CtBinary)ctDataType).getData();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < byArray.length) {
                String string = Integer.toHexString(byArray[n]);
                if (string.length() > 2) {
                    string = string.substring(string.length() - 2);
                } else if (string.length() < 2) {
                    string = "0" + string;
                }
                stringBuffer.append(string);
                ++n;
            }
            l = Long.parseLong(stringBuffer.toString(), 16);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return l;
    }

    public static long toLong(CtDataType ctDataType) {
        long l = -1L;
        if (ctDataType != null && ctDataType instanceof CtInt64) {
            CtInt64 ctInt64 = (CtInt64)ctDataType;
            l = ctInt64.getData();
        } else if (ctDataType != null && ctDataType instanceof CtInt32) {
            CtInt32 ctInt32 = (CtInt32)ctDataType;
            l = ctInt32.getData();
        } else if (ctDataType != null && ctDataType instanceof CtUint64) {
            CtUint64 ctUint64 = (CtUint64)ctDataType;
            l = ctUint64.getData().longValue();
        } else if (ctDataType != null && ctDataType instanceof CtUint32) {
            CtUint32 ctUint32 = (CtUint32)ctDataType;
            l = ctUint32.getData().longValue();
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return l;
    }

    public static float toFloat(CtDataType ctDataType) {
        float f = -1.0f;
        if (ctDataType != null && ctDataType instanceof CtFloat32) {
            CtFloat32 ctFloat32 = (CtFloat32)ctDataType;
            f = ctFloat32.getData();
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return f;
    }

    public static boolean toBoolean(CtDataType ctDataType) {
        boolean bl = true;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n = ((CtInt32)ctDataType).getData();
            if (n == 0) {
                bl = false;
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return bl;
    }

    public static NIFRUID toFruID(CtDataType ctDataType, CtDataType ctDataType2, String string, String string2, String string3, Class clazz) {
        NIFRUID nIFRUID = null;
        if (ctDataType != null && ctDataType instanceof CtString && ctDataType2 != null && ctDataType2 instanceof CtString) {
            String string4 = ((CtString)ctDataType).getData();
            NIESSID nIESSID = new NIESSID(string4);
            string4 = ((CtString)ctDataType2).getData();
            NIMtmsParser nIMtmsParser = new NIMtmsParser(string4);
            String string5 = nIMtmsParser.getType();
            String string6 = nIMtmsParser.getModel();
            String string7 = nIMtmsParser.getSequence();
            nIFRUID = new NIFRUID(nIESSID, string5, string6, string7, string, string2, string3, clazz);
        } else {
            logger.error("Bad data was passed into a convert method: ");
        }
        return nIFRUID;
    }

    public static NIEnclosureID toEnclosureID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIEnclosureID nIEnclosureID = null;
        if (ctDataType != null && ctDataType instanceof CtString && ctDataType2 != null && ctDataType2 instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            NIESSID nIESSID = new NIESSID(string);
            string = ((CtString)ctDataType2).getData();
            NIMtmsParser nIMtmsParser = new NIMtmsParser(string);
            String string2 = nIMtmsParser.getType();
            String string3 = nIMtmsParser.getModel();
            String string4 = nIMtmsParser.getSequence();
            nIEnclosureID = new NIEnclosureID(nIESSID, string2, string3, string4);
        } else {
            logger.error("Bad data was passed into a convert method: ");
        }
        return nIEnclosureID;
    }

    public static NIIOPortID toIOPortID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIIOPortID nIIOPortID = null;
        if (ctDataType != null && ctDataType instanceof CtString && ctDataType2 != null && ctDataType2 instanceof CtInt32) {
            NIESSID nIESSID = new NIESSID(((CtString)ctDataType).getData());
            int n = ((CtInt32)ctDataType2).getData();
            nIIOPortID = new NIIOPortID(nIESSID, n);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType + ", " + ctDataType2);
        }
        return nIIOPortID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InetAddress[] toInetAddressesArray(CtArray ctArray) throws NIServerException {
        InetAddress[] inetAddressArray = null;
        if (ctArray != null) {
            CtDataType[] ctDataTypeArray = ctArray.getData();
            inetAddressArray = new InetAddress[ctDataTypeArray.length];
            if (ctDataTypeArray != null && ctDataTypeArray instanceof CtString[]) {
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    try {
                        inetAddressArray[n] = InetAddress.getByName(((CtString)ctDataTypeArray[n]).getData());
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.error("Bad data was passed into a convert method.");
                        throw new NIServerException(1, "Bad data was passed into a convert method.");
                    }
                    ++n;
                }
                return inetAddressArray;
            }
            logger.error("Bad data was passed into a convert method.  data == null || !(data instanceof CtString[])");
            throw new NIServerException(1, "Bad data was passed into a convert method.  data == null || !(data instanceof CtString[])");
        }
        logger.error("Bad data was passed into a convert method.  input == null.");
        throw new NIServerException(1, "Bad data was passed into a convert method.  input == null.");
    }

    public static NIStorageFacilityID toStorageFacilityID(CtDataType ctDataType, long l) {
        NIStorageFacilityID nIStorageFacilityID = null;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            NIMtmsParser nIMtmsParser = new NIMtmsParser(string);
            String string2 = nIMtmsParser.getType();
            String string3 = nIMtmsParser.getManufacturePlant();
            String string4 = nIMtmsParser.getSequence();
            nIStorageFacilityID = new NIStorageFacilityID(string2, string3, string4, l);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIStorageFacilityID;
    }

    public static NISFPowerControlMode toSFPowerControlMode(CtDataType ctDataType) {
        NISFPowerControlMode nISFPowerControlMode = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            switch (((CtInt32)ctDataType).getData()) {
                case -1: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeIndetermined == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeIndetermined = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeIndetermined")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeIndetermined);
                    break;
                }
                case 0: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeLocal == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeLocal = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeLocal")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeLocal);
                    break;
                }
                case 3: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCAuto == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCAuto = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCAuto")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCAuto);
                    break;
                }
                case 1: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCManual == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCManual = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCManual")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCManual);
                    break;
                }
                case 2: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduled == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduled = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCScheduled")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduled);
                    break;
                }
                case 4: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduledAuto == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduledAuto = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCScheduledAuto")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteHMCScheduledAuto);
                    break;
                }
                case 5: {
                    nISFPowerControlMode = (NISFPowerControlMode)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteS390PowerControl == null ? (class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteS390PowerControl = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteS390PowerControl")) : class$com$ibm$storage$ess$ni$option$config$NISFPowerControlModeRemoteS390PowerControl);
                    break;
                }
                default: {
                    logger.error("Undefined option from RAS: " + ((CtInt32)ctDataType).getData());
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nISFPowerControlMode;
    }

    public static int toPowerState(CtDataType ctDataType) {
        int n = -1;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n2 = ((CtInt32)ctDataType).getData();
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n = n2;
                    break;
                }
                default: {
                    logger.error("Undefined state from RAS: " + ((CtInt32)ctDataType).getData());
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return n;
    }

    public static NIESSID toEssID(CtDataType ctDataType) {
        return NIfromMcConverter.toEssID(ctDataType, 0L);
    }

    public static NIESSID toEssID(CtDataType ctDataType, long l) {
        NIESSID nIESSID = null;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            nIESSID = new NIESSID(string, l);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIESSID;
    }

    public static NIESSState toESSState(CtDataType ctDataType) {
        NIESSState nIESSState = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            switch (((CtInt32)ctDataType).getData()) {
                case 0: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateOnline == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateOnline = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateOnline")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateOnline);
                    break;
                }
                case 1: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateOffline == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateOffline = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateOffline")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateOffline);
                    break;
                }
                case 2: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateResuming == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateResuming = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateResuming")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateResuming);
                    break;
                }
                case 3: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescing == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescing = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateQuiescing")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescing);
                    break;
                }
                case 4: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescingException == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescingException = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateQuiescingException")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateQuiescingException);
                    break;
                }
                case 5: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateForcedQuiescing")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing);
                    break;
                }
                case 6: {
                    nIESSState = (NIESSState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing == null ? (class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIESSStateForcedQuiescing")) : class$com$ibm$storage$ess$ni$option$config$NIESSStateForcedQuiescing);
                    break;
                }
                default: {
                    logger.error("Undefined option from RAS: " + ((CtInt32)ctDataType).getData());
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIESSState;
    }

    public static double toDiskCapacity(CtDataType ctDataType) {
        double d = -1.0;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            d = new Double(string);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return d;
    }

    public static double toDiskRPM(CtDataType ctDataType) {
        double d = -1.0;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            d = new Double(string);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return d;
    }

    public static NIStorageServerID toServerID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIStorageServerID nIStorageServerID = null;
        if (ctDataType != null && ctDataType instanceof CtString && ctDataType2 != null && ctDataType2 instanceof CtInt32) {
            String string = ((CtString)ctDataType).getData();
            NIESSID nIESSID = new NIESSID(string);
            int n = ((CtInt32)ctDataType2).getData();
            nIStorageServerID = new NIStorageServerID(nIESSID, n);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType + ", " + ctDataType2);
        }
        return nIStorageServerID;
    }

    public static NIArraySiteID toArraySiteID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIArraySiteID nIArraySiteID = null;
        int n = NIfromMcConverter.toInteger(ctDataType2);
        if (n != -1) {
            nIArraySiteID = new NIArraySiteID(NIfromMcConverter.toEssID(ctDataType), n);
        }
        return nIArraySiteID;
    }

    public static NIArraySiteID[] toArraySiteIDArray(CtDataType ctDataType, CtArray ctArray) {
        NIArraySiteID[] nIArraySiteIDArray = null;
        if (ctArray != null) {
            CtDataType[] ctDataTypeArray = ctArray.getData();
            nIArraySiteIDArray = new NIArraySiteID[ctDataTypeArray.length];
            if (ctDataTypeArray != null && ctDataTypeArray instanceof CtInt32[]) {
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    nIArraySiteIDArray[n] = NIfromMcConverter.toArraySiteID(ctDataType, ctDataTypeArray[n]);
                    ++n;
                }
            } else {
                logger.error("Bad data was passed into a convert method: " + ctDataTypeArray);
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType + ", " + ctArray);
        }
        return nIArraySiteIDArray;
    }

    public static NIArraySiteConfiguration[] toArraySiteConfigurationArray(CtArray ctArray) {
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = null;
        CtDataType[] ctDataTypeArray = ctArray.getData();
        if (ctDataTypeArray != null && ctDataTypeArray instanceof CtString[]) {
            nIArraySiteConfigurationArray = new NIArraySiteConfiguration[ctDataTypeArray.length];
            int n = 0;
            while (n < ctDataTypeArray.length) {
                if (((CtString)ctDataTypeArray[n]).getData().equals("6+P+S")) {
                    Object var4_4 = null;
                    nIArraySiteConfigurationArray[n] = new NIArraySiteConfiguration(1, 1);
                } else if (((CtString)ctDataTypeArray[n]).getData().equals("7+P")) {
                    nIArraySiteConfigurationArray[n] = new NIArraySiteConfiguration(0, 1);
                } else if (((CtString)ctDataTypeArray[n]).getData().equals("3x2+2S")) {
                    nIArraySiteConfigurationArray[n] = new NIArraySiteConfiguration(2, 0);
                } else if (((CtString)ctDataTypeArray[n]).getData().equals("4x2")) {
                    nIArraySiteConfigurationArray[n] = new NIArraySiteConfiguration(0, 0);
                } else {
                    logger.error("Bad data was passed into a NIArraySiteConfiguration: data= " + ((CtString)ctDataTypeArray[n]).getData());
                }
                ++n;
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataTypeArray);
        }
        return nIArraySiteConfigurationArray;
    }

    public static int[] fixInterfaceID(int[] nArray) {
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = (nArray[n] & 0xF000) >> 12;
                int n3 = (nArray[n] & 0xF00) >> 8;
                int n4 = (nArray[n] & 0xFC) >> 2;
                int n5 = (nArray[n] & 2) >> 1;
                int n6 = (nArray[n] & 1) >> 0;
                nArray[n] = n2 << 0 | n3 << 4 | n4 << 8 | n5 << 14 | n6 << 15;
                ++n;
            }
        }
        return nArray;
    }

    public static int extractInterfaceID(int[] nArray) {
        int n = -1;
        if (nArray != null && nArray.length > 0) {
            n = (nArray[0] & 0x3F00) >> 8;
        }
        return n;
    }

    public static NIRequestedPortState toRequestedPortState(CtDataType ctDataType) {
        NIRequestedPortState nIRequestedPortState = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            switch (((CtInt32)ctDataType).getData()) {
                case 4: {
                    nIRequestedPortState = (NIRequestedPortState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateFenced == null ? (class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateFenced = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIRequestedPortStateFenced")) : class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateFenced);
                    break;
                }
                case 1: {
                    nIRequestedPortState = (NIRequestedPortState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOnline == null ? (class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOnline = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIRequestedPortStateOnline")) : class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOnline);
                    break;
                }
                case 0: {
                    nIRequestedPortState = (NIRequestedPortState)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOffline == null ? (class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOffline = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIRequestedPortStateOffline")) : class$com$ibm$storage$ess$ni$option$config$NIRequestedPortStateOffline);
                    break;
                }
                default: {
                    logger.error("Undefined data from RAS: " + ((CtInt32)ctDataType).getData());
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIRequestedPortState;
    }

    public static NIAddressGroupID toAddressGroupID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIAddressGroupID nIAddressGroupID = null;
        if (ctDataType != null && ctDataType instanceof CtString && ctDataType2 != null && (ctDataType2 instanceof CtString || ctDataType2 instanceof CtInt32)) {
            String string = ((CtString)ctDataType).getData();
            NIESSID nIESSID = new NIESSID(string);
            int n = ctDataType2 instanceof CtString ? Integer.parseInt(((CtString)ctDataType2).getData(), 16) : ((CtInt32)ctDataType2).getData();
            nIAddressGroupID = new NIAddressGroupID(nIESSID, n);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType + ", " + ctDataType2);
        }
        return nIAddressGroupID;
    }

    public static NIDeviceType toDeviceType(CtDataType ctDataType) {
        NIDeviceType nIDeviceType = null;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            if (string.equals("FB")) {
                nIDeviceType = (NIDeviceType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeFB == null ? (class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeFB = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB")) : class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeFB);
            } else if (string.equals("CKD")) {
                nIDeviceType = (NIDeviceType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeCKD == null ? (class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeCKD = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD")) : class$com$ibm$storage$ess$ni$option$config$NIDeviceTypeCKD);
            } else {
                logger.error("Invalid Device Type returned from RAS: " + string);
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIDeviceType;
    }

    public static NIArrayID toArrayID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIArrayID nIArrayID = null;
        int n = NIfromMcConverter.toInteger(ctDataType2);
        if (n != -1) {
            nIArrayID = new NIArrayID(NIfromMcConverter.toEssID(ctDataType), n);
        }
        return nIArrayID;
    }

    public static NIArrayID[] toArrayIDArray(CtDataType ctDataType, CtArray ctArray) {
        NIArrayID[] nIArrayIDArray = null;
        if (ctArray != null) {
            CtDataType[] ctDataTypeArray = ctArray.getData();
            nIArrayIDArray = new NIArrayID[ctDataTypeArray.length];
            if (ctDataTypeArray != null && ctDataTypeArray instanceof CtInt32[]) {
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    nIArrayIDArray[n] = NIfromMcConverter.toArrayID(ctDataType, ctDataTypeArray[n]);
                    ++n;
                }
            } else {
                logger.error("Bad data was passed into a convert method. - Bad data from resource manager");
            }
        } else {
            logger.error("Bad data was passed into a convert method. - Null object passes in");
        }
        return nIArrayIDArray;
    }

    public static NICKDBaseCUType toCuBaseType(CtDataType ctDataType) {
        NICKDBaseCUType nICKDBaseCUType = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            switch (((CtInt32)ctDataType).getData()) {
                case 0: {
                    nICKDBaseCUType = (NICKDBaseCUType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3 == null ? (class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3")) : class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3);
                    break;
                }
                case 1: {
                    nICKDBaseCUType = (NICKDBaseCUType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3TPF == null ? (class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3TPF = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3TPF")) : class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model3TPF);
                    break;
                }
                case 2: {
                    nICKDBaseCUType = (NICKDBaseCUType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model6 == null ? (class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model6 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6")) : class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUType3990Model6);
                    break;
                }
                case 3: {
                    nICKDBaseCUType = (NICKDBaseCUType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUTypeBS2000 == null ? (class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUTypeBS2000 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NICKDBaseCUTypeBS2000")) : class$com$ibm$storage$ess$ni$option$config$NICKDBaseCUTypeBS2000);
                    break;
                }
                default: {
                    logger.error("Undefined option from RAS: " + ((CtInt32)ctDataType).getData());
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nICKDBaseCUType;
    }

    public static NIVolumeID toVolumeID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIVolumeID nIVolumeID = null;
        if (ctDataType2 != null && ctDataType2 instanceof CtString) {
            String string = ((CtString)ctDataType2).getData();
            if (string.equals("")) {
                return null;
            }
            String string2 = new String(string.substring(2));
            int n = Integer.parseInt(string2, 16);
            String string3 = new String(string.substring(0, 2));
            int n2 = Integer.parseInt(string3, 16);
            NIESSID nIESSID = NIfromMcConverter.toEssID(ctDataType);
            nIVolumeID = new NIVolumeID(new NILSSID(nIESSID, n2), n);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType + ", " + ctDataType2);
        }
        return nIVolumeID;
    }

    public static NIVolumeType toVolumeType(CtDataType ctDataType) {
        NIVolumeType nIVolumeType = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n = ((CtInt32)ctDataType).getData();
            switch (n) {
                case 10: {
                    nIVolumeType = (NIVolumeType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDBase == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDBase = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDBase);
                    break;
                }
                case 12: {
                    nIVolumeType = (NIVolumeType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias);
                    break;
                }
                case 13: {
                    nIVolumeType = (NIVolumeType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDCrossCUAlias);
                    break;
                }
                case 11: {
                    nIVolumeType = (NIVolumeType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDSingleCuAlias == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDSingleCuAlias = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeCKDSingleCuAlias);
                    break;
                }
                case 20: {
                    nIVolumeType = (NIVolumeType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockBase == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockBase = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockBase);
                    break;
                }
                case 21: {
                    nIVolumeType = (NIVolumeType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockMap == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockMap = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockMap")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeTypeFixedBlockMap);
                    break;
                }
                default: {
                    logger.error("Bad Volume_TYPE was passed into a convert method: Type=" + n);
                    break;
                }
            }
        } else {
            logger.error("Bad Volume was passed into a convert method.");
        }
        return nIVolumeType;
    }

    public static NIDataType toDataType(CtDataType ctDataType) {
        NIDataType nIDataType = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n = ((CtInt32)ctDataType).getData();
            switch (n) {
                case 10: {
                    nIDataType = (NIDataType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDataType3380 == null ? (class$com$ibm$storage$ess$ni$option$config$NIDataType3380 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDataType3380")) : class$com$ibm$storage$ess$ni$option$config$NIDataType3380);
                    break;
                }
                case 11: {
                    nIDataType = (NIDataType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDataType3390 == null ? (class$com$ibm$storage$ess$ni$option$config$NIDataType3390 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDataType3390")) : class$com$ibm$storage$ess$ni$option$config$NIDataType3390);
                    break;
                }
                case 0: {
                    nIDataType = (NIDataType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock512 == null ? (class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock512 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512")) : class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock512);
                    break;
                }
                case 1: {
                    nIDataType = (NIDataType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Protected == null ? (class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Protected = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected")) : class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Protected);
                    break;
                }
                case 2: {
                    nIDataType = (NIDataType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Unprotected == null ? (class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Unprotected = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected")) : class$com$ibm$storage$ess$ni$option$config$NIDataTypeBlock520Unprotected);
                    break;
                }
                case -1: {
                    nIDataType = (NIDataType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIDataTypeUnknown == null ? (class$com$ibm$storage$ess$ni$option$config$NIDataTypeUnknown = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIDataTypeUnknown")) : class$com$ibm$storage$ess$ni$option$config$NIDataTypeUnknown);
                }
                default: {
                    logger.error("Bad DATA_TYPE was passed into a convert method: type=." + n);
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIDataType;
    }

    public static NIRankID toRankID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIRankID nIRankID = null;
        int n = NIfromMcConverter.toInteger(ctDataType2);
        if (n != -1) {
            nIRankID = new NIRankID(NIfromMcConverter.toEssID(ctDataType), n);
        }
        return nIRankID;
    }

    public static NIRaidType toRaidType(CtDataType ctDataType) {
        NIRaidType nIRaidType = null;
        if (ctDataType != null && ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            if ("RAID10".equals(string)) {
                nIRaidType = (NIRaidType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIRaidType10 == null ? (class$com$ibm$storage$ess$ni$option$config$NIRaidType10 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIRaidType10")) : class$com$ibm$storage$ess$ni$option$config$NIRaidType10);
            } else if ("RAID5".equals(string)) {
                nIRaidType = (NIRaidType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIRaidType5 == null ? (class$com$ibm$storage$ess$ni$option$config$NIRaidType5 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIRaidType5")) : class$com$ibm$storage$ess$ni$option$config$NIRaidType5);
            } else {
                logger.error("Bad RAID_TYPE was passed into a convert method: data=" + ctDataType);
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIRaidType;
    }

    public static NIExtentPoolID toExtentPoolID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIExtentPoolID nIExtentPoolID = null;
        int n = NIfromMcConverter.toInteger(ctDataType2);
        if (n != -1) {
            nIExtentPoolID = new NIExtentPoolID(NIfromMcConverter.toEssID(ctDataType), n);
        }
        return nIExtentPoolID;
    }

    public static NIExtentType toExtentType(CtDataType ctDataType) {
        NIExtentType nIExtentType = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n = ((CtInt32)ctDataType).getData();
            switch (n) {
                case 4: {
                    nIExtentType = (NIExtentType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIExtentTypeFB == null ? (class$com$ibm$storage$ess$ni$option$config$NIExtentTypeFB = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIExtentTypeFB")) : class$com$ibm$storage$ess$ni$option$config$NIExtentTypeFB);
                    break;
                }
                case 132: {
                    nIExtentType = (NIExtentType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIExtentTypeCKD == null ? (class$com$ibm$storage$ess$ni$option$config$NIExtentTypeCKD = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD")) : class$com$ibm$storage$ess$ni$option$config$NIExtentTypeCKD);
                    break;
                }
                default: {
                    logger.error("Bad SEGMENT_TYPE was passed into into a convert method: data=" + ctDataType);
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIExtentType;
    }

    public static NISCSIHostPortID toSCSIHostPortID(CtDataType ctDataType, CtDataType ctDataType2) {
        NISCSIHostPortID nISCSIHostPortID = null;
        int n = NIfromMcConverter.toInteger(ctDataType2);
        if (n != -1) {
            nISCSIHostPortID = new NISCSIHostPortID(NIfromMcConverter.toEssID(ctDataType), n);
        }
        return nISCSIHostPortID;
    }

    public static NIFabricTopology toAttachingPortTopology(CtDataType ctDataType) {
        NIFabricTopology nIFabricTopology = null;
        int n = -1;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            try {
                n = ((CtInt32)ctDataType).getData();
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
            switch (n) {
                case 0: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown);
                    break;
                }
                case 2: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop);
                    break;
                }
                case 1: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp);
                    break;
                }
                default: {
                    logger.error("Bad port topology was passed into a convert method.");
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIFabricTopology;
    }

    public static NIFabricTopology toFCPortTopology(CtDataType ctDataType) {
        NIFabricTopology nIFabricTopology = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n = ((CtInt32)ctDataType).getData();
            switch (n) {
                case 0: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyUnknown);
                    break;
                }
                case 3: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFicon == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFicon = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyFicon")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFicon);
                    break;
                }
                case 2: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyFCArbitratedLoop);
                    break;
                }
                case 4: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcpFicon == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcpFicon = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcpFicon")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcpFicon);
                    break;
                }
                case 1: {
                    nIFabricTopology = (NIFabricTopology)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp == null ? (class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp")) : class$com$ibm$storage$ess$ni$option$config$NIFabricTopologyScsiFcp);
                    break;
                }
                default: {
                    logger.error("Bad port topology was passed into a convert method: data=" + ctDataType);
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIFabricTopology;
    }

    public static NIPortMask toPortMask(CtDataType ctDataType) {
        byte[] byArray = NIfromMcConverter.toByteArrayfromHexString(ctDataType);
        NIPortMask nIPortMask = new NIPortMask("2107", byArray);
        return nIPortMask;
    }

    private static byte[] toByteArrayfromHexString(CtDataType ctDataType) {
        byte[] byArray = null;
        if (ctDataType == null) {
            byArray = null;
        } else if (ctDataType instanceof CtString) {
            String string = ((CtString)ctDataType).getData();
            byArray = new byte[string.length() / 2];
            byArray = NIByteArray.hexToByteArray(string);
        } else {
            logger.error("toByteArrayfromHexString error: data: " + ctDataType);
        }
        return byArray;
    }

    public static NIVolumeGroup toVolumeGroup(CtDataType ctDataType, CtDataType ctDataType2, CtDataType ctDataType3) {
        NIVolumeGroupID nIVolumeGroupID = NIfromMcConverter.toVolumeGroupID(ctDataType, ctDataType2);
        String string = NIfromMcConverter.toString(ctDataType3);
        NIVolumeGroupType nIVolumeGroupType = null;
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = null;
        return new NIVolumeGroupImpl(nIVolumeGroupID, string, nIVolumeGroupType, nIVolumeGroupVolumeList);
    }

    public static NIVolumeGroupID toVolumeGroupID(CtDataType ctDataType, CtDataType ctDataType2) {
        NIVolumeGroupID nIVolumeGroupID = null;
        int n = NIfromMcConverter.toInteger(ctDataType2);
        if (n != -1) {
            nIVolumeGroupID = new NIVolumeGroupID(NIfromMcConverter.toEssID(ctDataType), n);
        }
        return nIVolumeGroupID;
    }

    public static NIVolumeGroupType toVolumeGroupType(CtDataType ctDataType) {
        NIVolumeGroupType nIVolumeGroupType = null;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            int n = ((CtInt32)ctDataType).getData();
            switch (n) {
                case 801: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeCopyServices == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeCopyServices = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeCopyServices")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeCopyServices);
                    break;
                }
                case 10: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconAll == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconAll = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconAll);
                    break;
                }
                case 11: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMask == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMask = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMask")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMask);
                    break;
                }
                case 12: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMixedMask == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMixedMask = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMixedMask")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeFiconEsconMixedMask);
                    break;
                }
                case 30: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520All == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520All = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520All);
                    break;
                }
                case 32: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Map256 == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Map256 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Map256")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Map256);
                    break;
                }
                case 31: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Mask == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Mask = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSI520Mask);
                    break;
                }
                case 20: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIAll == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIAll = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIAll);
                    break;
                }
                case 22: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMap256 == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMap256 = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMap256);
                    break;
                }
                case 21: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMask == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMask = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMask);
                    break;
                }
                case 23: {
                    nIVolumeGroupType = (NIVolumeGroupType)NIConfigOptionFactory.getOptionFactory().getOption(class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMixedMask == null ? (class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMixedMask = NIfromMcConverter.class$("com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMixedMask")) : class$com$ibm$storage$ess$ni$option$config$NIVolumeGroupTypeSCSIMixedMask);
                    break;
                }
                default: {
                    logger.error("Bad volume group was passed into a convert method: type=" + n);
                    break;
                }
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIVolumeGroupType;
    }

    public static NIVolumeGroupVolumeList toVolumeMask(CtDataType ctDataType, CtDataType ctDataType2, NIVolumeGroupType nIVolumeGroupType) {
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = NIResourceFactory.newVolumeGroupVolumeList(nIVolumeGroupType);
        if (ctDataType != null && ctDataType instanceof CtBinary && ctDataType2 != null && ctDataType2 instanceof CtString) {
            NIESSID nIESSID = NIfromMcConverter.toEssID(ctDataType2);
            byte[] byArray = ((CtBinary)ctDataType).getData();
            int n = 32;
            int n2 = 8;
            int n3 = 128;
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = 0;
                while (n5 < n2) {
                    if ((byArray[n4] & n3 >>> n5) > 0) {
                        int n6 = n4 / n;
                        int n7 = n4 % n * n2 + n5;
                        nIVolumeGroupVolumeList.add(new NIVolumeID(new NILSSID(nIESSID, n6), n7));
                    }
                    ++n5;
                }
                ++n4;
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return nIVolumeGroupVolumeList;
    }

    public static NIVolumeGroupVolumeList toVolumeMap(CtDataType ctDataType, CtDataType ctDataType2) {
        Serializable serializable;
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[]{};
        Byte by = new Byte(-1);
        if (ctDataType != null && ctDataType instanceof CtBinary && ctDataType2 != null && ctDataType2 instanceof CtString) {
            serializable = NIfromMcConverter.toEssID(ctDataType2);
            byte[] byArray = ((CtBinary)ctDataType).getData();
            logger.debug_detailed("Bytes in map: + " + byArray.length);
            nIVolumeIDArray = new NIVolumeID[byArray.length / 2];
            int n = 0;
            while (n < byArray.length / 2) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 2 * n;
                String string = Integer.toHexString(byArray[n2]);
                if (string.length() > 2) {
                    string = string.substring(string.length() - 2);
                } else if (string.length() < 2) {
                    string = "0" + string;
                }
                stringBuffer.append(string);
                Byte by2 = new Byte(byArray[n2]);
                int n3 = n2 + 1;
                String string2 = Integer.toHexString(byArray[n3]);
                if (string2.length() > 2) {
                    string2 = string2.substring(string2.length() - 2);
                } else if (string.length() < 2) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
                Byte by3 = new Byte(byArray[n3]);
                logger.debug_detailed("LVN[" + n + "] = 0x" + stringBuffer.toString());
                if (!by2.equals(by) || !by3.equals(by)) {
                    nIVolumeIDArray[n] = new NIVolumeID(new NILSSID((NIESSID)serializable, by2.intValue() & 0xFF), by3.intValue() & 0xFF);
                }
                ++n;
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType + ctDataType2);
        }
        try {
            serializable = new NIVolumeGroupSCSIMapImpl(nIVolumeIDArray);
        }
        catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
            serializable = new NIVolumeGroupSCSIMapImpl();
            logger.error("Failed to create NIVolumeGroupMap due to invalid number of volumes");
        }
        return serializable;
    }

    public static NILSSID toLssId(CtDataType ctDataType, CtDataType ctDataType2, CtDataType ctDataType3) {
        return new NILSSID(NIfromMcConverter.toEssID(ctDataType), NIfromMcConverter.toIntfromHexString(ctDataType2), NIfromMcConverter.toIntfromHexString(ctDataType3));
    }

    public static long toLongfromHexString(CtDataType ctDataType) {
        long l = 0L;
        if (ctDataType != null && ctDataType instanceof CtString) {
            CtString ctString = (CtString)ctDataType;
            if (ctString.getData().equals("")) {
                logger.error("RAS returned a null string... Will return 0 for the value.");
            } else {
                BigInteger bigInteger = new BigInteger(ctString.getData().trim(), 16);
                l = bigInteger.longValue();
            }
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return l;
    }

    public static float toPercentage(CtDataType ctDataType) {
        float f = -1.0f;
        if (ctDataType != null && ctDataType instanceof CtInt32) {
            f = (float)((double)NIfromMcConverter.toInteger(ctDataType) / 100.0);
        } else {
            logger.error("Bad data was passed into a convert method: " + ctDataType);
        }
        return f;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

