/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.domain;

import com.ibm.rsct.rmcjni.McActionRsp;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceQueryActionConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.results.NILICFeatureKeyDescriptor;
import com.ibm.storage.ess.ni.application.results.NIQueryLICFeatureKeysResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIESSState;
import com.ibm.storage.ess.ni.resource.NIESSImpl;
import com.ibm.storage.ess.ni.results.NILICFeatureKeyDescriptorImpl;
import com.ibm.storage.ess.ni.results.NIQueryLICFeatureKeysResultImpl;
import com.ibm.storage.ess.ni.util.NIMtmsParser;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NIESSConverter
implements NIResourceConverter,
NIResourceModificationConverter,
NIResourceQueryActionConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIESSConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIESSConverter = NIESSConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.domain.NIESSConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIESSConverter);
    private static final int BITS_PER_INTEGER = 32;
    private static final int LIC_STORAGE_TYPE_FIRST_BIT = 0;
    private static final int LIC_STORAGE_TYPE_LAST_BIT = 1;
    private static final int LIC_SCALE_FIRST_BIT = 2;
    private static final int LIC_SCALE_LAST_BIT = 5;
    private static final int LIC_RANGE_FIRST_BIT = 6;
    private static final int LIC_RANGE_LAST_BIT = 15;
    private static final int LIC_KEY_FIELD_LEN = 4;
    private static final long BYTES_PER_TERABYTE = 1000000000000L;
    private static final long WWPN_UNDEFINED = -1L;
    private static final String LIC_KEY_DELIMITER = "-";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIESSConverter;

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        NIESS nIESS = (NIESS)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[]{new McAttribute("storageFacilityImageUserName", 0, (CtDataType)NItoMcConverter.fromString(nIESS.getUserName())), new McAttribute("userDescription", 0, (CtDataType)NItoMcConverter.fromString(nIESS.getUserDescription())), new McAttribute("essNetCopyServicesEnabled", 0, (CtDataType)NItoMcConverter.fromBoolean(nIESS.isEssNetCSEnabled())), new McAttribute("limitESSNetCopyServices", 0, (CtDataType)NItoMcConverter.fromBoolean(nIESS.isLimitEssNetCS())), new McAttribute("essNetCopyServicesVolumeGroup", 0, (CtDataType)NItoMcConverter.fromVolumeGroupID(nIESS.getAllowedEssNetCS())), new McAttribute("requestedState", 0, (CtDataType)NItoMcConverter.fromESSState(nIESS.getRequestedState()))};
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIStorageFacilityImage.");
            throw new NIServerException(1, "Attributes were null while querying the NIStorageFacilityImage.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        long l = NIfromMcConverter.toLongfromHexString((CtDataType)hashtable.get("storageFacilityImageWWNN"));
        NIMtmsParser nIMtmsParser = new NIMtmsParser(NIfromMcConverter.toString((CtDataType)hashtable.get("storageFacilityImageMTMS")));
        String string = nIMtmsParser.getModel();
        NIESSID nIESSID = NIfromMcConverter.toEssID((CtDataType)hashtable.get("storageFacilityImageMTMS"), l);
        String string2 = NIfromMcConverter.toString((CtDataType)hashtable.get("storageFacilityImageUserName"));
        String string3 = NIfromMcConverter.toString((CtDataType)hashtable.get("userDescription"));
        boolean bl = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("essNetCopyServicesEnabled"));
        boolean bl2 = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("limitESSNetCopyServices"));
        NIVolumeGroupID nIVolumeGroupID = NIfromMcConverter.toVolumeGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("essNetCopyServicesVolumeGroup"));
        NIESSState nIESSState = NIfromMcConverter.toESSState((CtDataType)hashtable.get("requestedState"));
        NIESSState nIESSState2 = NIfromMcConverter.toESSState((CtDataType)hashtable.get("state"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("imageNvsMemory"));
        int n3 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("imageCacheMemory"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("imageProcessorMemory"));
        NIESSImpl nIESSImpl = new NIESSImpl(nIESSID, string2, string3, bl2, bl, nIVolumeGroupID, nIESSState, nIESSState2, string, n2, n3, n4);
        return nIESSImpl;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        NIMtmsParser nIMtmsParser = new NIMtmsParser(nIResourceID.toString());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("storageFacilityImageMTMS=?\"");
        stringBuffer.append(nIMtmsParser.getRASString());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public String toSelectStringWithSF(NIStorageFacilityID nIStorageFacilityID) throws NIServerException {
        NIMtmsParser nIMtmsParser = new NIMtmsParser(nIStorageFacilityID.toString());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("storageFacilityMTMS=?\"");
        stringBuffer.append(nIMtmsParser.getRASString());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public NIResult convertQueryAction(String string, McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIQueryLICFeatureKeysResult nIQueryLICFeatureKeysResult = null;
        if (string.equals("queryLICFeatureKeys")) {
            nIQueryLICFeatureKeysResult = this.fromQueryLICFeatureKeysAction(mcActionRspArray, nIESSID);
        }
        return nIQueryLICFeatureKeysResult;
    }

    public CtStructuredData toInstallLICFeatureKeyAction(String string) {
        String string2 = this.stripLicString(string);
        logger.debug_general("Installing key: \"" + string2 + "\"");
        return new CtStructuredData(new CtDataType[]{new CtString(string2)});
    }

    public CtStructuredData toQueryLICFeatureKeysAction() {
        return null;
    }

    private int valueOfBits(int n, int n2, int n3) {
        int n4 = 32 - n3 - 1;
        int n5 = n3 - n2 + 1;
        int n6 = (int)Math.pow(2.0, n5) - 1;
        return n >> n4 & n6;
    }

    private NIQueryLICFeatureKeysResult fromQueryLICFeatureKeysAction(McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        CtStructuredData ctStructuredData = mcActionRspArray[0].getData()[0];
        int n = ctStructuredData.getElementCount();
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int n2 = 0;
        int n3 = 16;
        int[] nArray3 = new int[]{};
        long[] lArray = new long[]{};
        String[] stringArray = new String[]{};
        String string = null;
        int n4 = 0;
        while (n4 < n) {
            CtDataType ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n4);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n4 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n4 + ".");
            }
            switch (n4) {
                case 0: {
                    int n5 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 1: {
                    int n6 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 2: {
                    int n7 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 3: {
                    n2 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 4: {
                    NIESSID nIESSID2 = NIfromMcConverter.toEssID(ctDataType);
                    break;
                }
                case 5: {
                    NIStorageFacilityID nIStorageFacilityID = NIfromMcConverter.toStorageFacilityID(ctDataType, -1L);
                    break;
                }
                case 6: {
                    string = NIfromMcConverter.toString(ctDataType);
                    break;
                }
                case 7: {
                    nArray2 = NIfromMcConverter.toIntegerArray((CtArray)ctDataType);
                    if (n2 == nArray2.length) break;
                    logger.warning("numLicFeatureKeyDescs (" + n2 + ") does not equal the number of feature types actually retrieved (" + nArray2.length + ")");
                    break;
                }
                case 8: {
                    stringArray = NIfromMcConverter.toStringArray((CtArray)ctDataType);
                    if (n2 == stringArray.length) break;
                    logger.warning("numLicFeatureKeyDescs (" + n2 + ") does not equal the number of encrypted keys actually retrieved (" + stringArray.length + ")");
                    break;
                }
                case 9: {
                    nArray = NIfromMcConverter.toIntegerArray((CtArray)ctDataType);
                    lArray = new long[nArray.length];
                    nArray3 = new int[nArray.length];
                    int n8 = 0;
                    while (n8 < nArray.length) {
                        logger.debug_general("LIC Info: enablementVals[" + n8 + "] = " + nArray[n8]);
                        nArray3[n8] = this.valueOfBits(nArray[n8] << n3, 0, 1);
                        int n9 = this.valueOfBits(nArray[n8] << n3, 2, 5);
                        int n10 = this.valueOfBits(nArray[n8] << n3, 6, 15);
                        lArray[n8] = new Double(Math.pow(2.0, n9 * 5) * (double)n10 / 1.0E12).longValue();
                        if (n9 < 0 || n10 < 0) {
                            logger.warning("Invalid enablementVal received (" + nArray[n8] + ") for index " + n8);
                        }
                        ++n8;
                    }
                    if (n2 == nArray.length) break;
                    logger.warning("numLicFeatureKeyDescs (" + n2 + ") does not equal the number actually retrieved (" + nArray.length + ")");
                    break;
                }
            }
            ++n4;
        }
        if (n2 > nArray2.length) {
            n2 = nArray2.length;
        }
        if (n2 > nArray3.length) {
            n2 = nArray3.length;
        }
        if (n2 > stringArray.length) {
            n2 = stringArray.length;
        }
        NILICFeatureKeyDescriptor[] nILICFeatureKeyDescriptorArray = new NILICFeatureKeyDescriptor[n2];
        n4 = 0;
        while (n4 < n2) {
            nILICFeatureKeyDescriptorArray[n4] = new NILICFeatureKeyDescriptorImpl(nArray2[n4], nArray3[n4], lArray[n4], this.formatLicString(stringArray[n4]));
            ++n4;
        }
        return new NIQueryLICFeatureKeysResultImpl(this.formatLicString(string), nILICFeatureKeyDescriptorArray, true, 0);
    }

    private String formatLicString(String string) {
        String string2;
        if (string.indexOf(LIC_KEY_DELIMITER) < 0) {
            int n = string.length();
            string2 = "";
            int n2 = 0;
            while (n2 < n) {
                if (n2 != 0) {
                    string2 = string2 + LIC_KEY_DELIMITER;
                }
                string2 = string2 + string.substring(n2, n2 + 4);
                n2 += 4;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    private String stripLicString(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, LIC_KEY_DELIMITER);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + stringTokenizer.nextToken();
            ++n2;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssStorageFacilityImage";

        public static interface RsrcAct {
            public static final String INSTALL_LIC_FEATURE_KEY = "installLICFeatureKey";
            public static final String QUERY_LIC_FEATURE_KEYS = "queryLICFeatureKeys";
        }

        public static interface Attr {
            public static final String SF_MTMS = "storageFacilityMTMS";
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String SFI_USER_NAME = "storageFacilityImageUserName";
            public static final String SFI_WWNN = "storageFacilityImageWWNN";
            public static final String USER_DESCRIPTION = "userDescription";
            public static final String ESS_NET_COPY_SERVICES_ENABLED = "essNetCopyServicesEnabled";
            public static final String LIMIT_ESS_NET_COPY_SERVICES = "limitESSNetCopyServices";
            public static final String ESS_NET_COPY_SERVICES_VOLUME_GROUP = "essNetCopyServicesVolumeGroup";
            public static final String REQUESTED_STATE = "requestedState";
            public static final String IMAGE_PROCESSOR_MEMORY = "imageProcessorMemory";
            public static final String IMAGE_NVS_MEMORY = "imageNvsMemory";
            public static final String IMAGE_CACHE_MEMORY = "imageCacheMemory";
            public static final String STATE = "state";
        }
    }
}

