/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.domain;

import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlMode;
import com.ibm.storage.ess.ni.resource.NIStorageFacilityImpl;
import com.ibm.storage.ess.ni.util.NIMtmsParser;
import java.util.Hashtable;

public class NIStorageFacilityConverter
implements NIResourceConverter,
NIResourceModificationConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIStorageFacilityConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIStorageFacilityConverter = NIStorageFacilityConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.domain.NIStorageFacilityConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIStorageFacilityConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$domain$NIStorageFacilityConverter;

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        McAttribute[] mcAttributeArray = new McAttribute[5];
        NIStorageFacility nIStorageFacility = (NIStorageFacility)nIResource;
        int n = 0;
        mcAttributeArray[n++] = new McAttribute("storageFacilityUserName", 0, (CtDataType)NItoMcConverter.fromString(nIStorageFacility.getUserName()));
        mcAttributeArray[n++] = new McAttribute("userDescription", 0, (CtDataType)NItoMcConverter.fromString(nIStorageFacility.getUserDescription()));
        mcAttributeArray[n++] = new McAttribute("scheduledPowerOffTime", 0, (CtDataType)NItoMcConverter.fromStringArray(nIStorageFacility.getPowerOffTimes()));
        mcAttributeArray[n++] = new McAttribute("scheduledPowerOnTime", 0, (CtDataType)NItoMcConverter.fromStringArray(nIStorageFacility.getPowerOffTimes()));
        mcAttributeArray[n++] = new McAttribute("remotezSeriesFeature", 0, (CtDataType)NItoMcConverter.fromBoolean(nIStorageFacility.getZSeriesPowerControl()));
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIStorageFacility.");
            throw new NIServerException(1, "Attributes were null while querying the NIStorageFacility.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        long l = NIfromMcConverter.toLongfromHexString((CtDataType)hashtable.get("storageFacilityWWNN"));
        NIMtmsParser nIMtmsParser = new NIMtmsParser(NIfromMcConverter.toString((CtDataType)hashtable.get("storageFacilityMTMS")));
        String string = nIMtmsParser.getModel();
        NIStorageFacilityID nIStorageFacilityID = NIfromMcConverter.toStorageFacilityID((CtDataType)hashtable.get("storageFacilityMTMS"), l);
        String string2 = NIfromMcConverter.toString((CtDataType)hashtable.get("storageFacilityUserName"));
        String string3 = NIfromMcConverter.toString((CtDataType)hashtable.get("userDescription"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("configuration"));
        String[] stringArray = NIfromMcConverter.toStringArray((CtArray)hashtable.get("scheduledPowerOnTime"));
        String[] stringArray2 = NIfromMcConverter.toStringArray((CtArray)hashtable.get("scheduledPowerOffTime"));
        boolean bl = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("remotezSeriesFeature"));
        NISFPowerControlMode nISFPowerControlMode = NIfromMcConverter.toSFPowerControlMode((CtDataType)hashtable.get("powerControlMode"));
        NISFPowerControlMode nISFPowerControlMode2 = NIfromMcConverter.toSFPowerControlMode((CtDataType)hashtable.get("requestedPowerControlMode"));
        String string4 = NIfromMcConverter.toString((CtDataType)hashtable.get("manufacturer"));
        int n3 = NIfromMcConverter.toPowerState((CtDataType)hashtable.get("powerState"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("imageProcessorMemory"));
        NIStorageFacilityImpl nIStorageFacilityImpl = new NIStorageFacilityImpl(nIStorageFacilityID, string, string2, string3, n2, nISFPowerControlMode, nISFPowerControlMode2, n3, stringArray, stringArray2, bl, string4, n4);
        return nIStorageFacilityImpl;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        NIMtmsParser nIMtmsParser = new NIMtmsParser(nIResourceID.toString());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("storageFacilityMTMS=?\"");
        stringBuffer.append(nIMtmsParser.getRASString());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public CtStructuredData toPowerOnAction() {
        return null;
    }

    public CtStructuredData toPowerOffAction() {
        return null;
    }

    public CtStructuredData toRequestPowerControlAction(NISFPowerControlMode nISFPowerControlMode) {
        logger.debug_general("Setting requested power control mode: \"" + nISFPowerControlMode + "\"");
        return new CtStructuredData(new CtDataType[]{NItoMcConverter.fromSfPowerMode(nISFPowerControlMode)});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssStorageFacility";

        public static interface RsrcAct {
            public static final String MANUAL_POWER_ON = "manualPowerOn";
            public static final String MANUAL_POWER_OFF = "manualPowerOff";
            public static final String REQUEST_POWER_CONTROL = "requestPowerControlMode";
        }

        public static interface Attr {
            public static final String MTMS = "storageFacilityMTMS";
            public static final String WWNN = "storageFacilityWWNN";
            public static final String USER_NAME = "storageFacilityUserName";
            public static final String USER_DESCRIPTION = "userDescription";
            public static final String CONFIGURATION = "configuration";
            public static final String SCHEDULE_POWER_ON_TIME = "scheduledPowerOnTime";
            public static final String SCHEDULE_POWER_OFF_TIME = "scheduledPowerOffTime";
            public static final String POWER_CONTROL_MODE = "powerControlMode";
            public static final String REQUESTED_POWER_CONTROL_MODE = "requestedPowerControlMode";
            public static final String REMOTE_ZSERIES_FEATURE = "remotezSeriesFeature";
            public static final String MANUFACTURER = "manufacturer";
            public static final String IMAGE_PROCESSOR_MEMORY = "imageProcessorMemory";
            public static final String POWER_STATE = "powerState";
        }
    }
}

