/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.physical;

import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.rmcjni.McClassActionRsp;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtInt32Array;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CtUint64Array;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceQueryClassActionConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIESCONPort;
import com.ibm.storage.ess.ni.application.resource.NIFibreChannelPort;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.results.NILoginDescriptor;
import com.ibm.storage.ess.ni.application.results.NIQueryUnknownWWPNResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.resource.NIESCONPortImpl;
import com.ibm.storage.ess.ni.resource.NIFibreChannelPortImpl;
import com.ibm.storage.ess.ni.results.NIQueryUnknownWWPNResultImpl;
import com.ibm.storage.ess.ni.util.NIPortMaskBitIndexConverter;
import java.util.Hashtable;

public class NIIOPortConverter
implements NIResourceConverter,
NIResourceModificationConverter,
NIResourceQueryClassActionConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$physical$NIIOPortConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$physical$NIIOPortConverter = NIIOPortConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.physical.NIIOPortConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$physical$NIIOPortConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$physical$NIIOPortConverter;

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        NIIOPort nIIOPort = (NIIOPort)nIResource;
        int n = nIIOPort.getPortType();
        McAttribute[] mcAttributeArray = null;
        int n2 = 0;
        switch (n) {
            case 10: {
                mcAttributeArray = new McAttribute[1];
                NIESCONPort nIESCONPort = (NIESCONPort)nIIOPort;
                mcAttributeArray[n2++] = new McAttribute("esconVolumeGroup", 0, (CtDataType)NItoMcConverter.fromVolumeGroupID(nIESCONPort.getVolumeGroupID()));
                break;
            }
            case 20: 
            case 21: {
                mcAttributeArray = new McAttribute[6];
                NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)nIIOPort;
                mcAttributeArray[n2++] = new McAttribute("topologyULP", 0, (CtDataType)NItoMcConverter.fromFCPortTopology(nIFibreChannelPort.getTopology()));
                mcAttributeArray[n2++] = new McAttribute("anonymousFICONAccess", 0, (CtDataType)NItoMcConverter.fromBoolean(nIFibreChannelPort.isAnonymousFICONEnabled()));
                mcAttributeArray[n2++] = new McAttribute("anonymousFICONPortGroup", 0, (CtDataType)NItoMcConverter.fromInt(nIFibreChannelPort.getAnonymousFICONPortGroup()));
                mcAttributeArray[n2++] = new McAttribute("anonymousFICONVolumeGroup", 0, (CtDataType)NItoMcConverter.fromVolumeGroupID(nIFibreChannelPort.getAnonymousFICONVolumeGroup()));
            }
        }
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIIOPort.");
            throw new NIServerException(1, "Attributes were null while querying the NIIOPort.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIIOPortID nIIOPortID = NIfromMcConverter.toIOPortID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("interfaceIdentifier"));
        String string = NIfromMcConverter.toString((CtDataType)hashtable.get("locationCode"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("portType"));
        int n3 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("portSpeed"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("state"));
        int n5 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("interfaceIdentifier"));
        if (n2 == 10) {
            NIAddressGroupID nIAddressGroupID = NIfromMcConverter.toAddressGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("esconAddressGroup"));
            NIVolumeGroupID nIVolumeGroupID = NIfromMcConverter.toVolumeGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("esconVolumeGroup"));
            int n6 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("esconPortGroup"));
            boolean bl = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("esconLimitInbandCopyServices"));
            NIESCONPortImpl nIESCONPortImpl = new NIESCONPortImpl(nIIOPortID, string, n2, n3, n4, nIAddressGroupID, nIVolumeGroupID, n5, n6);
            return nIESCONPortImpl;
        }
        if (n2 == 20 || n2 == 21) {
            NIVolumeGroupID nIVolumeGroupID = NIfromMcConverter.toVolumeGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("anonymousFICONVolumeGroup"));
            int n7 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("anonymousFICONCkdPriorityOffset"));
            boolean bl = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("anonymousFICONAccess"));
            int n8 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("anonymousFICONPortGroup"));
            boolean bl2 = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("anonymousFICONLimitInbandCopyServices"));
            NIFabricTopology nIFabricTopology = NIfromMcConverter.toFCPortTopology((CtDataType)hashtable.get("topologyULP"));
            int n9 = NIPortMaskBitIndexConverter.getPortMaskBitIndex("2107", n5);
            long l = NIfromMcConverter.toLongfromHexString((CtDataType)hashtable.get("wwpn"));
            String string2 = NIfromMcConverter.toString((CtDataType)hashtable.get("logicalName"));
            NIFibreChannelPortImpl nIFibreChannelPortImpl = new NIFibreChannelPortImpl(nIIOPortID, string, n2, n3, l, n4, n8, nIVolumeGroupID, n9, nIFabricTopology, n5);
            nIFibreChannelPortImpl.setLogicalName(string2);
            return nIFibreChannelPortImpl;
        }
        return null;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("interfaceIdentifier");
        stringBuffer.append("==");
        stringBuffer.append(((NIIOPortID)nIResourceID).getInterfaceIdentifier());
        return stringBuffer.toString();
    }

    public CtStructuredData toChangeTopologyAction(NIFibreChannelPortImpl nIFibreChannelPortImpl) throws NIServerException {
        return new CtStructuredData(new CtDataType[]{NItoMcConverter.fromString(nIFibreChannelPortImpl.getLogicalName()), NItoMcConverter.fromFCPortTopology(nIFibreChannelPortImpl.getTopology())});
    }

    public CtStructuredData toQueryUnknownWWPNsAction(int n, int n2) {
        return new CtStructuredData(new CtDataType[]{new CtInt32(n), new CtInt32(n2)});
    }

    public NIResult convertQueryClassAction(String string, McClassActionRsp[] mcClassActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIQueryUnknownWWPNResult nIQueryUnknownWWPNResult = null;
        if (string.equals("queryUnknownWWPNs")) {
            nIQueryUnknownWWPNResult = this.fromQueryUnknownWWPNsAction(mcClassActionRspArray, nIESSID);
        }
        return nIQueryUnknownWWPNResult;
    }

    public NIQueryUnknownWWPNResult fromQueryUnknownWWPNsAction(McClassActionRsp[] mcClassActionRspArray, NIESSID nIESSID) throws NIServerException {
        CtUint64Array ctUint64Array;
        CtUint64Array ctUint64Array2;
        CtInt32Array ctInt32Array;
        CtDataType ctDataType;
        CtStructuredData ctStructuredData = mcClassActionRspArray[0].getData()[0];
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        int n4 = 2;
        while (n4 < 6) {
            ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n4);
                switch (n4) {
                    case 2: {
                        n3 = NIfromMcConverter.toInteger((CtDataType)((CtInt32)ctDataType));
                        break;
                    }
                    case 3: {
                        n = NIfromMcConverter.toInteger((CtDataType)((CtInt32)ctDataType));
                        break;
                    }
                    case 4: {
                        n2 = NIfromMcConverter.toInteger((CtDataType)((CtInt32)ctDataType));
                        break;
                    }
                    case 5: {
                        bl = NIfromMcConverter.toBoolean((CtDataType)((CtInt32)ctDataType));
                        break;
                    }
                    default: {
                        logger.warning("We should never process data we don't need.");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Caught exception when processing Header on element " + n4 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception when processing Header on element " + n4 + ".");
            }
            ++n4;
        }
        ctDataType = new NILoginDescriptor[n3];
        try {
            ctInt32Array = (CtInt32Array)ctStructuredData.getData(7);
            ctUint64Array2 = (CtUint64Array)ctStructuredData.getData(8);
            ctUint64Array = (CtUint64Array)ctStructuredData.getData(9);
        }
        catch (Exception exception) {
            logger.error("Caught exception when casting id list, the wwpn list and the wwnn list from data element 7, 8, and 9.");
            logger.throwable((Throwable)exception);
            throw new NIServerException(1, "Caught exception when casting id list, the wwpn list and the wwnn list from data element 7, 8, and 9.");
        }
        int n5 = 0;
        while (n5 < n3) {
            try {
                int n6 = NIfromMcConverter.toInteger(ctInt32Array.getData()[n5]);
                long l = NIfromMcConverter.toLong(ctUint64Array2.getData()[n5]);
                long l2 = NIfromMcConverter.toLong(ctUint64Array.getData()[n5]);
                ctDataType[n5] = new NILoginDescriptor(l, l2, new NIIOPortID(nIESSID, n6));
            }
            catch (Exception exception) {
                logger.error("Caught exception while creating Login Descriptor " + n5 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception while creating Login Descriptor " + n5 + ".");
            }
            ++n5;
        }
        return new NIQueryUnknownWWPNResultImpl(n, n2, bl, (NILoginDescriptor[])ctDataType, true, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssHAPort";

        public static interface ClassAct {
            public static final String QUERY_UNKNOWN_WWPNS = "queryUnknownWWPNs";
        }

        public static interface RsrcAct {
            public static final String CHANGE_TOPOLOGY = "changeTopology";
        }

        public static interface Attr {
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String INTERFACE_ID = "interfaceIdentifier";
            public static final String LOCATION_CODE = "locationCode";
            public static final String PORT_TYPE = "portType";
            public static final String PORT_SPEED = "portSpeed";
            public static final String WWPN = "wwpn";
            public static final String STATE = "state";
            public static final String FC_TOPOLOGY = "topologyULP";
            public static final String FC_SCSI_ACCESS = "anonymousSCSIAccess";
            public static final String FC_SCSI_PORT_PROFILE = "anonymousSCSIPortProfile";
            public static final String FC_SCSI_PORT_GROUP = "anonymousSCSIPortGroup";
            public static final String FC_SCSI_VOLUME_GROUP = "anonymousSCSIVolumeGroup";
            public static final String FC_SCSI_OVERRIDE_DEFAULT_PRIORITY = "anonymousSCSIOverrideDefaultPriority";
            public static final String FC_SCSI_OVERRIDE_DEFAULT_PRIORITY_VALUE = "anonymousSCSIOverrideDefaultPriorityValue";
            public static final String FC_SCSI_LOGON_LIMIT = "scsiLoginLimit";
            public static final String FC_FICON_ACCESS = "anonymousFICONAccess";
            public static final String FC_FICON_PORT_GROUP = "anonymousFICONPortGroup";
            public static final String FC_FICON_VOLUME_GROUP = "anonymousFICONVolumeGroup";
            public static final String FC_FICON_INBAND_CS_ENABLED = "anonymousFICONInbandCopyServiceEnabled";
            public static final String FC_FICON_LIMIT_INBAND_CS = "anonymousFICONLimitInbandCopyServices";
            public static final String FC_FICON_OVERRIDE_PRIORITY = "anonymousFICONOverrideDefaultPriority";
            public static final String FC_FICON_PRIORITY_VALUE = "anonymousFICONDefaultPriorityOverrideValue";
            public static final String FC_FICON_CKD_PRIORITY_OFFSET = "anonymousFICONCkdPriorityOffset";
            public static final String FC_FICON_LOGON_LIMIT = "ficonLoginLimit";
            public static final String ESCON_ADDRESS_GROUP = "esconAddressGroup";
            public static final String ESCON_PORT_GROUP = "esconPortGroup";
            public static final String ESCON_VOLUME_GROUP = "esconVolumeGroup";
            public static final String ESCON_INBAND_CS_ENABLED = "esconInbandCopyServiceEnabled";
            public static final String ESCON_LIMIT_INBAND_CS = "esconLimitInbandCopyServices";
            public static final String ESCON_OVERRIDE_PRIORITY = "esconOverrideDefaultPriority";
            public static final String ESCON_PRIORITY_VALUE = "esconDefaultPriorityOverrideValue";
            public static final String ESCON_CKD_PRIORITY_OFFSET = "esconCkdPriorityOffset";
            public static final String LOGICAL_NAME = "logicalName";
        }
    }
}

