/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.application.resource;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIFibreChannelPort;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NIPortMask
implements Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$application$resource$NIPortMask == null ? (class$com$ibm$storage$ess$ni$application$resource$NIPortMask = NIPortMask.class$("com.ibm.storage.ess.ni.application.resource.NIPortMask")) : class$com$ibm$storage$ess$ni$application$resource$NIPortMask);
    private static final long serialVersionUID = 1L;
    private static final int MASK_SIZE_2107 = 48;
    private static final int MASK_SIZE_1750 = 4;
    protected byte[] portMaskBytes;
    protected NIByteArray portMaskByteArray;
    protected int numberOfBytes;
    protected String machineType;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$resource$NIPortMask;

    public NIPortMask(String string) {
        this.machineType = string;
        this.numberOfBytes = 48;
        if (string.equals("1750")) {
            this.numberOfBytes = 4;
        }
        this.portMaskBytes = new byte[this.numberOfBytes];
        int n = 0;
        while (n < this.numberOfBytes) {
            this.portMaskBytes[n] = 0;
            ++n;
        }
        this.portMaskByteArray = new NIByteArray(this.portMaskBytes);
    }

    public NIPortMask(String string, byte[] byArray) {
        this.machineType = string;
        this.numberOfBytes = byArray.length;
        this.portMaskBytes = byArray;
        this.portMaskByteArray = new NIByteArray(byArray);
    }

    public boolean isAllEnabled() {
        int n = 0;
        n = 0;
        while (n < this.numberOfBytes) {
            if (this.portMaskByteArray.getByteAsInt(n) < 255) break;
            ++n;
        }
        return n >= this.numberOfBytes;
    }

    public void setAllEnabled(boolean bl) {
        int n = 0;
        while (n < this.numberOfBytes) {
            byte by = 0;
            if (bl) {
                by = -1;
            }
            this.portMaskByteArray.writeByte(n, by);
            ++n;
        }
    }

    public void add(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        this.portMaskByteArray.setBit(n2, n3);
    }

    public void add(NIIOPort nIIOPort) {
        this.add(nIIOPort.getPortMaskBitIndex());
    }

    public void remove(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        this.portMaskByteArray.clearBit(n2, n3);
    }

    public void remove(NIIOPort nIIOPort) {
        this.remove(nIIOPort.getPortMaskBitIndex());
    }

    public int[] getInterfaceIDs() {
        int[] nArray = new int[this.portMaskByteArray.getByteArray().length * 8];
        int[] nArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.portMaskByteArray.getByteArray().length) {
            int n3 = 0;
            while (n3 < 8) {
                if (this.portMaskByteArray.bitIsSet(n2, n3)) {
                    int n4;
                    int n5 = n2 * 8 + n3;
                    int n6 = n5 / 16;
                    int n7 = (n5 - n6 * 16) / 4;
                    int n8 = n5 - n6 * 16 - n7 * 4;
                    if (this.machineType.equals("2107")) {
                        n7 += n7 > 1 ? 1 : 0;
                    }
                    nArray[n] = n4 = (n6 << 8) + (n7 << 4) + n8;
                    ++n;
                }
                nArray2 = new int[n];
                System.arraycopy(nArray, 0, nArray2, 0, n);
                ++n3;
            }
            ++n2;
        }
        return nArray2;
    }

    public List getContainedPorts(List list) {
        int n = list == null ? 0 : list.size();
        ArrayList<NIFibreChannelPort> arrayList = new ArrayList<NIFibreChannelPort>();
        int n2 = 0;
        while (n2 < n) {
            NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)list.get(n2);
            if (this.contains(nIFibreChannelPort)) {
                arrayList.add(nIFibreChannelPort);
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean contains(NIIOPort nIIOPort) {
        int n = nIIOPort.getPortMaskBitIndex();
        int n2 = n / 8;
        int n3 = n % 8;
        return this.portMaskByteArray.bitIsSet(n2, n3);
    }

    public int size() {
        return this.numberOfBytes;
    }

    public String toString() {
        return NIByteArray.toHexString(this.portMaskBytes);
    }

    public byte[] toArray() {
        return this.portMaskByteArray.getByteArray();
    }

    public void clear() {
        Arrays.fill(this.portMaskBytes, (byte)0);
        this.portMaskByteArray.setByteArray(this.portMaskBytes);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

