/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIDDMPack;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIFibreChannelPort;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineESS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIAvailableLSS;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorArray;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExpressCommon;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExpressOpenSystemVolumes;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExpressZSeriesVolumes;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorOpenSystemVolumes;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorRank;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorStorageFacility;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorStorageFacilityImage;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorVolumeGroups;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorZSeriesLCUs;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorZSeriesVolumes;
import com.ibm.storage.ess.ni.ca.NIExpressArray;
import com.ibm.storage.ess.ni.ca.NIExtentPoolData;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIIOAdapter;
import com.ibm.storage.ess.ni.ca.NIImageHostAttachment;
import com.ibm.storage.ess.ni.ca.NIPortProfile;
import com.ibm.storage.ess.ni.ca.NIStorageFacilityImageClientData;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIHostConstants;
import com.ibm.storage.ess.ni.exception.NIConnectionCAException;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIArraySize;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicy;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySequential;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySpread;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySpreadWithLimit;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeType;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeBlocks;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeDS;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeDSESS;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeESS;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeISeriesProtected;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeISeriesUnprotected;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeZSeries;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisor {
    protected static final NIVolumeType ALIAS_TYPE = NIVolumeTypeCKDSingleCuAlias.Option;
    private static final String CLASS_NAME = "NIConfigurationAdvisor";
    protected static final String CANNOT_GET_SERVICE = "Operation cannot continue. Service not available";
    protected static final String CONNECTION_PROBLEM = "Cannot get the needed services";
    protected static final int DDM_146 = 1;
    protected static final int DDM_300 = 2;
    protected static final int DDM_73 = 0;
    protected static final int DDM_450 = 4;
    protected static final int DDM_500 = 3;
    protected static final String ESS = "ESS";
    protected static final String EXISTING_ARRAYS = "Existing Arrays";
    protected static final String EXISTING_RANKS = "Existing Ranks";
    protected static final String EXTENT_TYPE = "Extent Type";
    protected static final String FUTURE_ARRAYS = "Future Arrays";
    protected static final String FUTURE_RANKS = "Future Ranks";
    protected static final int HEX_0XFF = 256;
    protected static final int HEX_0XFFFF = 65535;
    protected static final String INCORRECT_ESS = "EssIDs don't match";
    protected static final String INVALID_ADDRESS_GROUP_NUMBER = " Address Group Number being used is invalid. Please check configuration";
    protected static final String INVALID_CKD_VOLUME_TYPE = "Invalid CKD Volume Type";
    protected static final String INVALID_DDM_CAPACITY = "Invalid DDM Capacity";
    protected static final String INVALID_DEVICE_TYPE = "Invalid Device Type";
    protected static final String INVALID_HOST_TYPE = "Invalid Host Type";
    protected static final String INVALID_SEGMENT_TYPE = "Invalid Extent Type";
    protected static final String INVALID_VOLUME_QUANTITY = "Invalid Volume Quantity. Only one volume is allowed for the nickname";
    protected static final String INVALID_VOLUME_TYPE = "Invalid Volume Type";
    protected static final String INVALID_VOLUMEGROUP_TYPE = "Invalid Volume Group Type";
    protected static final String INVALID_BASE_VOLUME_NUMBER = "Invalid Base Volume Number";
    protected static final String INVALID_STARTING_ADDRESS = "Invalid Starting Address";
    protected static final String INCORRECT_OWNER = "Object is not the owner. Unable to unattach.";
    protected static final String VOLUME_NNAME_NOT_UNIQUE = "Volume Nickname is not unique";
    protected static final String INVALID_SUFFIX = "Suffix is not numeric";
    protected static final String INVALID_PREFIX_SUFFIX_COMBINATION = "Both the prefix and suffix is either empty or null";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisor.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    protected static final int LSS_0XFF = 255;
    protected static final int MAP_INDEX = 256;
    protected static final int MASK_INDEX = 65536;
    protected static final String NULL_ID = "Null ID";
    protected static final String NULL_PARAMETER = "Null Parameter";
    protected static final String POOL_SIZE = "Pool Size";
    protected static final String QUERY_FAILURE = "Query Failure";
    protected static final String RAID_TYPE = "Raid Type";
    protected static final int SITE_33 = 0;
    protected static final int SITE_44 = 1;
    protected static final int SITE_6PS = 2;
    protected static final int SITE_7P = 3;
    protected static final int SITE_2PS = 4;
    protected static final int SITE_3P = 5;
    protected static final int SITE_22 = 6;
    protected static final int SITE_122S = 7;
    protected static final String SSID_NOT_IN_RANGE = "Invalid SSID";
    protected static final String STORAGE_LIMIT = "Storage Limit";
    private static final NIExtentType[] storageType = new NIExtentType[]{NIExtentTypeFB.Option, NIExtentTypeCKD.Option};
    private static final NICKDAddressPolicy[] addressPolicy = new NICKDAddressPolicy[]{NICKDAddressPolicySequential.Option, NICKDAddressPolicySpread.Option, NICKDAddressPolicySpreadWithLimit.Option};
    protected static final int UNASSIGNED_RANK_GROUP = -1;
    protected static final int UNDEFINED_ADDGRP_NUMBER = -1;
    protected static final int UNDEFINED_ARRAY_NUMBER = -1;
    protected static final int UNDEFINED_LSS_NUMBER = -1;
    protected static final int UNDEFINED_LSSGRP_NUMBER = -1;
    protected static final int UNDEFINED_RANK_NUM = -1;
    protected static final int UNDEFINED_SEGMENT_POOL_NUMBER = -1;
    protected static final int UNDEFINED_SEGMENT_TYPE = -1;
    protected static final int UNDEFINED_SSID = -1;
    protected static final int UNDEFINED_VALUE = -1;
    protected static final int UNDEFINED_VOL_TYPE = -1;
    protected static final int UNDEFINED_VOLUME_NUMBER = -1;
    protected static final int MAXIMUM_CAPACITY = -1;
    protected static final String USED_ARRAYSITES = "Arraysites Used";
    private NIDomainService domainService = null;
    private NIHostConfigurationService hostService = null;
    private NILogicalConfigurationService logicalService = null;
    private NIPhysicalConfigurationService physicalService = null;
    private NIServices services = null;
    protected static final boolean LOG_RETURN_VALUES = true;
    protected static final boolean LOG_RETURN_VALUES_DETAIL = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    public NIConfigurationAdvisor(NIServices nIServices) throws NIParameterInvalidCAException, NIConnectionCAException {
        this.services = nIServices;
        if (this.services == null) {
            throw new NIParameterInvalidCAException(this.services, NULL_PARAMETER);
        }
        this.domainService = this.services.getDomainService();
        this.physicalService = this.services.getPhysicalConfigurationService();
        this.logicalService = this.services.getLogicalConfigurationService();
        this.hostService = this.services.getHostConfigurationService();
        if (this.domainService == null || this.physicalService == null || this.logicalService == null || this.hostService == null) {
            throw new NIConnectionCAException(this.services, CONNECTION_PROBLEM);
        }
    }

    protected NIDomainService getDomainService() {
        return this.domainService;
    }

    protected NILogicalConfigurationService getLogicalService() {
        return this.logicalService;
    }

    protected NIPhysicalConfigurationService getPhysicalService() {
        return this.physicalService;
    }

    protected NIHostConfigurationService getHostService() {
        return this.hostService;
    }

    protected NIServices getServices() {
        return this.services;
    }

    protected boolean checkAllLSS(NIESSID nIESSID, NILSS[] nILSSArray) {
        Serializable serializable;
        boolean bl = true;
        int n = 0;
        while (n < nILSSArray.length) {
            serializable = nILSSArray[n];
            if (!((NILSSID)serializable.getID()).getESS().equals(nIESSID)) {
                bl = false;
                break;
            }
            ++n;
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("checkAllLSS(NIExtentPool, NILSS[]) return value: " + bl);
        logger.debug_general(((StringBuffer)serializable).toString());
        return bl;
    }

    public List getAs400VolumeSizeList(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAs400VolumeSizeList(NIExtentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorOpenSystemVolumes.getAs400VolumeSizeList(nIExtentPool);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAs400VolumeSizeList(NIExtentPool) return values:");
        int n2 = 0;
        while (n2 < n) {
            NIAs400VolumeSize nIAs400VolumeSize = (NIAs400VolumeSize)list.get(n2);
            double d = nIAs400VolumeSize.getStorageBinaryGB();
            stringBuffer.append(" " + d);
            ++n2;
        }
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAs400VolumeSizeList(NIExtentPool)");
        return list;
    }

    public int getAvailableAddresses(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableAddresses(NILSS[], NIExtentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorZSeriesVolumes.getAvailableAddresses(nILSSArray, nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getAvailableAddresses(NILSS[], NIExtentPool) return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableAddresses(NILSS[], NIExtentPool)");
        return n;
    }

    public List getAvailableArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailableArraySites(NIESSID, NIArraySite[], NIRaidType)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
    }

    public List getAvailableArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableArraySites(NIESS, NIArraySite[], NIRaidType)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableArraySites() return value: " + n + " sites");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableArraySites(NIESSID, NIArraySite[], NIRaidType)");
        return list;
    }

    public List getAvailableArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailableArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
    }

    public List getAvailableArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableArraySites(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableArraySites() return value: " + n + " sites");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType)");
        return list;
    }

    public List getImageHostAttachments(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getImageHostAttachments()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        List list = nIConfigurationAdvisorVolumeGroups.getImageHostAttachments(nIESSID);
        logger.exit(CLASS_NAME, "getImageHostAttachments()");
        return list;
    }

    public List getAvailableHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroupType nIVolumeGroupType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getAvailableHostAttachments(NIImageHostAttachment[], NIVolumeGroupType");
        if (nIImageHostAttachmentArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIImageHostAttachment is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIImageHostAttachmentArray, NULL_PARAMETER);
        }
        if (nIVolumeGroupType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroupType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        List list = nIConfigurationAdvisorVolumeGroups.getAvailableHostAttachments(nIImageHostAttachmentArray, nIVolumeGroupType);
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableHostAttachments() return value: " + n + " attachments");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableHostAttachments(NIImageHostAttachment[], NIVolumeGroupType");
        return list;
    }

    public int getNumberOfHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroup[] nIVolumeGroupArray) throws NIParameterInvalidCAException {
        if (nIImageHostAttachmentArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIImageHostAttachment[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIImageHostAttachmentArray, NULL_PARAMETER);
        }
        if (nIVolumeGroupArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroup[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        int n = nIConfigurationAdvisorVolumeGroups.getNumberOfHostAttachments(nIImageHostAttachmentArray, nIVolumeGroupArray);
        return n;
    }

    public int getNumberOfHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIFibreChannelPort nIFibreChannelPort) throws NIParameterInvalidCAException {
        Serializable serializable;
        logger.enter(CLASS_NAME, "getNumberOfHostAttachments(NIImageHostAttachment[], NIFibreChannelPort)");
        if (nIImageHostAttachmentArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIImageHostAttachment[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIImageHostAttachmentArray, NULL_PARAMETER);
        }
        if (nIFibreChannelPort == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFibreChannelPort is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFibreChannelPort, NULL_PARAMETER);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < nIImageHostAttachmentArray.length) {
            NISCSIHostPort nISCSIHostPort;
            serializable = nIImageHostAttachmentArray[n2].getSCSIHostPorts();
            if (((Vector)serializable).size() > 0 && (nISCSIHostPort = (NISCSIHostPort)((Vector)serializable).get(0)).getPortMask().contains(nIFibreChannelPort)) {
                ++n;
            }
            ++n2;
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("getNumberOfHostAttachments(NIImageHostAttachment[], NIFibreChannelPort) return value: " + n);
        logger.debug_general(((StringBuffer)serializable).toString());
        logger.exit(CLASS_NAME, "getNumberOfHostAttachments(NIImageHostAttachment[], NIFibreChannelPort)");
        return n;
    }

    public List getHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroupID nIVolumeGroupID) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getHostAttachments(NIImageHostAttachment[], NIVolumeGroupID)");
        if (nIImageHostAttachmentArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIImageHostAttachment[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIImageHostAttachmentArray, NULL_PARAMETER);
        }
        if (nIVolumeGroupID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroupID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        List list = nIConfigurationAdvisorVolumeGroups.getHostAttachments(nIImageHostAttachmentArray, nIVolumeGroupID);
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getHostAttachments(NIImageHostAttachment[], NIVolumeGroupID) return value: " + n + " attachments");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getHostAttachments(NIImageHostAttachment[], NIVolumeGroupID)");
        return list;
    }

    public List getHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroupID[] nIVolumeGroupIDArray) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getHostAttachments(NIImageHostAttachment[], NIVolumeGroupID[])");
        if (nIImageHostAttachmentArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIImageHostAttachment[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIImageHostAttachmentArray, NULL_PARAMETER);
        }
        if (nIVolumeGroupIDArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroupID[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupIDArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        List list = nIConfigurationAdvisorVolumeGroups.getHostAttachments(nIImageHostAttachmentArray, nIVolumeGroupIDArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getHostAttachments(NIImageHostAttachment[], NIVolumeGroupID[]) return value: " + n + " attachments");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getHostAttachments(NIImageHostAttachment[], NIVolumeGroupID[])");
        return list;
    }

    public int[] getAvailableLCUIDs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableLCUIDs(NIESSID)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesLCUs nIConfigurationAdvisorZSeriesLCUs = new NIConfigurationAdvisorZSeriesLCUs(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorZSeriesLCUs.getAvailableLCUIDs(nIESSID);
        stringBuffer = new StringBuffer();
        int n = nArray.length;
        stringBuffer.append("getAvailableLCUIDs() return values:");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" " + nArray[n2]);
            ++n2;
        }
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableLCUIDs(NIESSID)");
        return nArray;
    }

    public List getAvailableLcusForVolumes(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableLcusForVolumes(NILSS[], NIExtentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getAvailableLcusForVolumes(nILSSArray, nIExtentPool);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableLcusForVolumes() return values:");
        int n2 = 0;
        while (n2 < n) {
            NILSS nILSS = (NILSS)list.get(n2);
            NILSSID nILSSID = (NILSSID)nILSS.getID();
            int n3 = nILSSID.getLSSNumber();
            stringBuffer.append(" " + n3);
            ++n2;
        }
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableLcusForVolumes(NILSS[], NIExtentPool)");
        return list;
    }

    public List getAvailableLSSs(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableLSSs(NILSS[], NIExtentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not of type NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorOpenSystemVolumes.getAvailableLSSs(nILSSArray, nIExtentPool);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableLSSs() return values:");
        int n2 = 0;
        while (n2 < n) {
            NIAvailableLSS nIAvailableLSS = (NIAvailableLSS)list.get(n2);
            int n3 = nIAvailableLSS.getLssAddress();
            stringBuffer.append(" " + n3);
            ++n2;
        }
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableLSSs(NILSS[], NIExtentPool)");
        return list;
    }

    public List getAvailablePrimaryArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIRaidType)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailablePrimaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
    }

    public List getAvailablePrimaryArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIRaidType)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getAvailablePrimaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIRaidType) return value: " + n + " sites");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIRaidType)");
        return list;
    }

    public List getAvailablePrimaryArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailablePrimaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
    }

    public List getAvailablePrimaryArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getAvailablePrimaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType) return value: " + n + " sites");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailablePrimaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType)");
        return list;
    }

    public double getAvailableRawStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableRawStorageGB(NIExtentPool extentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getAvailableRawStorageGB(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getAvailableRawStorageGB(NIExtentPool extentPool) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableRawStorageGB(NIExtentPool extentPool)");
        return d;
    }

    public List getAvailableSecondaryArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIRaidType, NIArraySite)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailableSecondaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
    }

    public List getAvailableSecondaryArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIRaidType, NIArraySite)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getAvailableSecondaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIRaidType, NIArraySite) return value: " + n + " sites");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIRaidType, NIArraySite)");
        return list;
    }

    public List getAvailableSecondaryArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailableSecondaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
    }

    public List getAvailableSecondaryArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getAvailableSecondaryArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite) return value: " + n + " sites");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableSecondaryArraySites(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite)");
        return list;
    }

    public long getAvailableStorageCylinder(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableStorageCylinder()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        long l = nIConfigurationAdvisorExtentPool.getAvailableStorageCylinder(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getAvailableStorageCylinder(NIExtentPool extentPool) return value: " + l);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableStorageCylinder()");
        return l;
    }

    public double getAvailableStorageGB(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableStorageGB(NIESSID ess)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorStorageFacilityImage.getAvailableStorageGB(nIESSID);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getAvailableStorageGB(NIESSID ess) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableStorageGB(NIESSID ess)");
        return d;
    }

    public double getAvailableStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableStorageGB(NIExtentPool extentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getAvailableStorageGB(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getAvailableStorageGB(NIExtentPool extentPool) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableStorageGB(NIExtentPool extentPool)");
        return d;
    }

    public double getAvailableStorageGBForFutureExtentPool(NIESSID nIESSID, NIExtentType nIExtentType, NIRaidType nIRaidType, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getAvailableStorageGBForFutureExtentPool()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" useExisting: " + bl);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getAvailableStorageGBForFutureExtentPool(nIESS, nIExtentType, nIRaidType, bl);
    }

    public double getAvailableStorageGBForFutureExtentPool(NIESS nIESS, NIExtentType nIExtentType, NIRaidType nIRaidType, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAvailableStorageGBForFutureExtentPool()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" useExisting: " + bl);
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getAvailableStorageGBForFutureExtentPool(nIESS, nIExtentType, nIRaidType, bl);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getAvailableStorageGBForFutureExtentPool() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getAvailableStorageGBForFutureExtentPool()");
        return d;
    }

    public NICKDVolumeType getCKDVolumeType(NIVolume nIVolume) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getCKDVolumeType()");
        if (nIVolume == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolume, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeID: " + ((NIVolumeID)nIVolume.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        NICKDVolumeType nICKDVolumeType = nIConfigurationAdvisorZSeriesVolumes.getCKDVolumeType(nIVolume);
        logger.exit(CLASS_NAME, "getCKDVolumeType()");
        return nICKDVolumeType;
    }

    public List getCkdVolumeTypeList() {
        logger.enter(CLASS_NAME, "getCkdVolumeTypeList()");
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        List list = nIConfigurationAdvisorZSeriesVolumes.getCkdVolumeTypeList();
        logger.exit(CLASS_NAME, "getCkdVolumeTypeList()");
        return list;
    }

    public List getExpressCkdVolumeTypeList() {
        logger.enter(CLASS_NAME, "getExpressCkdVolumeTypeList()");
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        List list = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressCkdVolumeTypeList();
        logger.exit(CLASS_NAME, "getExpressCkdVolumeTypeList()");
        return list;
    }

    public List getCompatibleCKDVolumeType(NIVolume nIVolume) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getCompatibleCKDVolumeType()");
        if (nIVolume == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolume, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeID: " + ((NIVolumeID)nIVolume.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getCompatibleCKDVolumeType(nIVolume);
        logger.exit(CLASS_NAME, "getCompatibleCKDVolumeType()");
        return list;
    }

    public List getCompatibleHostTypes(NIVolumeGroupType nIVolumeGroupType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getCompatibleHostTypes()");
        if (nIVolumeGroupType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroupType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeGroupType: " + nIVolumeGroupType.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorVolumeGroups.getCompatibleHostTypes(nIVolumeGroupType);
        logger.exit(CLASS_NAME, "getCompatibleHostTypes()");
        return list;
    }

    public List getExistingRanksForExtentPool(NIESS nIESS, NIExtentPoolID nIExtentPoolID, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExistingRanksForExtentPool()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIArray[] nIArrayArray = this.getImageArrays((NIESSID)nIESS.getID());
        NIRank[] nIRankArray = this.getImageRanks((NIESSID)nIESS.getID());
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        long l = this.convertBinaryGBToExtents(n, nIExtentType);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolSizeGB: " + n);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorExtentPool.getExistingRanksForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, l, nIArrayArray, nIRankArray, bl);
        stringBuffer = new StringBuffer();
        int n2 = list.size();
        stringBuffer.append("getExistingRanksForExtentPool() return value: " + n2 + " ranks");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExistingRanksForExtentPool()");
        return list;
    }

    public List getExpressAs400VolumeSizeList(NIExtentPoolData[] nIExtentPoolDataArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressAs400VolumeSizeList()");
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        List list = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressAs400VolumeSizeList(nIExtentPoolDataArray);
        logger.exit(CLASS_NAME, "getExpressAs400VolumeSizeList()");
        return list;
    }

    public int getExpressCKDAvailableAddresses(NIExtentPoolData[] nIExtentPoolDataArray, NILSS[] nILSSArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressAvailableAddresses()");
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        int n = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressCKDAvailableAddresses(nIExtentPoolDataArray, nILSSArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressAvailableAddresses() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressAvailableAddresses()");
        return n;
    }

    public List getExpressAvailableLCUs(NIExtentPoolData[] nIExtentPoolDataArray, NILSS[] nILSSArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressAvailableLCUs()");
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        List list = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressAvailableLCUs(nIExtentPoolDataArray, nILSSArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getExpressAvailableLCUIDs() return values:");
        int n2 = 0;
        while (n2 < n) {
            NIAvailableLSS nIAvailableLSS = (NIAvailableLSS)list.get(n2);
            stringBuffer.append(" " + nIAvailableLSS.getLssAddress());
            ++n2;
        }
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressAvailableLCUs()");
        return list;
    }

    public List getExpressExtentPools(NIESSID nIESSID, NIRaidType nIRaidType, NIExtentType nIExtentType, double d) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getExpressExtentPools()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" TotalAvailableGB: " + d);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this);
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getExpressExtentPools(nIESS, nIRaidType, nIExtentType, d);
    }

    public List getExpressExtentPools(NIESS nIESS, NIRaidType nIRaidType, NIExtentType nIExtentType, double d) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressExtentPools()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" TotalAvailableGB: " + d);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this);
        List list = nIConfigurationAdvisorExpressCommon.getExpressExtentPools(nIESS, nIRaidType, nIExtentType, d);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getExpressExtentPools() return value: " + n + " pools");
        logger.debug_general(stringBuffer.toString());
        int n2 = 0;
        while (n2 < n) {
            NIExtentPoolData nIExtentPoolData = (NIExtentPoolData)list.get(n2);
            stringBuffer = new StringBuffer();
            stringBuffer.append(" pool[" + n2 + "]: " + nIExtentPoolData.toString());
            logger.debug_general(stringBuffer.toString());
            ++n2;
        }
        logger.exit(CLASS_NAME, "getExpressExtentPools()");
        return list;
    }

    public List getExpressFutureCkdVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, NIAvailableLSS[] nIAvailableLSSArray, int n, int n2, NICKDAddressPolicy nICKDAddressPolicy, int n3, int n4, boolean bl, String string, String string2, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressFutureCkdVolumes()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n5 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        stringBuffer.append(" BaseVolQuantity: " + n);
        stringBuffer.append(" AliasPerBase: " + n2);
        stringBuffer.append(" AddressingPolicyMode: " + nICKDAddressPolicy);
        stringBuffer.append(" StartingLCU: " + n3);
        stringBuffer.append(" NumberLCUs: " + n4);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        stringBuffer.append(" VerifyUniqueNicknames: " + bl2);
        logger.debug_general(stringBuffer.toString());
        return this.getExpressFutureCkdVolumes(nIESSID, nICKDVolumeType, nIExtentPoolDataArray, nIAvailableLSSArray, n, n2, nICKDAddressPolicy, n3, n4, bl, string, string2, bl2, true);
    }

    public List getExpressFutureCkdVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, NIAvailableLSS[] nIAvailableLSSArray, int n, int n2, NICKDAddressPolicy nICKDAddressPolicy, int n3, int n4, boolean bl, String string, String string2, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressFutureCkdVolumes()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n5 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        stringBuffer.append(" BaseVolQuantity: " + n);
        stringBuffer.append(" AliasPerBase: " + n2);
        stringBuffer.append(" AddressingPolicyMode: " + nICKDAddressPolicy);
        stringBuffer.append(" StartingLCU: " + n3);
        stringBuffer.append(" NumberLCUs: " + n4);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        stringBuffer.append(" VerifyUniqueNicknames: " + bl2);
        stringBuffer.append(" DecimalFormat: " + bl3);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        List list = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressFutureCkdVolumes(nIESSID, nICKDVolumeType, nIExtentPoolDataArray, nIAvailableLSSArray, n, n2, nICKDAddressPolicy, n3, n4, bl, string, string2, bl2, bl3);
        stringBuffer = new StringBuffer();
        int n6 = list.size();
        stringBuffer.append("getExpressFutureCkdVolumes() return value: " + n6 + " volumes");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressFutureCkdVolumes()");
        return list;
    }

    public NIExtentPool getExpressFutureExtentPool(NIESSID nIESSID, NIExtentPoolData nIExtentPoolData) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException, NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getExpressFutureExtentPool()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentPoolData == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolData, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this);
        NIExtentPool nIExtentPool = nIConfigurationAdvisorExpressCommon.getExpressFutureExtentPool(nIESSID, nIExtentPoolData);
        logger.exit(CLASS_NAME, "getExpressFutureExtentPool()");
        return nIExtentPool;
    }

    public List getExpressFutureLcus(NIESSID nIESSID, NIVolume[] nIVolumeArray, NIAvailableLSS[] nIAvailableLSSArray, int n, int n2, NICKDBaseCUType nICKDBaseCUType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressFutureLcus()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIVolumeArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeArray, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" StartingLCU: " + n);
        stringBuffer.append(" StartSSID: " + n2);
        if (nICKDBaseCUType != null) {
            stringBuffer.append(" CKDBaseCUType: " + nICKDBaseCUType.toString());
        }
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        List list = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressFutureLcus(nIESSID, nIVolumeArray, nIAvailableLSSArray, n, n2, nICKDBaseCUType);
        stringBuffer = new StringBuffer();
        int n3 = list.size();
        stringBuffer.append("getExpressAvailableLCUIDs() return values:");
        int n4 = 0;
        while (n4 < n3) {
            NILSS nILSS = (NILSS)list.get(n4);
            NILSSID nILSSID = (NILSSID)nILSS.getID();
            stringBuffer.append(" " + nILSSID.getLSSNumber());
            ++n4;
        }
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressFutureLcus()");
        return list;
    }

    public NIVolumeGroup getExpressFutureVolumeGroup(NIESSID nIESSID, String string, NIHostType nIHostType, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getExpressFutureVolumeGroup()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIVolumeArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeArray, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        NIVolumeGroup nIVolumeGroup = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressFutureVolumeGroup(nIESSID, string, nIHostType, nIVolumeArray);
        logger.exit(CLASS_NAME, "getExpressFutureVolumeGroup()");
        return nIVolumeGroup;
    }

    public List getExpressFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSize: " + l);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        stringBuffer.append(" VerifyUniqueNicknames: " + bl2);
        logger.debug_general(stringBuffer.toString());
        return this.getExpressFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolDataArray, n, l, nIAs400VolumeSize, bl, string, string2, bl2, true);
    }

    public List getExpressFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n2 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSize: " + l);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        stringBuffer.append(" VerifyUniqueNicknames: " + bl2);
        stringBuffer.append(" DecimalFormat: " + bl3);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        List list = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolDataArray, n, l, nIAs400VolumeSize, bl, string, string2, bl2, bl3);
        stringBuffer = new StringBuffer();
        int n3 = list.size();
        stringBuffer.append("getExpressFutureVolumes() return value: " + n3 + " volumes");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressFutureVolumes()");
        return list;
    }

    public List getExpressFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, int n, int n2, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (bl) {
            if (string2 == null || string2.equals("")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
            }
            try {
                int n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSize: " + n2);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        stringBuffer.append(" VerifyUniqueNicknames: " + bl2);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        long l = this.convertGBToBlocks(n2, true);
        return this.getExpressFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolDataArray, n, l, nIAs400VolumeSize, bl, string, string2, bl2);
    }

    public int getExpressMaxAs400VolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, NIAs400VolumeSize nIAs400VolumeSize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressMaxAs400VolumeQuantity()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (nIAs400VolumeSize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIAs400VolumeSize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIAs400VolumeSize, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TotalRequestedCapacityGB: " + d);
        stringBuffer.append(" As400VolumeSize: " + nIAs400VolumeSize);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        int n = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressMaxAs400VolumeQuantity(nIExtentPoolDataArray, d, nIAs400VolumeSize);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressMaxAs400VolumeQuantity() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressMaxAs400VolumeQuantity()");
        return n;
    }

    public int getExpressMaxVolumeSize(NIExtentPoolData[] nIExtentPoolDataArray, double d, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressMaxVolumeSize()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TotalRequestedCapacityGB: " + d);
        stringBuffer.append(" VolQuantity: " + n);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        long l = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressMaxVolumeCapacity(nIExtentPoolDataArray, d, n);
        int n2 = this.convertBlocksToGB(l, true);
        if (n2 > 2048) {
            n2 = 2048;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressMaxVolumeSize() return value: " + n2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressMaxVolumeSize()");
        return n2;
    }

    public long getExpressMaxVolumeCapacity(NIExtentPoolData[] nIExtentPoolDataArray, double d, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressMaxVolumeCapacity()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TotalRequestedCapacityGB: " + d);
        stringBuffer.append(" VolQuantity: " + n);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        long l = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressMaxVolumeCapacity(nIExtentPoolDataArray, d, n);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressMaxVolumeCapacity() return value: " + l);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressMaxVolumeCapacity()");
        return l;
    }

    public int getExpressTotalStorageGB(NIExtentPoolData[] nIExtentPoolDataArray, int n, NIAs400VolumeSize nIAs400VolumeSize) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getExpressTotalStorageGB()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (nIAs400VolumeSize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIAs400VolumeSize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIAs400VolumeSize, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" As400VolumeSize: " + nIAs400VolumeSize);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        int n2 = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressTotalStorageGB(nIExtentPoolDataArray, n, nIAs400VolumeSize);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressTotalStorageGB() return value: " + n2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressTotalStorageGB()");
        return n2;
    }

    public int getExpressMaxCkdVolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, NIAvailableLSS[] nIAvailableLSSArray, NICKDVolumeType nICKDVolumeType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressMaxCkdVolumeQuantity()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TotalRequestedCapacityGB: " + d);
        stringBuffer.append(" NICKDVolumeType: " + nICKDVolumeType);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        int n = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressMaxCkdVolumeQuantity(nIExtentPoolDataArray, d, nIAvailableLSSArray, nICKDVolumeType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressMaxCkdVolumeQuantity() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressMaxCkdVolumeQuantity()");
        return n;
    }

    public int getExpressMaxVolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressMaxVolumeQuantity()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TotalRequestedCapacityGB: " + d);
        stringBuffer.append(" VolumeSize: " + l);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        int n = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressMaxVolumeQuantity(nIExtentPoolDataArray, d, l);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressMaxVolumeQuantity() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressMaxVolumeQuantity()");
        return n;
    }

    public int getExpressMaxVolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressMaxVolumeQuantity()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TotalRequestedCapacityGB: " + d);
        stringBuffer.append(" VolumeSize: " + n);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        long l = this.convertGBToBlocks(n, true);
        return this.getExpressMaxVolumeQuantity(nIExtentPoolDataArray, d, l);
    }

    public int getExpressTotalStorageGB(NIExtentPoolData[] nIExtentPoolDataArray, int n, NICKDVolumeType nICKDVolumeType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getExpressTotalStorageGB()");
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null or empty.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" CKDVolType: " + nICKDVolumeType.toString());
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        int n2 = NIConfigurationAdvisorExpressZSeriesVolumes.getExpressTotalStorageGB(nIExtentPoolDataArray, n, nICKDVolumeType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressTotalStorageGB() return value: " + n2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressTotalStorageGB()");
        return n2;
    }

    public double getExpressTotalAvailableCapacityGB(NIESSID nIESSID, NIRaidType nIRaidType, NIExtentType nIExtentType) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException, NIServerException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getExpressTotalAvailableCapacityGB");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this);
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getExpressTotalAvailableCapacityGB(nIESS, nIRaidType, nIExtentType);
    }

    public double getExpressTotalAvailableCapacityGB(NIESS nIESS, NIRaidType nIRaidType, NIExtentType nIExtentType) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException, NIServerException {
        logger.enter(CLASS_NAME, "getExpressTotalAvailableCapacityGB");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this);
        double d = nIConfigurationAdvisorExpressCommon.getExpressTotalAvailableCapacityGB(nIESS, nIRaidType, nIExtentType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressTotalAvailableCapacityGB() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressTotalAvailableCapacityGB");
        return d;
    }

    public int getExpressTotalStorageGB(NIExtentPoolData[] nIExtentPoolDataArray, int n, int n2) throws NIParameterInvalidCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressTotalStorageGB()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSize: " + n2);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        int n3 = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressTotalStorageGB(nIExtentPoolDataArray, n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getExpressTotalStorageGB() return value: " + n3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressTotalStorageGB()");
        return n3;
    }

    public List getExpressUpdatedExtentPools(NIExtentPoolData[] nIExtentPoolDataArray, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressUpdatedExtentPools(NIExtentPoolData[], NIVolume[])");
        NIConfigurationAdvisorExpressOpenSystemVolumes nIConfigurationAdvisorExpressOpenSystemVolumes = new NIConfigurationAdvisorExpressOpenSystemVolumes(this);
        List list = nIConfigurationAdvisorExpressOpenSystemVolumes.getExpressUpdatedExtentPools(nIExtentPoolDataArray, nIVolumeArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getExpressUpdatedExtentPools(NIExtentPoolData[], NIVolume[]) return value: " + n + " pools");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressUpdatedExtentPools(NIExtentPoolData[], NIVolume[])");
        return list;
    }

    public List getExpressUpdatedExtentPools(NIExtentPoolData[] nIExtentPoolDataArray, NIAvailableLSS[] nIAvailableLSSArray, int n, NICKDVolumeType nICKDVolumeType) throws NIParameterInvalidCAException {
        if (nIExtentPoolDataArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolDataArray, NULL_PARAMETER);
        }
        logger.enter(CLASS_NAME, "getExpressUpdatedExtentPools(NIExtentPoolData[], NIAvailableLSS[], int volQuantity, NICKDVolType)");
        NIConfigurationAdvisorExpressZSeriesVolumes nIConfigurationAdvisorExpressZSeriesVolumes = new NIConfigurationAdvisorExpressZSeriesVolumes(this);
        List list = nIConfigurationAdvisorExpressZSeriesVolumes.getExpressUpdatedExtentPools(nIExtentPoolDataArray, nIAvailableLSSArray, n, nICKDVolumeType);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = list.size();
        stringBuffer.append("getExpressUpdatedExtentPools(NIExtentPoolData[], NIAvailableLSS[], int volQuantity, NICKDVolType) return value: " + n2 + " pools");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getExpressUpdatedExtentPools(NIExtentPoolData[], NIAvailableLSS[], int volQuantity, NICKDVolType)");
        return list;
    }

    public List getExpressUpdatedVolumes(NIVolume[] nIVolumeArray, NIExtentPoolData nIExtentPoolData, NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExpressUpdatedExtentVolumes()");
        if (nIVolumeArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeArray, NULL_PARAMETER);
        }
        if (nIExtentPoolData == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolData is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolData, NULL_PARAMETER);
        }
        if (nIExtentPoolID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nIExtentPoolID + "NIExtentPoolID null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolID, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + nIExtentPoolID.toString());
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this);
        List list = nIConfigurationAdvisorExpressCommon.getExpressUpdatedVolumes(nIVolumeArray, nIExtentPoolData, nIExtentPoolID);
        logger.exit(CLASS_NAME, "getExpressUpdatedExtentVolumes()");
        return list;
    }

    public int getMaxAliasPerBase(NIAvailableLSS[] nIAvailableLSSArray, int n, int n2) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getMaxAliasPerBase()");
        if (nIAvailableLSSArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIAvailableLSS[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIAvailableLSSArray, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" BaseVolQuantity: " + n);
        stringBuffer.append(" NumberLCUsToCreate: " + n2);
        logger.debug_general(stringBuffer.toString());
        int n3 = NIConfigurationAdvisorExpressZSeriesVolumes.getMaxAliasesPerBase(nIAvailableLSSArray, n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAliasPerBase() return value: " + n3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAliasPerBase()");
        return n3;
    }

    public NIFBVolumeType getFBVolumeType(NIVolume nIVolume) throws NIParameterInvalidCAException {
        if (nIVolume == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolume, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        NIFBVolumeType nIFBVolumeType = nIConfigurationAdvisorOpenSystemVolumes.getFBVolumeType(nIVolume);
        return nIFBVolumeType;
    }

    public List getFBVolumeTypeList() {
        logger.enter(CLASS_NAME, "getFBVolumeTypeList()");
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        List list = nIConfigurationAdvisorOpenSystemVolumes.getFBVolumeTypeList();
        logger.exit(CLASS_NAME, "getFBVolumeTypeList()");
        return list;
    }

    public List getFutureArray(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIRaidType, int, int, int)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2, n3);
    }

    public List getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIRaidType, int, int, int)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2, n3);
        stringBuffer = new StringBuffer();
        int n4 = list.size();
        stringBuffer.append("getFutureArray(NIESS, NIArraySite[], NIRaidType, int, int, int) return value: " + n4 + " arrays");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIRaidType, int, int, int)");
        return list;
    }

    public List getFutureArray(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, int, int, int)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2, n3);
    }

    public List getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, int, int, int)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2, n3);
        stringBuffer = new StringBuffer();
        int n4 = list.size();
        stringBuffer.append("getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, int, int, int) return value: " + n4 + " arrays");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, int, int, int)");
        return list;
    }

    public List getFutureArray(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIRaidType, NIArraySize, int, int, int)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2, n3);
    }

    public List getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIRaidType, NIArraySize, int, int, int)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2, n3);
        stringBuffer = new StringBuffer();
        int n4 = list.size();
        stringBuffer.append("getFutureArray(NIESSID, NIArraySite[], NIRaidType, NIArraySize, int, int, int) return value: " + n4 + " arrays");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIRaidType, NIArraySize, int, int, int)");
        return list;
    }

    public List getFutureArray(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySize, int, int, int)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2, n3);
    }

    public List getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySize, int, int, int)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" DDMCapacity: " + n2);
        stringBuffer.append(" DDMRPM: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2, n3);
        stringBuffer = new StringBuffer();
        int n4 = list.size();
        stringBuffer.append("getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySize, int, int, int) return value: " + n4 + " arrays");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySize, int, int, int)");
        return list;
    }

    public NIArray getFutureArray(NIESSID nIESSID, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIRaidType, NIArraySite)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIArraySite[] nIArraySiteArray = this.getImageArraySites(nIESSID);
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
    }

    public NIArray getFutureArray(NIESS nIESS, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIRaidType, NIArraySite)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIArraySite[] nIArraySiteArray = this.getImageArraySites((NIESSID)nIESS.getID());
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        NIArray nIArray = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureArray(NIESS, NIRaidType, NIArraySite) return value: ");
        stringBuffer.append(nIArray == null ? "null" : nIArray.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIRaidType, NIArraySite)");
        return nIArray;
    }

    public NIArray getFutureArray(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
    }

    public NIArray getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySiteID: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        NIArray nIArray = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureArray(NIESS, NIRaidType, NIArraySite) return value: ");
        stringBuffer.append(nIArray == null ? "null" : nIArray.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIRaidType, NIArraySite)");
        return nIArray;
    }

    public NIArray getFutureArray(NIESSID nIESSID, NIRaidType nIRaidType, NIArraySite nIArraySite, NIArraySite nIArraySite2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIRaidType, NIArraySite primarySite, NIArraySite secondarySite)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIArraySite2 != null && nIArraySite2.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Secondary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite2, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIArraySite[] nIArraySiteArray = this.getImageArraySites(nIESSID);
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySite: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        stringBuffer.append(" SecondarySite: " + ((NIArraySiteID)nIArraySite2.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite, nIArraySite2);
    }

    public NIArray getFutureArray(NIESS nIESS, NIRaidType nIRaidType, NIArraySite nIArraySite, NIArraySite nIArraySite2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIRaidType, NIArraySite primarySite, NIArraySite secondarySite)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIArraySite2 != null && nIArraySite2.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Secondary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite2, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIArraySite[] nIArraySiteArray = this.getImageArraySites((NIESSID)nIESS.getID());
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySite: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        stringBuffer.append(" SecondarySite: " + ((NIArraySiteID)nIArraySite2.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        NIArray nIArray = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite, nIArraySite2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureArray(NIESS, NIRaidType, NIArraySite primarySite, NIArraySite secondarySite) return value: ");
        stringBuffer.append(nIArray == null ? "null" : nIArray.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIRaidType, NIArraySite primarySite, NIArraySite secondarySite)");
        return nIArray;
    }

    public NIArray getFutureArray(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite, NIArraySite nIArraySite2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getFutureArray(NIESSID, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite primarySite, NIArraySite secondarySite)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIArraySite2 != null && nIArraySite2.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Secondary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite2, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySite: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        stringBuffer.append(" SecondarySite: " + ((NIArraySiteID)nIArraySite2.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite, nIArraySite2);
    }

    public NIArray getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite, NIArraySite nIArraySite2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite primarySite, NIArraySite secondarySite)");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySite == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_PARAMETER);
        }
        if (nIArraySite.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Primary ArraySite ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite, NULL_ID);
        }
        if (nIArraySite2 != null && nIArraySite2.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Secondary ArraySite is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySite2, NULL_ID);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" PrimarySite: " + ((NIArraySiteID)nIArraySite.getID()).toString());
        stringBuffer.append(" SecondarySite: " + ((NIArraySiteID)nIArraySite2.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        NIArray nIArray = nIConfigurationAdvisorArray.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite, nIArraySite2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite primarySite, NIArraySite secondarySite) return value: ");
        stringBuffer.append(nIArray == null ? "null" : nIArray.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArray(NIESS, NIArraySite[], NIStorageDeviceFRU[], NIRaidType, NIArraySite primarySite, NIArraySite secondarySite)");
        return nIArray;
    }

    public List getFutureArraysForExtentPool(NIESSID nIESSID, NIExtentPoolID nIExtentPoolID, NIExtentType nIExtentType, NIRaidType nIRaidType, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        boolean bl = false;
        boolean bl2 = false;
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureArraysForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, bl2, n, bl);
    }

    public List getFutureArraysForExtentPool(NIESS nIESS, NIExtentPoolID nIExtentPoolID, NIExtentType nIExtentType, NIRaidType nIRaidType, boolean bl, int n, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        long l = this.convertBinaryGBToExtents(n, nIExtentType);
        return this.getFutureArraysForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, bl, n, l, bl2, false);
    }

    protected List getFutureArraysForExtentPool(NIESS nIESS, NIExtentPoolID nIExtentPoolID, NIExtentType nIExtentType, NIRaidType nIRaidType, boolean bl, int n, long l, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureArraysForExtentPool()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIExtentPoolID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolID, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" ExtentPoolID: " + nIExtentPoolID.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" RequestedCapacityRequired: " + bl);
        stringBuffer.append(" NeededStorageGB: " + n);
        stringBuffer.append(" Needed Extents: " + l);
        stringBuffer.append(" UseExisting: " + bl2);
        stringBuffer.append(" ExpressConfig: " + bl3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorExtentPool.getFutureArraysForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, bl, l, bl2, bl3);
        stringBuffer = new StringBuffer();
        int n2 = list.size();
        stringBuffer.append("getFutureArraysForExtentPool() return value: " + n2 + " arrays");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureArraysForExtentPool()");
        return list;
    }

    public List getFutureCkdAliasVolumes(NIESSID nIESSID, NILSS nILSS, int[] nArray, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdAliasVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nILSS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, NULL_PARAMETER);
        }
        if (!(nILSS.getDeviceType() instanceof NIDeviceTypeCKD)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS not instance of NIDeviceTypeCKD.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, INVALID_DEVICE_TYPE);
        }
        if (n3 <= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("iBases is <= 0.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(INVALID_BASE_VOLUME_NUMBER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" LSSID: " + ((NILSSID)nILSS.getID()).toString());
        stringBuffer.append(" AliasStartAddr: " + n);
        stringBuffer.append(" Ascending: " + bl);
        stringBuffer.append(" Pavs: " + n2);
        stringBuffer.append(" iBases: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getFutureCkdAliasVolumes(nIESSID, nILSS, nArray, null, n, bl, n2, n3);
        logger.exit(CLASS_NAME, "getFutureCkdAliasVolumes()");
        return list;
    }

    public List getFutureCkdAliasVolumes(NIESSID nIESSID, NILSS nILSS, int[] nArray, NIVolume[] nIVolumeArray, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdAliasVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nILSS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, NULL_PARAMETER);
        }
        if (!(nILSS.getDeviceType() instanceof NIDeviceTypeCKD)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS not instance of NIDeviceTypeCKD.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, INVALID_DEVICE_TYPE);
        }
        if (n3 <= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("iBases is <= 0.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(INVALID_BASE_VOLUME_NUMBER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" LSSID: " + ((NILSSID)nILSS.getID()).toString());
        stringBuffer.append(" AliasStartAddr: " + n);
        stringBuffer.append(" Ascending: " + bl);
        stringBuffer.append(" Pavs: " + n2);
        stringBuffer.append(" iBases: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getFutureCkdAliasVolumes(nIESSID, nILSS, nArray, nIVolumeArray, n, bl, n2, n3);
        logger.exit(CLASS_NAME, "getFutureCkdAliasVolumes()");
        return list;
    }

    public List getFutureCkdAliasVolumes(NIESSID nIESSID, NILSS nILSS, NIVolume[] nIVolumeArray, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdAliasVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nILSS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, NULL_PARAMETER);
        }
        if (!(nILSS.getDeviceType() instanceof NIDeviceTypeCKD)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS is not instance of NIDeviceTypeCKD.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, INVALID_DEVICE_TYPE);
        }
        if (n3 <= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("iBases is <= 0.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(INVALID_BASE_VOLUME_NUMBER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" LSS: " + ((NILSSID)nILSS.getID()).toString());
        stringBuffer.append(" AliasStartAddr: " + n);
        stringBuffer.append(" Ascending: " + bl);
        stringBuffer.append(" Pavs: " + n2);
        stringBuffer.append(" iBases: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getFutureCkdAliasVolumes(nIESSID, nILSS, nIVolumeArray, null, n, bl, n2, n3);
        logger.exit(CLASS_NAME, "getFutureCkdAliasVolumes()");
        return list;
    }

    public List getFutureCkdAliasVolumes(NIESSID nIESSID, NILSS nILSS, NIVolume[] nIVolumeArray, NIVolume[] nIVolumeArray2, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdAliasVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nILSS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, NULL_PARAMETER);
        }
        if (!(nILSS.getDeviceType() instanceof NIDeviceTypeCKD)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NILSS is not instance of NIDeviceTypeCKD.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nILSS, INVALID_DEVICE_TYPE);
        }
        if (n3 <= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("iBases is <= 0.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(INVALID_BASE_VOLUME_NUMBER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" LSS: " + ((NILSSID)nILSS.getID()).toString());
        stringBuffer.append(" AliasStartAddr: " + n);
        stringBuffer.append(" Ascending: " + bl);
        stringBuffer.append(" Pavs: " + n2);
        stringBuffer.append(" iBases: " + n3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getFutureCkdAliasVolumes(nIESSID, nILSS, nIVolumeArray, nIVolumeArray2, n, bl, n2, n3);
        logger.exit(CLASS_NAME, "getFutureCkdAliasVolumes()");
        return list;
    }

    public List getFutureCkdBaseVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n, int n2, int n3, boolean bl, NICKDAddressPolicy nICKDAddressPolicy, int n4, int n5, boolean bl2, String string, String string2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdBaseVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (bl2) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n6 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" CustomSize: " + n2);
        stringBuffer.append(" BaseStartAddr: " + n3);
        stringBuffer.append(" Ascending: " + bl);
        if (nICKDAddressPolicy != null) {
            stringBuffer.append(" AddressingPolicyMode: " + nICKDAddressPolicy);
        }
        stringBuffer.append(" LCUQuantity: " + n4);
        stringBuffer.append(" GenerateNicknameSequence: " + bl2);
        stringBuffer.append(" Decimal: " + bl3);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesVolumes.getFutureCkdBaseVolumes(nIESSID, nICKDVolumeType, nIExtentPool, nILSSArray, n, n2, n3, bl, nICKDAddressPolicy, n4, n5, bl2, string, string2, bl3);
        logger.exit(CLASS_NAME, "getFutureCkdBaseVolumes()");
        return list;
    }

    public List getFutureCkdBaseVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n, int n2, int n3, boolean bl, NICKDAddressPolicy nICKDAddressPolicy, int n4, int n5, boolean bl2, String string, String string2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdBaseVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (bl2) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n6 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" CustomSize: " + n2);
        stringBuffer.append(" BaseStartAddr: " + n3);
        stringBuffer.append(" Ascending: " + bl);
        if (nICKDAddressPolicy != null) {
            stringBuffer.append(" AddressingPolicyMode: " + nICKDAddressPolicy);
        }
        stringBuffer.append(" LCUQuantity: " + n4);
        stringBuffer.append(" GenerateNicknameSequence: " + bl2);
        logger.debug_general(stringBuffer.toString());
        return this.getFutureCkdBaseVolumes(nIESSID, nICKDVolumeType, nIExtentPool, nILSSArray, n, n2, n3, bl, nICKDAddressPolicy, n4, n5, bl2, string, string2, true);
    }

    public List getFutureCkdBaseVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n, int n2, int n3, boolean bl, NICKDAddressPolicy nICKDAddressPolicy, int n4, int n5, boolean bl2, String string, boolean bl3, String string2, boolean bl4) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureCkdBaseVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strVolNamePrefix is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (bl2 && bl4 && string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strVolNameSuffix is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" CustomSize: " + n2);
        stringBuffer.append(" BaseStartAddr: " + n3);
        stringBuffer.append(" Ascending: " + bl);
        if (nICKDAddressPolicy != null) {
            stringBuffer.append(" AddressingPolicyMode: " + nICKDAddressPolicy);
        }
        stringBuffer.append(" LCUQuantity: " + n4);
        stringBuffer.append(" GenerateNicknameSequence: " + bl2);
        logger.debug_general(stringBuffer.toString());
        return this.getFutureCkdBaseVolumes(nIESSID, nICKDVolumeType, nIExtentPool, nILSSArray, n, n2, n3, bl, nICKDAddressPolicy, n4, n5, bl2, string, string2);
    }

    public NIExtentPool getFutureExtentPool(NIESSID nIESSID, String string, NIExtentType nIExtentType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureExtentPool(NIESSID, String nickName, NIExtentType)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strExtentPoolNickname is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        logger.debug_general(stringBuffer.toString());
        NIExtentPool nIExtentPool = nIConfigurationAdvisorExtentPool.getFutureExtentPool(nIESSID, string, nIExtentType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureExtentPool(NIESSID, String nickName, NIExtentType) return value: ");
        stringBuffer.append(nIExtentPool == null ? "null" : nIExtentPool.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureExtentPool(NIESSID, String nickName, NIExtentType)");
        return nIExtentPool;
    }

    public NIExtentPool getFutureExtentPool(NIESSID nIESSID, String string, NIExtentType nIExtentType, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException, NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getFutureExtentPool(NIESSID, String nickName, NIExtentType, int serverNumber)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strExtentPoolNickname is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" ServerNumber: " + n);
        logger.debug_general(stringBuffer.toString());
        NIExtentPool nIExtentPool = nIConfigurationAdvisorExtentPool.getFutureExtentPool(nIESSID, string, nIExtentType, n);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureExtentPool(NIESSID, String nickName, NIExtentType, int serverNumber) return value: ");
        stringBuffer.append(nIExtentPool == null ? "null" : nIExtentPool.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureExtentPool(NIESSID, String nickName, NIExtentType, int serverNumber)");
        return nIExtentPool;
    }

    public List getFutureLcus(NIESSID nIESSID, int[] nArray, int n, NICKDBaseCUType nICKDBaseCUType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureLcus()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesLCUs nIConfigurationAdvisorZSeriesLCUs = new NIConfigurationAdvisorZSeriesLCUs(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" StartSsid: " + n);
        if (nICKDBaseCUType != null) {
            stringBuffer.append(" CKDBaseCUType: " + nICKDBaseCUType.toString());
        }
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorZSeriesLCUs.getFutureLcus(nIESSID, nArray, n, nICKDBaseCUType);
        logger.exit(CLASS_NAME, "getFutureLcus()");
        return list;
    }

    public NIOfflineStorageFacility getFutureOfflineStorageFacility(NIStoragePlexID nIStoragePlexID, String string, String string2, String string3, String string4, NIOfflineESS[] nIOfflineESSArray) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getFutureOfflineStorageFacility()");
        if (nIStoragePlexID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStoragePlexID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStoragePlexID, NULL_PARAMETER);
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StoragePlexID: " + nIStoragePlexID.toString());
        logger.debug_general(stringBuffer.toString());
        NIOfflineStorageFacility nIOfflineStorageFacility = nIConfigurationAdvisorStorageFacility.getFutureOfflineStorageFacility(nIStoragePlexID, string, string2, string3, string4, nIOfflineESSArray);
        logger.exit(CLASS_NAME, "getFutureOfflineStorageFacility()");
        return nIOfflineStorageFacility;
    }

    public NIOfflineStoragePlex getFutureOfflineStoragePlex(NIEnterpriseID nIEnterpriseID, String string, String string2, boolean bl) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getFutureOfflineStoragePlex()");
        if (nIEnterpriseID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIEnterpriseID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIEnterpriseID, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        logger.debug_general(stringBuffer.toString());
        stringBuffer.append(" EnterpriseID: " + nIEnterpriseID.toString());
        NIOfflineStoragePlex nIOfflineStoragePlex = NIResourceFactory.newOfflineStoragePlex(nIEnterpriseID, bl, string, string2);
        logger.exit(CLASS_NAME, "getFutureOfflineStoragePlex()");
        return nIOfflineStoragePlex;
    }

    public NIRank getFutureRank(NIESSID nIESSID, NIArray nIArray, NIExtentType nIExtentType, NIExtentPool nIExtentPool) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getFutureRank(NIESSID, NIArray, NIExtentType, NIExtentPool)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArray is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArray, NULL_PARAMETER);
        }
        if (nIArray.getID() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArray ID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArray, NULL_ID);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorRank nIConfigurationAdvisorRank = new NIConfigurationAdvisorRank(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ArrayID: " + ((NIArrayID)nIArray.getID()).toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        if (nIExtentPool != null) {
            stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        }
        logger.debug_general(stringBuffer.toString());
        NIRank nIRank = nIConfigurationAdvisorRank.getFutureRank(nIESSID, nIArray, nIExtentType, nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureRank(NIESSID, NIArray, NIExtentType, NIExtentPool) return value: ");
        stringBuffer.append(nIRank == null ? "empty" : nIRank.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureRank(NIESSID, NIArray, NIExtentType, NIExtentPool)");
        return nIRank;
    }

    public List getFutureRanksForExtentPool(NIESSID nIESSID, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        boolean bl = false;
        boolean bl2 = false;
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, n, bl, null, bl2);
    }

    public List getFutureRanksForExtentPool(NIESS nIESS, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        boolean bl = false;
        boolean bl2 = false;
        return this.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, n, bl, null, bl2);
    }

    public List getFutureRanksForExtentPool(NIESS nIESS, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        boolean bl2 = true;
        return this.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, n, bl2, null, bl);
    }

    public List getFutureRanksForExtentPool(NIESSID nIESSID, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl, Vector vector) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        boolean bl2 = false;
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, n, bl, vector, bl2);
    }

    public List getFutureRanksForExtentPool(NIESS nIESS, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl, Vector vector) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        boolean bl2 = false;
        return this.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, n, bl, vector, bl2);
    }

    public List getFutureRanksForExtentPool(NIESS nIESS, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl, Vector vector, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        long l = this.convertBinaryGBToExtents(n, nIExtentType);
        return this.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, n, l, bl, vector, bl2);
    }

    public List getFutureRanksForExtentPool(NIESS nIESS, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, long l, boolean bl, Vector vector, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureRanksForExtentPool()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" NeededStorageGB: " + n);
        stringBuffer.append(" NeededExtents: " + l);
        stringBuffer.append(" UseExisting: " + bl);
        stringBuffer.append(" ArraysToExclude: " + vector);
        stringBuffer.append(" RequestedCapacityRequired: " + bl2);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorExtentPool.getFutureRanksForExtentPool(nIESS, nIExtentPool, nIExtentType, nIRaidType, l, bl, vector, bl2);
        stringBuffer = new StringBuffer();
        int n2 = list.size();
        stringBuffer.append("getFutureRanksForExtentPool() return value: " + n2 + " ranks");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureRanksForExtentPool()");
        return list;
    }

    public NIVolumeGroup getFutureVolumeGroup(NIESSID nIESSID, String string, NIHostType[] nIHostTypeArray, NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getFutureVolumeGroup(NIESSID, String userName, NIHostType[], NIImageHostAttachment[], NIVolume[])");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strUserName is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (nIHostTypeArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIHostType[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIHostTypeArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        NIVolumeGroup nIVolumeGroup = nIConfigurationAdvisorVolumeGroups.getFutureVolumeGroup(nIESSID, string, nIHostTypeArray, nIImageHostAttachmentArray, nIVolumeArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureVolumeGroup(NIESSID, String userName, NIHostType[], NIImageHostAttachment[], NIVolume[]) return value: ");
        stringBuffer.append(nIVolumeGroup == null ? "null" : nIVolumeGroup.toString());
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getFutureVolumeGroup(NIESSID, String userName, NIHostType[], NIImageHostAttachment[], NIVolume[])");
        return nIVolumeGroup;
    }

    public List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int[] nArray, NIVolumeGroup[] nIVolumeGroupArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolCapacity: " + l);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        logger.debug_general(stringBuffer.toString());
        return this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPool, nILSSArray, nArray, nIVolumeGroupArray, n, l, nIAs400VolumeSize, bl, string, string2, true);
    }

    public List getVolumeClientData(NIESSID nIESSID, NIVolume[] nIVolumeArray, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getVolumeClientData()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIVolumeArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        List list = nIConfigurationAdvisorOpenSystemVolumes.getVolumeClientData(nIESSID, nIVolumeArray, bl);
        logger.exit(CLASS_NAME, "getVolumeClientData()");
        return list;
    }

    public List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int[] nArray, NIVolumeGroup[] nIVolumeGroupArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n2 = bl2 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric or hex value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolCapacity: " + l);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        stringBuffer.append(" Decimal: " + bl2);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorOpenSystemVolumes.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPool, nILSSArray, nArray, nIVolumeGroupArray, n, l, nIAs400VolumeSize, bl, string, string2, bl2);
        logger.exit(CLASS_NAME, "getFutureVolumes()");
        return list;
    }

    public List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int[] nArray, NIVolumeGroup[] nIVolumeGroupArray, int n, int n2, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (bl) {
            if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Both the prefix and suffix are either empty or null.  Throwing invalid parameter exception.");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)string2, INVALID_PREFIX_SUFFIX_COMBINATION);
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    int n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The suffix must be a numeric value.  Throwing invalid parameter exception.");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)string2, INVALID_SUFFIX);
                }
            }
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSize: " + n2);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        logger.debug_general(stringBuffer.toString());
        long l = n2;
        l *= (long)NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
        return this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPool, nILSSArray, nArray, nIVolumeGroupArray, n, l /= 512L, nIAs400VolumeSize, bl, string, string2);
    }

    public List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int[] nArray, NIVolumeGroup[] nIVolumeGroupArray, int n, int n2, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, boolean bl2, String string2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getFutureVolumes()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIFBVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIFBVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIFBVolumeType, NULL_PARAMETER);
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strVolNamePrefix is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (bl && bl3 && string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("strVolNameSuffix is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" FBVolumeType: " + nIFBVolumeType.toString());
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSize: " + n2);
        stringBuffer.append(" GenerateNicknameSequence: " + bl);
        logger.debug_general(stringBuffer.toString());
        return this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPool, nILSSArray, nArray, nIVolumeGroupArray, n, n2, nIAs400VolumeSize, bl, string, string2);
    }

    public List getInstalledDDMPack(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getInstalledDDMPack()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorStorageFacilityImage.getInstalledDDMPack(nIESSID);
        logger.exit(CLASS_NAME, "getInstalledDDMPack()");
        return list;
    }

    public List getLcuTypeList() {
        logger.enter(CLASS_NAME, "getLcuTypeList()");
        NIConfigurationAdvisorZSeriesLCUs nIConfigurationAdvisorZSeriesLCUs = new NIConfigurationAdvisorZSeriesLCUs(this);
        List list = nIConfigurationAdvisorZSeriesLCUs.getLcuTypeList();
        logger.exit(CLASS_NAME, "getLcuTypeList()");
        return list;
    }

    public List getMachineTypes() {
        logger.enter(CLASS_NAME, "getMachineType()");
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        List list = nIConfigurationAdvisorStorageFacility.getMachineTypes();
        logger.exit(CLASS_NAME, "getMachineType()");
        return list;
    }

    public int getMaxAdapters(NIStorageFacilityID nIStorageFacilityID) throws NIParameterInvalidCAException {
        NIStorageFacility nIStorageFacility;
        logger.enter(CLASS_NAME, "getMaxAdapters()");
        if (nIStorageFacilityID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacilityID: " + nIStorageFacilityID.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIStorageFacility = (NIStorageFacility)this.domainService.getStorageFacility(nIStorageFacilityID).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is not valid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        return this.getMaxAdapters(nIStorageFacility);
    }

    public int getMaxAdapters(NIStorageFacility nIStorageFacility) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getMaxAdapters()");
        if (nIStorageFacility == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacility is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacility, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacility: " + nIStorageFacility.toString());
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorStorageFacility.getMaxAdapters(nIStorageFacility);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAdapters() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAdapters()");
        return n;
    }

    public int getMaxAdapters(String string, String string2) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getMaxAdapters()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        stringBuffer.append(" ModelNumber: " + string2);
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorStorageFacility.getMaxAdapters(string, string2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAdapters() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAdapters()");
        return n;
    }

    public int getMaxAs400VolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NIVolumeGroup[] nIVolumeGroupArray, NIAs400VolumeSize nIAs400VolumeSize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAs400VolumeQuantity()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" NIExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        if (nIAs400VolumeSize != null) {
            stringBuffer.append(" As400VolumeSize: " + nIAs400VolumeSize.toString());
        }
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorOpenSystemVolumes.getMaxAs400VolumeQuantity(nIExtentPool, nILSSArray, nIVolumeGroupArray, nIAs400VolumeSize);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAs400VolumeQuantity() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAs400VolumeQuantity()");
        return n;
    }

    public NIAs400VolumeSize getMaxAs400VolumeSize(NIExtentPool nIExtentPool, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAs400VolumeSize()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        logger.debug_general(stringBuffer.toString());
        NIAs400VolumeSize nIAs400VolumeSize = nIConfigurationAdvisorOpenSystemVolumes.getMaxAs400VolumeSize(nIExtentPool, n);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAs400VolumeSize() return value: " + nIAs400VolumeSize);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAs400VolumeSize()");
        return nIAs400VolumeSize;
    }

    public int getMaxAvailableArrays(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIArraySize);
    }

    public int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorArray.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIArraySize);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAvailableArrays() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAvailableArrays()");
        return n;
    }

    public int getMaxAvailableArrays(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIArraySize);
    }

    public int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorArray.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIArraySize);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAvailableArrays() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAvailableArrays()");
        return n;
    }

    public int getMaxAvailableArrays(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2);
    }

    public int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        int n3 = nIConfigurationAdvisorArray.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAvailableArrays() return value: " + n3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAvailableArrays()");
        return n3;
    }

    public int getMaxAvailableArrays(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2);
    }

    public int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        int n3 = nIConfigurationAdvisorArray.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAvailableArrays() return value: " + n3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAvailableArrays()");
        return n3;
    }

    public int getMaxAvailableArrays(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs(nIESSID);
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2);
    }

    public int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.getImageDDMs((NIESSID)nIESS.getID());
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        int n3 = nIConfigurationAdvisorArray.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAvailableArrays() return value: " + n3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAvailableArrays()");
        return n3;
    }

    public int getMaxAvailableArrays(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2);
    }

    public int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxAvailableArrays()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        if (nIArraySiteArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySite[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySiteArray, NULL_PARAMETER);
        }
        if (nIStorageDeviceFRUArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageDeviceFRU[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageDeviceFRUArray, NULL_PARAMETER);
        }
        if (nIArraySize == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArraySize is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArraySize, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ArraySize: " + nIArraySize.toString());
        stringBuffer.append(" DDMCapacity: " + n);
        stringBuffer.append(" DDMRPM: " + n2);
        logger.debug_general(stringBuffer.toString());
        int n3 = nIConfigurationAdvisorArray.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxAvailableArrays() return value: " + n3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxAvailableArrays()");
        return n3;
    }

    public int getMaxCkdCustomVolSize(NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n) throws NIServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        logger.enter(CLASS_NAME, "getMaxCkdCustomVolSize()");
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        int n2 = nIConfigurationAdvisorZSeriesVolumes.getMaxCkdCustomVolSize(nIExtentPool, nILSSArray, n);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxCkdCustomVolSize() return value: " + n2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxCkdCustomVolSize()");
        return n2;
    }

    public int getMaxCkdCustomVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n) throws NIServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxCkdCustomVolumeQuantity()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeFB) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolCylinder: " + n);
        logger.debug_general(stringBuffer.toString());
        int n2 = nIConfigurationAdvisorZSeriesVolumes.getMaxCkdCustomVolumeQuantity(nIExtentPool, nILSSArray, n);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxCkdCustomVolumeQuantity() return value: " + n2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxCkdCustomVolumeQuantity()");
        return n2;
    }

    public int getMaxCkdVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NICKDVolumeType nICKDVolumeType) throws NIServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxCkdVolumeQuantity()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorZSeriesVolumes.getMaxCkdVolumeQuantity(nIExtentPool, nILSSArray, nICKDVolumeType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxCkdVolumeQuantity() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxCkdVolumeQuantity()");
        return n;
    }

    public int getMaxDDMPacks(NIStorageFacilityID nIStorageFacilityID) throws NIParameterInvalidCAException {
        NIStorageFacility nIStorageFacility;
        logger.enter(CLASS_NAME, "getMaxDDMPacks()");
        if (nIStorageFacilityID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacilityID: " + nIStorageFacilityID.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIStorageFacility = (NIStorageFacility)this.domainService.getStorageFacility(nIStorageFacilityID).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        return this.getMaxDDMPacks(nIStorageFacility);
    }

    public int getMaxDDMPacks(NIStorageFacility nIStorageFacility) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getMaxDDMPacks()");
        if (nIStorageFacility == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacility is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacility, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacility: " + nIStorageFacility.toString());
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorStorageFacility.getMaxDDMPacks(nIStorageFacility);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxDDMPacks() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxDDMPacks()");
        return n;
    }

    public int getMaxDDMPacks(String string, String string2) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getMaxDDMPacks()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        stringBuffer.append(" ModelNumber: " + string2);
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorStorageFacility.getMaxDDMPacks(string, string2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxDDMPacks() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxDDMPacks()");
        return n;
    }

    public int getMaximumNumberOfImages(String string, String string2) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getMaximumNumberOfImages()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        stringBuffer.append(" ModelNumber: " + string2);
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorStorageFacility.getMaximumNumberOfImages(string, string2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaximumNumberOfImages() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaximumNumberOfImages()");
        return n;
    }

    public double getMaxStorageForExtentPoolTB(NIESSID nIESSID, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getMaxStorageForExtentPoolTB()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getMaxStorageForExtentPoolTB(nIESS, nIRaidType);
    }

    public double getMaxStorageForExtentPoolTB(NIESS nIESS, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxStorageForExtentPoolTB()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getMaxStorageForExtentPoolTB(nIESS, nIRaidType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxStorageForExtentPoolTB() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxStorageForExtentPoolTB()");
        return d;
    }

    public int getMaxVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NIVolumeGroup[] nIVolumeGroupArray, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxVolumeQuantity()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolCapacity: " + l);
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorOpenSystemVolumes.getMaxVolumeQuantity(nIExtentPool, nILSSArray, nIVolumeGroupArray, l);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxVolumeQuantity() return value: " + n);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxVolumeQuantity()");
        return n;
    }

    public int getMaxVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NIVolumeGroup[] nIVolumeGroupArray, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxVolumeQuantity()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolSize: " + n);
        logger.debug_general(stringBuffer.toString());
        long l = this.convertGBToBlocks(n, true);
        return this.getMaxVolumeQuantity(nIExtentPool, nILSSArray, nIVolumeGroupArray, l);
    }

    public long getMaxVolumeSize(NIExtentPool nIExtentPool, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxVolumeSize()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        logger.debug_general(stringBuffer.toString());
        long l = this.getMaxVolumeCapacity(nIExtentPool, n);
        int n2 = this.convertBlocksToGB(l, true);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxVolumeSize() return value: " + l + " blocks, " + n2 + " GB");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxVolumeSize()");
        return n2;
    }

    public long getMaxVolumeCapacity(NIExtentPool nIExtentPool, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxVolumeSize()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        logger.debug_general(stringBuffer.toString());
        return this.getMaxVolumeCapacity(nIExtentPool, n, true);
    }

    public long getMaxVolumeCapacity(NIExtentPool nIExtentPool, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxVolumeSize()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" BinaryGB: " + bl);
        logger.debug_general(stringBuffer.toString());
        long l = nIConfigurationAdvisorOpenSystemVolumes.getMaxVolumeCapacity(nIExtentPool, n, bl);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxVolumeSize() return value: " + l);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxVolumeSize()");
        return l;
    }

    public List getModelType(String string) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getModelType()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorStorageFacility.getModelType(string);
        logger.exit(CLASS_NAME, "getModelType()");
        return list;
    }

    public NIVolumeGroup getModifiedVolumeGroup(NIVolumeGroup nIVolumeGroup, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getModifiedVolumeGroup()");
        if (nIVolumeGroup == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroup is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroup, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeGroupID: " + ((NIVolumeGroupID)nIVolumeGroup.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        NIVolumeGroup nIVolumeGroup2 = nIConfigurationAdvisorOpenSystemVolumes.getModifiedVolumeGroup(nIVolumeGroup, nIVolumeArray);
        logger.exit(CLASS_NAME, "getModifiedVolumeGroup()");
        return nIVolumeGroup2;
    }

    public int[] getNextArrayNumber(NIESSID nIESSID, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getNextArrayNumber()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" Quantity: " + n);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getNextArrayNumber(nIESS, n);
    }

    public int[] getNextArrayNumber(NIESS nIESS, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getNextArrayNumber()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" Quantity: " + n);
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorArray.getNextArrayNumber(nIESS, n);
        logger.exit(CLASS_NAME, "getNextArrayNumber()");
        return nArray;
    }

    public int getNextAvailableSSID(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getNextAvailableSSID()");
        if (nIStorageFacilityID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacilityID: " + nIStorageFacilityID.toString());
        logger.debug_general(stringBuffer.toString());
        int[] nArray = this.getNextAvailableSSID(nIStorageFacilityID, 1, -1);
        int n = nArray[0];
        logger.exit(CLASS_NAME, "getNextAvailableSSID()");
        return n;
    }

    public int[] getNextRankNumber(NIESSID nIESSID, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getNextRankNumber()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorRank nIConfigurationAdvisorRank = new NIConfigurationAdvisorRank(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" Quantity: " + n);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getNextRankNumber(nIESS, n);
    }

    public int[] getNextRankNumber(NIESS nIESS, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getNextRankNumber()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        NIConfigurationAdvisorRank nIConfigurationAdvisorRank = new NIConfigurationAdvisorRank(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" Quantity: " + n);
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorRank.getNextRankNumber(nIESS, n);
        logger.exit(CLASS_NAME, "getNextRankNumber()");
        return nArray;
    }

    protected int getNextVolNum(int[] nArray, int n, boolean bl) {
        int n2;
        if (bl) {
            n2 = n - 1;
            while (++n2 < nArray.length && nArray[n2] != -1) {
            }
            if (n2 == nArray.length) {
                n2 = -1;
                while (++n2 < n && nArray[n2] != -1) {
                }
                if (n2 == n) {
                    n2 = -1;
                }
            }
        } else {
            n2 = n + 1;
            while (--n2 >= 0 && nArray[n2] != -1) {
            }
            if (n2 == -1) {
                n2 = nArray.length;
                while (--n2 > n && nArray[n2] != -1) {
                }
                if (n2 == n) {
                    n2 = -1;
                }
            }
        }
        return n2;
    }

    protected int getNextVolNum(int[] nArray, int n, boolean bl, int n2) {
        int n3;
        if (bl) {
            n3 = n - 1;
            while (++n3 < nArray.length && n3 < n2 && nArray[n3] != -1) {
            }
            if (n3 == nArray.length) {
                n3 = -1;
                while (++n3 < n && nArray[n3] != -1) {
                }
                if (n3 == n) {
                    n3 = -1;
                }
            }
        } else {
            n3 = n + 1;
            while (--n3 >= 0 && nArray[n3] != -1) {
            }
            if (n3 == -1) {
                n3 = n2 + 1;
                while (--n3 > n && nArray[n3] != -1) {
                }
                if (n3 == n) {
                    n3 = -1;
                }
            }
        }
        return n3;
    }

    public int[] getNextVolumeNumber(NILSSID nILSSID, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getNextVolumeNumber()");
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        if (nILSSID != null) {
            stringBuffer.append(" LSSID: " + nILSSID.toString());
        }
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorOpenSystemVolumes.getNextVolumeNumber(nILSSID, n);
        logger.exit(CLASS_NAME, "getNextVolumeNumber()");
        return nArray;
    }

    public int getNextVolumeNumber(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getNextVolumeNumber()");
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        if (nILSSID != null) {
            stringBuffer.append(" LSSID: " + nILSSID.toString());
        }
        logger.debug_general(stringBuffer.toString());
        int n = nIConfigurationAdvisorOpenSystemVolumes.getNextVolumeNumber(nILSSID);
        logger.exit(CLASS_NAME, "getNextVolumeNumber()");
        return n;
    }

    public long getNumberOfExtents(int n, NIExtentType nIExtentType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getNumberOfExtents()");
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageGB: " + n);
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        logger.debug_general(stringBuffer.toString());
        long l = nIConfigurationAdvisorExtentPool.getNumberOfExtents(n, nIExtentType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getNumberOfExtents() return value: " + l);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getNumberOfExtents()");
        return l;
    }

    public int getNumberOfFutureRanksForExtentPool(NIESSID nIESSID, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getNumberOfFutureRanksForExtentPool()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ExtentPoolSizeGB: " + n);
        stringBuffer.append(" UseExisting: " + bl);
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getNumberOfFutureRanksForExtentPool(nIESS, nIExtentType, nIRaidType, n, bl);
    }

    public int getNumberOfFutureRanksForExtentPool(NIESS nIESS, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getNumberOfFutureRanksForExtentPool()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, NULL_PARAMETER);
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" ExtentPoolSizeGB: " + n);
        stringBuffer.append(" UseExisting: " + bl);
        logger.debug_general(stringBuffer.toString());
        int n2 = nIConfigurationAdvisorExtentPool.getNumberOfFutureRanksForExtentPool(nIESS, nIExtentType, nIRaidType, n, bl);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getNumberOfFutureRanksForExtentPool() return value: " + n2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getNumberOfFutureRanksForExtentPool()");
        return n2;
    }

    public List getRaidTypesInExtentPool(NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getRaidTypesInExtentPool()");
        if (nIExtentPoolID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + nIExtentPoolID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorExtentPool.getRaidTypesInExtentPool(nIExtentPoolID);
        logger.exit(CLASS_NAME, "getRaidTypesInExtentPool()");
        return list;
    }

    public List getRaidTypesList(NIESSID nIESSID) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getRaidTypesList()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorStorageFacilityImage.getRaidTypesList(nIESSID);
        logger.exit(CLASS_NAME, "getRaidTypesList()");
        return nIConfigurationAdvisorStorageFacilityImage.getRaidTypesList(nIESSID);
    }

    public List getRanksInExtentPool(NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getRanksInExtentPool()");
        if (nIExtentPoolID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPoolID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + nIExtentPoolID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorExtentPool.getRanksInExtentPool(nIExtentPoolID);
        stringBuffer = new StringBuffer();
        int n = list.size();
        stringBuffer.append("getRanksInExtentPool() return value: " + n + " ranks");
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getRanksInExtentPool()");
        return list;
    }

    public double getReservedStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getReservedStorageGB(NIExtentPool extentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + nIExtentPool.toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getReservedStorageGB(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getReservedStorageGB(NIExtentPool extentPool) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getReservedStorageGB(NIExtentPool extentPool)");
        return d;
    }

    public List getSCSIHostTypeList() {
        logger.enter(CLASS_NAME, "getSCSIHostTypeList()");
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        List list = nIConfigurationAdvisorVolumeGroups.getSCSIHostTypeList();
        logger.exit(CLASS_NAME, "getSCSIHostTypeList()");
        return list;
    }

    public double getStorageInGB(long l, NIDataType nIDataType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getStorageInGB()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageSize: " + l);
        double d = 0.0;
        if (nIDataType != null) {
            stringBuffer.append(" DataType: " + nIDataType.toString());
            if (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) {
                d = (double)(l * 512L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            } else if (nIDataType instanceof NIDataType3380) {
                d = (double)(l * 712140L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            } else if (nIDataType instanceof NIDataType3390) {
                d = (double)(l * 849960L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            }
        } else {
            d = (double)(l * 712140L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
        }
        logger.debug_general(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("getStorageInGB( ) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getStorageInGB()");
        return d;
    }

    public List getStorageTypeList() {
        logger.enter(CLASS_NAME, "getStorageTypeList()");
        Vector<NIExtentType> vector = new Vector<NIExtentType>(Arrays.asList(storageType));
        logger.exit(CLASS_NAME, "getStorageTypeList()");
        return vector;
    }

    public List getCKDAddressPolicyList() {
        logger.enter(CLASS_NAME, "getCKDAddressPolicyList()");
        ArrayList<NICKDAddressPolicy> arrayList = new ArrayList<NICKDAddressPolicy>(Arrays.asList(addressPolicy));
        logger.exit(CLASS_NAME, "getCKDAddressPolicyList()");
        return arrayList;
    }

    public int[] getSupportedDDMCapacities(NIESSID nIESSID) throws NIParameterInvalidCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getSupportedDDMCapacities()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getSupportedDDMCapacities(nIESS);
    }

    public int[] getSupportedDDMCapacities(NIESS nIESS) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getSupportedDDMCapacities()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESS: " + nIESS.toString());
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorStorageFacilityImage.getSupportedDDMCapacities(nIESS);
        logger.exit(CLASS_NAME, "getSupportedDDMCapacities()");
        return nArray;
    }

    public int[] getSupportedDDMCapacities(String string, String string2) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getSupportedDDMCapacities()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        stringBuffer.append(" ModelNumber: " + string2);
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorStorageFacilityImage.getSupportedDDMCapacities(string, string2);
        logger.exit(CLASS_NAME, "getSupportedDDMCapacities()");
        return nArray;
    }

    public int[] getSupportedRPMs(NIESSID nIESSID) throws NIParameterInvalidCAException {
        NIESS nIESS;
        logger.enter(CLASS_NAME, "getSupportedRPMs()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIESSID}).getResourceList().get(0);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        return this.getSupportedRPMs(nIESS);
    }

    public int[] getSupportedRPMs(NIESS nIESS) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getSupportedRPMs()");
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESS: " + nIESS.toString());
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorStorageFacilityImage.getSupportedRPMs(nIESS);
        logger.exit(CLASS_NAME, "getSupportedRPMs()");
        return nArray;
    }

    public int[] getSupportedRPMs(String string, String string2) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getSupportedRPMs()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        stringBuffer.append(" ModelNumber: " + string2);
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorStorageFacilityImage.getSupportedRPMs(string, string2);
        logger.exit(CLASS_NAME, "getSupportedRPMs()");
        return nArray;
    }

    public double getThresholdStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getThresholdStorageGB()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getThresholdStorageGB(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getThresholdStorageGB() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getThresholdStorageGB()");
        return d;
    }

    public double getTotalFutureStorageGB(NIDDMPack[] nIDDMPackArray) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getTotalFutureStorageGB()");
        if (nIDDMPackArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIDDMPack[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIDDMPackArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        double d = nIConfigurationAdvisorStorageFacility.getTotalFutureStorageGB(nIDDMPackArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalFutureStorageGB() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalFutureStorageGB()");
        return d;
    }

    public double getTotalFutureStorageGB(NIDDMPack[] nIDDMPackArray, String string) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getTotalFutureStorageGB()");
        if (nIDDMPackArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIDDMPack[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIDDMPackArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        double d = nIConfigurationAdvisorStorageFacility.getTotalFutureStorageGB(nIDDMPackArray, string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalFutureStorageGB() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalFutureStorageGB()");
        return d;
    }

    public double getTotalRawStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getTotalRawStorageGB(NIExtentPool extentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getTotalRawStorageGB(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalRawStorageGB() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalRawStorageGB(NIExtentPool extentPool)");
        return d;
    }

    public double getTotalStorageGB(NIArray nIArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getTotalStorageGB(NIArray array)");
        if (nIArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArray is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Array: " + ((NIArrayID)nIArray.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorArray.getTotalStorageGB(nIArray, NIExtentTypeFB.Option);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalStorageGB(NIArray array) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalStorageGB(NIArray array)");
        return d;
    }

    public double getTotalStorageGB(NIArray nIArray, NIExtentType nIExtentType) throws NIParameterInvalidCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getTotalStorageGB(NIArray array, NIExtentType extentType)");
        if (nIArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIArray is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Array: " + ((NIArrayID)nIArray.getID()).toString());
        stringBuffer.append(" ExtentType: " + nIExtentType);
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorArray.getTotalStorageGB(nIArray, nIExtentType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalStorageGB(NIArray array, NIExtentType extentType) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalStorageGB(NIArray array, NIExtentType extentType)");
        return d;
    }

    public double getTotalStorageGB(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getTotalStorageGB(NIESSID ess)");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorStorageFacilityImage.getTotalStorageGB(nIESSID);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalStorageGB(NIESSID ess) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalStorageGB(NIESSID ess)");
        return d;
    }

    public double getTotalStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getTotalStorageGB(NIExtentPool extentPool)");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorExtentPool.getTotalStorageGB(nIExtentPool);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalStorageGB(NIExtentPool extentPool) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalStorageGB(NIExtentPool extentPool)");
        return d;
    }

    public double getTotalStorageGB(NIRank nIRank) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getTotalStorageGB(NIRank niRank)");
        if (nIRank == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRank is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRank, NULL_PARAMETER);
        }
        NIConfigurationAdvisorRank nIConfigurationAdvisorRank = new NIConfigurationAdvisorRank(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" RankID: " + ((NIRankID)nIRank.getID()).toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorRank.getTotalStorageGB(nIRank);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalStorageGB(NIRank niRank) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalStorageGB(NIRank niRank)");
        return d;
    }

    public double getTotalStorageGB(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getTotalStorageGB(NIStorageFacilityID facility)");
        if (nIStorageFacilityID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacilityID: " + nIStorageFacilityID.toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorStorageFacility.getTotalStorageGB(nIStorageFacilityID);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getTotalStorageGB(NIStorageFacilityID facility) return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getTotalStorageGB(NIStorageFacilityID facility)");
        return d;
    }

    protected int[] getVolAddrTable(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray = new int[256];
        List list = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        Arrays.fill(nArray, -1);
        try {
            nIConfigQueryResult = this.logicalService.getVolumes(nILSSID);
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() != 0 || nIConfigQueryResult.getResourceList() == null) {
            throw new NIQueryFailureCAException(QUERY_FAILURE);
        }
        list = nIConfigQueryResult.getResourceList();
        Arrays.fill(nArray, -1);
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            nArray[n3] = n3 = ((NIVolumeID)((NIVolume)list.get(n2)).getID()).getVolNumber();
            ++n2;
        }
        return nArray;
    }

    public int[] getVolumeAddresses(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException, NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getVolumeAddresses()");
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        if (nIExtentPool != null) {
            stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        }
        logger.debug_general(stringBuffer.toString());
        int[] nArray = nIConfigurationAdvisorZSeriesVolumes.getVolumeAddresses(nILSSArray, nIExtentPool);
        logger.exit(CLASS_NAME, "getVolumeAddresses()");
        return nArray;
    }

    public List getVolumeGroups(NIVolumeID nIVolumeID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getVolumeGroups()");
        if (nIVolumeID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Volume: " + nIVolumeID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorOpenSystemVolumes.getVolumeGroups(nIVolumeID);
        logger.exit(CLASS_NAME, "getVolumeGroups()");
        return list;
    }

    public NIVolumeGroupType getVolumeGroupType(NIHostType nIHostType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getVolumeGroupType()");
        if (nIHostType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIHostType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIHostType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        NIVolumeGroupType nIVolumeGroupType = nIConfigurationAdvisorVolumeGroups.getVolumeGroupType(nIHostType);
        logger.exit(CLASS_NAME, "getVolumeGroupType()");
        return nIVolumeGroupType;
    }

    public List getVolumes(NIVolumeGroupID nIVolumeGroupID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getVolumes(NIVolumeGroupID)");
        if (nIVolumeGroupID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroupID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeGroupID: " + nIVolumeGroupID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorVolumeGroups.getVolumes(nIVolumeGroupID);
        logger.exit(CLASS_NAME, "getVolumes(NIVolumeGroupID)");
        return list;
    }

    public List getVolumes(NIVolumeGroupID nIVolumeGroupID, NIDeviceType nIDeviceType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getVolumes(NIVolumeGroupID, NIDeviceType)");
        if (nIVolumeGroupID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeGroupID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeGroupID: " + nIVolumeGroupID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorVolumeGroups.getVolumes(nIVolumeGroupID, nIDeviceType);
        logger.exit(CLASS_NAME, "getVolumes(NIVolumeGroupID, NIDeviceType)");
        return list;
    }

    protected List getConfigurableArraySites(NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray) {
        int n;
        Serializable serializable;
        Vector<Serializable> vector = new Vector<Serializable>();
        int n2 = nIArraySiteArray.length;
        int n3 = 0;
        while (n3 < n2) {
            serializable = nIArraySiteArray[n3];
            n = serializable.getArraySiteStatus();
            if (n == 1) {
                vector.add(serializable);
            }
            ++n3;
        }
        serializable = new StringBuffer();
        n = vector.size();
        ((StringBuffer)serializable).append("getConfigurableSites() return value: " + n + " sites");
        logger.debug_general(((StringBuffer)serializable).toString());
        return vector;
    }

    protected List getConfigurableArraySiteIDs(NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        Serializable serializable;
        Vector<NIArraySiteID> vector = new Vector<NIArraySiteID>();
        int n2 = nIArraySiteArray.length;
        int n3 = 0;
        while (n3 < n2) {
            serializable = nIArraySiteArray[n3];
            n = serializable.getArraySiteStatus();
            if (n == 1) {
                vector.add((NIArraySiteID)serializable.getID());
            }
            ++n3;
        }
        serializable = new StringBuffer();
        n = vector.size();
        ((StringBuffer)serializable).append("getConfigurableSiteIDs() return value: " + n + " sites");
        logger.debug_general(((StringBuffer)serializable).toString());
        return vector;
    }

    protected String padding(int n, int n2) {
        return this.padding(n, n2, true);
    }

    protected String padding(int n, int n2, boolean bl) {
        String string = "";
        String string2 = null;
        string2 = bl ? Integer.toString(n) : Integer.toHexString(n).toUpperCase();
        int n3 = 0;
        while (n3 < n2 - string2.length()) {
            string = n3 == 0 ? "0" : string + "0";
            ++n3;
        }
        string = string + string2;
        return string;
    }

    public NIVolume setCKDVolumeType(NIVolume nIVolume, NICKDVolumeType nICKDVolumeType) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "setCKDVolumeType()");
        if (nIVolume == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolume, NULL_PARAMETER);
        }
        if (nICKDVolumeType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NICKDVolumeType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeID: " + ((NIVolumeID)nIVolume.getID()).toString());
        stringBuffer.append(" CKDVolumeType: " + nICKDVolumeType.toString());
        logger.debug_general(stringBuffer.toString());
        NIVolume nIVolume2 = nIConfigurationAdvisorZSeriesVolumes.setCKDVolumeType(nIVolume, nICKDVolumeType);
        logger.exit(CLASS_NAME, "setCKDVolumeType()");
        return nIVolume2;
    }

    public boolean validateSsid(NIStorageFacilityID nIStorageFacilityID, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "validateSsid()");
        if (nIStorageFacilityID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIStorageFacilityID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIStorageFacilityID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorZSeriesLCUs nIConfigurationAdvisorZSeriesLCUs = new NIConfigurationAdvisorZSeriesLCUs(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" StorageFacilityID: " + nIStorageFacilityID.toString());
        stringBuffer.append(" SSID: " + n);
        logger.debug_general(stringBuffer.toString());
        boolean bl = nIConfigurationAdvisorZSeriesLCUs.validateSsid(nIStorageFacilityID, n);
        logger.exit(CLASS_NAME, "validateSsid()");
        return bl;
    }

    public List getRankClientData(NIESSID nIESSID, NIRank[] nIRankArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getRankClientData()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIRankArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRank[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRankArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorRank nIConfigurationAdvisorRank = new NIConfigurationAdvisorRank(this);
        List list = nIConfigurationAdvisorRank.getRankClientData(nIESSID, nIRankArray);
        logger.exit(CLASS_NAME, "getRankClientData()");
        return list;
    }

    public List getExtentPoolClientData(NIESSID nIESSID, NIExtentPool[] nIExtentPoolArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        List list = this.getExtentPoolClientData(nIESSID, nIExtentPoolArray, true);
        return list;
    }

    public List getExtentPoolClientData(NIESSID nIESSID, NIExtentPool[] nIExtentPoolArray, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getExtentPoolClientData()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIExtentPoolArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPoolArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this);
        List list = nIConfigurationAdvisorExtentPool.getExtentPoolClientData(nIESSID, nIExtentPoolArray, bl);
        logger.exit(CLASS_NAME, "getExtentPoolClientData()");
        return list;
    }

    public List getVolumeClientData(NIESSID nIESSID, NIVolume[] nIVolumeArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getVolumeClientData()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        if (nIVolumeArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolume[] is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeArray, NULL_PARAMETER);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        List list = nIConfigurationAdvisorOpenSystemVolumes.getVolumeClientData(nIESSID, nIVolumeArray, false);
        logger.exit(CLASS_NAME, "getVolumeClientData()");
        return list;
    }

    public NIVolumeGroup getVolumeGroupForModify(NIVolumeGroup nIVolumeGroup, NIVolumeGroupID nIVolumeGroupID) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getVolumeGroupForModify()");
        if (nIVolumeGroup == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("futureVolumeGroup is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroup, NULL_PARAMETER);
        }
        if (nIVolumeGroupID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("volumeGroupID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeGroupID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorVolumeGroups nIConfigurationAdvisorVolumeGroups = new NIConfigurationAdvisorVolumeGroups(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" VolumeGroupID: " + nIVolumeGroupID.toString());
        logger.debug_general(stringBuffer.toString());
        NIVolumeGroup nIVolumeGroup2 = nIConfigurationAdvisorVolumeGroups.getVolumeGroupForModify(nIVolumeGroup, nIVolumeGroupID);
        logger.exit(CLASS_NAME, "getVolumeGroupForModify()");
        return nIVolumeGroup2;
    }

    protected Hashtable createDAPairTableForSites(NIArraySite[] nIArraySiteArray, int n) {
        int n2;
        Hashtable<Integer, Vector> hashtable = new Hashtable<Integer, Vector>(2);
        Vector vector = null;
        int n3 = 0;
        while (n3 < n) {
            vector = new Vector();
            hashtable.put(new Integer(n3), vector);
            ++n3;
        }
        int n4 = 0;
        while (n4 < nIArraySiteArray.length) {
            NIArraySite nIArraySite = nIArraySiteArray[n4];
            if (nIArraySite != null && (n2 = nIArraySite.getDeviceAdapterPair()) < n) {
                vector = (Vector)hashtable.get(new Integer(n2));
                vector.add(nIArraySite);
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            vector = (Vector)hashtable.get(new Integer(n5));
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NIArraySite nIArraySite = (NIArraySite)object;
                    NIArraySite nIArraySite2 = (NIArraySite)object2;
                    int n2 = ((NIArraySiteID)nIArraySite.getID()).getArraySiteNumber();
                    int n3 = ((NIArraySiteID)nIArraySite2.getID()).getArraySiteNumber();
                    n = n2 - n3;
                    return n;
                }
            });
            ++n5;
        }
        n2 = 0;
        while (n2 < n) {
            vector = (Vector)hashtable.get(new Integer(n2));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("createDAPairTableForSites: DA pair " + n2 + " contains " + vector.size() + " sites");
            logger.debug_general(stringBuffer.toString());
            ++n2;
        }
        return hashtable;
    }

    public List getSupportedDDMPack(String string, String string2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getSupportedDDMPack()");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("machineType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string, NULL_PARAMETER);
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("modelNumber is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)string2, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" MachineType: " + string);
        stringBuffer.append(" ModelNumber: " + string2);
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorStorageFacility.getSupportedDDMPack(string, string2);
        logger.exit(CLASS_NAME, "getSupportedDDMPack()");
        return list;
    }

    protected int[] getNextAvailableSSID(NIStorageFacilityID nIStorageFacilityID, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray;
        block10: {
            int n3;
            int n4;
            int n5;
            Vector vector;
            int n6;
            int n7;
            int[] nArray2;
            block9: {
                nArray2 = new int[65536];
                n7 = 65536;
                n6 = -1;
                nArray = new int[n];
                Arrays.fill(nArray, -1);
                List list = this.getExistingLSSs(nIStorageFacilityID);
                vector = list == null ? new Vector() : new Vector(list);
                n5 = vector.size();
                if (n5 != 0) break block9;
                n6 = n2 == -1 ? 1 : n2;
                int n8 = 0;
                while (n8 < n) {
                    nArray[n8] = n6++;
                    ++n8;
                }
                break block10;
            }
            Arrays.fill(nArray2, -1);
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NILSS nILSS = (NILSS)object;
                    NILSS nILSS2 = (NILSS)object2;
                    int n2 = ((NILSSID)nILSS.getID()).getSSID();
                    int n3 = ((NILSSID)nILSS2.getID()).getSSID();
                    n = n2 - n3;
                    return n;
                }
            });
            int n9 = 0;
            while (n9 < n5) {
                n4 = ((NILSSID)((NILSS)vector.get(n9)).getID()).getSSID();
                if (n9 == 0) {
                    n7 = n2 == -1 ? n4 + 1 : n2;
                }
                if (nArray2[n4] == -1) {
                    nArray2[n4] = n4;
                }
                ++n9;
            }
            n4 = 0;
            if (n7 < 65279) {
                n3 = n7;
                while (n3 < 65280 && n4 < n) {
                    if (nArray2[n3] == -1) {
                        nArray[n4] = n6 = n3;
                        ++n4;
                    }
                    ++n3;
                }
            }
            if (n4 >= n) break block10;
            n3 = 1;
            while (n3 < n7 && n4 < n) {
                if (nArray2[n3] == -1) {
                    nArray[n4] = n6 = n3;
                    ++n4;
                }
                ++n3;
            }
        }
        return nArray;
    }

    protected List getExistingLSSs(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.domainService.getESSs(nIStorageFacilityID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        List list = null;
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getESSs " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        List list2 = null;
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        int n2 = 0;
        while (n2 < n) {
            NIESS nIESS = (NIESS)list.get(n2);
            NIConfigQueryResult nIConfigQueryResult2 = null;
            try {
                nIConfigQueryResult2 = this.logicalService.getLogicalSubsystems((NIESSID)nIESS.getID());
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(stringBuffer.toString());
            }
            if (nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
                list2 = nIConfigQueryResult2.getResourceList();
            } else if (nIConfigQueryResult2.getCode() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure getLogicalSubsystems " + nIConfigQueryResult2.getCode());
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException(QUERY_FAILURE);
            }
            ++n2;
        }
        return list2;
    }

    public int convertDDMCapacityMBtoGB(int n) {
        int n2 = 0;
        if (Math.abs(n - 300000) < 20000) {
            n2 = 300000 / (int)NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        } else if (Math.abs(n - 146000) < 20000) {
            n2 = 146000 / (int)NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        } else if (Math.abs(n - 73000) < 20000) {
            n2 = 73000 / (int)NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        } else if (Math.abs(n - 500000) < 20000) {
            n2 = 500000 / (int)NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        } else if (Math.abs(n - 450000) < 20000) {
            n2 = 450000 / (int)NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        }
        return n2;
    }

    protected int convertDDMRPM(int n) {
        int n2 = 0;
        if (Math.abs(n - 15000) < 1500) {
            n2 = 15000;
        }
        if (Math.abs(n - 10000) < 1500) {
            n2 = 10000;
        }
        return n2;
    }

    protected int convertDDMCapacityConstant(int n) {
        int n2 = 0;
        if (Math.abs(n - 300000) < 20000) {
            n2 = 300000;
        } else if (Math.abs(n - 146000) < 20000) {
            n2 = 146000;
        } else if (Math.abs(n - 73000) < 20000) {
            n2 = 73000;
        }
        return n2;
    }

    protected NIArraySite[] getImageArraySites(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        NIArraySite[] nIArraySiteArray = null;
        try {
            nIConfigQueryResult = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getArraySites " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        nIArraySiteArray = list != null ? list.toArray(new NIArraySite[0]) : new NIArraySite[]{};
        return nIArraySiteArray;
    }

    protected NIStorageDeviceFRU[] getImageDDMs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = null;
        try {
            nIConfigQueryResult = this.physicalService.getStorageDeviceFRUs(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            throw new NIQueryFailureCAException(QUERY_FAILURE);
        }
        nIStorageDeviceFRUArray = list != null ? list.toArray(new NIStorageDeviceFRU[0]) : new NIStorageDeviceFRU[]{};
        return nIStorageDeviceFRUArray;
    }

    protected NIArray[] getImageArrays(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        NIArray[] nIArrayArray = null;
        try {
            nIConfigQueryResult = this.logicalService.getArrays(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getArrays " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        nIArrayArray = list != null ? list.toArray(new NIArray[0]) : new NIArray[]{};
        return nIArrayArray;
    }

    protected NIRank[] getImageRanks(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        NIRank[] nIRankArray = null;
        try {
            nIConfigQueryResult = this.logicalService.getRanks(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getRanks " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        nIRankArray = list != null ? list.toArray(new NIRank[0]) : new NIRank[]{};
        return nIRankArray;
    }

    protected NIExtentPool[] getImageExtentPools(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        NIExtentPool[] nIExtentPoolArray = null;
        try {
            nIConfigQueryResult = this.logicalService.getExtentPools(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getExtentPools " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        nIExtentPoolArray = list != null ? list.toArray(new NIExtentPool[0]) : new NIExtentPool[]{};
        return nIExtentPoolArray;
    }

    public List getPortProfiles() {
        logger.enter(CLASS_NAME, "getPortProfiles()");
        Vector<NIPortProfile> vector = new Vector<NIPortProfile>();
        int n = 25;
        int n2 = 0;
        while (n2 < n) {
            String string = NIHostConstants.getHostInfo(n2, 2);
            int n3 = Integer.parseInt(NIHostConstants.getHostInfo(n2, 3));
            int n4 = Integer.parseInt(NIHostConstants.getHostInfo(n2, 4));
            NIPortProfile nIPortProfile = new NIPortProfile(string, n3, n4);
            vector.add(nIPortProfile);
            ++n2;
        }
        logger.exit(CLASS_NAME, "getPortProfiles()");
        return vector;
    }

    public NIStorageFacilityImageClientData getStorageFacilityImageClientData(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getStorageFacilityImageClientData()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        NIStorageFacilityImageClientData nIStorageFacilityImageClientData = nIConfigurationAdvisorStorageFacilityImage.getStorageFacilityImageClientData(nIESSID);
        logger.exit(CLASS_NAME, "getStorageFacilityImageClientData()");
        return nIStorageFacilityImageClientData;
    }

    public List getAllInstalledDDMPack(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getAllInstalledDDMPack()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        List list = nIConfigurationAdvisorStorageFacilityImage.getAllInstalledDDMPack(nIESSID);
        logger.exit(CLASS_NAME, "getAllInstalledDDMPack()");
        return list;
    }

    public double getUnconfiguredStorageGB(NIESSID nIESSID) throws NIParameterInvalidCAException, NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIUnknownCAException, NIQueryFailureCAException, NIServerException {
        logger.enter(CLASS_NAME, "getUnconfiguredStorageGB()");
        if (nIESSID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESSID is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, NULL_PARAMETER);
        }
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESSID: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorStorageFacilityImage.getUnconfiguredStorageGB(nIESSID);
        logger.exit(CLASS_NAME, "getUnconfiguredStorageGB()");
        return d;
    }

    public int convertBlocksToGB(long l, boolean bl) {
        long l2 = l * 512L;
        return (int)(l2 /= bl ? (long)NIConfigurationConstants.BYTES_IN_ONE_GB_BIN : (long)NIConfigurationConstants.BYTES_IN_ONE_GB_DEC);
    }

    public long convertGBToBlocks(int n, boolean bl) {
        long l = n;
        long l2 = (l *= bl ? (long)NIConfigurationConstants.BYTES_IN_ONE_GB_BIN : (long)NIConfigurationConstants.BYTES_IN_ONE_GB_DEC) / 512L;
        l2 = (l2 + 64L - 1L) / 64L * 64L;
        return l2;
    }

    public double convertBlocksToDoubleGB(long l, boolean bl) {
        logger.enter(CLASS_NAME, "convertBlocksToDoubleGB()");
        double d = Math.pow(10.0, 9.0);
        double d2 = Math.pow(2.0, 30.0);
        double d3 = l * 512L;
        BigDecimal bigDecimal = new BigDecimal(d3 /= bl ? NIConfigurationConstants.BYTES_IN_ONE_GB_BIN : NIConfigurationConstants.BYTES_IN_ONE_GB_DEC);
        bigDecimal = bigDecimal.setScale(1, 4);
        d3 = bigDecimal.doubleValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("capacityInBlocks: " + l);
        stringBuffer.append(" binaryGB: " + bl);
        stringBuffer.append(" sizeInGB: " + d3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "convertBlocksToDoubleGB()");
        return d3;
    }

    public double convertBlocksToDoubleGB(long l, boolean bl, boolean bl2) {
        logger.enter(CLASS_NAME, "convertBlocksToDoubleGB()");
        double d = Math.pow(10.0, 9.0);
        double d2 = Math.pow(2.0, 30.0);
        double d3 = l * 512L;
        BigDecimal bigDecimal = new BigDecimal(d3 /= bl ? NIConfigurationConstants.BYTES_IN_ONE_GB_BIN : NIConfigurationConstants.BYTES_IN_ONE_GB_DEC);
        int n = bl2 ? 1 : 4;
        bigDecimal = bigDecimal.setScale(1, n);
        d3 = bigDecimal.doubleValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("capacityInBlocks: " + l);
        stringBuffer.append(" binaryGB: " + bl);
        stringBuffer.append(" sizeInGB: " + d3);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "convertBlocksToDoubleGB()");
        return d3;
    }

    public long convertDoubleGBToBlocks(double d, boolean bl) {
        logger.enter(CLASS_NAME, "convertDoubleGBToBlocks()");
        double d2 = d * (bl ? NIConfigurationConstants.BYTES_IN_ONE_GB_BIN : NIConfigurationConstants.BYTES_IN_ONE_GB_DEC);
        long l = (long)d2;
        long l2 = l / 512L;
        l2 = (l2 + 64L - 1L) / 64L * 64L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sizeInGB: " + d);
        stringBuffer.append(" binaryGB: " + bl);
        stringBuffer.append(" capacityInBlocks: " + l2);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "convertDoubleGBToBlocks()");
        return l2;
    }

    protected long convertBinaryGBToExtents(double d, NIExtentType nIExtentType) {
        double d2 = 0.0;
        if (nIExtentType instanceof NIExtentTypeCKD) {
            d2 = 0.88104;
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            d2 = 1.0;
        }
        long l = (int)(d / d2);
        return l;
    }

    protected long convertBlocksToExtents(long l) {
        long l2 = (l + 128L - 1L) / 128L;
        long l3 = (l2 + 16384L - 1L) / 16384L;
        return l3;
    }

    public double convertExtentsToBinaryGB(long l, NIExtentType nIExtentType) {
        double d = 0.0;
        if (nIExtentType instanceof NIExtentTypeCKD) {
            d = 0.88104;
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            d = 1.0;
        }
        double d2 = (double)l * d;
        return d2;
    }

    public long convertExtentsToCylinders(long l) {
        long l2 = l * 1113L;
        return l2;
    }

    protected int convertExtentsToIntBinaryGB(long l, NIExtentType nIExtentType) {
        double d = 0.0;
        if (nIExtentType instanceof NIExtentTypeCKD) {
            d = 0.88104;
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            d = 1.0;
        }
        double d2 = (double)l * d;
        BigDecimal bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.setScale(0, 0);
        int n = bigDecimal.intValue();
        return n;
    }

    public boolean isVolumeSize2105Compatible(double d, boolean bl) {
        boolean bl2 = false;
        if (d <= 982.2 && d >= 0.1) {
            double d2 = d * (bl ? NIConfigurationConstants.BYTES_IN_ONE_GB_BIN : NIConfigurationConstants.BYTES_IN_ONE_GB_DEC);
            long l = (long)d2;
            long l2 = l / 512L;
            long l3 = 2L * ((l2 + 128L - 1L) / 128L);
            long l4 = (l2 + 64L - 1L) / 64L;
            bl2 = l3 == l4;
        }
        return bl2;
    }

    public boolean validateDecimalVolumeSize(double d) {
        boolean bl = true;
        double d2 = d * 10.0;
        int n = (int)d2;
        if (d > 982.2 || d < 0.1 || d2 != (double)n) {
            bl = false;
        }
        return bl;
    }

    public boolean validateBinaryVolumeSize(int n) {
        boolean bl = false;
        int[][] nArray = NIConfigurationConstants.BINARY_SIZE_BOUNDRIES;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n >= nArray[n2][0] && n <= nArray[n2][1] && n % nArray[n2][2] == 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public int roundUpBinaryVolumeSize(int n) {
        int n2 = 0;
        if (n > 2048) {
            n2 = 2048;
        } else if (n < 1) {
            n2 = 1;
        } else if (!this.validateBinaryVolumeSize(n)) {
            int[][] nArray = NIConfigurationConstants.BINARY_SIZE_BOUNDRIES;
            int n3 = 1;
            int n4 = 2;
            int n5 = 0;
            while (n5 < nArray.length) {
                if (n <= nArray[n5][n3]) {
                    n2 = n + (nArray[n5][n4] - n % nArray[n5][n4]);
                    break;
                }
                ++n5;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    public int roundUpBinaryVolumeSize(int n, int n2) {
        int n3 = 0;
        if (n > 2048) {
            n3 = 2048;
        } else if (n < 1) {
            n3 = 1;
        } else if (!this.validateBinaryVolumeSize(n)) {
            int[][] nArray = NIConfigurationConstants.BINARY_SIZE_BOUNDRIES;
            int n4 = 1;
            int n5 = 2;
            int n6 = 0;
            while (n6 < nArray.length) {
                if (n <= nArray[n6][n4]) {
                    n3 = n + (nArray[n6][n5] - n % nArray[n6][n5]);
                    if (n3 > n2) {
                        n3 -= nArray[n6][n5];
                    }
                    break;
                }
                ++n6;
            }
        } else {
            n3 = n;
        }
        return n3;
    }

    public NIIOAdapter[] getDefaultIOAdapters(String string, String string2, int n, int n2, int n3, int n4) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "getDefaultIOAdapters()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Machine Type: " + string);
        stringBuffer.append(" Model Number: " + string2);
        stringBuffer.append(" Num images: " + n);
        stringBuffer.append(" Num FCSW: " + n2);
        stringBuffer.append(" Num FCLW: " + n3);
        stringBuffer.append(" Num ESCON: " + n4);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        NIIOAdapter[] nIIOAdapterArray = nIConfigurationAdvisorStorageFacilityImage.getDefaultIOAdapters(string, string2, n, n2, n3, n4);
        logger.exit(CLASS_NAME, "getDefaultIOAdapters()");
        return nIIOAdapterArray;
    }

    public int[] getAvailableRacks(String string, String string2) {
        logger.enter(CLASS_NAME, "getAvailableRacks()");
        int[] nArray = null;
        if (string.equals("1750")) {
            nArray = NIConfigurationConstants.RACK_NUMBERS_1750;
        } else if (string.equals("2107")) {
            nArray = NIConfigurationConstants.RACK_NUMBERS_2107;
        }
        logger.exit(CLASS_NAME, "getAvailableRacks()");
        return nArray;
    }

    public int[] getAvailableIOAdapterEnclosures(String string, String string2) {
        logger.enter(CLASS_NAME, "getAvailableIOAdapterEnclosures()");
        int[] nArray = null;
        if (string.equals("1750")) {
            nArray = NIConfigurationConstants.ENCLOSURE_NUMBERS_1750;
        } else if (string.equals("2107")) {
            nArray = NIConfigurationConstants.ENCLOSURE_NUMBERS_2107;
        }
        logger.exit(CLASS_NAME, "getAvailableIOAdapterEnclosures()");
        return nArray;
    }

    public int[] getAvailableIOAdapterLocations(String string, String string2) {
        logger.enter(CLASS_NAME, "getAvailableIOAdapterLocations()");
        int[] nArray = null;
        if (string.equals("1750")) {
            nArray = NIConfigurationConstants.ADAPTER_LOCATIONS_1750;
        } else if (string.equals("2107")) {
            nArray = NIConfigurationConstants.ADAPTER_LOCATIONS_2107;
        }
        logger.exit(CLASS_NAME, "getAvailableIOAdapterLocations()");
        return nArray;
    }

    public NIIOPort[] getIOPorts(NIIOAdapter[] nIIOAdapterArray, String string, String string2, String string3, String string4, int n) {
        logger.enter(CLASS_NAME, "getIOPorts()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" machineType: " + string);
        stringBuffer.append(" model: " + string2);
        stringBuffer.append(" imgageNumber: " + n);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorStorageFacilityImage nIConfigurationAdvisorStorageFacilityImage = new NIConfigurationAdvisorStorageFacilityImage(this);
        NIIOPort[] nIIOPortArray = nIConfigurationAdvisorStorageFacilityImage.getIOPorts(nIIOAdapterArray, string, string2, string3, string4, n);
        logger.exit(CLASS_NAME, "getIOPorts()");
        return nIIOPortArray;
    }

    public NIVolumeSizeType getVolumeSizeType(NIVolume nIVolume) {
        NIVolumeSizeType nIVolumeSizeType = null;
        NIDataType nIDataType = nIVolume.getDataType();
        long l = nIVolume.getCapacity();
        if (nIDataType instanceof NIDataType3380 || nIDataType instanceof NIDataType3390) {
            nIVolumeSizeType = NIVolumeSizeTypeZSeries.Option;
        } else if (nIDataType instanceof NIDataTypeBlock520Protected) {
            nIVolumeSizeType = NIVolumeSizeTypeISeriesProtected.Option;
        } else if (nIDataType instanceof NIDataTypeBlock520Unprotected) {
            nIVolumeSizeType = NIVolumeSizeTypeISeriesUnprotected.Option;
        } else if (nIDataType instanceof NIDataTypeBlock512) {
            long l2;
            long l3;
            int n;
            nIVolumeSizeType = l % (long)NIConfigurationConstants.BLOCKS_IN_ONE_GB_BIN == 0L ? ((n = this.convertBlocksToGB(l, true)) == NIConfigurationConstants.DSESS_SIZE_457 || n == NIConfigurationConstants.DSESS_SIZE_914 ? NIVolumeSizeTypeDSESS.Option : NIVolumeSizeTypeDS.Option) : (l == (l3 = ((l2 = (l + 1L) * 512L / (long)NIConfigurationConstants.BYTES_PER_100_MB_DEC) * (long)NIConfigurationConstants.BYTES_PER_100_MB_DEC / 512L + 64L - 1L) / 64L * 64L) ? NIVolumeSizeTypeESS.Option : NIVolumeSizeTypeBlocks.Option);
        }
        return nIVolumeSizeType;
    }

    public boolean validateVolumeSizeDS(int n) {
        logger.enter(CLASS_NAME, "validateVolumeSizeDS()");
        boolean bl = true;
        if (n < 1 || n > 2048) {
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" volSize: " + n);
        stringBuffer.append(" valid result: " + bl);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "validateVolumeSizeDS()");
        return bl;
    }

    public boolean validateVolumeSizeESS(double d) {
        logger.enter(CLASS_NAME, "validateVolumeSizeESS()");
        boolean bl = true;
        double d2 = d * 10.0;
        int n = (int)d2;
        if (d > 982.2 || d < 0.1 || d2 != (double)n) {
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" volSize: " + d);
        stringBuffer.append(" valid result: " + bl);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "validateVolumeSizeESS()");
        return bl;
    }

    public boolean validateVolumeSizeBlocks(long l) {
        logger.enter(CLASS_NAME, "validateVolumeSizeBlocks()");
        boolean bl = true;
        if (l < 1L || l > 0x100000000L) {
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" blocks: " + l);
        stringBuffer.append(" valid result: " + bl);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "validateVolumeSizeBlocks()");
        return bl;
    }

    public double getMaxVolumeCapacity(NIExtentPool nIExtentPool, int n, NIVolumeSizeType nIVolumeSizeType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        logger.enter(CLASS_NAME, "getMaxVolumeSize()");
        if (nIExtentPool == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, NULL_PARAMETER);
        }
        if (!(nIVolumeSizeType instanceof NIVolumeSizeTypeDS || nIVolumeSizeType instanceof NIVolumeSizeTypeESS || nIVolumeSizeType instanceof NIVolumeSizeTypeBlocks)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeSizeType is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentPool is not instance of NIExtentTypeFB.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, INVALID_SEGMENT_TYPE);
        }
        NIConfigurationAdvisorOpenSystemVolumes nIConfigurationAdvisorOpenSystemVolumes = new NIConfigurationAdvisorOpenSystemVolumes(this);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ExtentPoolID: " + ((NIExtentPoolID)nIExtentPool.getID()).toString());
        stringBuffer.append(" VolQuantity: " + n);
        stringBuffer.append(" VolSizeType: " + nIVolumeSizeType);
        logger.debug_general(stringBuffer.toString());
        double d = nIConfigurationAdvisorOpenSystemVolumes.getMaxVolumeCapacity(nIExtentPool, n, nIVolumeSizeType);
        stringBuffer = new StringBuffer();
        stringBuffer.append("getMaxVolumeSize() return value: " + d);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "getMaxVolumeSize()");
        return d;
    }

    public boolean validateVolumeSize(double d, NIVolumeSizeType nIVolumeSizeType) throws NIParameterInvalidCAException {
        long l;
        int n;
        if (!(nIVolumeSizeType instanceof NIVolumeSizeTypeDS || nIVolumeSizeType instanceof NIVolumeSizeTypeESS || nIVolumeSizeType instanceof NIVolumeSizeTypeBlocks)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIVolumeSizeType is invalid.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeSizeType, INVALID_SEGMENT_TYPE);
        }
        boolean bl = nIVolumeSizeType instanceof NIVolumeSizeTypeDS ? ((double)(n = (int)d) == d ? this.validateVolumeSizeDS(n) : false) : (nIVolumeSizeType instanceof NIVolumeSizeTypeESS ? this.validateVolumeSizeESS(d) : ((double)(l = (long)d) == d ? this.validateVolumeSizeBlocks(l) : false));
        return bl;
    }

    public long convertVolumeSizeToBlocks(double d, NIVolumeSizeType nIVolumeSizeType) throws NIParameterInvalidCAException {
        boolean bl = this.validateVolumeSize(d, nIVolumeSizeType);
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The volume size is not valid for the corresponding VolumeSizeType.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIVolumeSizeType, INVALID_VOLUME_TYPE);
        }
        long l = 0L;
        l = nIVolumeSizeType instanceof NIVolumeSizeTypeDS ? (long)d * (long)NIConfigurationConstants.BLOCKS_IN_ONE_GB_BIN : (nIVolumeSizeType instanceof NIVolumeSizeTypeESS ? ((long)(d * NIConfigurationConstants.BYTES_IN_ONE_GB_DEC) / 512L + 64L - 1L) / 64L * 64L : (long)d);
        return Math.abs(l);
    }

    public NIIOAdapter[] getInstalledIOAdapters(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        logger.enter(CLASS_NAME, "getInstalledIOAdapters()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Facility: " + nIStorageFacility);
        logger.debug_general(stringBuffer.toString());
        NIConfigurationAdvisorStorageFacility nIConfigurationAdvisorStorageFacility = new NIConfigurationAdvisorStorageFacility(this);
        NIIOAdapter[] nIIOAdapterArray = nIConfigurationAdvisorStorageFacility.getInstalledIOAdapters(nIStorageFacility);
        logger.exit(CLASS_NAME, "getInstalledIOAdapters()");
        return nIIOAdapterArray;
    }

    public List getExpressOrderedArraysToCreate(List list) {
        logger.enter(CLASS_NAME, "getExpressOrderedArraysToCreate()");
        List<NIExpressArray> list2 = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            NIExtentPoolData nIExtentPoolData = (NIExtentPoolData)list.get(n);
            List list3 = nIExtentPoolData.getFutureArraysForExtentPoolData();
            if (!nIExtentPoolData.isExisting() && list3 != null) {
                int n2 = 0;
                while (n2 < list3.size()) {
                    NIExpressArray nIExpressArray = (NIExpressArray)list3.get(n2);
                    nIExpressArray.setExtentPoolID(nIExtentPoolData.getExtentPoolID());
                    list2.add(nIExpressArray);
                    ++n2;
                }
            }
            ++n;
        }
        list2 = this.sortByArraySiteNumber(list2);
        logger.exit(CLASS_NAME, "getExpressOrderedArraysToCreate()");
        return list2;
    }

    protected List sortByArraySiteNumber(List list) {
        logger.enter(CLASS_NAME, "sortByArraySiteNumber()");
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIExpressArray nIExpressArray = (NIExpressArray)object;
                NIExpressArray nIExpressArray2 = (NIExpressArray)object2;
                NIArraySiteID nIArraySiteID = nIExpressArray.getArray().getArraySites()[0];
                NIArraySiteID nIArraySiteID2 = nIExpressArray2.getArray().getArraySites()[0];
                if (nIArraySiteID.getArraySiteNumber() > nIArraySiteID2.getArraySiteNumber()) {
                    n = 1;
                } else if (nIArraySiteID.getArraySiteNumber() < nIArraySiteID2.getArraySiteNumber()) {
                    n = -1;
                }
                return n;
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        Collections.sort(list, comparator);
        logger.exit(CLASS_NAME, "sortByArraySiteNumber()");
        return list;
    }

    protected List sortArraySiteByNumber(List list) {
        logger.enter(CLASS_NAME, "sortArraySiteByNumber()");
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIArraySite nIArraySite = (NIArraySite)object;
                NIArraySite nIArraySite2 = (NIArraySite)object2;
                NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySite.getID();
                NIArraySiteID nIArraySiteID2 = (NIArraySiteID)nIArraySite2.getID();
                if (nIArraySiteID.getArraySiteNumber() > nIArraySiteID2.getArraySiteNumber()) {
                    n = 1;
                } else if (nIArraySiteID.getArraySiteNumber() < nIArraySiteID2.getArraySiteNumber()) {
                    n = -1;
                }
                return n;
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        Collections.sort(list, comparator);
        logger.exit(CLASS_NAME, "sortArraySiteByNumber()");
        return list;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

