/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIAvailableLSS;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExpressCommon;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorZSeriesVolumes;
import com.ibm.storage.ess.ni.ca.NIExpressArray;
import com.ibm.storage.ess.ni.ca.NIExtentPoolData;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicy;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySequential;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySpread;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3380Mod2;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3380Mod3;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3390Custom;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3390Mod3;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3390Mod9;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorExpressZSeriesVolumes {
    public static int USE_ALL_AVAILABLE_LCUS = -1;
    private static String SHORT_SSID = "Not enough valid SSIDs to create LCU";
    private static String NO_LCU = "LCU quantity must be greater than zero for sequential.";
    private static String INSUFFICIENT_LCU = "There must be no more than256 volumes per LCU.";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorExpressZSeriesVolumes.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private NIConfigurationAdvisor ca = null;
    private NILogicalConfigurationService logicalService = null;
    private NIDomainService domainService = null;
    private NIConfigurationAdvisorExtentPool caExtentPool = null;
    private static final NICKDVolumeType[] ckdVolumeTypes = new NICKDVolumeType[]{NICKDVolumeType3380Mod2.Option, NICKDVolumeType3380Mod3.Option, NICKDVolumeType3390Mod3.Option, NICKDVolumeType3390Mod9.Option};
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorExpressZSeriesVolumes(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
        this.domainService = this.ca.getDomainService();
        this.caExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
    }

    protected List getExpressAvailableLCUs(NIExtentPoolData[] nIExtentPoolDataArray, NILSS[] nILSSArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        boolean[] blArray = new boolean[32];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < nIExtentPoolDataArray.length) {
            if (nIExtentPoolDataArray[n].getRankGroup() == 0) {
                bl2 = true;
            } else if (nIExtentPoolDataArray[n].getRankGroup() == 1) {
                bl3 = true;
            }
            if (bl2 && bl3) break;
            ++n;
        }
        n = 0;
        while (n < blArray.length) {
            if (n % 2 == 0 && !bl2 || n % 2 == 1 && !bl3) {
                blArray[n] = true;
            }
            ++n;
        }
        if (nILSSArray != null) {
            n = 0;
            while (n < nILSSArray.length) {
                int n2 = ((NILSSID)nILSSArray[n].getID()).getLSSNumber();
                if (!blArray[n2]) {
                    if (nILSSArray[n].getDeviceType() instanceof NIDeviceTypeFB) {
                        int n3 = n2 / 16;
                        int n4 = n3 *= 16;
                        while (n4 < 16) {
                            blArray[n4] = true;
                            ++n4;
                        }
                    } else {
                        blArray[n2] = true;
                    }
                }
                ++n;
            }
        }
        Vector<NIAvailableLSS> vector = new Vector<NIAvailableLSS>();
        n = 0;
        while (n < blArray.length) {
            if (!blArray[n]) {
                vector.add(new NIAvailableLSS(n));
            }
            ++n;
        }
        if (vector.size() > 0) {
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NIAvailableLSS nIAvailableLSS = (NIAvailableLSS)object;
                    NIAvailableLSS nIAvailableLSS2 = (NIAvailableLSS)object2;
                    int n2 = nIAvailableLSS.getLssAddress();
                    int n3 = nIAvailableLSS2.getLssAddress();
                    n = n2 - n3;
                    return n;
                }
            });
        }
        return vector;
    }

    protected int getExpressCKDAvailableAddresses(NIExtentPoolData[] nIExtentPoolDataArray, NILSS[] nILSSArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        int n = 0;
        List list = this.getExpressAvailableLCUs(nIExtentPoolDataArray, nILSSArray);
        if (list != null) {
            n = list.size() * 256;
        }
        return n;
    }

    protected int getExpressMaxCkdVolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, NIAvailableLSS[] nIAvailableLSSArray, NICKDVolumeType nICKDVolumeType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n = 0;
        long l = nICKDVolumeType.getStorageCylinder();
        long l2 = (l + 1113L - 1L) / 1113L;
        if (l2 < 1L) {
            l2 = 1L;
        }
        long l3 = this.ca.convertBinaryGBToExtents(d, NIExtentTypeCKD.Option);
        int n2 = (int)(l3 / l2);
        if (l3 < l2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("requested Capacity: " + l3 + " volume size:" + l2);
            stringBuffer.append(" Volume Capacity > Requested Capacity: Returning 0");
            logger.debug_general(stringBuffer.toString());
            return 0;
        }
        int[] nArray = new int[]{this.getMaxAvailableCKDVolume(nIAvailableLSSArray, 0), this.getMaxAvailableCKDVolume(nIAvailableLSSArray, 1)};
        int n3 = nIExtentPoolDataArray.length;
        int n4 = 0;
        while (n4 < n3) {
            NIExtentPoolData nIExtentPoolData = nIExtentPoolDataArray[n4];
            NIExtentPool nIExtentPool = nIExtentPoolData.getExtentPool();
            int n5 = nIExtentPoolData.getRankGroup();
            long l4 = nIExtentPoolData.getNumExtents() / l2;
            if (l4 > (long)nArray[n5]) {
                l4 = nArray[n5];
            }
            int n6 = n5;
            nArray[n6] = (int)((long)nArray[n6] - l4);
            n = (int)((long)n + l4);
            ++n4;
        }
        if (n > n2 && n2 > 0) {
            n = n2;
        }
        return n;
    }

    private int getMaxAvailableCKDVolume(NIAvailableLSS[] nIAvailableLSSArray, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < nIAvailableLSSArray.length) {
            NIAvailableLSS nIAvailableLSS = nIAvailableLSSArray[n3];
            int n4 = nIAvailableLSS.getLssAddress();
            if (n4 % 2 == 0 && n == 0 || n4 % 2 == 1 && n == 1) {
                n2 += nIAvailableLSS.getNumberOfAvailableDevices();
            }
            ++n3;
        }
        return n2;
    }

    protected static int getExpressTotalStorageGB(NIExtentPoolData[] nIExtentPoolDataArray, int n, NICKDVolumeType nICKDVolumeType) {
        int n2 = NIConfigurationAdvisorZSeriesVolumes.getVolSize(nICKDVolumeType);
        long l = (n2 + 1113 - 1) / 1113;
        double d = (double)(l * (long)n) * 0.88104;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(0, 0);
        int n3 = bigDecimal.intValue();
        return n3;
    }

    protected static int getMaxAliasesPerBase(NIAvailableLSS[] nIAvailableLSSArray, int n, int n2) {
        int n3 = n2 == USE_ALL_AVAILABLE_LCUS ? nIAvailableLSSArray.length : n2;
        int n4 = n3 * 256 - n;
        return n4 / n;
    }

    protected List getExpressFutureCkdVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, NIAvailableLSS[] nIAvailableLSSArray, int n, int n2, NICKDAddressPolicy nICKDAddressPolicy, int n3, int n4, boolean bl, String string, String string2, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        int n7 = 0;
        ArrayList<NIVolume> arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        NIDataType nIDataType = null;
        NIExtentPoolID nIExtentPoolID = null;
        NIExtentPoolData nIExtentPoolData = null;
        NIVolume nIVolume = null;
        NIVolumeID nIVolumeID = null;
        String string3 = "";
        if (nICKDAddressPolicy == null) {
            nICKDAddressPolicy = NICKDAddressPolicySequential.Option;
        }
        if (bl) {
            if (string2 != null && !string2.equals("")) {
                try {
                    n5 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bl2) {
                arrayList2 = this.getVolumeNames(nIESSID);
            }
        }
        if (nICKDVolumeType instanceof NICKDVolumeType3380Mod2 || nICKDVolumeType instanceof NICKDVolumeType3380Mod3) {
            nIDataType = NIDataType3380.Option;
        } else if (nICKDVolumeType instanceof NICKDVolumeType3390Mod3 || nICKDVolumeType instanceof NICKDVolumeType3390Mod9 || nICKDVolumeType instanceof NICKDVolumeType3390Custom) {
            nIDataType = NIDataType3390.Option;
        }
        long l = nICKDVolumeType.getStorageCylinder();
        long l2 = (l + 1113L - 1L) / 1113L;
        if (l2 < 1L) {
            l2 = 1L;
        }
        ArrayList<NIAvailableLSS> arrayList3 = new ArrayList<NIAvailableLSS>();
        int n8 = 0;
        while (n8 < nIAvailableLSSArray.length) {
            if (nIAvailableLSSArray[n8].getLssAddress() >= n3) {
                arrayList3.add(nIAvailableLSSArray[n8]);
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < nIAvailableLSSArray.length) {
            if (nIAvailableLSSArray[n8].getLssAddress() < n3) {
                arrayList3.add(nIAvailableLSSArray[n8]);
            }
            ++n8;
        }
        nIAvailableLSSArray = arrayList3.toArray(new NIAvailableLSS[0]);
        n4 = Math.min(n4, nIAvailableLSSArray.length);
        int n9 = n * n2;
        int n10 = n + n9;
        if (nICKDAddressPolicy instanceof NICKDAddressPolicySpread) {
            if (n4 < 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(NO_LCU);
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException(new Integer(n4));
            }
            if (n10 / n4 > 256) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(INSUFFICIENT_LCU);
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException(new Integer(n4));
            }
            n6 = n10 / n4;
            n7 = n10 % n4;
        } else if (nICKDAddressPolicy instanceof NICKDAddressPolicySequential) {
            n6 = 256;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Null Parameter");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDAddressPolicy);
        }
        int n11 = 0;
        while (n11 < nIExtentPoolDataArray.length) {
            nIExtentPoolData = nIExtentPoolDataArray[n11];
            nIExtentPoolData.setNumVolumeExtents(0L);
            ++n11;
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        boolean bl4 = false;
        long l3 = 0L;
        boolean bl5 = false;
        arrayList = new ArrayList<NIVolume>();
        int n15 = nICKDVolumeType.getMTMValue();
        int n16 = 0;
        n8 = 0;
        while (n8 < nIAvailableLSSArray.length && !bl4) {
            block35: {
                int n17;
                int n18 = nIAvailableLSSArray[n8].getLssAddress();
                n16 = nICKDAddressPolicy instanceof NICKDAddressPolicySequential || nICKDAddressPolicy instanceof NICKDAddressPolicySpread && n8 >= n7 ? n6 : n6 + 1;
                int n19 = 0;
                n11 = 0;
                while (n11 < nIExtentPoolDataArray.length) {
                    nIExtentPoolData = nIExtentPoolDataArray[n11];
                    n17 = nIExtentPoolData.getRankGroup();
                    if (!(n18 % 2 == 0 && n17 == 1 || n18 % 2 == 1 && n17 == 0 || (l3 = nIExtentPoolData.getNumExtents() - nIExtentPoolData.getNumVolumeExtents()) < l2)) break;
                    ++n11;
                }
                if (n11 >= nIExtentPoolDataArray.length) break block35;
                n11 = 0;
                while (n11 < n16 && !bl4) {
                    block37: {
                        block36: {
                            if (l3 >= l2) break block36;
                            int n20 = 0;
                            while (n20 < nIExtentPoolDataArray.length) {
                                nIExtentPoolData = nIExtentPoolDataArray[n20];
                                n17 = nIExtentPoolData.getRankGroup();
                                if (!(n18 % 2 == 0 && n17 == 1 || n18 % 2 == 1 && n17 == 0 || (l3 = nIExtentPoolData.getNumExtents() - nIExtentPoolData.getNumVolumeExtents()) < l2)) break;
                                ++n20;
                            }
                            if (n20 >= nIExtentPoolDataArray.length) break block37;
                        }
                        nIExtentPoolID = nIExtentPoolData.getExtentPoolID();
                        if (bl && arrayList2.contains(string3 = string2 != null && !string2.equals("") ? string + this.ca.padding(n5, string2.length(), bl3) : string)) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("Volume Nickname is not unique");
                            logger.debug_general(stringBuffer.toString());
                            throw new NIParameterInvalidCAException((Object)string3, "Volume Nickname is not unique");
                        }
                        if (n13 < n) {
                            nIVolume = new NIVolumeImpl(new NIVolumeID(new NILSSID(nIESSID, n18), n19), string3, null, null, null, nIExtentPoolID, false, NIVolumeTypeCKDBase.Option, nIDataType, l, n15, 0, 0, 0);
                            ++n13;
                            l3 -= l2;
                            nIExtentPoolData.addNumVolumeExtents(l2);
                            nIExtentPoolData.addFutureVolume(nIVolume);
                        } else if (n12 < n9) {
                            nIVolume = NIResourceFactory.newVolume(new NILSSID(nIESSID, n18), n19, nIVolumeID, NIVolumeTypeCKDCrossCUAlias.Option, string3);
                            if (++n12 % n2 == 0) {
                                nIVolumeID = (NIVolumeID)((NIVolume)arrayList.get(++n14)).getID();
                            }
                        } else {
                            bl4 = true;
                            break;
                        }
                        arrayList.add(nIVolume);
                        ++n5;
                        ++n19;
                    }
                    ++n11;
                }
                if (bl4) break;
            }
            ++n8;
        }
        return arrayList;
    }

    private ArrayList getVolumeNames(NIESSID nIESSID) throws NIQueryFailureCAException {
        int n;
        ArrayList<String> arrayList;
        ArrayList arrayList2;
        block9: {
            arrayList2 = new ArrayList();
            NIConfigQueryResult nIConfigQueryResult = null;
            NIConfigQueryResult nIConfigQueryResult2 = null;
            try {
                nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID);
                if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                    arrayList = nIConfigQueryResult.getResourceList();
                    arrayList2 = new ArrayList();
                    n = arrayList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        block8: {
                            NILSS nILSS = (NILSS)arrayList.get(n2);
                            try {
                                Object object;
                                nIConfigQueryResult2 = this.logicalService.getVolumes((NILSSID)nILSS.getID());
                                if (nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
                                    object = nIConfigQueryResult2.getResourceList();
                                    arrayList2.addAll(object);
                                    break block8;
                                }
                                object = new StringBuffer();
                                ((StringBuffer)object).append("Query Failure");
                                logger.debug_general(((StringBuffer)object).toString());
                                throw new NIQueryFailureCAException();
                            }
                            catch (Exception exception) {
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(exception.toString());
                                logger.debug_general(stringBuffer.toString());
                                throw new NIQueryFailureCAException();
                            }
                        }
                        ++n2;
                    }
                    break block9;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure");
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(exception.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException();
            }
        }
        arrayList = new ArrayList<String>();
        n = 0;
        while (n < arrayList2.size()) {
            NIVolume nIVolume = (NIVolume)arrayList2.get(n);
            arrayList.add(nIVolume.getUserName());
            ++n;
        }
        return arrayList;
    }

    protected List getExpressFutureLcus(NIESSID nIESSID, NIVolume[] nIVolumeArray, NIAvailableLSS[] nIAvailableLSSArray, int n, int n2, NICKDBaseCUType nICKDBaseCUType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NILSSID[] nILSSIDArray = new NILSSID[32];
        NIStorageFacilityID nIStorageFacilityID = nIESSID.getStorageFacility();
        int n3 = n2;
        int[] nArray = this.ca.getNextAvailableSSID(nIStorageFacilityID, nILSSIDArray.length, n2);
        if (nArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure - " + SHORT_SSID);
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException();
        }
        int n4 = 0;
        while (n4 < nIVolumeArray.length) {
            NILSSID nILSSID;
            nILSSIDArray[nILSSID.getLSSNumber()] = nILSSID = ((NIVolumeID)nIVolumeArray[n4].getID()).getLSS();
            ++n4;
        }
        ArrayList<NILSS> arrayList = new ArrayList<NILSS>(nILSSIDArray.length);
        int n5 = 0;
        n4 = 0;
        while (n4 < nILSSIDArray.length) {
            if (nILSSIDArray[n4] != null) {
                NILSS nILSS = NIResourceFactory.newLSS(nIESSID, nILSSIDArray[n4].getLSSNumber(), nArray[n5], NIDeviceTypeCKD.Option, nICKDBaseCUType);
                arrayList.add(nILSS);
                ++n5;
            }
            ++n4;
        }
        return arrayList;
    }

    protected List getExpressUpdatedExtentPools(NIExtentPoolData[] nIExtentPoolDataArray, NIAvailableLSS[] nIAvailableLSSArray, int n, NICKDVolumeType nICKDVolumeType) {
        Vector<NIExtentPoolData> vector = new Vector<NIExtentPoolData>();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        List list = new Vector();
        Vector vector4 = new Vector();
        Vector<NIResourceID> vector5 = new Vector<NIResourceID>();
        NIESS nIESS = null;
        long l = 0L;
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIExtentPoolDataArray[0].getExtentPoolID().getESS()}).getResourceList().get(0);
            list = this.logicalService.getRanks(nIExtentPoolDataArray[0].getExtentPoolID().getESS()).getResourceList();
        }
        catch (Exception exception) {
            logger.debug_general("exception getting ranks");
            exception.printStackTrace();
        }
        int n2 = 0;
        while (n2 < list.size()) {
            vector5.add(((NIRank)list.get(n2)).getID());
            ++n2;
        }
        int n3 = 0;
        while (n3 < nIExtentPoolDataArray.length) {
            NIExtentPoolData nIExtentPoolData = nIExtentPoolDataArray[n3];
            long l2 = !nIExtentPoolDataArray[n3].isExisting() ? nIExtentPoolData.getNumVolumeExtents() : 0L;
            long l3 = 0L;
            Vector<Serializable> vector6 = new Vector<Serializable>();
            Vector<Serializable> vector7 = new Vector<Serializable>();
            Vector<Serializable> vector8 = new Vector<Serializable>();
            Vector vector9 = new Vector();
            if (l2 > 0L) {
                Serializable serializable;
                int n4;
                if (l2 > l3) {
                    n4 = 0;
                    while (n4 < nIExtentPoolData.getFutureArraysForExtentPoolData().size()) {
                        serializable = (NIExpressArray)nIExtentPoolData.getFutureArraysForExtentPoolData().get(n4);
                        logger.debug_general("Array:" + ((NIExpressArray)serializable).getArray().toString() + "  Extents:" + ((NIExpressArray)serializable).getEffectiveCapacity());
                        vector7.add(serializable);
                        if (l2 <= (l3 += (long)((NIExpressArray)serializable).getEffectiveCapacity())) break;
                        ++n4;
                    }
                }
                if (l2 > l3) {
                    n4 = 0;
                    while (n4 < nIExtentPoolData.getFutureRanksForExtentPoolData().size()) {
                        serializable = (NIRank)nIExtentPoolData.getFutureRanksForExtentPoolData().get(n4);
                        List list2 = null;
                        try {
                            list2 = this.logicalService.getArrays(serializable.getArrayIDs()).getResourceList();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        int n5 = 0;
                        while (n5 < list2.size()) {
                            NIArray nIArray = (NIArray)list2.get(n5);
                            NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this.ca);
                            l3 += (long)nIConfigurationAdvisorExpressCommon.getArrayCapacity(nIArray, "1750", nIExtentPoolData.getExtentPool().getExtentType(), false);
                            ++n5;
                        }
                        if (vector5.contains(serializable.getID())) {
                            vector8.add(serializable);
                        } else {
                            vector6.add(serializable);
                        }
                        if (l2 <= l3) break;
                        ++n4;
                    }
                }
                nIExtentPoolData.setExistingRanks(vector8);
                nIExtentPoolData.setFutureRanksForExtentPoolData(vector6);
                nIExtentPoolData.setFutureArraysForExtentPoolData(vector7);
            }
            if (nIExtentPoolData.getNumVolumeExtents() != 0L) {
                vector.add(nIExtentPoolData);
            }
            ++n3;
        }
        int n6 = 0;
        while (n6 < vector.size()) {
            NIExtentPoolData nIExtentPoolData = (NIExtentPoolData)vector.get(n6);
            logger.debug_general("Pool[" + n6 + "] " + "existingRanks:" + nIExtentPoolData.getExistingRanks().size() + " futureRanks:" + nIExtentPoolData.getFutureRanksForExtentPoolData().size() + " futureArrays:" + nIExtentPoolData.getFutureArraysForExtentPoolData().size());
            ++n6;
        }
        return vector;
    }

    private List getCompatibleLCUs(NILSS[] nILSSArray) {
        Vector<NILSS> vector = new Vector<NILSS>();
        int n = nILSSArray.length;
        int n2 = 0;
        while (n2 < nILSSArray.length) {
            NILSS nILSS = nILSSArray[n2];
            if (nILSS.getDeviceType() instanceof NIDeviceTypeCKD) {
                vector.add(nILSS);
            }
            ++n2;
        }
        return vector;
    }

    protected List getExpressCkdVolumeTypeList() {
        Vector<NICKDVolumeType> vector = new Vector<NICKDVolumeType>(Arrays.asList(ckdVolumeTypes));
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

