/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU;
import com.ibm.storage.ess.ni.application.results.NIExtentAvailabilityResult;
import com.ibm.storage.ess.ni.ca.NIAvailableSite;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorArray;
import com.ibm.storage.ess.ni.ca.NIExtentPoolClientData;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIMachineTypeModel;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorExtentPool {
    private static final NIExtentType[] storageType = new NIExtentType[]{NIExtentTypeFB.Option, NIExtentTypeCKD.Option};
    private static final String CLASS_NAME = "NIConfigurationAdvisorExtentPool";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorExtentPool.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private NIConfigurationAdvisor ca = null;
    private NIConfigurationAdvisorArray caarray = null;
    private NIPhysicalConfigurationService physicalService = null;
    private NILogicalConfigurationService logicalService = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorExtentPool(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
        this.physicalService = this.ca.getPhysicalService();
        this.caarray = new NIConfigurationAdvisorArray(this.ca);
    }

    protected Hashtable createDAPairTableForArrays(NIArray[] nIArrayArray, int n) {
        int n2;
        Hashtable<Integer, Vector> hashtable = new Hashtable<Integer, Vector>(2);
        Vector vector = null;
        int n3 = 0;
        while (n3 < n) {
            vector = new Vector();
            hashtable.put(new Integer(n3), vector);
            ++n3;
        }
        int n4 = 0;
        while (n4 < nIArrayArray.length) {
            NIArray nIArray = nIArrayArray[n4];
            if (nIArray != null && (n2 = nIArray.getDeviceAdapterPairID()) < n) {
                vector = (Vector)hashtable.get(new Integer(n2));
                vector.add(nIArray);
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            vector = (Vector)hashtable.get(new Integer(n5));
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NIArray nIArray = (NIArray)object;
                    NIArray nIArray2 = (NIArray)object2;
                    int n2 = ((NIArrayID)nIArray.getID()).getArrayNumber();
                    int n3 = ((NIArrayID)nIArray2.getID()).getArrayNumber();
                    n = n2 - n3;
                    return n;
                }
            });
            ++n5;
        }
        n2 = 0;
        while (n2 < n) {
            vector = (Vector)hashtable.get(new Integer(n2));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("createDAPairTableForArrays: DA pair " + n2 + " contains " + vector.size() + " arrays");
            logger.debug_general(stringBuffer.toString());
            ++n2;
        }
        return hashtable;
    }

    private Hashtable createDAPairTableForRanks(NIArray[] nIArrayArray, NIRank[] nIRankArray, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        Serializable serializable;
        Hashtable<Integer, Vector> hashtable = new Hashtable<Integer, Vector>(2);
        Vector vector = null;
        int n2 = 0;
        while (n2 < n) {
            vector = new Vector();
            hashtable.put(new Integer(n2), vector);
            ++n2;
        }
        int n3 = 0;
        while (n3 < nIRankArray.length) {
            NIRank nIRank = nIRankArray[n3];
            if (nIRank != null) {
                NIArrayID[] nIArrayIDArray = nIRank.getArrayIDs();
                serializable = new Vector();
                int n4 = 0;
                while (n4 < nIArrayIDArray.length) {
                    int n5 = 0;
                    while (n5 < nIArrayArray.length) {
                        NIArrayID nIArrayID = (NIArrayID)nIArrayArray[n5].getID();
                        if (nIArrayID.equals(nIArrayIDArray[n4])) {
                            ((Vector)serializable).add(nIArrayArray[n5]);
                            break;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                if (((Vector)serializable).size() == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Query Failure array not found for ID " + nIArrayIDArray[0]);
                    logger.debug_general(stringBuffer.toString());
                    throw new NIQueryFailureCAException(stringBuffer.toString());
                }
                NIArray nIArray = (NIArray)((Vector)serializable).get(0);
                int n6 = nIArray.getDeviceAdapterPairID();
                if (n6 < n) {
                    vector = (Vector)hashtable.get(new Integer(n6));
                    vector.add(nIRank);
                }
            }
            ++n3;
        }
        int n7 = 0;
        while (n7 < n) {
            vector = (Vector)hashtable.get(new Integer(n7));
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NIRank nIRank = (NIRank)object;
                    NIRank nIRank2 = (NIRank)object2;
                    int n2 = ((NIRankID)nIRank.getID()).getRankNumber();
                    int n3 = ((NIRankID)nIRank2.getID()).getRankNumber();
                    n = n2 - n3;
                    return n;
                }
            });
            ++n7;
        }
        int n8 = 0;
        while (n8 < n) {
            vector = (Vector)hashtable.get(new Integer(n8));
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("createDAPairTableForRanks: DA pair " + n8 + " contains " + vector.size() + " Ranks");
            logger.debug_general(((StringBuffer)serializable).toString());
            ++n8;
        }
        return hashtable;
    }

    protected double getAvailableRawStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        double d = 0.0;
        d = this.getTotalRawStorageGB(nIExtentPool) - this.getUsedAndReservedStorageGB(nIExtentPool);
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    protected long getAvailableStorageCylinder(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        int n = 0;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumAvailableExtents();
        if (n < 0) {
            n = 0;
        }
        long l = n * 1113;
        return l;
    }

    protected double getAvailableStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentType nIExtentType = nIExtentPool.getExtentType();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        int n = 0;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumAvailableExtents();
        if (n < 0) {
            n = 0;
        }
        double d = this.ca.convertExtentsToBinaryGB(n, nIExtentType);
        return d;
    }

    protected int getAvailableExtents(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        int n = 0;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumAvailableExtents();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected double getAvailableStorageGBForFutureExtentPool(NIESS nIESS, NIExtentType nIExtentType, NIRaidType nIRaidType, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        List list;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n = nIMachineTypeModel.getMaxDAPairs();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        Object var11_11 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        long l = 0L;
        NIArraySite[] nIArraySiteArray = this.ca.getImageArraySites(nIESSID);
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.ca.getImageDDMs(nIESSID);
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        if (bl) {
            list = this.getExistingRanksForExtentPool(nIESS, null, nIExtentType, nIRaidType, -1L, nIArrayArray, nIRankArray, false);
            n2 = list.size();
            int n4 = 0;
            while (n4 < n2) {
                l += ((NIRank)list.get(n4)).getNumExtents();
                ++n4;
            }
            List list2 = this.getExistingArraysForExtentPool(nIESSID, nIExtentType, nIRaidType, -1L, n, nIArrayArray);
            n3 = list2.size();
            int n5 = 0;
            while (n5 < n3) {
                l += this.caarray.getArrayExtents((NIArray)list2.get(n5), nIExtentType);
                ++n5;
            }
        }
        list = this.ca.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
        NIArraySite[] nIArraySiteArray2 = list.toArray(new NIArraySite[0]);
        int n6 = nIArraySiteArray2.length;
        NIAvailableSite[] nIAvailableSiteArray = new NIAvailableSite[n6];
        int n7 = 0;
        while (n7 < n6) {
            nIAvailableSiteArray[n7] = new NIAvailableSite(nIArraySiteArray2[n7]);
            ++n7;
        }
        nIAvailableSiteArray = this.getFutureArrayCapacities(nIESSID, nIRaidType, nIExtentType, nIAvailableSiteArray, nIArrayArray, n);
        int n8 = 0;
        while (n8 < n6) {
            l += (long)nIAvailableSiteArray[n8].getEffectiveCapacity();
            ++n8;
        }
        double d = this.ca.convertExtentsToBinaryGB(l, nIExtentType);
        return d;
    }

    protected List getExistingArraysForExtentPool(NIESSID nIESSID, NIExtentType nIExtentType, NIRaidType nIRaidType, long l, int n, NIArray[] nIArrayArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Serializable serializable;
        int n2;
        int n3;
        long l2 = 0L;
        Vector<NIArray> vector = new Vector<NIArray>(1, 1);
        Hashtable hashtable = this.createDAPairTableForArrays(nIArrayArray, n);
        if (hashtable != null && hashtable.size() > 0) {
            int n4 = 0;
            n3 = 0;
            while (n3 < n) {
                Vector vector2 = (Vector)hashtable.get(new Integer(n3));
                if (vector2.size() > n4) {
                    n4 = vector2.size();
                }
                ++n3;
            }
            n2 = 0;
            while (n2 < n4 && (l2 < l || l == -1L)) {
                int n5 = 0;
                while (n5 < n && (l2 < l || l == -1L)) {
                    NIArray nIArray;
                    serializable = (Vector)hashtable.get(new Integer(n5));
                    if (serializable != null && ((Vector)serializable).size() > n2 && (nIArray = (NIArray)((Vector)serializable).elementAt(n2)).getArrayStatus() == 1 && nIArray.getRaidType().equals(nIRaidType)) {
                        l2 += this.caarray.getArrayExtents(nIArray, nIExtentType);
                        vector.add(nIArray);
                    }
                    ++n5;
                }
                ++n2;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = vector.size();
        stringBuffer.append("getExistingArraysForExtentPool() return value: " + n3 + " arrays, total extents: " + l2);
        logger.debug_general(stringBuffer.toString());
        n2 = 0;
        while (n2 < n3) {
            NIArray nIArray = (NIArray)vector.get(n2);
            serializable = (NIArrayID)nIArray.getID();
            stringBuffer = new StringBuffer();
            stringBuffer.append("getExistingArraysForExtentPool() array[" + n2 + "]: " + ((NIArrayID)serializable).toString() + ", extents: " + this.caarray.getArrayExtents(nIArray, nIExtentType));
            logger.debug_general(stringBuffer.toString());
            ++n2;
        }
        return vector;
    }

    protected List getExistingRanksForExtentPool(NIESS nIESS, NIExtentPoolID nIExtentPoolID, NIExtentType nIExtentType, NIRaidType nIRaidType, long l, NIArray[] nIArrayArray, NIRank[] nIRankArray, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESS.toString());
        if (nIExtentPoolID != null) {
            stringBuffer.append(" ExtentPool: " + nIExtentPoolID.toString());
        }
        stringBuffer.append(" ExtentType: " + nIExtentType.toString());
        stringBuffer.append(" RaidType: " + nIRaidType.toString());
        stringBuffer.append(" Extents: " + l);
        stringBuffer.append(" Number of existing arrays: " + nIArrayArray.length);
        stringBuffer.append(" Number of existing ranks: " + nIRankArray.length);
        stringBuffer.append(" ExpressConfig: " + bl);
        logger.debug_general(stringBuffer.toString());
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n3 = nIMachineTypeModel.getMaxDAPairs();
        int n4 = 0;
        Vector<NIRank> vector = new Vector<NIRank>(1, 1);
        Hashtable hashtable = this.createDAPairTableForRanks(nIArrayArray, nIRankArray, n3);
        if (hashtable != null && hashtable.size() > 0) {
            n2 = 0;
            n = 0;
            while (n < n3) {
                Vector vector2 = (Vector)hashtable.get(new Integer(n));
                if (vector2.size() > n2) {
                    n2 = vector2.size();
                }
                ++n;
            }
            int n5 = 0;
            while (n5 < n2 && ((long)n4 < l || l == -1L)) {
                int n6 = 0;
                while (n6 < n3 && ((long)n4 < l || l == -1L)) {
                    NIRank nIRank;
                    Vector vector3 = (Vector)hashtable.get(new Integer(n6));
                    if (vector3 != null && vector3.size() > n5 && ((nIRank = (NIRank)vector3.elementAt(n5)).getConfigurationState() == 2 && nIRank.getRAIDType().equals(nIRaidType) && nIRank.getExtentType().equals(nIExtentType) || !bl && nIRank.getConfigurationState() == 0 && nIRank.getExtentPoolID().equals(nIExtentPoolID))) {
                        n4 = (int)((long)n4 + nIRank.getNumExtents());
                        vector.add(nIRank);
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        stringBuffer = new StringBuffer();
        n2 = vector.size();
        stringBuffer.append("getExistingRanksForExtentPool() return value: " + n2 + " ranks, total extents: " + n4);
        logger.debug_general(stringBuffer.toString());
        n = 0;
        while (n < n2) {
            NIRank nIRank = (NIRank)vector.get(n);
            NIRankID nIRankID = (NIRankID)nIRank.getID();
            stringBuffer = new StringBuffer();
            stringBuffer.append("getExistingRanksForExtentPool() rank[" + n + "]: " + nIRankID.toString() + ", extents: " + nIRank.getNumExtents());
            logger.debug_general(stringBuffer.toString());
            ++n;
        }
        return vector;
    }

    protected List getFutureArraysForExtentPool(NIESS nIESS, NIExtentPoolID nIExtentPoolID, NIExtentType nIExtentType, NIRaidType nIRaidType, boolean bl, long l, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, nIESS.getModel());
        int n = nIMachineTypeModel.getMaxDAPairs();
        Vector<NIArray> vector = new Vector<NIArray>();
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        long l2 = 0L;
        if (bl2) {
            NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
            List list = this.getExistingRanksForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, l, nIArrayArray, nIRankArray, bl3);
            int n2 = list.size();
            long l3 = 0L;
            int n3 = 0;
            while (n3 < n2) {
                long l4 = ((NIRank)list.get(n3)).getNumExtents();
                l3 += l4;
                l2 += l4;
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("getFutureArraysForExtentPool() total capacity of existing ranks: " + l3 + " extents");
            logger.debug_general(stringBuffer.toString());
            long l5 = 0L;
            if (l2 < l) {
                long l6 = l - l2;
                List list2 = this.getExistingArraysForExtentPool(nIESSID, nIExtentType, nIRaidType, l6, n, nIArrayArray);
                int n4 = list2.size();
                int n5 = 0;
                while (n5 < n4) {
                    long l7 = this.caarray.getArrayExtents((NIArray)list2.get(n5), nIExtentType);
                    l5 += l7;
                    l2 += l7;
                    ++n5;
                }
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("getFutureArraysForExtentPool() total capacity of existing unassigned arrays: " + l5 + " extents");
            logger.debug_general(stringBuffer.toString());
        }
        long l8 = 0L;
        if (l2 < l) {
            NIArraySite[] nIArraySiteArray = this.ca.getImageArraySites(nIESSID);
            NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.ca.getImageDDMs(nIESSID);
            List list = this.ca.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType);
            NIArraySite[] nIArraySiteArray2 = list.toArray(new NIArraySite[0]);
            int n6 = nIArraySiteArray2.length;
            NIAvailableSite[] nIAvailableSiteArray = new NIAvailableSite[n6];
            int n7 = 0;
            while (n7 < n6) {
                nIAvailableSiteArray[n7] = new NIAvailableSite(nIArraySiteArray2[n7]);
                ++n7;
            }
            nIAvailableSiteArray = this.getFutureArrayCapacities(nIESSID, nIRaidType, nIExtentType, nIAvailableSiteArray, nIArrayArray, n);
            int n8 = 0;
            while (n8 < n6 && l2 < l) {
                NIArray nIArray = this.ca.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, (NIArraySite)nIAvailableSiteArray[n8]);
                vector.add(nIArray);
                l8 += (long)nIAvailableSiteArray[n8].getEffectiveCapacity();
                l2 += (long)nIAvailableSiteArray[n8].getEffectiveCapacity();
                ++n8;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureArraysForExtentPool() total capacity of existing unconfigured array sites: " + l8 + " extents");
        logger.debug_general(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureArraysForExtentPool() requested storage: " + l + " extents, obtained storage: " + l2 + " extents");
        logger.debug_general(stringBuffer.toString());
        if (l2 < l) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("getFutureArraysForExtentPool() >>>> WARNING: requested storage could not be fully obtained");
            logger.debug_general(stringBuffer.toString());
            if (bl) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("Returning no Arrays; boolean requestedCapacityRequired not met");
                logger.debug_general(stringBuffer.toString());
                vector = new Vector();
            }
        }
        return vector;
    }

    protected NIExtentPool getFutureExtentPool(NIESSID nIESSID, String string, NIExtentType nIExtentType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray = new int[]{0, 0};
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        n = 0;
        while (n < nIRankArray.length) {
            n3 = nIRankArray[n].getRankGroup();
            if (n3 != -1) {
                int n4 = n3;
                nArray[n4] = (int)((long)nArray[n4] + nIRankArray[n].getNumExtents());
            }
            ++n;
        }
        if (nArray[1] < nArray[0]) {
            n2 = 1;
        }
        NIExtentPool nIExtentPool = this.getFutureExtentPool(nIESSID, string, nIExtentType, n2);
        return nIExtentPool;
    }

    protected NIExtentPool getFutureExtentPool(NIESSID nIESSID, String string, NIExtentType nIExtentType, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException, NIParameterInvalidCAException {
        NIExtentPool nIExtentPool = NIResourceFactory.newExtentPool(nIESSID, n, nIExtentType, string);
        return nIExtentPool;
    }

    protected List getFutureRanksForExtentPool(NIESS nIESS, NIExtentPool nIExtentPool, NIExtentType nIExtentType, NIRaidType nIRaidType, long l, boolean bl, Vector vector, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Hashtable hashtable;
        Object object;
        Object object2;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n = nIMachineTypeModel.getMaxDAPairs();
        long l2 = 0L;
        Vector vector2 = new Vector();
        Vector<NIRank> vector3 = new Vector<NIRank>(1, 1);
        NIExtentPoolID nIExtentPoolID = null;
        if (nIExtentPool != null) {
            nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        }
        Vector<NIArrayID> vector4 = new Vector<NIArrayID>();
        if (vector != null && !bl) {
            int n2 = 0;
            while (n2 < vector.size()) {
                object2 = (NIArray)vector.get(n2);
                object = (NIArrayID)object2.getID();
                vector4.add((NIArrayID)object);
                ++n2;
            }
        }
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        if (bl) {
            object2 = this.ca.getImageRanks(nIESSID);
            object = this.getExistingRanksForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, l, nIArrayArray, (NIRank[])object2, false);
            int n3 = object.size();
            long l3 = 0L;
            int n4 = 0;
            while (n4 < n3) {
                long l4 = ((NIRank)object.get(n4)).getNumExtents();
                l3 += l4;
                l2 += l4;
                ++n4;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("getFutureRanksForExtentPool() total capacity of existing ranks: " + l3 + " extents");
            logger.debug_general(stringBuffer.toString());
        }
        long l5 = 0L;
        if (l2 < l && (hashtable = this.createDAPairTableForArrays(nIArrayArray, n)) != null && hashtable.size() > 0) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                Vector vector5 = (Vector)hashtable.get(new Integer(n6));
                if (vector5.size() > n5) {
                    n5 = vector5.size();
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < n5 && l2 < l) {
                int n8 = 0;
                while (n8 < n && l2 < l) {
                    Vector vector6 = (Vector)hashtable.get(new Integer(n8));
                    if (vector6 != null && vector6.size() > n7) {
                        NIArray nIArray = (NIArray)vector6.elementAt(n7);
                        NIArrayID nIArrayID = (NIArrayID)nIArray.getID();
                        if (nIArray.getArrayStatus() == 1 && nIArray.getRaidType().equals(nIRaidType) && !vector4.contains(nIArrayID)) {
                            long l6 = this.caarray.getArrayExtents(nIArray, nIExtentType);
                            l5 += l6;
                            l2 += l6;
                            NIRank nIRank = this.ca.getFutureRank(nIESSID, nIArray, nIExtentType, nIExtentPool);
                            vector3.add(nIRank);
                        }
                    }
                    ++n8;
                }
                ++n7;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureRanksForExtentPool() total capacity of existing unassigned arrays: " + l5 + " extents");
        logger.debug_general(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("getFutureRanksForExtentPool() requested storage: " + l + " extents, obtained storage: " + l2 + " extents");
        logger.debug_general(stringBuffer.toString());
        if (l2 < l) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("getFutureRanksForExtentPool() >>>> WARNING: requested storage could not be fully obtained");
            logger.debug_general(stringBuffer.toString());
            if (bl2) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("Returning no Ranks; boolean requestedCapacityRequired not met");
                logger.debug_general(stringBuffer.toString());
                vector3 = new Vector();
            }
        }
        return vector3;
    }

    protected double getMaxStorageForExtentPoolTB(NIESS nIESS, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIArraySite[] nIArraySiteArray;
        NIStorageDeviceFRU[] nIStorageDeviceFRUArray;
        NIArray[] nIArrayArray;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n = nIMachineTypeModel.getMaxDAPairs();
        NIExtentTypeFB nIExtentTypeFB = NIExtentTypeFB.Option;
        long l = 0L;
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        int n2 = 0;
        while (n2 < nIRankArray.length) {
            nIArrayArray = nIRankArray[n2];
            if (nIArrayArray.getConfigurationState() == 2 && (nIArrayArray.getRAIDType() instanceof NIRaidType5 && nIRaidType instanceof NIRaidType5 || nIArrayArray.getRAIDType() instanceof NIRaidType10 && nIRaidType instanceof NIRaidType10)) {
                l += nIArrayArray.getNumExtents();
            }
            ++n2;
        }
        nIArrayArray = this.ca.getImageArrays(nIESSID);
        int n3 = 0;
        while (n3 < nIArrayArray.length) {
            nIStorageDeviceFRUArray = nIArrayArray[n3];
            if (nIStorageDeviceFRUArray.getArrayStatus() == 1 && (nIStorageDeviceFRUArray.getRaidType() instanceof NIRaidType5 && nIRaidType instanceof NIRaidType5 || nIStorageDeviceFRUArray.getRaidType() instanceof NIRaidType10 && nIRaidType instanceof NIRaidType10)) {
                l += this.caarray.getArrayExtents((NIArray)nIStorageDeviceFRUArray, nIExtentTypeFB);
            }
            ++n3;
        }
        nIStorageDeviceFRUArray = this.ca.getImageDDMs(nIESSID);
        NIArraySite[] nIArraySiteArray2 = this.ca.getImageArraySites(nIESSID);
        Vector vector = new Vector(this.ca.getConfigurableArraySiteIDs(nIArraySiteArray2, nIStorageDeviceFRUArray));
        Vector<NIArraySite[]> vector2 = new Vector<NIArraySite[]>();
        int n4 = 0;
        while (n4 < nIArraySiteArray2.length) {
            nIArraySiteArray = nIArraySiteArray2[n4];
            NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySiteArray.getID();
            if (nIArraySiteArray.getArraySiteStatus() == 1 && vector.contains(nIArraySiteID)) {
                vector2.add(nIArraySiteArray);
            }
            ++n4;
        }
        nIArraySiteArray = vector2.toArray(new NIArraySite[0]);
        int n5 = nIArraySiteArray.length;
        NIAvailableSite[] nIAvailableSiteArray = new NIAvailableSite[n5];
        int n6 = 0;
        while (n6 < n5) {
            nIAvailableSiteArray[n6] = new NIAvailableSite(nIArraySiteArray[n6]);
            ++n6;
        }
        nIAvailableSiteArray = this.getFutureArrayCapacities(nIESSID, nIRaidType, nIExtentTypeFB, nIAvailableSiteArray, nIArrayArray, n);
        int n7 = 0;
        while (n7 < n5) {
            l += (long)nIAvailableSiteArray[n7].getEffectiveCapacity();
            ++n7;
        }
        double d = this.ca.convertExtentsToBinaryGB(l, nIExtentTypeFB);
        double d2 = d * (NIConfigurationConstants.BYTES_IN_ONE_GB_BIN / NIConfigurationConstants.BYTES_IN_ONE_TB_BIN);
        return d2;
    }

    protected long getNumberOfExtents(int n, NIExtentType nIExtentType) throws NIParameterInvalidCAException {
        long l = 0L;
        if (nIExtentType instanceof NIExtentTypeCKD) {
            l = (long)((double)n / 0.88104);
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            l = (long)((double)n / 1.0);
        }
        return l;
    }

    protected int getNumberOfFutureRanksForExtentPool(NIESS nIESS, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray = this.getNumberOfFutureArraysAndRanksForExtentPool(nIESS, nIExtentType, nIRaidType, n, bl);
        return nArray[0];
    }

    protected int[] getNumberOfFutureArraysAndRanksForExtentPool(NIESS nIESS, NIExtentType nIExtentType, NIRaidType nIRaidType, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n2;
        Object object;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, nIESS.getModel());
        int n3 = nIMachineTypeModel.getMaxDAPairs();
        long l = this.ca.convertBinaryGBToExtents(n, nIExtentType);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getNumberOfFutureArraysAndRanksForExtentPool() number of requested extents: " + l);
        logger.debug_general(stringBuffer.toString());
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l2 = 0L;
        long l3 = 0L;
        Object var20_17 = null;
        Object var21_18 = null;
        Object var22_19 = null;
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        long l4 = 0L;
        if (bl) {
            long l5;
            object = this.getExistingRanksForExtentPool(nIESS, null, nIExtentType, nIRaidType, l, nIArrayArray, nIRankArray, false);
            n2 = object.size();
            int n7 = 0;
            while (n7 < n2 && l4 < l) {
                l5 = ((NIRank)object.get(n7)).getNumExtents();
                l4 += l5;
                l2 += l5;
                ++n4;
                ++n7;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("getNumberOfFutureArraysAndRanksForExtentPool() number of existing ranks: " + n4 + ", extents: " + l2);
            logger.debug_general(stringBuffer.toString());
            if (l4 < l) {
                l5 = l - l4;
                List list = this.getExistingArraysForExtentPool(nIESSID, nIExtentType, nIRaidType, l5, n3, nIArrayArray);
                int n8 = list.size();
                int n9 = 0;
                while (n9 < n8 && l4 < l) {
                    long l6 = this.caarray.getArrayExtents((NIArray)list.get(n9), nIExtentType);
                    l4 += l6;
                    l3 += l6;
                    ++n5;
                    ++n9;
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append("getNumberOfFutureArraysAndRanksForExtentPool() number of unassigned arrays: " + n5 + ", extents: " + l3);
                logger.debug_general(stringBuffer.toString());
            }
        }
        if (l4 < l) {
            object = this.ca.getImageArraySites(nIESSID);
            NIStorageDeviceFRU[] nIStorageDeviceFRUArray = this.ca.getImageDDMs(nIESSID);
            List list = this.ca.getAvailableArraySites(nIESS, (NIArraySite[])object, nIStorageDeviceFRUArray, nIRaidType);
            NIArraySite[] nIArraySiteArray = list.toArray(new NIArraySite[0]);
            NIAvailableSite[] nIAvailableSiteArray = new NIAvailableSite[nIArraySiteArray.length];
            int n10 = 0;
            while (n10 < nIArraySiteArray.length) {
                nIAvailableSiteArray[n10] = new NIAvailableSite(nIArraySiteArray[n10]);
                ++n10;
            }
            nIAvailableSiteArray = this.getFutureArrayCapacities(nIESSID, nIRaidType, nIExtentType, nIAvailableSiteArray, nIArrayArray, n3);
            long l7 = 0L;
            int n11 = 0;
            while (n11 < nIAvailableSiteArray.length && l4 < l) {
                long l8 = nIAvailableSiteArray[n11].getEffectiveCapacity();
                l4 += l8;
                l7 += l8;
                ++n6;
                ++n11;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("getNumberOfFutureArraysAndRanksForExtentPool() number of available sites: " + n6 + ", extents: " + l7);
            logger.debug_general(stringBuffer.toString());
        }
        int n12 = n4 + n5 + n6;
        n2 = n5 + n6;
        int n13 = n6;
        int[] nArray = new int[]{n12, n2, n13};
        return nArray;
    }

    protected List getRaidTypesInExtentPool(NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = nIExtentPoolID.getESS();
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        Vector<NIRaidType5> vector = new Vector<NIRaidType5>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nIRankArray.length) {
            NIRank nIRank = nIRankArray[n];
            if (nIRank.getExtentPoolID() != null && nIRank.getExtentPoolID().equals(nIExtentPoolID)) {
                NIRaidType nIRaidType = null;
                if (nIRank.getRAIDType() instanceof NIRaidType5) {
                    nIRaidType = NIRaidType5.Option;
                    if (!bl) {
                        vector.add((NIRaidType5)nIRaidType);
                    }
                    bl = true;
                } else if (nIRank.getRAIDType() instanceof NIRaidType10) {
                    nIRaidType = NIRaidType10.Option;
                    if (!bl2) {
                        vector.add((NIRaidType5)nIRaidType);
                    }
                    bl2 = true;
                }
            }
            if (bl && bl2) break;
            ++n;
        }
        return vector;
    }

    protected List getRanksInExtentPool(NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = nIExtentPoolID.getESS();
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        Vector<NIRank> vector = new Vector<NIRank>();
        int n = 0;
        while (n < nIRankArray.length) {
            NIRank nIRank = nIRankArray[n];
            if (nIRank.getExtentPoolID() != null && nIRank.getExtentPoolID().equals(nIExtentPoolID)) {
                vector.add(nIRank);
            }
            ++n;
        }
        return vector;
    }

    protected double getReservedStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentType nIExtentType = nIExtentPool.getExtentType();
        int n = 0;
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumReservedExtents();
        if (n < 0) {
            n = 0;
        }
        double d = this.ca.convertExtentsToBinaryGB(n, nIExtentType);
        return d;
    }

    protected double getThresholdStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        double d = 0.0;
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentType nIExtentType = nIExtentPool.getExtentType();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        float f = 0.0f;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        f = nIExtentAvailabilityResult.getExtentThreshold();
        if (f < 0.0f) {
            f = 0.0f;
        }
        double d2 = this.ca.convertExtentsToBinaryGB((int)f, nIExtentType);
        return d2;
    }

    protected double getTotalRawStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        double d = 0.0;
        double d2 = 0.0;
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        Object var7_5 = null;
        NIESSID nIESSID = nIExtentPoolID.getESS();
        NIArraySite[] nIArraySiteArray = this.ca.getImageArraySites(nIESSID);
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        Vector vector = new Vector(this.getRanksInExtentPool(nIExtentPoolID));
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3;
            NIRank nIRank = (NIRank)vector.elementAt(n2);
            NIArrayID[] nIArrayIDArray = nIRank.getArrayIDs();
            Vector<NIArray> vector2 = new Vector<NIArray>();
            int n4 = 0;
            while (n4 < nIArrayIDArray.length) {
                n3 = 0;
                while (n3 < nIArrayArray.length) {
                    object = (NIArrayID)nIArrayArray[n3].getID();
                    if (((NIResourceID)object).equals(nIArrayIDArray[n4])) {
                        vector2.add(nIArrayArray[n3]);
                        break;
                    }
                    ++n3;
                }
                ++n4;
            }
            n3 = 0;
            object = nIESSID.getType();
            if (((String)object).equals("2107")) {
                n3 = 8;
            } else if (((String)object).equals("1750")) {
                n3 = 4;
            }
            int n5 = vector2.size();
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                NIArray nIArray = (NIArray)vector2.get(n6);
                NIArraySiteID[] nIArraySiteIDArray = nIArray.getArraySites();
                Vector<NIArraySite> vector3 = new Vector<NIArraySite>();
                int n8 = 0;
                while (n8 < nIArraySiteIDArray.length) {
                    n7 = 0;
                    while (n7 < nIArraySiteArray.length) {
                        NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySiteArray[n7].getID();
                        if (nIArraySiteID.equals(nIArraySiteIDArray[n8])) {
                            vector3.add(nIArraySiteArray[n7]);
                            break;
                        }
                        ++n7;
                    }
                    ++n8;
                }
                n7 = vector3.size();
                int n9 = 0;
                while (n9 < n7) {
                    d2 += (double)(((NIArraySite)vector3.get(n9)).getDiskCapacity() * n3);
                    ++n9;
                }
                ++n6;
            }
            ++n2;
        }
        d = d2 / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    protected NIAvailableSite[] getFutureArrayCapacities(NIESSID nIESSID, NIRaidType nIRaidType, NIExtentType nIExtentType, NIAvailableSite[] nIAvailableSiteArray, NIArray[] nIArrayArray, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        String string = nIESSID.getType();
        Hashtable hashtable = this.ca.createDAPairTableForSites(nIAvailableSiteArray, n);
        Hashtable hashtable2 = this.createDAPairTableForArrays(nIArrayArray, n);
        if (hashtable != null && hashtable.size() > 0) {
            int n2 = 0;
            while (n2 < n) {
                Vector vector = (Vector)hashtable.get(new Integer(n2));
                int n3 = 0;
                Vector vector2 = new Vector();
                if (hashtable2 != null && hashtable2.size() > 0) {
                    vector2 = (Vector)hashtable2.get(new Integer(n2));
                }
                n3 = vector.size();
                vector = (Vector)this.ca.sortArraySiteByNumber(vector);
                int n4 = 0;
                while (n4 < n3) {
                    NIArraySiteID nIArraySiteID;
                    NIAvailableSite nIAvailableSite;
                    int n5;
                    NIAvailableSite nIAvailableSite2 = (NIAvailableSite)vector.get(n4);
                    int n6 = nIAvailableSite2.getRequiredSpares();
                    Vector vector3 = this.getArraySitesOnDualLoop(nIAvailableSite2, vector);
                    if (nIRaidType.equals(NIRaidType5.Option)) {
                        if (n6 >= 2) {
                            n5 = 0;
                            while (n6 >= 2 && n5 < vector3.size()) {
                                nIAvailableSite = (NIAvailableSite)vector3.get(n5);
                                nIArraySiteID = (NIArraySiteID)nIAvailableSite.getID();
                                if (!nIArraySiteID.equals(nIAvailableSite2.getID()) && nIAvailableSite.getDiskCapacity() == nIAvailableSite2.getDiskCapacity() && nIAvailableSite.getDiskRPM() == nIAvailableSite2.getDiskRPM() && nIAvailableSite.getRequiredSpares() == 0) {
                                    nIAvailableSite.setRequiredSpares(nIAvailableSite.getRequiredSpares() + 1);
                                    --n6;
                                }
                                ++n5;
                            }
                            if (n6 >= 2) {
                                // empty if block
                            }
                            n6 = 1;
                        }
                        n5 = this.getCapacity(nIAvailableSite2, nIRaidType, n6, string, nIExtentType, true);
                        nIAvailableSite2.setEffectiveCapacity(n5);
                    } else if (nIRaidType.equals(NIRaidType10.Option)) {
                        if (n6 == 1) {
                            n5 = 0;
                            while (n5 < vector3.size()) {
                                nIAvailableSite = (NIAvailableSite)vector3.get(n5);
                                nIArraySiteID = (NIArraySiteID)nIAvailableSite.getID();
                                if (!nIArraySiteID.equals(nIAvailableSite2.getID()) && nIAvailableSite.getDiskCapacity() == nIAvailableSite2.getDiskCapacity() && nIAvailableSite.getDiskRPM() == nIAvailableSite2.getDiskRPM() && nIAvailableSite.getRequiredSpares() > 0) {
                                    nIAvailableSite.setRequiredSpares(nIAvailableSite.getRequiredSpares() - 1);
                                    break;
                                }
                                ++n5;
                            }
                            n6 = 2;
                        } else if (n6 >= 3) {
                            n5 = 0;
                            while (n6 >= 3 && n5 < vector3.size()) {
                                nIAvailableSite = (NIAvailableSite)vector3.get(n5);
                                nIArraySiteID = (NIArraySiteID)nIAvailableSite.getID();
                                if (!nIArraySiteID.equals(nIAvailableSite2.getID()) && nIAvailableSite.getDiskCapacity() == nIAvailableSite2.getDiskCapacity() && nIAvailableSite.getDiskRPM() == nIAvailableSite2.getDiskRPM() && nIAvailableSite.getRequiredSpares() == 0) {
                                    nIAvailableSite.setRequiredSpares(nIAvailableSite.getRequiredSpares() + 1);
                                    --n6;
                                }
                                ++n5;
                            }
                            if (n6 >= 3) {
                                // empty if block
                            }
                            n6 = 2;
                        }
                        n5 = this.getCapacity(nIAvailableSite2, nIRaidType, n6, string, nIExtentType, false);
                        nIAvailableSite2.setEffectiveCapacity(n5);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return nIAvailableSiteArray;
    }

    private int[] adjustSpares(int[] nArray, int[] nArray2, int n, Vector vector) {
        if (vector != null) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                NIArraySiteConfiguration[] nIArraySiteConfigurationArray;
                int n4;
                NIArray nIArray = (NIArray)vector.get(n3);
                int n5 = nIArray.getDiskCapacity();
                if (Math.abs(n5 - n) < 20000) {
                    NIArraySiteConfiguration[] nIArraySiteConfigurationArray2 = nIArray.getArraySiteConfiguration();
                    n4 = 0;
                    while (n4 < nIArraySiteConfigurationArray2.length) {
                        nIArraySiteConfigurationArray = nIArraySiteConfigurationArray2[n4];
                        if (Math.abs(n - 73000) < 20000) {
                            nArray[0] = nArray[0] - nIArraySiteConfigurationArray.getNumSpares();
                        } else if (Math.abs(n - 146000) < 20000) {
                            nArray[1] = nArray[1] - nIArraySiteConfigurationArray.getNumSpares();
                        } else if (Math.abs(n - 300000) < 20000) {
                            nArray[2] = nArray[2] - nIArraySiteConfigurationArray.getNumSpares();
                        } else if (Math.abs(n - 450000) < 20000) {
                            nArray[4] = nArray[4] - nIArraySiteConfigurationArray.getNumSpares();
                        } else if (Math.abs(n - 500000) < 20000) {
                            nArray[3] = nArray[3] - nIArraySiteConfigurationArray.getNumSpares();
                        }
                        ++n4;
                    }
                } else {
                    NIArraySiteConfiguration nIArraySiteConfiguration;
                    int n6;
                    int n7 = nIArray.getDiskRPM();
                    if (Math.abs(n - 73000) < 20000) {
                        n4 = nArray2[0];
                        if (Math.abs(n7 - n4) < 1500) {
                            nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
                            n6 = 0;
                            while (n6 < nIArraySiteConfigurationArray.length) {
                                nIArraySiteConfiguration = nIArraySiteConfigurationArray[n6];
                                nArray[0] = nArray[0] - nIArraySiteConfiguration.getNumSpares();
                                ++n6;
                            }
                        }
                    } else if (Math.abs(n - 146000) < 20000) {
                        n4 = nArray2[1];
                        if (Math.abs(n7 - n4) < 1500) {
                            nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
                            n6 = 0;
                            while (n6 < nIArraySiteConfigurationArray.length) {
                                nIArraySiteConfiguration = nIArraySiteConfigurationArray[n6];
                                nArray[1] = nArray[1] - nIArraySiteConfiguration.getNumSpares();
                                ++n6;
                            }
                        }
                    } else if (Math.abs(n - 300000) < 20000) {
                        n4 = nArray2[2];
                        if (Math.abs(n7 - n4) < 1500) {
                            nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
                            n6 = 0;
                            while (n6 < nIArraySiteConfigurationArray.length) {
                                nIArraySiteConfiguration = nIArraySiteConfigurationArray[n6];
                                nArray[2] = nArray[2] - nIArraySiteConfiguration.getNumSpares();
                                ++n6;
                            }
                        }
                    } else if (Math.abs(n - 450000) < 20000) {
                        n4 = nArray2[4];
                        if (Math.abs(n7 - n4) < 1500) {
                            nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
                            n6 = 0;
                            while (n6 < nIArraySiteConfigurationArray.length) {
                                nIArraySiteConfiguration = nIArraySiteConfigurationArray[n6];
                                nArray[4] = nArray[4] - nIArraySiteConfiguration.getNumSpares();
                                ++n6;
                            }
                        }
                    } else if (Math.abs(n - 500000) < 20000 && Math.abs(n7 - (n4 = nArray2[3])) < 1500) {
                        nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
                        n6 = 0;
                        while (n6 < nIArraySiteConfigurationArray.length) {
                            nIArraySiteConfiguration = nIArraySiteConfigurationArray[n6];
                            nArray[3] = nArray[3] - nIArraySiteConfiguration.getNumSpares();
                            ++n6;
                        }
                    }
                }
                ++n3;
            }
        }
        return nArray;
    }

    private int getRPMForCapacity(int n, Vector vector) {
        int n2 = 0;
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            NIArraySite nIArraySite = (NIArraySite)vector.get(n4);
            int n6 = nIArraySite.getDiskCapacity();
            if (Math.abs(n6 - n) < 20000 && Math.abs((n5 = nIArraySite.getDiskRPM()) - n2) < 1500 && n5 > n2) {
                n2 = n5;
            }
            ++n4;
        }
        return n2;
    }

    private int getLargestCap(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        if (n2 > 0) {
            n = ((NIArraySite)vector.get(0)).getDiskCapacity();
        }
        int n3 = 1;
        while (n3 < n2) {
            NIArraySite nIArraySite = (NIArraySite)vector.get(n3);
            int n4 = nIArraySite.getDiskCapacity();
            if (Math.abs(n4 - n) >= 20000 && n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    private int getNumBigSites(int n, Vector vector) {
        int n2 = 0;
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            NIArraySite nIArraySite = (NIArraySite)vector.get(n4);
            int n5 = nIArraySite.getDiskCapacity();
            if (Math.abs(n5 - n) < 20000) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    private int getCapacity(NIArraySite nIArraySite, NIRaidType nIRaidType, int n, String string, NIExtentType nIExtentType, boolean bl) {
        bl = false;
        long l = nIArraySite.getDiskCapacity();
        int n2 = 0;
        if (Math.abs(l - 73000L) < 20000L) {
            n2 = 0;
        } else if (Math.abs(l - 146000L) < 20000L) {
            n2 = 1;
        } else if (Math.abs(l - 300000L) < 20000L) {
            n2 = 2;
        } else if (Math.abs(l - 450000L) < 20000L) {
            n2 = 4;
        } else if (Math.abs(l - 500000L) < 20000L) {
            n2 = 3;
        }
        int n3 = 2;
        if (string.equals("2107") || bl) {
            if (nIRaidType instanceof NIRaidType5) {
                if (n == 1) {
                    n3 = 2;
                } else if (n == 0) {
                    n3 = 3;
                }
            } else if (nIRaidType instanceof NIRaidType10) {
                if (n == 2) {
                    n3 = 0;
                } else if (n == 0) {
                    n3 = 1;
                }
            }
        } else if (string.equals("1750")) {
            if (nIRaidType instanceof NIRaidType5) {
                if (n == 1) {
                    n3 = 4;
                } else if (n == 0) {
                    n3 = 5;
                }
            } else if (nIRaidType instanceof NIRaidType10) {
                if (n == 0) {
                    n3 = 6;
                } else if (n == 2) {
                    n3 = 7;
                }
            }
        }
        int n4 = nIExtentType instanceof NIExtentTypeCKD ? (string.equals("2107") ? NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_2107[n2][n3] : NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_1750[n2][n3]) : (string.equals("2107") ? NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_2107[n2][n3] : NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_1750[n2][n3]);
        StringBuffer stringBuffer = new StringBuffer();
        NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySite.getID();
        stringBuffer.append("getCapacity() site: " + nIArraySiteID.toString() + ", raidType: " + nIRaidType.toString() + ", numSpares: " + n + ", machineType: " + string + ", extentType: " + nIExtentType + ", 8-DDM: " + bl + ", extents: " + n4);
        logger.debug_general(stringBuffer.toString());
        return n4;
    }

    private boolean isUniform(Vector vector) {
        boolean bl = true;
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        if (n > 0) {
            n2 = ((NIArraySite)vector.get(0)).getDiskCapacity();
            n3 = ((NIArraySite)vector.get(0)).getDiskRPM();
        }
        int n4 = 1;
        while (n4 < n) {
            NIArraySite nIArraySite = (NIArraySite)vector.get(n4);
            if (Math.abs(nIArraySite.getDiskCapacity() - n2) >= 20000 || Math.abs(nIArraySite.getDiskRPM() - n3) >= 1500) {
                bl = false;
                break;
            }
            ++n4;
        }
        return bl;
    }

    private Vector getArraySitesOnDualLoop(NIArraySite nIArraySite, List list) {
        int n = nIArraySite.getDualLoop();
        Vector<NIArraySite> vector = new Vector<NIArraySite>();
        int n2 = 0;
        while (n2 < list.size()) {
            NIArraySite nIArraySite2 = (NIArraySite)list.get(n2);
            if (nIArraySite2.getDualLoop() == n) {
                vector.add(nIArraySite2);
            }
            ++n2;
        }
        return vector;
    }

    protected double getTotalStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentType nIExtentType = nIExtentPool.getExtentType();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        int n = 0;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumExtents();
        if (n < 0) {
            n = 0;
        }
        double d = this.ca.convertExtentsToBinaryGB(n, nIExtentType);
        return d;
    }

    protected double getUsedStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentType nIExtentType = nIExtentPool.getExtentType();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        int n = 0;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumAllocatedExtents();
        if (n < 0) {
            n = 0;
        }
        double d = this.ca.convertExtentsToBinaryGB(n, nIExtentType);
        return d;
    }

    protected double getUsedAndReservedStorageGB(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentType nIExtentType = nIExtentPool.getExtentType();
        NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
        int n = 0;
        if (nIExtentAvailabilityResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        n = nIExtentAvailabilityResult.getNumAllocatedExtents() + nIExtentAvailabilityResult.getNumReservedExtents();
        if (n < 0) {
            n = 0;
        }
        double d = this.ca.convertExtentsToBinaryGB(n, nIExtentType);
        return d;
    }

    protected List getRaidTypesInExtentPool(NIRank[] nIRankArray, NIExtentPoolID nIExtentPoolID) throws NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector<NIRaidType5> vector = new Vector<NIRaidType5>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nIRankArray.length) {
            NIRank nIRank = nIRankArray[n];
            if (nIRank.getExtentPoolID() != null && nIRank.getExtentPoolID().equals(nIExtentPoolID)) {
                NIRaidType nIRaidType = null;
                if (nIRank.getRAIDType() instanceof NIRaidType5) {
                    nIRaidType = NIRaidType5.Option;
                    if (!bl) {
                        vector.add((NIRaidType5)nIRaidType);
                    }
                    bl = true;
                } else if (nIRank.getRAIDType() instanceof NIRaidType10) {
                    nIRaidType = NIRaidType10.Option;
                    if (!bl2) {
                        vector.add((NIRaidType5)nIRaidType);
                    }
                    bl2 = true;
                }
            }
            if (bl && bl2) break;
            ++n;
        }
        return vector;
    }

    protected List getRanksInExtentPool(NIRank[] nIRankArray, NIExtentPoolID nIExtentPoolID) throws NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector<NIRank> vector = new Vector<NIRank>();
        int n = 0;
        while (n < nIRankArray.length) {
            NIRank nIRank = nIRankArray[n];
            if (nIRank.getExtentPoolID() != null && nIRank.getExtentPoolID().equals(nIExtentPoolID)) {
                vector.add(nIRank);
            }
            ++n;
        }
        return vector;
    }

    protected List getExtentPoolClientData(NIESSID nIESSID, NIExtentPool[] nIExtentPoolArray, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector<NIExtentPoolClientData> vector = new Vector<NIExtentPoolClientData>();
        int n = nIExtentPoolArray.length;
        NIRank[] nIRankArray = null;
        Object var7_7 = null;
        if (nIExtentPoolArray.length == 0) {
            return vector;
        }
        nIRankArray = this.ca.getImageRanks(nIESSID);
        NIArray[] nIArrayArray = null;
        NIArraySite[] nIArraySiteArray = null;
        if (bl) {
            nIArrayArray = this.ca.getImageArrays(nIESSID);
            nIArraySiteArray = this.ca.getImageArraySites(nIESSID);
        }
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            NIExtentPool nIExtentPool = nIExtentPoolArray[n2];
            NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
            List list = this.getRaidTypesInExtentPool(nIRankArray, nIExtentPoolID);
            NIRaidType[] nIRaidTypeArray = list.toArray(new NIRaidType[0]);
            double d3 = 0.0;
            NIExtentType nIExtentType = nIExtentPool.getExtentType();
            if (nIExtentType instanceof NIExtentTypeCKD) {
                d3 = 0.88104;
            } else if (nIExtentType instanceof NIExtentTypeFB) {
                d3 = 1.0;
            }
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            boolean bl2 = false;
            List list2 = this.getRanksInExtentPool(nIRankArray, nIExtentPoolID);
            if (list2.size() > 0) {
                NIExtentAvailabilityResult nIExtentAvailabilityResult = null;
                try {
                    nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
                }
                catch (NullPointerException nullPointerException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(nullPointerException.toString());
                    logger.debug_general(stringBuffer.toString());
                    throw new NIUnknownCAException(nullPointerException.toString());
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" queryExtentAvailability return code: " + nIExtentAvailabilityResult.getCode());
                logger.debug_general(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                stringBuffer.append(" numExtents=" + nIExtentAvailabilityResult.getNumExtents() + " numAllocatedExtents=" + nIExtentAvailabilityResult.getNumAllocatedExtents() + " numReservedExtents=" + nIExtentAvailabilityResult.getNumReservedExtents() + " numAvailableExtents=" + nIExtentAvailabilityResult.getNumAvailableExtents() + " extentThreshold=" + nIExtentAvailabilityResult.getExtentThreshold());
                logger.debug_general(stringBuffer.toString());
                if (nIExtentAvailabilityResult.getCode() == 0) {
                    int n3 = nIExtentAvailabilityResult.getNumExtents();
                    d4 = (double)n3 * d3;
                    int n4 = nIExtentAvailabilityResult.getNumAllocatedExtents();
                    d6 = (double)n4 * d3;
                    int n5 = nIExtentAvailabilityResult.getNumReservedExtents();
                    d7 = (double)n5 * d3;
                    int n6 = nIExtentAvailabilityResult.getNumAvailableExtents();
                    d8 = (double)n6 * d3;
                    if (bl) {
                        int n7 = 0;
                        while (n7 < list2.size()) {
                            Object object;
                            int n8;
                            NIRank nIRank = (NIRank)list2.get(n7);
                            NIArrayID[] nIArrayIDArray = nIRank.getArrayIDs();
                            Vector<NIArray> vector2 = new Vector<NIArray>();
                            int n9 = 0;
                            while (n9 < nIArrayIDArray.length) {
                                n8 = 0;
                                while (n8 < nIArrayArray.length) {
                                    object = (NIArrayID)nIArrayArray[n8].getID();
                                    if (((NIResourceID)object).equals(nIArrayIDArray[n9])) {
                                        vector2.add(nIArrayArray[n8]);
                                        break;
                                    }
                                    ++n8;
                                }
                                ++n9;
                            }
                            n8 = 0;
                            object = nIESSID.getType();
                            if (((String)object).equals("2107")) {
                                n8 = 8;
                            } else if (((String)object).equals("1750")) {
                                n8 = 4;
                            }
                            int n10 = vector2.size();
                            int n11 = 0;
                            while (n11 < n10) {
                                int n12;
                                NIArray nIArray = (NIArray)vector2.get(n11);
                                NIArraySiteID[] nIArraySiteIDArray = nIArray.getArraySites();
                                Vector<NIArraySite> vector3 = new Vector<NIArraySite>();
                                int n13 = 0;
                                while (n13 < nIArraySiteIDArray.length) {
                                    n12 = 0;
                                    while (n12 < nIArraySiteArray.length) {
                                        NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySiteArray[n12].getID();
                                        if (nIArraySiteID.equals(nIArraySiteIDArray[n13])) {
                                            vector3.add(nIArraySiteArray[n12]);
                                            break;
                                        }
                                        ++n12;
                                    }
                                    ++n13;
                                }
                                n12 = vector3.size();
                                int n14 = 0;
                                while (n14 < n12) {
                                    d5 += (double)(((NIArraySite)vector3.get(n14)).getDiskCapacity() * n8);
                                    ++n14;
                                }
                                ++n11;
                            }
                            ++n7;
                        }
                    }
                    bl2 = nIExtentAvailabilityResult.getPercentExtentsAvailable() - nIExtentAvailabilityResult.getExtentThreshold() <= 0.0f;
                } else if (nIExtentAvailabilityResult.getCode() != 0) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("Query Failure");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIQueryFailureCAException("Query Failure");
                }
            }
            if ((d2 = d5 / NIConfigurationConstants.MB_IN_ONE_GB_DEC) < 0.0) {
                d2 = 0.0;
            }
            if ((d = d2 - d6 - d7) < 0.0) {
                d = 0.0;
            }
            NIExtentPoolClientData nIExtentPoolClientData = new NIExtentPoolClientData(nIExtentPool, nIRaidTypeArray, d4, d2, d6, d7, d8, d, bl2);
            vector.add(nIExtentPoolClientData);
            ++n2;
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

