/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIAddressGroup;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIVolumeSerialDescriptor;
import com.ibm.storage.ess.ni.ca.NIAvailableLSS;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorZSeriesVolumes;
import com.ibm.storage.ess.ni.ca.NIImageHostAttachment;
import com.ibm.storage.ess.ni.ca.NIVolumeClientData;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize141GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize17GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize282GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize35GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize72GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize8GB;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeType;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeTypeAS400Protected;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeTypeAS400Unprotected;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeTypeStandard2107;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeCopyServices;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Map256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeBlocks;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeDS;
import com.ibm.storage.ess.ni.option.config.NIVolumeSizeTypeESS;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorOpenSystemVolumes {
    private static final String CLASS_NAME = "NIConfigurationAdvisorOpenSystemVolumes";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorOpenSystemVolumes.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private static final NIFBVolumeType[] fbVolumeTypeList = new NIFBVolumeType[]{NIFBVolumeTypeStandard2107.Option, NIFBVolumeTypeAS400Protected.Option, NIFBVolumeTypeAS400Unprotected.Option};
    private NILogicalConfigurationService logicalService = null;
    private NIConfigurationAdvisor ca = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorOpenSystemVolumes(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
    }

    protected NIFBVolumeType getFBVolumeType(NIVolume nIVolume) throws NIParameterInvalidCAException {
        NIDataType nIDataType = nIVolume.getDataType();
        NIFBVolumeType nIFBVolumeType = null;
        if (nIDataType != null) {
            if (nIDataType instanceof NIDataTypeBlock512) {
                nIFBVolumeType = NIFBVolumeTypeStandard2107.Option;
            } else if (nIDataType instanceof NIDataTypeBlock520Protected) {
                nIFBVolumeType = NIFBVolumeTypeAS400Protected.Option;
            } else if (nIDataType instanceof NIDataTypeBlock520Unprotected) {
                nIFBVolumeType = NIFBVolumeTypeAS400Unprotected.Option;
            }
        }
        return nIFBVolumeType;
    }

    protected List getAvailableLSSs(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = ((NIExtentPoolID)nIExtentPool.getID()).getESS();
        int n = 0;
        int n2 = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n = 255;
            n2 = 16;
        } else if (string.equals("1750")) {
            n = 32;
            n2 = 2;
        }
        Vector vector = new Vector();
        Object var8_8 = null;
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        if (nILSSArray != null) {
            boolean bl = this.ca.checkAllLSS(nIESSID, nILSSArray);
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("EssIDs don't match");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
            }
            int n3 = 0;
            while (n3 < nILSSArray.length) {
                int n4;
                NILSS nILSS = nILSSArray[n3];
                nArray[n4] = n4 = ((NILSSID)nILSS.getID()).getLSSNumber();
                ++n3;
            }
            vector.addAll(this.getAvailableExistingLSSs(nILSSArray, nIExtentPool, nArray));
        }
        vector.addAll(this.getFutureLSSs(nIESSID, nIExtentPool, nArray, n2));
        if (vector.size() > 0) {
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NIAvailableLSS nIAvailableLSS = (NIAvailableLSS)object;
                    NIAvailableLSS nIAvailableLSS2 = (NIAvailableLSS)object2;
                    int n2 = nIAvailableLSS.getLssAddress();
                    int n3 = nIAvailableLSS2.getLssAddress();
                    if (n2 < 16) {
                        n2 += 256;
                    }
                    if (n3 < 16) {
                        n3 += 256;
                    }
                    n = n2 - n3;
                    return n;
                }
            });
        }
        return vector;
    }

    protected List getFBVolumeTypeList() {
        Vector<NIFBVolumeType> vector = new Vector<NIFBVolumeType>(Arrays.asList(fbVolumeTypeList));
        return vector;
    }

    protected int getMaxVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NIVolumeGroup[] nIVolumeGroupArray, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n;
        NIESSID nIESSID = ((NIExtentPoolID)nIExtentPool.getID()).getESS();
        if (nILSSArray != null && (n = this.ca.checkAllLSS(nIESSID, nILSSArray)) == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EssIDs don't match");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
        }
        if (nIVolumeGroupArray != null) {
            n = 0;
            while (n < nIVolumeGroupArray.length) {
                NIVolumeGroup nIVolumeGroup = nIVolumeGroupArray[n];
                if (nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSI520All || nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSI520Map256 || nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSI520Mask) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Invalid Volume Group Type " + nIVolumeGroup.getType().getClass());
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
                }
                ++n;
            }
        }
        n = this.getMaxFBVolumeQuantity(nIESSID, nIExtentPool, nILSSArray, nIVolumeGroupArray, l);
        return n;
    }

    protected int getMaxAs400VolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NIVolumeGroup[] nIVolumeGroupArray, NIAs400VolumeSize nIAs400VolumeSize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        long l;
        int n;
        NIESSID nIESSID = null;
        try {
            nIESSID = ((NIExtentPoolID)nIExtentPool.getID()).getESS();
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nILSSArray != null && (n = (int)(this.ca.checkAllLSS(nIESSID, nILSSArray) ? 1 : 0)) == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EssIDs don't match");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
        }
        if (nIVolumeGroupArray != null) {
            n = nIVolumeGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                NIVolumeGroup nIVolumeGroup = nIVolumeGroupArray[n2];
                if (nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSIMap256 || nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSIMask) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Invalid Volume Group Type " + nIVolumeGroup.getType().getClass());
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
                }
                ++n2;
            }
        }
        if ((l = nIAs400VolumeSize.getStorageBlock()) < NIAs400VolumeSize8GB.Option.getStorageBlock()) {
            l = NIAs400VolumeSize8GB.Option.getStorageBlock();
        }
        int n3 = this.getMaxFBVolumeQuantity(nIESSID, nIExtentPool, nILSSArray, nIVolumeGroupArray, l);
        return n3;
    }

    private int getMaxFBVolumeQuantity(NIESSID nIESSID, NIExtentPool nIExtentPool, NILSS[] nILSSArray, NIVolumeGroup[] nIVolumeGroupArray, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n;
        int n2 = (int)this.ca.convertBlocksToExtents(l);
        int n3 = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n3 = 65280;
        } else if (string.equals("1750")) {
            n3 = NIConfigurationConstants.MAX_VOLUMES_PER_ESS_1750;
        }
        int n4 = this.getMaxAvailableFBVolume(nIESSID, nIExtentPool, nILSSArray);
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        int n5 = nIConfigurationAdvisorExtentPool.getAvailableExtents(nIExtentPool);
        int n6 = n2 > 0 ? n5 / n2 : n5;
        int n7 = n = Math.min(n4, n6);
        if (nIVolumeGroupArray != null) {
            n7 = this.getMinVolumesInVolGroup(nIVolumeGroupArray);
        }
        if ((n = Math.min(n, n7)) > 0) {
            n = Math.min(n, n3);
        }
        return n;
    }

    protected long getMaxVolumeCapacity(NIExtentPool nIExtentPool, int n, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        long l = 0L;
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        int n2 = nIConfigurationAdvisorExtentPool.getAvailableExtents(nIExtentPool);
        l = n > 0 ? (long)(n2 / n) : (long)n2;
        long l2 = l * 16384L * 128L;
        if (bl && l2 > 0x100000000L) {
            l2 = 0x100000000L;
        } else if (!bl && l2 > 1918359375L) {
            l2 = 1918359375L;
        }
        return l2;
    }

    protected NIAs400VolumeSize getMaxAs400VolumeSize(NIExtentPool nIExtentPool, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        long l = this.getMaxVolumeCapacity(nIExtentPool, n, true);
        NIAs400VolumeSize nIAs400VolumeSize = null;
        List list = this.getAs400VolumeSizeList(nIExtentPool);
        if (list != null && list.size() > 0) {
            int n2 = list.size();
            if (l >= ((NIAs400VolumeSize)list.get(n2 - 1)).getStorageBlock()) {
                nIAs400VolumeSize = (NIAs400VolumeSize)list.get(n2 - 1);
            } else if (l == ((NIAs400VolumeSize)list.get(0)).getStorageBlock()) {
                nIAs400VolumeSize = (NIAs400VolumeSize)list.get(0);
            } else {
                int n3 = 1;
                while (n3 < n2) {
                    if (l <= ((NIAs400VolumeSize)list.get(n3)).getStorageBlock()) {
                        nIAs400VolumeSize = (NIAs400VolumeSize)list.get(n3 - 1);
                        break;
                    }
                    ++n3;
                }
            }
        }
        return nIAs400VolumeSize;
    }

    protected List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int[] nArray, NIVolumeGroup[] nIVolumeGroupArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        StringBuffer stringBuffer;
        Serializable serializable;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        Vector<NIVolumeImpl> vector = new Vector<NIVolumeImpl>();
        Vector vector2 = new Vector();
        boolean bl3 = false;
        int[] nArray2 = null;
        NIDataType nIDataType = null;
        boolean bl4 = false;
        long l2 = 0L;
        int n6 = 1;
        Vector<Integer> vector3 = new Vector<Integer>();
        int n7 = 0;
        if (nIVolumeGroupArray != null) {
            n7 = nIVolumeGroupArray.length;
        }
        NIVolumeTypeFixedBlockBase nIVolumeTypeFixedBlockBase = NIVolumeTypeFixedBlockBase.Option;
        if (nIFBVolumeType instanceof NIFBVolumeTypeStandard2107) {
            if (nIVolumeGroupArray != null) {
                n2 = 0;
                while (n2 < n7) {
                    serializable = nIVolumeGroupArray[n2];
                    if (serializable.getType() instanceof NIVolumeGroupTypeSCSI520All || serializable.getType() instanceof NIVolumeGroupTypeSCSI520Map256 || serializable.getType() instanceof NIVolumeGroupTypeSCSI520Mask) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer2.append("Invalid Volume Group Type " + serializable.getType().getClass());
                        logger.debug_general(stringBuffer2.toString());
                        throw new NIParameterInvalidCAException((Object)stringBuffer2.toString());
                    }
                    ++n2;
                }
            }
            l2 = l;
            n2 = this.getMaxVolumeQuantity(nIExtentPool, nILSSArray, nIVolumeGroupArray, l);
            stringBuffer = new StringBuffer();
            stringBuffer.append("Volume capacity blocks: " + l + ", maximum quantity: " + n2);
            logger.debug_general(stringBuffer.toString());
            if (n2 < n) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("Returning zero volumes due to requested quantity not met (1)");
                logger.debug_general(stringBuffer.toString());
                return vector2;
            }
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Protected || nIFBVolumeType instanceof NIFBVolumeTypeAS400Unprotected) {
            n6 = this.getMTMValue(nIFBVolumeType, nIAs400VolumeSize);
            if (nIVolumeGroupArray != null) {
                n2 = 0;
                while (n2 < n7) {
                    serializable = nIVolumeGroupArray[n2];
                    if (serializable.getType() instanceof NIVolumeGroupTypeSCSIAll || serializable.getType() instanceof NIVolumeGroupTypeSCSIMap256 || serializable.getType() instanceof NIVolumeGroupTypeSCSIMask) {
                        StringBuffer stringBuffer3 = new StringBuffer();
                        stringBuffer3.append("Invalid Volume Group Type " + serializable.getType().getClass());
                        logger.debug_general(stringBuffer3.toString());
                        throw new NIParameterInvalidCAException((Object)stringBuffer3.toString());
                    }
                    ++n2;
                }
            }
            l2 = nIAs400VolumeSize.getStorageBlock();
            n2 = this.getMaxAs400VolumeQuantity(nIExtentPool, nILSSArray, nIVolumeGroupArray, nIAs400VolumeSize);
            stringBuffer = new StringBuffer();
            stringBuffer.append("Volume size: " + nIAs400VolumeSize + ", maximum quantity: " + n2);
            logger.debug_general(stringBuffer.toString());
            if (n2 < n) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("Returning zero volumes due to requested quantity not met (2)");
                logger.debug_general(stringBuffer.toString());
                return vector2;
            }
        }
        nArray2 = this.getLSSAddressesToUse(nILSSArray, nIExtentPool, nArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("Quantity of LSS addresses to use: " + nArray2.length);
        logger.debug_general(stringBuffer.toString());
        if (bl && string2 != null && !string2.equals("")) {
            int n8 = n3 = bl2 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
        }
        if (nIFBVolumeType instanceof NIFBVolumeTypeStandard2107) {
            nIDataType = NIDataTypeBlock512.Option;
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Protected) {
            nIDataType = NIDataTypeBlock520Protected.Option;
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Unprotected) {
            nIDataType = NIDataTypeBlock520Unprotected.Option;
        }
        Hashtable<Integer, NILSSID> hashtable = new Hashtable<Integer, NILSSID>(2);
        serializable = new Hashtable(2);
        int n9 = 0;
        if (nArray2 != null) {
            n9 = nArray2.length;
        }
        int n10 = 0;
        while (n10 < n9 && n4 < n) {
            NILSS nILSS = this.getLSS(nIESSID, nArray2[n10], nILSSArray);
            NILSSID nILSSID = null;
            if (nILSS == null) {
                bl4 = true;
                if (hashtable != null && hashtable.size() > 0) {
                    nILSSID = (NILSSID)hashtable.get(new Integer(nArray2[n10]));
                }
                if (nILSSID == null) {
                    nILSSID = new NILSSID(nIESSID, nArray2[n10], -1);
                    hashtable.put(new Integer(nArray2[n10]), nILSSID);
                    ((Hashtable)serializable).put(new Integer(nArray2[n10]), new Vector());
                }
            } else {
                bl4 = false;
                nILSSID = (NILSSID)nILSS.getID();
            }
            int n11 = 0;
            n11 = bl4 ? 256 : 256 - nILSS.getConfiguredDevices();
            int[] nArray3 = new int[256];
            Arrays.fill(nArray3, -1);
            this.fillInAddressTable(nILSSID, (Hashtable)serializable, bl4, n10, nArray2, nArray3);
            int n12 = 0;
            while (n12 < n11) {
                n5 = this.ca.getNextVolNum(nArray3, 0, true);
                if (n5 == -1) break;
                nArray3[n5] = n5;
                String string3 = new String();
                if (bl) {
                    if (string != null) {
                        string3 = string3 + string;
                    }
                    if (string2 != null && !string2.equals("")) {
                        string3 = string3 + this.ca.padding(n3, string2.length(), bl2);
                        ++n3;
                    }
                }
                NIVolumeImpl nIVolumeImpl = null;
                nIVolumeImpl = bl4 ? new NIVolumeImpl(new NIVolumeID(nILSSID, n5), string3, null, null, null, (NIExtentPoolID)nIExtentPool.getID(), false, nIVolumeTypeFixedBlockBase, nIDataType, l2, n6, 0, 0, 0) : new NIVolumeImpl(new NIVolumeID((NILSSID)nILSS.getID(), n5), string3, null, null, null, (NIExtentPoolID)nIExtentPool.getID(), false, nIVolumeTypeFixedBlockBase, nIDataType, l2, n6, 0, 0, 0);
                vector.add(nIVolumeImpl);
                ++n4;
                if (bl4) {
                    vector3.add(new Integer(n5));
                    ((Hashtable)serializable).put(new Integer(nArray2[n10]), vector3);
                }
                if (n4 == n) break;
                ++n12;
            }
            ++n10;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("Requested quantity: " + n + ", actual quantity: " + n4);
        logger.debug_general(stringBuffer.toString());
        if (n4 < n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("Returning zero volumes due to requested quantity not met (3)");
            logger.debug_general(stringBuffer.toString());
            return vector2;
        }
        return vector;
    }

    protected int getNextVolumeNumber(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        int n = this.getNextVolumeNumber(nILSSID, 1)[0];
        return n;
    }

    protected int[] getNextVolumeNumber(NILSSID nILSSID, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        int n2 = -1;
        int[] nArray2 = new int[256];
        nArray2 = this.ca.getVolAddrTable(nILSSID);
        int n3 = 0;
        while (n3 < n) {
            n2 = this.ca.getNextVolNum(nArray2, 0, true);
            if (n2 == -1) break;
            nArray[n3] = n2;
            nArray2[n2] = n2;
            ++n3;
        }
        return nArray;
    }

    protected List getAs400VolumeSizeList(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector vector = new Vector();
        Vector<NIAs400VolumeSize> vector2 = new Vector<NIAs400VolumeSize>();
        NIAs400VolumeSize[] nIAs400VolumeSizeArray = new NIAs400VolumeSize[]{NIAs400VolumeSize8GB.Option, NIAs400VolumeSize17GB.Option, NIAs400VolumeSize35GB.Option, NIAs400VolumeSize72GB.Option, NIAs400VolumeSize141GB.Option, NIAs400VolumeSize282GB.Option};
        double d = this.ca.getAvailableStorageGB(nIExtentPool);
        int n = nIAs400VolumeSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(d >= nIAs400VolumeSizeArray[n2].getStorageBinaryGB())) break;
            vector2.add(nIAs400VolumeSizeArray[n2]);
            ++n2;
        }
        if (vector2.size() == 0) {
            return vector;
        }
        return vector2;
    }

    private int getMTMValue(NIFBVolumeType nIFBVolumeType, NIAs400VolumeSize nIAs400VolumeSize) {
        int n = 1;
        if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Protected) {
            n = nIAs400VolumeSize.getMTMProtectedValue();
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Unprotected) {
            n = nIAs400VolumeSize.getMTMUnprotectedValue();
        }
        return n;
    }

    protected NIVolumeGroup getModifiedVolumeGroup(NIVolumeGroup nIVolumeGroup, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException, NIUnknownCAException {
        Serializable serializable;
        NIESSID nIESSID = null;
        try {
            nIESSID = ((NIVolumeGroupID)nIVolumeGroup.getID()).getESS();
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        int n = 0;
        if (nIVolumeArray != null) {
            n = nIVolumeArray.length;
            int n2 = 0;
            while (n2 < n) {
                serializable = nIVolumeArray[n2];
                if (!((NIVolumeID)serializable.getID()).getLSS().getESS().equals(nIESSID)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("EssIDs don't match");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
                }
                ++n2;
            }
        }
        NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
        serializable = null;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        if (nIVolumeGroupType != null && !(nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll) && !(nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All)) {
            serializable = nIVolumeGroup.getVolumeGroupList();
            n4 = serializable.size();
            int n6 = 0;
            if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask || nIVolumeGroupType instanceof NIVolumeGroupTypeCopyServices) {
                n6 = 65536;
            } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256 || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256) {
                n6 = 256;
            }
            n5 = n6 - n4;
            if (n5 >= n) {
                int n7 = 0;
                while (n7 < n) {
                    serializable.add((NIVolumeID)nIVolumeArray[n7].getID());
                    ++n7;
                }
            }
            nIVolumeGroup.setVolumeGroupList((NIVolumeGroupVolumeList)serializable);
        }
        return nIVolumeGroup;
    }

    protected List getVolumeGroups(NIVolumeID nIVolumeID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Object object;
        Vector<NIResourceID> vector = new Vector<NIResourceID>();
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = null;
        boolean bl = false;
        NIESSID nIESSID = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        NIConfigQueryResult nIConfigQueryResult2 = null;
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[]{nIVolumeID};
        try {
            nIESSID = nIVolumeID.getLSS().getESS();
            nIConfigQueryResult = this.logicalService.getVolumeGroups(nIESSID);
            nIConfigQueryResult2 = this.logicalService.getVolumes(nIVolumeIDArray);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        NIDataType nIDataType = null;
        boolean bl2 = false;
        if (nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
            object = (NIVolume)nIConfigQueryResult2.getResourceList().get(0);
            nIDataType = object.getDataType();
            if (nIDataType != null && (nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected)) {
                bl2 = true;
            }
        } else if (nIConfigQueryResult2.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getVolumes " + nIConfigQueryResult2.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            object = nIConfigQueryResult.getResourceList();
            int n = object.size();
            int n2 = 0;
            while (n2 < n) {
                NIVolumeGroupType nIVolumeGroupType = ((NIVolumeGroup)object.get(n2)).getType();
                if (bl2) {
                    if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All) {
                        vector.add(((NIVolumeGroup)object.get(n2)).getID());
                    } else {
                        nIVolumeGroupVolumeList = ((NIVolumeGroup)object.get(n2)).getVolumeGroupList();
                        bl = nIVolumeGroupVolumeList.contains(nIVolumeID);
                        if (bl) {
                            vector.add(((NIVolumeGroup)object.get(n2)).getID());
                        }
                    }
                } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll) {
                    vector.add(((NIVolumeGroup)object.get(n2)).getID());
                } else {
                    nIVolumeGroupVolumeList = ((NIVolumeGroup)object.get(n2)).getVolumeGroupList();
                    bl = nIVolumeGroupVolumeList.contains(nIVolumeID);
                    if (bl) {
                        vector.add(((NIVolumeGroup)object.get(n2)).getID());
                    }
                }
                ++n2;
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append("Query Failure getVolumeGroups " + nIConfigQueryResult.getCode());
            logger.debug_general(((StringBuffer)object).toString());
            throw new NIQueryFailureCAException(((StringBuffer)object).toString());
        }
        return vector;
    }

    private Vector getAvailableExistingLSSs(NILSS[] nILSSArray, NIExtentPool nIExtentPool, int[] nArray) throws NIUnknownCAException {
        NIAvailableLSS nIAvailableLSS = null;
        Vector<NIAvailableLSS> vector = new Vector<NIAvailableLSS>();
        if (nILSSArray != null) {
            int n = nILSSArray.length;
            int n2 = 0;
            while (n2 < n) {
                NILSS nILSS = nILSSArray[n2];
                try {
                    if (((NILSSID)nILSS.getID()).getLSSGroupID() == nIExtentPool.getRankGroup() && nILSS.getConfiguredDevices() < 256 && nILSS.getDeviceType() instanceof NIDeviceTypeFB) {
                        int n3 = ((NILSSID)nILSS.getID()).getLSSNumber();
                        nIAvailableLSS = new NIAvailableLSS(nILSS);
                        vector.add(nIAvailableLSS);
                        nArray[n3] = n3;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(nullPointerException.toString());
                    logger.debug_general(stringBuffer.toString());
                    throw new NIUnknownCAException(stringBuffer.toString());
                }
                ++n2;
            }
        }
        return vector;
    }

    private Vector getFutureLSSs(NIESSID nIESSID, NIExtentPool nIExtentPool, int[] nArray, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n2;
        int n3;
        int n4;
        int n5;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getAddressGroups(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        NIAvailableLSS nIAvailableLSS = null;
        Vector<NIAvailableLSS> vector = new Vector<NIAvailableLSS>();
        List list = null;
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getAddressGroups " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        int n6 = list.size();
        if (list != null) {
            int n7 = 0;
            while (n7 < n6) {
                NIAddressGroup nIAddressGroup = (NIAddressGroup)list.get(n7);
                if (nIAddressGroup.getDeviceType() instanceof NIDeviceTypeFB) {
                    n5 = 16;
                    n4 = 0;
                    while (n4 < n5) {
                        n3 = ((NIAddressGroupID)nIAddressGroup.getID()).getAddressGroupNumber();
                        n2 = n3 * n5 + n4;
                        if (n2 < 255 && nArray[n2] == -1 && (nIExtentPool.getRankGroup() == 0 && n2 % 2 == 0 || nIExtentPool.getRankGroup() == 1 && n2 % 2 == 1)) {
                            nIAvailableLSS = new NIAvailableLSS(n2);
                            vector.add(nIAvailableLSS);
                            nArray[n2] = n2;
                        }
                        ++n4;
                    }
                }
                ++n7;
            }
        }
        int[] nArray2 = new int[n];
        Arrays.fill(nArray2, -1);
        int n8 = 0;
        while (n8 < n6) {
            nArray2[n5] = n5 = ((NIAddressGroupID)((NIAddressGroup)list.get(n8)).getID()).getAddressGroupNumber();
            ++n8;
        }
        n5 = nArray2.length - 1;
        while (n5 >= 0) {
            if (nArray2[n5] == -1) {
                n4 = 16;
                n3 = 0;
                while (n3 < n4) {
                    n2 = n5 * n4 + n3;
                    if (n2 < 255 && (nIExtentPool.getRankGroup() == 0 && n2 % 2 == 0 || nIExtentPool.getRankGroup() == 1 && n2 % 2 == 1)) {
                        nIAvailableLSS = new NIAvailableLSS(n2);
                        vector.add(nIAvailableLSS);
                        nArray[n2] = n2;
                    }
                    ++n3;
                }
            }
            --n5;
        }
        return vector;
    }

    protected int[] getLSSAddressesToUse(NILSS[] nILSSArray, NIExtentPool nIExtentPool, int[] nArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray2;
        block7: {
            Vector vector;
            block6: {
                vector = new Vector();
                nArray2 = null;
                if (nArray == null) break block6;
                int n = nArray.length;
                int[] nArray3 = new int[nArray.length];
                Arrays.fill(nArray3, -1);
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    if (nIExtentPool.getRankGroup() == 0 && nArray[n3] % 2 == 0 || nIExtentPool.getRankGroup() == 1 && nArray[n3] % 2 == 1) {
                        nArray3[n3] = nArray[n3];
                        ++n2;
                    }
                    ++n3;
                }
                Arrays.sort(nArray3);
                int n4 = 0;
                int n5 = 0;
                while (n5 < nArray3.length) {
                    if (nArray3[n5] != -1) {
                        n4 = n5;
                        break;
                    }
                    ++n5;
                }
                nArray2 = new int[nArray3.length - n4];
                int n6 = 0;
                while (n6 < nArray3.length) {
                    nArray2[n6] = nArray3[n4++];
                    ++n6;
                }
                break block7;
            }
            if (nArray2 != null) break block7;
            vector = new Vector(this.getAvailableLSSs(nILSSArray, nIExtentPool));
            nArray2 = new int[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                nArray2[n] = ((NIAvailableLSS)vector.get(n)).getLssAddress();
                ++n;
            }
        }
        return nArray2;
    }

    protected void fillInAddressTable(NILSSID nILSSID, Hashtable hashtable, boolean bl, int n, int[] nArray, int[] nArray2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        block8: {
            block7: {
                Vector vector = new Vector();
                if (!bl) break block7;
                vector = (Vector)hashtable.get(new Integer(nArray[n]));
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    nArray2[n4] = n4 = ((Integer)vector.elementAt(n3)).intValue();
                    ++n3;
                }
                break block8;
            }
            NIConfigQueryResult nIConfigQueryResult = null;
            Vector vector = null;
            try {
                nIConfigQueryResult = this.logicalService.getVolumes(nILSSID);
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(stringBuffer.toString());
            }
            if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                vector = new Vector(nIConfigQueryResult.getResourceList());
            } else if (nIConfigQueryResult.getCode() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure getVolumes " + nIConfigQueryResult.getCode());
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException(stringBuffer.toString());
            }
            if (vector == null) break block8;
            int n5 = vector.size();
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                NIVolumeID nIVolumeID = (NIVolumeID)((NIVolume)vector.get(n6)).getID();
                nArray2[n7] = n7 = nIVolumeID.getVolNumber();
                ++n6;
            }
        }
    }

    protected NILSS getLSS(NIESSID nIESSID, int n, NILSS[] nILSSArray) {
        NILSS nILSS = null;
        if (nILSSArray != null) {
            int n2 = nILSSArray.length;
            int n3 = 0;
            while (n3 < n2) {
                NILSS nILSS2 = nILSSArray[n3];
                if (nILSS2 != null && ((NILSSID)nILSS2.getID()).getESS().equals(nIESSID) && ((NILSSID)nILSS2.getID()).getLSSNumber() == n) {
                    nILSS = nILSS2;
                    break;
                }
                ++n3;
            }
        }
        return nILSS;
    }

    protected int getMaxAvailableFBVolume(NIESSID nIESSID, NIExtentPool nIExtentPool, NILSS[] nILSSArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        Object object;
        if (!(nIExtentPool.getExtentType() instanceof NIExtentTypeFB)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid Extent Type " + nIExtentPool.getExtentType().getClass());
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
        }
        int n = 0;
        int n2 = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n = 255;
            n2 = 16;
        } else if (string.equals("1750")) {
            n = 32;
            n2 = 2;
        }
        int n3 = 0;
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        int n4 = nILSSArray.length;
        int n5 = 0;
        while (n5 < n4) {
            object = nILSSArray[n5];
            int n6 = ((NILSSID)object.getID()).getLSSNumber();
            if (nArray[n6] == -1) {
                nArray[n6] = n6;
            }
            try {
                if (object != null && ((NILSSID)object.getID()).getLSSGroupID() == nIExtentPool.getRankGroup() && object.getConfiguredDevices() < 256 && object.getDeviceType() instanceof NIDeviceTypeFB) {
                    n3 += 256 - object.getConfiguredDevices();
                }
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(stringBuffer.toString());
            }
            ++n5;
        }
        object = null;
        try {
            object = this.logicalService.getAddressGroups(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        List list = null;
        if (object.getCode() != 0 || object.getResourceList() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getAddressGroups " + object.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        list = object.getResourceList();
        if (list != null) {
            int n7;
            int n8;
            int n9;
            Object object2;
            int n10 = list.size();
            int n11 = 0;
            while (n11 < n10) {
                object2 = (NIAddressGroup)list.get(n11);
                n9 = 0;
                if (object2.getDeviceType() instanceof NIDeviceTypeFB) {
                    n8 = 16;
                    n7 = 0;
                    if (nIExtentPool.getRankGroup() == 0) {
                        n7 = 0;
                    } else if (nIExtentPool.getRankGroup() == 1) {
                        n7 = 1;
                    }
                    int n12 = n7;
                    while (n12 < n8) {
                        int n13 = ((NIAddressGroupID)object2.getID()).getAddressGroupNumber();
                        int n14 = n13 * n8 + n12;
                        if (n14 < 255 && nArray[n14] == -1) {
                            ++n9;
                        }
                        n12 += 2;
                    }
                    n3 += n9 * 256;
                }
                ++n11;
            }
            object2 = new int[n2];
            Arrays.fill((int[])object2, -1);
            n9 = 0;
            while (n9 < n10) {
                n8 = ((NIAddressGroupID)((NIAddressGroup)list.get(n9)).getID()).getAddressGroupNumber();
                object2[n8] = n8;
                ++n9;
            }
            n8 = 0;
            while (n8 < ((Object)object2).length) {
                if (object2[n8] == -1) {
                    n7 = 8;
                    if (n8 == 15 && nIExtentPool.getRankGroup() == 1) {
                        --n7;
                    }
                    n3 += n7 * 256;
                }
                ++n8;
            }
        }
        return n3;
    }

    private int getMinVolumesInVolGroup(NIVolumeGroup[] nIVolumeGroupArray) {
        int n = 65536;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nIVolumeGroupArray.length) {
            NIVolumeGroup nIVolumeGroup = nIVolumeGroupArray[n4];
            NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
            if (!(nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll) && !(nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All)) {
                n3 = nIVolumeGroup.getVolumeGroupList().size();
                int n5 = 0;
                if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask || nIVolumeGroupType instanceof NIVolumeGroupTypeCopyServices) {
                    n5 = 65536;
                } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256 || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256) {
                    n5 = 256;
                }
                n2 = n5 - n3;
                if (n > n2) {
                    n = n2;
                }
                if (n < 0) {
                    n = 0;
                }
            }
            ++n4;
        }
        return n;
    }

    private List getVolumeGroups(NIVolumeGroup[] nIVolumeGroupArray, NIVolume nIVolume) throws NIParameterInvalidCAException {
        Vector<NIVolumeGroup> vector = new Vector<NIVolumeGroup>();
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = null;
        boolean bl = false;
        NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
        NIDataType nIDataType = null;
        boolean bl2 = false;
        nIDataType = nIVolume.getDataType();
        if (nIDataType != null && (nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected)) {
            bl2 = true;
        }
        int n = nIVolumeGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            NIVolumeGroupType nIVolumeGroupType = nIVolumeGroupArray[n2].getType();
            if (bl2) {
                if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All) {
                    vector.add(nIVolumeGroupArray[n2]);
                } else {
                    nIVolumeGroupVolumeList = nIVolumeGroupArray[n2].getVolumeGroupList();
                    bl = nIVolumeGroupVolumeList.contains(nIVolumeID);
                    if (bl) {
                        vector.add(nIVolumeGroupArray[n2]);
                    }
                }
            } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll) {
                vector.add(nIVolumeGroupArray[n2]);
            } else {
                nIVolumeGroupVolumeList = nIVolumeGroupArray[n2].getVolumeGroupList();
                bl = nIVolumeGroupVolumeList.contains(nIVolumeID);
                if (bl) {
                    vector.add(nIVolumeGroupArray[n2]);
                }
            }
            ++n2;
        }
        return vector;
    }

    protected List getVolumeClientData(NIESSID nIESSID, NIVolume[] nIVolumeArray, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Object object;
        NIExtentPoolID[] nIExtentPoolIDArray;
        HashMap<NIExtentPoolID[], NIExtentPoolID[]> hashMap;
        HashMap hashMap2;
        Vector<NIVolumeClientData> vector = new Vector<NIVolumeClientData>();
        NIVolumeGroup[] nIVolumeGroupArray = null;
        NIImageHostAttachment[] nIImageHostAttachmentArray = null;
        NIRank[] nIRankArray = null;
        NIExtentPool[] nIExtentPoolArray = new NIExtentPool[]{};
        int n = nIVolumeArray.length;
        NIConfigQueryResult nIConfigQueryResult = null;
        boolean bl2 = false;
        boolean bl3 = false;
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = null;
        NIConfigurationAdvisorZSeriesVolumes nIConfigurationAdvisorZSeriesVolumes = null;
        String string = null;
        HashMap hashMap3 = hashMap2 = bl ? new HashMap() : null;
        if (nIVolumeArray.length == 0) {
            return vector;
        }
        int n2 = 0;
        while (n2 < n) {
            hashMap = nIVolumeArray[n2];
            NIDataType nIDataType = nIVolumeArray[n2].getDataType();
            if (nIDataType != null) {
                if (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) {
                    bl2 = true;
                } else if (nIDataType instanceof NIDataType3380 || nIDataType instanceof NIDataType3390) {
                    bl3 = true;
                }
            }
            ++n2;
        }
        nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        if (bl3) {
            nIConfigurationAdvisorZSeriesVolumes = new NIConfigurationAdvisorZSeriesVolumes(this.ca);
        }
        if (bl2) {
            try {
                nIConfigQueryResult = this.logicalService.getVolumeGroups(nIESSID);
            }
            catch (NullPointerException nullPointerException) {
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                nIVolumeGroupArray = nIConfigQueryResult.getResourceList().toArray(new NIVolumeGroup[0]);
            } else if (nIConfigQueryResult.getCode() != 0) {
                hashMap = new StringBuffer();
                ((StringBuffer)((Object)hashMap)).append("Query Failure");
                logger.debug_general(((StringBuffer)((Object)hashMap)).toString());
                throw new NIQueryFailureCAException("Query Failure");
            }
        }
        try {
            nIConfigQueryResult = this.logicalService.getRanks(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            nIRankArray = nIConfigQueryResult.getResourceList().toArray(new NIRank[0]);
        } else if (nIConfigQueryResult.getCode() != 0) {
            hashMap = new StringBuffer();
            ((StringBuffer)((Object)hashMap)).append("Query Failure");
            logger.debug_general(((StringBuffer)((Object)hashMap)).toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        if (bl2) {
            hashMap = this.ca.getImageHostAttachments(nIESSID);
            nIImageHostAttachmentArray = hashMap.toArray(new NIImageHostAttachment[0]);
        }
        hashMap = new HashMap();
        int n3 = 0;
        while (n3 < n) {
            nIExtentPoolIDArray = nIVolumeArray[n3].getExtentPool();
            if (nIExtentPoolIDArray != null && !hashMap.containsKey(nIExtentPoolIDArray)) {
                hashMap.put(nIExtentPoolIDArray, nIExtentPoolIDArray);
            }
            ++n3;
        }
        nIExtentPoolIDArray = hashMap.values().toArray(new NIExtentPoolID[0]);
        if (nIExtentPoolIDArray != null && nIExtentPoolIDArray.length > 0) {
            try {
                nIConfigQueryResult = this.logicalService.getExtentPools(nIExtentPoolIDArray);
            }
            catch (NullPointerException nullPointerException) {
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                nIExtentPoolArray = nIConfigQueryResult.getResourceList().toArray(new NIExtentPool[0]);
            } else if (nIConfigQueryResult.getCode() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure");
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException("Query Failure");
            }
        }
        hashMap = new HashMap<NIExtentPoolID[], NIExtentPoolID[]>();
        HashMap<NIExtentPoolID, NIRaidType[]> hashMap4 = new HashMap<NIExtentPoolID, NIRaidType[]>();
        int n4 = nIExtentPoolArray.length;
        int n5 = 0;
        while (n5 < n4) {
            NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPoolArray[n5].getID();
            hashMap.put((NIExtentPoolID[])nIExtentPoolID, (NIExtentPoolID[])nIExtentPoolArray[n5]);
            object = nIConfigurationAdvisorExtentPool.getRaidTypesInExtentPool(nIRankArray, nIExtentPoolID);
            NIRaidType[] nIRaidTypeArray = object.toArray(new NIRaidType[0]);
            hashMap4.put(nIExtentPoolID, nIRaidTypeArray);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n) {
            Object object2;
            Object object3;
            object = nIVolumeArray[n6];
            double d = this.getBinaryStorageInGB(object.getCapacity(), object.getDataType());
            double d2 = this.getDecimalStorageInGB(object.getCapacity(), object.getDataType());
            long l = object.getCapacity();
            NIExtentPoolID nIExtentPoolID = object.getExtentPool();
            NIExtentPool nIExtentPool = null;
            NIRaidType[] nIRaidTypeArray = null;
            if (nIExtentPoolID != null) {
                nIExtentPool = (NIExtentPool)hashMap.get(nIExtentPoolID);
                nIRaidTypeArray = (NIRaidType[])hashMap4.get(nIExtentPoolID);
            }
            NIDataType nIDataType = object.getDataType();
            NIVolumeGroup[] nIVolumeGroupArray2 = null;
            int n7 = 0;
            NICKDVolumeType nICKDVolumeType = null;
            if (nIDataType != null) {
                if (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) {
                    object3 = this.getVolumeGroups(nIVolumeGroupArray, (NIVolume)object);
                    nIVolumeGroupArray2 = object3.toArray(new NIVolumeGroup[0]);
                } else {
                    nIVolumeGroupArray2 = new NIVolumeGroup[]{};
                }
                if (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) {
                    n7 = this.ca.getNumberOfHostAttachments(nIImageHostAttachmentArray, nIVolumeGroupArray2);
                }
                if (nIDataType instanceof NIDataType3380 || nIDataType instanceof NIDataType3390) {
                    nICKDVolumeType = nIConfigurationAdvisorZSeriesVolumes.getCKDVolumeType((NIVolume)object);
                    if (bl) {
                        object3 = ((NIVolumeID)object.getID()).getLSS();
                        if (!hashMap2.containsKey(object3)) {
                            object2 = this.logicalService.queryVolumeSerial((NILSSID)object3);
                            Vector vector2 = object2.getVolumeSerialDescriptors();
                            HashMap<Integer, String> hashMap5 = new HashMap<Integer, String>(vector2.size());
                            int n8 = 0;
                            while (n8 < vector2.size()) {
                                NIVolumeSerialDescriptor nIVolumeSerialDescriptor = (NIVolumeSerialDescriptor)vector2.get(n8);
                                hashMap5.put(new Integer(nIVolumeSerialDescriptor.getVolumeNumber()), nIVolumeSerialDescriptor.getSerial());
                                ++n8;
                            }
                            hashMap2.put(object3, hashMap5);
                        }
                        object2 = (HashMap)hashMap2.get(object3);
                        int n9 = ((NIVolumeID)object.getID()).getVolNumber();
                        string = (String)((HashMap)object2).get(new Integer(n9));
                    }
                }
            } else {
                nIVolumeGroupArray2 = new NIVolumeGroup[]{};
            }
            object3 = this.ca.getVolumeSizeType((NIVolume)object);
            object2 = new NIVolumeClientData((NIVolume)object, d, d2, (NIVolumeSizeType)object3, l, nIRaidTypeArray, nIExtentPool, nIVolumeGroupArray2, nICKDVolumeType, n7, string);
            vector.add((NIVolumeClientData)object2);
            string = null;
            ++n6;
        }
        return vector;
    }

    private double getBinaryStorageInGB(long l, NIDataType nIDataType) throws NIParameterInvalidCAException {
        double d = 0.0;
        if (nIDataType != null) {
            if (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) {
                d = (double)(l * 512L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            } else if (nIDataType instanceof NIDataType3380) {
                d = (double)(l * 712140L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            } else if (nIDataType instanceof NIDataType3390) {
                d = (double)(l * 849960L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            }
        } else {
            d = (double)(l * 712140L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        d = bigDecimal.doubleValue();
        return d;
    }

    private double getDecimalStorageInGB(long l, NIDataType nIDataType) throws NIParameterInvalidCAException {
        double d = 0.0;
        if (nIDataType != null) {
            if (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) {
                d = (double)(l * 512L) / NIConfigurationConstants.BYTES_IN_ONE_GB_DEC;
            } else if (nIDataType instanceof NIDataType3380) {
                d = (double)(l * 712140L) / NIConfigurationConstants.BYTES_IN_ONE_GB_DEC;
            } else if (nIDataType instanceof NIDataType3390) {
                d = (double)(l * 849960L) / NIConfigurationConstants.BYTES_IN_ONE_GB_DEC;
            }
        } else {
            d = (double)(l * 712140L) / NIConfigurationConstants.BYTES_IN_ONE_GB_DEC;
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        d = bigDecimal.doubleValue();
        return d;
    }

    public double getMaxVolumeCapacity(NIExtentPool nIExtentPool, int n, NIVolumeSizeType nIVolumeSizeType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        double d = 0.0;
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        int n2 = nIConfigurationAdvisorExtentPool.getAvailableExtents(nIExtentPool);
        if (n < 1) {
            n = 1;
        }
        if (n2 < n) {
            d = 0.0;
        } else if (nIVolumeSizeType instanceof NIVolumeSizeTypeDS) {
            d = n2 / n;
            BigDecimal bigDecimal = new BigDecimal(d);
            d = (bigDecimal = bigDecimal.setScale(0, 1)).doubleValue();
            if (d > 2048.0) {
                d = 2048.0;
            }
        } else if (nIVolumeSizeType instanceof NIVolumeSizeTypeESS) {
            d = n2 / n;
            d = d * NIConfigurationConstants.BYTES_IN_ONE_GB_BIN / NIConfigurationConstants.BYTES_IN_ONE_GB_DEC;
            BigDecimal bigDecimal = new BigDecimal(d);
            d = (bigDecimal = bigDecimal.setScale(1, 1)).doubleValue();
            if (d > 982.2) {
                d = 982.2;
            }
        } else if (nIVolumeSizeType instanceof NIVolumeSizeTypeBlocks) {
            d = n2 / n;
            BigDecimal bigDecimal = new BigDecimal(d);
            d = (bigDecimal = bigDecimal.setScale(0, 1)).doubleValue();
            if (d > 2048.0) {
                d = 2048.0;
            }
            d *= (double)NIConfigurationConstants.BLOCKS_IN_ONE_GB_BIN;
        }
        return d;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

