/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NIFibreChannelPort;
import com.ibm.storage.ess.ni.application.resource.NIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIPortProfilesResult;
import com.ibm.storage.ess.ni.ca.NIEnterpriseAdvisorHostManager;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHost;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHostID;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImage;
import com.ibm.storage.ess.ni.ca.NIImageHostPort;
import com.ibm.storage.ess.ni.ca.NIImageHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIImageIOPort;
import com.ibm.storage.ess.ni.ca.NIPlex;
import com.ibm.storage.ess.ni.ca.NIQueryHostsResult;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIHostConstants;
import com.ibm.storage.ess.ni.exception.NIConnectionCAException;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIAttachLoginPolicy;
import com.ibm.storage.ess.ni.option.config.NIAttachLoginPolicyAnyPort;
import com.ibm.storage.ess.ni.option.config.NIAttachLoginPolicySpecificPorts;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFicon;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown;
import com.ibm.storage.ess.ni.option.config.NIHostPortType;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeESCON;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeFICON;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcAl;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcSf;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeUnknown;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Map256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.resource.NISCSIHostPortImpl;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import com.ibm.storage.ess.ni.util.NICAVector;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class NIEnterpriseAdvisor {
    protected static final int NO_ACTION_PLEX = 1;
    protected static final int MODIFY_PLEX = 3;
    protected static final int NO_ACTION_IMAGE = 1;
    protected static final int MODIFY_IMAGE = 3;
    protected static final int NO_ACTION_HOST = 1;
    protected static final int CREATE_HOST = 2;
    protected static final int MODIFY_HOST = 3;
    protected static final int DELETE_HOST = 4;
    protected static final int NO_ACTION_HOST_PORT_GRP = 1;
    protected static final int CREATE_HOST_PORT_GRP = 2;
    protected static final int MODIFY_HOST_PORT_GRP = 3;
    protected static final int DELETE_HOST_PORT_GRP = 4;
    protected static final int NO_ACTION_IMAGE_PORT_GRP = 1;
    protected static final int CREATE_IMAGE_PORT_GRP = 2;
    protected static final int MODIFY_IMAGE_PORT_GRP = 3;
    protected static final int DELETE_IMAGE_PORT_GROUP = 4;
    protected static final int CANDIDATE_IMAGE_PORT_GRP = 5;
    protected static final int NO_ACTION_IMAGE_PORT = 1;
    protected static final int CREATE_IMAGE_PORT = 2;
    protected static final int MODIFY_IMAGE_PORT = 3;
    protected static final int DELETE_IMAGE_PORT = 5;
    protected static final int REPLACE_IMAGE_PORT = 4;
    protected static final int NO_ACTION_IO_PORT = 1;
    protected static final int MODIFY_IO_PORT = 3;
    protected static final int INVALID_NUMBER = Integer.parseInt(NIHostConstants.INVALID_NUMBER);
    protected static final String FC_AL = "Fc_Al";
    protected static final String FC_SF = "Fc_Sf";
    protected static final String FICON = "FICON";
    protected static final String ESCON = "ESCON";
    protected static final String Unknown = "Unknown";
    protected static final String FICON_HOST = "Anonymous FICON Host";
    protected static final String ESCON_HOST = "Anonymous ESCON Host";
    private static final int WWPN_LENGTH = 16;
    private final String WWPN_DATEFMT = "yyMMddHHmmss";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisor = NIEnterpriseAdvisor.class$("com.ibm.storage.ess.ni.ca.NIEnterpriseAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisor);
    private static final String CLASS_NAME = "NIEnterpriseAdvisor";
    private Vector vecAllHosts = new NICAVector();
    private Vector vecAllPlexes = new NICAVector();
    private Vector vecBackupHosts = new NICAVector();
    private Vector vecBackupPlexes = new NICAVector();
    private boolean bCreatedAnonymousFICON = false;
    private boolean bCreatedAnonymousESCON = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisor;

    public NIQueryHostsResult getAllHosts(NIServices[] nIServicesArray, boolean bl) throws NIParameterInvalidCAException {
        if (nIServicesArray == null) {
            throw new NIParameterInvalidCAException(nIServicesArray, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getAllHosts()");
        this.setAnonymousESCONCreated(false);
        this.setAnonymousFICONCreated(false);
        NIEnterpriseAdvisorHostManager nIEnterpriseAdvisorHostManager = new NIEnterpriseAdvisorHostManager(this, nIServicesArray);
        nIEnterpriseAdvisorHostManager.loadHostsFromServer(bl);
        Vector vector = this.getHostsList();
        logger.exit(CLASS_NAME, "getAllHosts()");
        return new NIQueryHostsResult(vector, nIEnterpriseAdvisorHostManager.getErrors());
    }

    public void refreshImageIOPorts(NIImage nIImage) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        NICADeepCloneable nICADeepCloneable;
        Cloneable cloneable;
        StringBuffer stringBuffer;
        Serializable serializable;
        logger.enter(CLASS_NAME, "refreshImageIOPorts()");
        Vector vector = new Vector();
        NIServices nIServices = nIImage.getServices();
        NIPhysicalConfigurationService nIPhysicalConfigurationService = nIServices.getPhysicalConfigurationService();
        NIESSID nIESSID = nIImage.getESSID();
        NIConfigQueryResult nIConfigQueryResult = null;
        Vector vector2 = new Vector();
        try {
            nIConfigQueryResult = nIPhysicalConfigurationService.getFibreChannelPorts(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector2 = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            throw new NIQueryFailureCAException("Query Failure");
        }
        nIImage.removeAllImagePorts();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            serializable = (NIFibreChannelPort)vector2.get(n2);
            String string = serializable.getLocation();
            NIImageIOPort nIImageIOPort = new NIImageIOPort((NIIOPort)serializable, string, serializable.getTopology(), serializable.getPortType(), 1);
            nIImage.addImagePort(nIImageIOPort);
            if (serializable.getTopology() instanceof NIFabricTopologyFicon) {
                nIImageIOPort.setFICONEnabled(true);
                nIImageIOPort.setSCSIEnabled(false);
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" Created NIImageIOPort: " + nIImageIOPort + " " + nIImageIOPort.toString());
            logger.debug_general(stringBuffer.toString());
            ++n2;
        }
        serializable = nIImage.getHostPortGroups();
        int n3 = ((Vector)serializable).size();
        int n4 = 0;
        while (n4 < n3) {
            NIHostPort nIHostPort;
            cloneable = (NIImageHostPortGroup)((Vector)serializable).get(n4);
            Vector vector3 = ((NIImageHostPortGroup)cloneable).getHostPorts();
            if (vector3.size() >= 1 && (nIHostPort = ((NIImageHostPort)(nICADeepCloneable = (NIImageHostPort)vector3.get(0))).getHostPort()) instanceof NISCSIHostPort) {
                NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIHostPort;
                ((NIImageHostPortGroup)cloneable).removeAllIOPorts();
                Vector<NIImageIOPort> vector4 = new Vector<NIImageIOPort>();
                NIPortMask nIPortMask = nISCSIHostPort.getPortMask();
                if (nIPortMask != null) {
                    Serializable serializable2;
                    Vector vector5 = nIImage.getImagePorts();
                    int n5 = 0;
                    while (n5 < vector5.size()) {
                        NIImageIOPort nIImageIOPort = (NIImageIOPort)vector5.get(n5);
                        serializable2 = nIImageIOPort.getIOPort();
                        if (nIPortMask.contains((NIIOPort)serializable2)) {
                            vector4.add(nIImageIOPort);
                            nIImageIOPort.setSCSIEnabled(true);
                            nIImageIOPort.addHostPorts(vector3);
                        }
                        ++n5;
                    }
                    ((NIImageHostPortGroup)cloneable).addIOPorts(vector4);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(" Updated NIImageHostPortGroup: " + ((NIImageHostPortGroup)cloneable).toString());
                    logger.debug_general(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("    Number of atteched NIImageIOPorts: " + vector4.size());
                    logger.debug_general(stringBuffer.toString());
                    int n6 = 0;
                    while (n6 < vector4.size()) {
                        serializable2 = (NIImageIOPort)vector4.get(n6);
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("    Attached NIImageIOPort: " + ((NIImageIOPort)serializable2).toString());
                        logger.debug_general(stringBuffer.toString());
                        ++n6;
                    }
                }
            }
            ++n4;
        }
        cloneable = nIImage.getImagePorts();
        int n7 = 0;
        while (n7 < ((Vector)cloneable).size()) {
            nICADeepCloneable = (NIImageIOPort)((Vector)cloneable).get(n7);
            stringBuffer = new StringBuffer();
            stringBuffer.append(" Updated NIImageIOPort: " + ((NIImageIOPort)nICADeepCloneable).toString());
            logger.debug_general(stringBuffer.toString());
            ++n7;
        }
        logger.exit(CLASS_NAME, "refreshImageIOPorts()");
    }

    public NIEnterpriseHost getHost(NIEnterpriseHostID nIEnterpriseHostID) throws NIParameterInvalidCAException {
        if (nIEnterpriseHostID == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHostID, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getHost()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHostID.toString());
        logger.debug_general(stringBuffer.toString());
        NIEnterpriseHost nIEnterpriseHost = null;
        int n = this.vecAllHosts.size();
        int n2 = 0;
        while (n2 < n) {
            NIEnterpriseHost nIEnterpriseHost2 = (NIEnterpriseHost)this.vecAllHosts.elementAt(n2);
            if (nIEnterpriseHostID.equals(nIEnterpriseHost2.getID())) {
                nIEnterpriseHost = nIEnterpriseHost2;
                break;
            }
            ++n2;
        }
        logger.exit(CLASS_NAME, "getHost()");
        return nIEnterpriseHost;
    }

    public void deleteHostSystem(NIEnterpriseHost nIEnterpriseHost) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "deleteHostSystem()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        logger.debug_general(stringBuffer.toString());
        Vector vector = nIEnterpriseHost.getPortGroups();
        stringBuffer = new StringBuffer();
        stringBuffer.append(" HostPortGroup: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        int n = 0;
        while (n < vector.size()) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)vector.elementAt(n);
            this.removeHostPortGroup(nIEnterpriseHost, nIEnterpriseHostPortGroup);
        }
        nIEnterpriseHost.setAction(4);
        this.vecAllHosts.remove(nIEnterpriseHost);
        logger.exit(CLASS_NAME, "deleteHostSystem()");
    }

    public List getHostTypeList() {
        logger.enter(CLASS_NAME, "getHostTypeList()");
        Vector<NIHostType> vector = new Vector<NIHostType>();
        int n = 0;
        while (n < 27) {
            if (!(this.bCreatedAnonymousFICON && n == 25 || this.bCreatedAnonymousESCON && n == 26)) {
                String string = NIHostConstants.getHostInfo(n, 0);
                String string2 = NIHostConstants.getHostInfo(n, 1);
                if (n != 26 && n != 25) {
                    String string3 = NIHostConstants.getHostInfo(n, 2);
                    int n2 = Integer.parseInt(NIHostConstants.getHostInfo(n, 3));
                    int n3 = Integer.parseInt(NIHostConstants.getHostInfo(n, 4));
                    NIHostType nIHostType = new NIHostType(string, string2, string3, n2, n3);
                    vector.add(nIHostType);
                }
            }
            ++n;
        }
        logger.exit(CLASS_NAME, "getHostTypeList()");
        return vector;
    }

    public NIEnterpriseHost createHostSystem(String string, String string2, NIHostType nIHostType) throws NIParameterInvalidCAException {
        if (string == null) {
            throw new NIParameterInvalidCAException((Object)string, "Null Parameter");
        }
        if (string2 == null) {
            throw new NIParameterInvalidCAException((Object)string2, "Null Parameter");
        }
        if (nIHostType == null) {
            throw new NIParameterInvalidCAException(nIHostType, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "createHostSystem()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" HostName: " + string);
        stringBuffer.append(" HostDescription: " + string2);
        stringBuffer.append(" HostType: " + nIHostType.toString());
        logger.debug_general(stringBuffer.toString());
        int n = this.getNextHostNumber(this.vecAllHosts);
        NIEnterpriseHostID nIEnterpriseHostID = new NIEnterpriseHostID(n);
        boolean bl = false;
        if (!nIHostType.getPortProfile().equals("XXXXX")) {
            bl = true;
        }
        NIEnterpriseHost nIEnterpriseHost = new NIEnterpriseHost(nIEnterpriseHostID, string, string2, bl, 2);
        nIEnterpriseHost.setHostType(nIHostType);
        if (!bl) {
            this.addHostPortGroup(nIEnterpriseHost, 1, NIHostPortTypeFICON.Option, true);
        }
        this.vecAllHosts.add(nIEnterpriseHost);
        logger.exit(CLASS_NAME, "createHostSystem()");
        return nIEnterpriseHost;
    }

    public void modifyHostSystem(NIEnterpriseHost nIEnterpriseHost, String string, String string2) throws NIParameterInvalidCAException {
        Cloneable cloneable;
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (string == null) {
            throw new NIParameterInvalidCAException((Object)string, "Null Parameter");
        }
        if (string2 == null) {
            throw new NIParameterInvalidCAException((Object)string2, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "modifyHostSystem()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString() + "\n");
        stringBuffer.append(" HostName: " + string);
        stringBuffer.append(" HostDescription: " + string2);
        logger.debug_general(stringBuffer.toString());
        int n = nIEnterpriseHost.getAction();
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Host Action: " + n);
        logger.debug_general(stringBuffer.toString());
        if (n < 4) {
            nIEnterpriseHost.setUserName(string);
            nIEnterpriseHost.setHostDescription(string2);
        }
        if (n == 1) {
            nIEnterpriseHost.setAction(3);
        }
        Vector vector = nIEnterpriseHost.getPlexes();
        int n2 = 0;
        while (n2 < vector.size()) {
            cloneable = (NIPlex)vector.get(n2);
            ((NIPlex)cloneable).setAction(3);
            ++n2;
        }
        cloneable = nIEnterpriseHost.getAttachedImages();
        int n3 = 0;
        while (n3 < ((Vector)cloneable).size()) {
            NIImage nIImage = (NIImage)((Vector)cloneable).get(n3);
            nIImage.setAction(3);
            ++n3;
        }
        boolean bl = nIEnterpriseHost.isSCSIHost();
        Vector vector2 = nIEnterpriseHost.getPortGroups();
        int n4 = 0;
        while (n4 < vector2.size()) {
            Object object;
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)vector2.get(n4);
            if (nIEnterpriseHostPortGroup.getAction() < 4) {
                object = nIEnterpriseHostPortGroup.getImageHostPortGrp();
                int n5 = 0;
                while (n5 < ((Vector)object).size()) {
                    NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)((Vector)object).get(n5);
                    if (nIImageHostPortGroup.getAction() < 4) {
                        Cloneable cloneable2;
                        Vector vector3 = nIImageHostPortGroup.getIOPorts();
                        int n6 = 0;
                        while (n6 < vector3.size()) {
                            cloneable2 = (NIImageIOPort)vector3.get(n6);
                            ((NIImageIOPort)cloneable2).setAction(3);
                            ++n6;
                        }
                        cloneable2 = nIImageHostPortGroup.getHostPorts();
                        int n7 = 0;
                        while (n7 < ((Vector)cloneable2).size()) {
                            NIImageHostPort nIImageHostPort = (NIImageHostPort)((Vector)cloneable2).get(n7);
                            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIImageHostPort.getHostPort();
                            nISCSIHostPort.setUserHostName(string);
                            nISCSIHostPort.setUserHostDescription(string2);
                            if (nIImageHostPort.getAction() < 5) {
                                nIImageHostPort.setAction(3);
                            }
                            ++n7;
                        }
                        nIImageHostPortGroup.setAction(3);
                    }
                    ++n5;
                }
                nIEnterpriseHostPortGroup.setAction(3);
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" HostPortGroup Topology: " + nIEnterpriseHostPortGroup.getTopology());
            logger.debug_general(stringBuffer.toString());
            object = this.getPrefix(nIEnterpriseHost.getUserName(), nIEnterpriseHost, nIEnterpriseHostPortGroup.getTopology());
            if (bl) {
                String string3 = (String)object + "(" + nIEnterpriseHostPortGroup.getPortCount() + ")" + "_" + nIEnterpriseHostPortGroup.getSuffix();
                nIEnterpriseHostPortGroup.setIdentifier(string3);
            } else {
                nIEnterpriseHostPortGroup.setIdentifier((String)object + "(" + 1 + ")");
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" HostPortGroup New Identifier: " + nIEnterpriseHostPortGroup.getIdentifier());
            logger.debug_general(stringBuffer.toString());
            ++n4;
        }
        logger.exit(CLASS_NAME, "modifyHostSystem()");
    }

    public List getHostPortGroups(NIEnterpriseHost nIEnterpriseHost) throws NIParameterInvalidCAException {
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getHostPortGroups()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        logger.debug_general(stringBuffer.toString());
        Vector vector = nIEnterpriseHost.getPortGroups();
        Vector<NIEnterpriseHostPortGroup> vector2 = new Vector<NIEnterpriseHostPortGroup>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)vector.elementAt(n2);
            int n3 = nIEnterpriseHostPortGroup.getAction();
            if (n3 < 4) {
                vector2.add(nIEnterpriseHostPortGroup);
            }
            ++n2;
        }
        logger.exit(CLASS_NAME, "getHostPortGroups()");
        return vector2;
    }

    public void addHostPortGroup(NIEnterpriseHost nIEnterpriseHost, int n, NIHostPortType nIHostPortType, boolean bl) throws NIParameterInvalidCAException {
        Object object;
        String string;
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (nIHostPortType == null) {
            throw new NIParameterInvalidCAException(nIHostPortType, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "addHostPortGroup()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        stringBuffer.append(" HostPortType: " + nIHostPortType.toString());
        stringBuffer.append(" Quantity: " + n);
        stringBuffer.append(" GroupPorts: " + bl);
        logger.debug_general(stringBuffer.toString());
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = nIEnterpriseHost.isSCSIHost();
        if (bl2) {
            if (bl) {
                n2 = n;
                n3 = 1;
            } else {
                n2 = 1;
                n3 = n;
            }
        } else {
            String string2 = NIHostConstants.getHostInfo(25, 0);
            string = NIHostConstants.getHostInfo(26, 0);
            int n4 = nIEnterpriseHost.getPortGroups().size();
            object = nIEnterpriseHost.getHostType().getHostType();
            if (n4 > 0) {
                if (this.bCreatedAnonymousFICON && ((String)object).equals(string2) || this.bCreatedAnonymousESCON && ((String)object).equals(string)) {
                    n3 = 0;
                }
            } else {
                n3 = 1;
                n2 = 1;
            }
        }
        int n5 = 0;
        while (n5 < n3) {
            string = "";
            if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl) {
                string = FC_AL;
            } else if (nIHostPortType instanceof NIHostPortTypeSCSIFcSf) {
                string = FC_SF;
            } else if (nIHostPortType instanceof NIHostPortTypeFICON) {
                string = FICON;
            } else if (nIHostPortType instanceof NIHostPortTypeESCON) {
                string = ESCON;
            } else if (nIHostPortType instanceof NIHostPortTypeUnknown) {
                string = Unknown;
            }
            String string3 = this.getPrefix(nIEnterpriseHost.getUserName(), nIEnterpriseHost, string);
            object = new Vector();
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = null;
            if (bl2) {
                nIEnterpriseHostPortGroup = this.getHostPortGroup(nIEnterpriseHost, string3, nIHostPortType, n2, (Vector)object, -1);
                nIEnterpriseHostPortGroup.setAction(2);
            } else {
                String string4 = string3 + "(" + 1 + ")";
                nIEnterpriseHostPortGroup = new NIEnterpriseHostPortGroup(nIEnterpriseHost, string4, 1, nIHostPortType, 1, 2);
            }
            nIEnterpriseHost.addHostPortGroup(nIEnterpriseHostPortGroup);
            ++n5;
        }
        logger.exit(CLASS_NAME, "addHostPortGroup()");
    }

    public void removeHostPortGroup(NIEnterpriseHost nIEnterpriseHost, NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (nIEnterpriseHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHostPortGroup, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "removeHostPortGroup()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        stringBuffer.append(" PortGroup: " + nIEnterpriseHostPortGroup.toString());
        stringBuffer.append(" PortGroup Action: " + nIEnterpriseHostPortGroup.getAction());
        logger.debug_general(stringBuffer.toString());
        if (nIEnterpriseHostPortGroup != null) {
            int n = nIEnterpriseHostPortGroup.getAction();
            int n2 = nIEnterpriseHost.getAction();
            if (n2 == 1) {
                nIEnterpriseHost.setAction(3);
            }
            if (n < 4) {
                Vector vector = nIEnterpriseHostPortGroup.getImageHostPortGrp();
                int n3 = 0;
                while (n3 < vector.size()) {
                    NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector.elementAt(n3);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(" ImagePortGroup" + n3 + ": " + nIImageHostPortGroup.toString() + "\n");
                    logger.debug_general(stringBuffer.toString());
                    this.unattachHostPortGroupFromImage(nIImageHostPortGroup.getOwner(), nIImageHostPortGroup);
                    ++n3;
                }
                nIEnterpriseHostPortGroup.setAction(4);
                nIEnterpriseHost.removeHostPortGroup(nIEnterpriseHostPortGroup);
            }
        }
        logger.exit(CLASS_NAME, "removeHostPortGroup()");
    }

    public void modifyHostPortGroup(NIEnterpriseHost nIEnterpriseHost, NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup, String[] stringArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (nIEnterpriseHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHostPortGroup, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "modifyHostPortGroup()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        stringBuffer.append(" HostPortGroup: " + nIEnterpriseHostPortGroup.toString());
        logger.debug_general(stringBuffer.toString());
        int n2 = nIEnterpriseHost.getAction();
        boolean bl = nIEnterpriseHost.isSCSIHost();
        int n3 = nIEnterpriseHostPortGroup.getPortCount();
        if (bl && (n = nIEnterpriseHostPortGroup.getAction()) < 4) {
            int n4;
            Vector<String> vector = new Vector<String>();
            int n5 = 0;
            if (stringArray != null) {
                n5 = stringArray.length;
                if (n5 > n3) {
                    n5 = n3;
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (stringArray[n6] != null) {
                        n4 = 0;
                        while (stringArray[n6].length() < 16) {
                            stringArray[n6] = "0" + stringArray[n6];
                            ++n4;
                        }
                    } else {
                        throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
                    }
                    vector.add(stringArray[n6]);
                    ++n6;
                }
            }
            if (n5 < n3) {
                Vector vector2 = this.generateDummyWWPN(n3 - n5);
                vector.addAll(vector2);
            }
            nIEnterpriseHostPortGroup.setWWPNs((Vector)vector.clone());
            if (n == 1 || n == 3) {
                nIEnterpriseHostPortGroup.setAction(3);
                if (n2 == 1) {
                    nIEnterpriseHost.setAction(3);
                }
                Vector vector3 = nIEnterpriseHostPortGroup.getImageHostPortGrp();
                n4 = 0;
                while (n4 < vector3.size()) {
                    NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector3.get(n4);
                    if (nIImageHostPortGroup.getAction() < 4) {
                        Object object;
                        Object object2;
                        Cloneable cloneable;
                        Vector vector4 = nIImageHostPortGroup.getHostPorts();
                        HashMap hashMap = new HashMap();
                        int n7 = 0;
                        while (n7 < vector4.size()) {
                            cloneable = (NIImageHostPort)vector4.get(n7);
                            if (((NIImageHostPort)cloneable).getAction() < 5) {
                                Long l = new Long(((NIImageHostPort)cloneable).getOriginalWWPN());
                                if (!hashMap.containsKey(l)) {
                                    hashMap.put(l, new HashSet());
                                }
                                object2 = (HashSet)hashMap.get(l);
                                ((HashSet)object2).add(cloneable);
                            }
                            ++n7;
                        }
                        cloneable = new Vector();
                        int n8 = 0;
                        while (n8 < vector.size()) {
                            object2 = (String)vector.elementAt(n8);
                            Long l = new Long(NIEnterpriseAdvisor.toLongFromHexString((String)object2));
                            object = (HashSet)hashMap.get(l);
                            if (object != null) {
                                hashMap.remove(l);
                            } else {
                                ((Vector)cloneable).add(object2);
                            }
                            ++n8;
                        }
                        if (((Vector)cloneable).size() > 0) {
                            object2 = new Vector(hashMap.values());
                            int n9 = 0;
                            while (n9 < ((Vector)object2).size()) {
                                object = (String)((Vector)cloneable).elementAt(n9);
                                Long l = new Long(NIEnterpriseAdvisor.toLongFromHexString((String)object));
                                HashSet hashSet = (HashSet)((Vector)object2).get(n9);
                                Iterator iterator = hashSet.iterator();
                                while (iterator.hasNext()) {
                                    NIImageHostPort nIImageHostPort = (NIImageHostPort)iterator.next();
                                    nIImageHostPort.setAction(4);
                                    nIImageHostPort.setWWPN(l);
                                    nIImageHostPortGroup.setAction(3);
                                }
                                ++n9;
                            }
                        }
                    }
                    ++n4;
                }
            }
        }
        logger.exit(CLASS_NAME, "modifyHostPortGroup()");
    }

    public List getImages(NIEnterpriseHost nIEnterpriseHost) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIConnectionCAException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getImages()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        logger.debug_general(stringBuffer.toString());
        Vector vector = nIEnterpriseHost.getAttachedImages();
        Vector vector2 = new Vector(this.getCandidateImages(nIEnterpriseHost, vector));
        Vector vector3 = new Vector();
        vector3.addAll(vector);
        vector3.addAll(vector2);
        int n = vector3.size();
        int n2 = 0;
        while (n2 < n) {
            NIImage nIImage = (NIImage)vector3.elementAt(n2);
            int n3 = 0;
            int n4 = 0;
            long l = 0L;
            if (vector.contains(nIImage)) {
                nIImage.setAttached(true);
                Vector vector4 = nIImage.getHostPortGroups();
                int n5 = vector4.size();
            } else {
                nIImage.setAttached(false);
            }
            nIImage.setAttachedVolumeGroups(n3);
            nIImage.setAttachedVolumes(n4);
            nIImage.setAttachedTotalGB(l);
            ++n2;
        }
        logger.exit(CLASS_NAME, "getImages()");
        return vector3;
    }

    public void unattachHostFromImage(NIEnterpriseHost nIEnterpriseHost, NIImage nIImage) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "unattachHostFromImage()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        stringBuffer.append(" Image: " + nIImage.toString());
        logger.debug_general(stringBuffer.toString());
        Vector vector = nIEnterpriseHost.getPortGroups();
        int n = 0;
        while (n < vector.size()) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)vector.elementAt(n);
            stringBuffer = new StringBuffer();
            stringBuffer.append(" HostPortGroup: " + nIEnterpriseHostPortGroup.toString());
            int n2 = nIEnterpriseHostPortGroup.getAction();
            stringBuffer.append(" HostPortGroup Action: " + n2);
            logger.debug_general(stringBuffer.toString());
            if (n2 < 4) {
                Vector vector2 = nIEnterpriseHostPortGroup.getImageHostPortGrp();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector2.elementAt(n3);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(" ImagePortGroup: " + nIImageHostPortGroup.toString());
                    logger.debug_general(stringBuffer.toString());
                    if (nIImageHostPortGroup.getOwner().equals(nIImage)) {
                        this.unattachHostPortGroupFromImage(nIImage, nIImageHostPortGroup);
                    }
                    ++n3;
                }
                if (n2 == 1) {
                    nIEnterpriseHostPortGroup.setAction(3);
                }
            }
            ++n;
        }
        int n4 = nIEnterpriseHost.getAction();
        if (n4 == 1) {
            nIEnterpriseHost.setAction(3);
        }
        logger.exit(CLASS_NAME, "unattachHostFromImage()");
    }

    public List getImageHostPortGroups(NIEnterpriseHost nIEnterpriseHost, NIImage nIImage) throws NIParameterInvalidCAException {
        Cloneable cloneable;
        NICADeepCloneable nICADeepCloneable;
        int n;
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getImageHostPortGroups()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Host: " + nIEnterpriseHost.toString());
        stringBuffer.append(" Image: " + nIImage.toString());
        logger.debug_general(stringBuffer.toString());
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = nIEnterpriseHost.getPortGroups();
        Vector vector3 = nIEnterpriseHost.getAttachedImages();
        boolean bl = false;
        int n2 = vector3.size();
        int n3 = 0;
        while (n3 < n2 && !bl) {
            NIImage nIImage2 = (NIImage)vector3.get(n3);
            if (nIImage.getESSID().equals(nIImage2.getESSID())) {
                bl = true;
            }
            ++n3;
        }
        int n4 = vector2.size();
        if (bl) {
            n = 0;
            while (n < n4) {
                Serializable serializable;
                nICADeepCloneable = (NIEnterpriseHostPortGroup)vector2.elementAt(n);
                boolean bl2 = false;
                cloneable = nICADeepCloneable.getImageHostPortGrp();
                int n5 = ((Vector)cloneable).size();
                int n6 = 0;
                while (n6 < n5 && !bl2) {
                    serializable = (NIImageHostPortGroup)((Vector)cloneable).elementAt(n6);
                    if (((NIImageHostPortGroup)serializable).getOwner().equals(nIImage)) {
                        vector.add(serializable);
                        bl2 = true;
                    }
                    ++n6;
                }
                if (!bl2) {
                    serializable = nICADeepCloneable.getHostPortType();
                    NIImageHostPortGroup nIImageHostPortGroup = new NIImageHostPortGroup(nIImage, (NIEnterpriseHostPortGroup)nICADeepCloneable, 5);
                    vector.add(nIImageHostPortGroup);
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < n4) {
                nICADeepCloneable = (NIEnterpriseHostPortGroup)vector2.elementAt(n);
                NIHostPortType nIHostPortType = nICADeepCloneable.getHostPortType();
                cloneable = new NIImageHostPortGroup(nIImage, (NIEnterpriseHostPortGroup)nICADeepCloneable, 5);
                vector.add(cloneable);
                ++n;
            }
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of image host port groups: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        n = 0;
        while (n < vector.size()) {
            stringBuffer = new StringBuffer();
            nICADeepCloneable = (NIImageHostPortGroup)vector.elementAt(n);
            stringBuffer.append(" group " + n + ": " + nICADeepCloneable);
            logger.debug_general(stringBuffer.toString());
            ++n;
        }
        logger.exit(CLASS_NAME, "getImageHostPortGroups()");
        return vector;
    }

    public void unattachHostPortGroupFromImage(NIImage nIImage, NIImageHostPortGroup nIImageHostPortGroup) throws NIParameterInvalidCAException {
        Serializable serializable;
        NICADeepCloneable nICADeepCloneable;
        int n;
        Cloneable cloneable;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        if (nIImageHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIImageHostPortGroup, "Null Parameter");
        }
        if (!nIImageHostPortGroup.getOwner().equals(nIImage)) {
            throw new NIParameterInvalidCAException(nIImage, "Object is not the owner. Unable to unattach.");
        }
        logger.enter(CLASS_NAME, "unattachHostPortGroupFromImage()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        stringBuffer.append(" ImagePortGroup: " + nIImageHostPortGroup.toString());
        logger.debug_general(stringBuffer.toString());
        NIEnterpriseHost nIEnterpriseHost = nIImageHostPortGroup.getEnterpriseGroup().getOwner();
        int n2 = nIImageHostPortGroup.getAction();
        stringBuffer = new StringBuffer();
        stringBuffer.append(" ImagePortGroup Action: " + n2);
        logger.debug_general(stringBuffer.toString());
        nIImageHostPortGroup.setAction(4);
        nIImageHostPortGroup.setAttachedToImage(false);
        NIHostPortType nIHostPortType = nIImageHostPortGroup.getHostPortType();
        Vector vector = nIImageHostPortGroup.getIOPorts();
        Vector vector2 = nIImageHostPortGroup.getHostPorts();
        int n3 = 0;
        while (n3 < vector.size()) {
            Serializable serializable2;
            cloneable = (NIImageIOPort)vector.elementAt(n3);
            if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl || nIHostPortType instanceof NIHostPortTypeSCSIFcSf || nIHostPortType instanceof NIHostPortTypeUnknown) {
                serializable2 = ((NIImageIOPort)cloneable).getHostPorts();
                n = 0;
                while (n < vector2.size()) {
                    int n4;
                    nICADeepCloneable = (NIImageHostPort)vector2.elementAt(n);
                    if (((Vector)serializable2).contains(nICADeepCloneable) && (n4 = ((NIImageHostPort)nICADeepCloneable).getAction()) < 5) {
                        serializable = (NISCSIHostPort)((NIImageHostPort)nICADeepCloneable).getHostPort();
                        NIPortMask nIPortMask = serializable.getPortMask();
                        nIPortMask.remove(((NIImageIOPort)cloneable).getIOPort());
                        serializable.setPortMask(nIPortMask);
                        ((NIImageHostPort)nICADeepCloneable).setAction(5);
                    }
                    ++n;
                }
            } else if (nIHostPortType instanceof NIHostPortTypeFICON) {
                serializable2 = (NIFibreChannelPort)((NIImageIOPort)cloneable).getIOPort();
                serializable2.setTopology(NIFabricTopologyUnknown.Option);
                ((NIImageIOPort)cloneable).setFabricTopology(NIFabricTopologyUnknown.Option);
                ((NIImageIOPort)cloneable).setFICONEnabled(false);
                stringBuffer = new StringBuffer();
                stringBuffer.append("fcPort to delete: " + serializable2.toString());
                logger.debug_general(stringBuffer.toString());
            }
            ((NIImageIOPort)cloneable).setAction(3);
            nIImageHostPortGroup.removeIOPort((NIImageIOPort)cloneable);
            nIImageHostPortGroup.getEnterpriseGroup().setAction(3);
        }
        cloneable = nIImage.getHostPortGroups();
        boolean bl = false;
        n = 0;
        while (n < ((Vector)cloneable).size()) {
            nICADeepCloneable = (NIImageHostPortGroup)((Vector)cloneable).elementAt(n);
            NIEnterpriseHost nIEnterpriseHost2 = ((NIImageHostPortGroup)nICADeepCloneable).getEnterpriseGroup().getOwner();
            if (nIEnterpriseHost2.equals(nIEnterpriseHost)) {
                bl = true;
                break;
            }
            ++n;
        }
        nICADeepCloneable = nIImage.getOwner();
        if (!bl) {
            nIEnterpriseHost.setAction(3);
            nIImage.setAttached(false);
            nIImage.setAttachedVolumeGroups(0);
            nIImage.setAttachedVolumes(0);
            nIImage.setAttachedTotalGB(0L);
            Vector vector3 = ((NIPlex)nICADeepCloneable).getImages();
            serializable = nIEnterpriseHost.getAttachedImages();
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < vector3.size()) {
                NIImage nIImage2 = (NIImage)vector3.elementAt(n5);
                boolean bl3 = false;
                int n6 = 0;
                while (n6 < ((Vector)serializable).size() && !bl3) {
                    NIImage nIImage3 = (NIImage)((Vector)serializable).get(n6);
                    if (nIImage3.getESSID().equals(nIImage2.getESSID())) {
                        bl3 = true;
                    }
                    ++n6;
                }
                if (bl3) {
                    bl2 = true;
                    break;
                }
                ++n5;
            }
        }
        nIImage.setAction(3);
        ((NIPlex)nICADeepCloneable).setAction(3);
        logger.exit(CLASS_NAME, "unattachHostPortGroupFromImage()");
    }

    public List getAvailableVolumeGroups(NIImage nIImage, NIImageHostPortGroup nIImageHostPortGroup) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIConnectionCAException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        if (nIImageHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIImageHostPortGroup, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getAvailableVolumeGroups()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        stringBuffer.append(" ImagePortGroup: " + nIImageHostPortGroup.toString());
        logger.debug_general(stringBuffer.toString());
        NIServices nIServices = nIImage.getServices();
        if (nIServices == null) {
            throw new NIConnectionCAException((Object)"Operation cannot continue. Service not available");
        }
        NILogicalConfigurationService nILogicalConfigurationService = nIServices.getLogicalConfigurationService();
        if (nILogicalConfigurationService == null) {
            throw new NIConnectionCAException((Object)"Operation cannot continue. Service not available");
        }
        NIEnterpriseHost nIEnterpriseHost = nIImageHostPortGroup.getEnterpriseGroup().getOwner();
        NIHostType nIHostType = nIEnterpriseHost.getHostType();
        NIConfigQueryResult nIConfigQueryResult = null;
        Vector vector = null;
        try {
            nIConfigQueryResult = nILogicalConfigurationService.getVolumeGroups(nIImage.getESSID());
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            throw new NIQueryFailureCAException("Query Failure");
        }
        Vector<NIVolumeGroup> vector2 = new Vector<NIVolumeGroup>();
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        String string = nIHostType.getHostType();
        boolean bl = nIEnterpriseHost.isSCSIHost();
        if (bl) {
            int n2 = nIHostType.getLogicalSize();
            int n3 = nIHostType.getAddressDiscovery();
            if (string.equals(NIHostConstants.getHostInfo(2, 0)) && n2 == Integer.parseInt(NIHostConstants.BLOCK_520)) {
                int n4 = 0;
                while (n4 < n) {
                    NIVolumeGroup nIVolumeGroup = (NIVolumeGroup)vector.get(n4);
                    NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
                    if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256 && n3 == Integer.parseInt(NIHostConstants.LUN_POLLING) || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask && n3 == Integer.parseInt(NIHostConstants.REPORT_LUN)) {
                        vector2.add(nIVolumeGroup);
                    }
                    ++n4;
                }
            } else if (!string.equals(NIHostConstants.getHostInfo(2, 0)) && n2 == Integer.parseInt(NIHostConstants.BLOCK_512)) {
                int n5 = 0;
                while (n5 < n) {
                    NIVolumeGroup nIVolumeGroup = (NIVolumeGroup)vector.get(n5);
                    NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
                    if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256 && n3 == Integer.parseInt(NIHostConstants.LUN_POLLING) || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask && n3 == Integer.parseInt(NIHostConstants.REPORT_LUN)) {
                        vector2.add(nIVolumeGroup);
                    }
                    ++n5;
                }
            }
        }
        logger.exit(CLASS_NAME, "getAvailableVolumeGroups()");
        return vector2;
    }

    public List getImagePorts(NIImage nIImage, NIImageHostPortGroup nIImageHostPortGroup) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        int n2;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        if (nIImageHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIImageHostPortGroup, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getImagePorts()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        stringBuffer.append(" ImagePortGroup: " + nIImageHostPortGroup.toString());
        logger.debug_general(stringBuffer.toString());
        boolean bl = false;
        NIHostPortType nIHostPortType = nIImageHostPortGroup.getHostPortType();
        Vector vector = nIImage.getImagePorts();
        Vector vector2 = nIImageHostPortGroup.getIOPorts();
        Vector<NIImageIOPort> vector3 = new Vector<NIImageIOPort>();
        int n3 = vector.size();
        int n4 = vector2.size();
        int n5 = 0;
        while (n5 < n3) {
            NIImageIOPort nIImageIOPort = (NIImageIOPort)vector.elementAt(n5);
            bl = this.isImageIOPortCompatible(nIHostPortType, nIImageIOPort);
            if (bl) {
                nIImageIOPort.setAvailable(true);
                n2 = 0;
                n = 0;
                while (n < n4) {
                    NIImageIOPort nIImageIOPort2 = (NIImageIOPort)vector2.elementAt(n);
                    if (nIImageIOPort2.getIOPort().equals(nIImageIOPort.getIOPort())) {
                        n2 = 1;
                        break;
                    }
                    ++n;
                }
                nIImageIOPort.setAttached(n2 != 0);
                vector3.add(nIImageIOPort);
            } else {
                nIImageIOPort.setAvailable(false);
            }
            ++n5;
        }
        int n6 = vector3.size();
        n2 = this.getNumberOfRecommendation(nIHostPortType, nIImageHostPortGroup.getPortCount(), n6);
        n = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n6 && n < n2) {
            NIImageIOPort nIImageIOPort = (NIImageIOPort)vector3.elementAt(n8);
            if (!nIImageIOPort.isAttached() || n7 != 0) {
                nIImageIOPort.setRecommended(true);
                ++n;
                if (n8 == n6 - 1 && n7 == 0) {
                    ++n7;
                    n8 = -1;
                }
            }
            ++n8;
        }
        logger.exit(CLASS_NAME, "getImagePorts()");
        return vector3;
    }

    public void assignVolumeGroupToHostAttachment(NIImage nIImage, NIImageHostPortGroup nIImageHostPortGroup, NIVolumeGroupID nIVolumeGroupID) throws NIParameterInvalidCAException {
        logger.enter(CLASS_NAME, "assignVolumeGroupToHostAttachment()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        stringBuffer.append(" HostAttachment: " + nIImageHostPortGroup.toString());
        if (nIVolumeGroupID != null) {
            stringBuffer.append(" VolumeGroup: " + nIVolumeGroupID.toString());
        }
        logger.debug_general(stringBuffer.toString());
        Vector vector = nIImageHostPortGroup.getHostPorts();
        NIHostPortType nIHostPortType = nIImageHostPortGroup.getHostPortType();
        if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl || nIHostPortType instanceof NIHostPortTypeSCSIFcSf || nIHostPortType instanceof NIHostPortTypeUnknown) {
            int n = 0;
            while (n < vector.size()) {
                NIImageHostPort nIImageHostPort = (NIImageHostPort)vector.elementAt(n);
                int n2 = nIImageHostPort.getAction();
                if (n2 < 5) {
                    NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIImageHostPort.getHostPort();
                    if (n2 == 1) {
                        nIImageHostPort.setAction(3);
                    }
                    nISCSIHostPort.setVolumeGroup(nIVolumeGroupID);
                }
                ++n;
            }
        }
        logger.exit(CLASS_NAME, "assignVolumeGroupToHostAttachment()");
    }

    public void attachHostPortGroupToImage(NIImage nIImage, NIImageHostPortGroup nIImageHostPortGroup, NIAttachLoginPolicy nIAttachLoginPolicy, NIVolumeGroupID nIVolumeGroupID, NIImageIOPort[] nIImageIOPortArray) throws NIParameterInvalidCAException {
        int n;
        Cloneable cloneable;
        int n2;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        if (nIImageHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIImageHostPortGroup, "Null Parameter");
        }
        if (nIAttachLoginPolicy == null) {
            throw new NIParameterInvalidCAException(nIAttachLoginPolicy, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "attachHostPortGroupToImage()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        stringBuffer.append(" PortGroup: " + nIImageHostPortGroup.toString());
        stringBuffer.append(" LoginPolicy: " + nIAttachLoginPolicy.toString());
        if (nIVolumeGroupID != null) {
            stringBuffer.append(" VolumeGroup: " + nIVolumeGroupID.toString());
        }
        if (nIImageIOPortArray != null && nIImageIOPortArray.length > 0) {
            int n3 = 0;
            while (n3 < nIImageIOPortArray.length) {
                stringBuffer.append(" IOPort[" + n3 + "]: " + nIImageIOPortArray[n3] + nIImageIOPortArray[n3].toString());
                ++n3;
            }
        } else {
            stringBuffer.append(" No IOPorts specified");
        }
        logger.debug_general(stringBuffer.toString());
        NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = nIImageHostPortGroup.getEnterpriseGroup();
        int n4 = nIImageHostPortGroup.getAction();
        if (n4 == 5) {
            nIImageHostPortGroup = this.createImageHostPortGroup(nIImage, nIEnterpriseHostPortGroup);
        }
        nIImageHostPortGroup.setLoginPolicy(nIAttachLoginPolicy);
        NIEnterpriseHost nIEnterpriseHost = nIEnterpriseHostPortGroup.getOwner();
        String string = nIEnterpriseHost.getUserName();
        String string2 = nIEnterpriseHost.getHostDescription();
        int n5 = nIEnterpriseHostPortGroup.getPortGroupNumber();
        NIHostType nIHostType = nIEnterpriseHost.getHostType();
        String string3 = "";
        int n6 = 0;
        int n7 = 0;
        String string4 = "XXXXX";
        if (nIHostType != null) {
            string3 = nIHostType.getHostType();
            n6 = nIHostType.getAddressDiscovery();
            n7 = nIHostType.getLogicalSize();
            string4 = nIHostType.getPortProfile();
        }
        NIFabricTopology nIFabricTopology = null;
        Vector vector = nIImageHostPortGroup.getHostPorts();
        NIHostPortType nIHostPortType = nIImageHostPortGroup.getHostPortType();
        if (nIImageIOPortArray != null) {
            int n8 = nIImageIOPortArray.length;
            n2 = 0;
            while (n2 < n8) {
                cloneable = nIImageIOPortArray[n2];
                if (!(((NIImageIOPort)cloneable).getFabricTopology() instanceof NIFabricTopologyUnknown)) {
                    if (nIFabricTopology == null) {
                        nIFabricTopology = ((NIImageIOPort)cloneable).getFabricTopology();
                    }
                } else {
                    NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)((NIImageIOPort)cloneable).getIOPort();
                    if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl || nIHostPortType instanceof NIHostPortTypeSCSIFcSf) {
                        ((NIImageIOPort)cloneable).setSCSIEnabled(true);
                        ((NIImageIOPort)cloneable).setFICONEnabled(false);
                        if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl) {
                            nIFibreChannelPort.setTopology(NIFabricTopologyFCArbitratedLoop.Option);
                            ((NIImageIOPort)cloneable).setFabricTopology(NIFabricTopologyFCArbitratedLoop.Option);
                            ((NIImageIOPort)cloneable).setAction(3);
                        } else if (nIHostPortType instanceof NIHostPortTypeSCSIFcSf) {
                            nIFibreChannelPort.setTopology(NIFabricTopologyScsiFcp.Option);
                            ((NIImageIOPort)cloneable).setFabricTopology(NIFabricTopologyScsiFcp.Option);
                            ((NIImageIOPort)cloneable).setAction(3);
                        }
                    } else if (nIHostPortType instanceof NIHostPortTypeFICON) {
                        ((NIImageIOPort)cloneable).setFICONEnabled(true);
                        ((NIImageIOPort)cloneable).setSCSIEnabled(false);
                        nIFibreChannelPort.setTopology(NIFabricTopologyFicon.Option);
                        ((NIImageIOPort)cloneable).setFabricTopology(NIFabricTopologyFicon.Option);
                        ((NIImageIOPort)cloneable).setAction(3);
                    }
                }
                ++n2;
            }
        }
        if (nIAttachLoginPolicy instanceof NIAttachLoginPolicySpecificPorts) {
            if (nIImageIOPortArray == null) {
                throw new NIParameterInvalidCAException(nIImageIOPortArray, "Null Parameter");
            }
            Vector<NIImageIOPort> vector2 = new Vector<NIImageIOPort>();
            NIPortMask nIPortMask = new NIPortMask(nIImage.getESSID().getType());
            nIPortMask.setAllEnabled(false);
            int n9 = nIImageIOPortArray.length;
            int n10 = 0;
            while (n10 < n9) {
                NIImageIOPort nIImageIOPort = nIImageIOPortArray[n10];
                nIImageIOPort.addHostPorts(vector);
                vector2.add(nIImageIOPort);
                nIPortMask.add(nIImageIOPort.getIOPort());
                ++n10;
            }
            if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl || nIHostPortType instanceof NIHostPortTypeSCSIFcSf || nIHostPortType instanceof NIHostPortTypeUnknown) {
                int n11 = 0;
                while (n11 < vector.size()) {
                    NIImageHostPort nIImageHostPort = (NIImageHostPort)vector.elementAt(n11);
                    int n12 = nIImageHostPort.getAction();
                    if (n12 < 5) {
                        NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIImageHostPort.getHostPort();
                        if (n12 == 1) {
                            nIImageHostPort.setAction(3);
                        }
                        nISCSIHostPort.setPortGroup(n5);
                        nISCSIHostPort.setUserHostName(string);
                        nISCSIHostPort.setUserHostDescription(string2);
                        nISCSIHostPort.setHostType(string3);
                        nISCSIHostPort.setAddressDiscovery(n6);
                        nISCSIHostPort.setLogicalBlockSize(n7);
                        nISCSIHostPort.setPortProfile(string4);
                        nISCSIHostPort.setPortMask(nIPortMask);
                        nISCSIHostPort.setVolumeGroup(nIVolumeGroupID);
                        if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl) {
                            nISCSIHostPort.setAttachingPortTopology(NIFabricTopologyFCArbitratedLoop.Option);
                        } else if (nIHostPortType instanceof NIHostPortTypeSCSIFcSf) {
                            nISCSIHostPort.setAttachingPortTopology(NIFabricTopologyScsiFcp.Option);
                        } else if (nIHostPortType instanceof NIHostPortTypeUnknown) {
                            if (nIFabricTopology != null && !(nIFabricTopology instanceof NIFabricTopologyUnknown)) {
                                nISCSIHostPort.setAttachingPortTopology(nIFabricTopology);
                            } else {
                                nISCSIHostPort.setAttachingPortTopology(NIFabricTopologyScsiFcp.Option);
                            }
                        }
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("HostType: " + string3);
                        logger.debug_general(stringBuffer.toString());
                    }
                    ++n11;
                }
            }
            nIImageHostPortGroup.addIOPorts(vector2);
        } else if (nIAttachLoginPolicy instanceof NIAttachLoginPolicyAnyPort) {
            NIPortMask nIPortMask = new NIPortMask(nIImage.getESSID().getType());
            nIPortMask.setAllEnabled(true);
            if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl || nIHostPortType instanceof NIHostPortTypeSCSIFcSf || nIHostPortType instanceof NIHostPortTypeUnknown) {
                n2 = 0;
                while (n2 < vector.size()) {
                    cloneable = (NIImageHostPort)vector.elementAt(n2);
                    int n13 = ((NIImageHostPort)cloneable).getAction();
                    if (n13 < 5) {
                        NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)((NIImageHostPort)cloneable).getHostPort();
                        if (n13 == 1) {
                            ((NIImageHostPort)cloneable).setAction(3);
                        }
                        nISCSIHostPort.setPortGroup(n5);
                        nISCSIHostPort.setUserHostName(string);
                        nISCSIHostPort.setUserHostDescription(string2);
                        nISCSIHostPort.setHostType(string3);
                        nISCSIHostPort.setAddressDiscovery(n6);
                        nISCSIHostPort.setLogicalBlockSize(n7);
                        nISCSIHostPort.setPortProfile(string4);
                        nISCSIHostPort.setPortMask(nIPortMask);
                        nISCSIHostPort.setVolumeGroup(nIVolumeGroupID);
                        if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl) {
                            nISCSIHostPort.setAttachingPortTopology(NIFabricTopologyFCArbitratedLoop.Option);
                        } else {
                            nISCSIHostPort.setAttachingPortTopology(NIFabricTopologyScsiFcp.Option);
                        }
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("HostType: " + string3);
                        logger.debug_general(stringBuffer.toString());
                    }
                    ++n2;
                }
                nIImageHostPortGroup.addIOPorts(nIImage.getImagePorts());
            } else if (nIHostPortType instanceof NIHostPortTypeFICON) {
                Vector vector3 = new Vector();
                try {
                    vector3 = new Vector(this.getImagePorts(nIImage, nIImageHostPortGroup));
                }
                catch (Exception exception) {
                    vector3 = new Vector();
                }
                cloneable = new Vector();
                int n14 = 0;
                while (n14 < vector3.size()) {
                    NIImageIOPort nIImageIOPort = (NIImageIOPort)vector3.get(n14);
                    if (nIImageIOPort.isRecommended()) {
                        NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)nIImageIOPort.getIOPort();
                        nIImageIOPort.setFICONEnabled(true);
                        nIImageIOPort.setSCSIEnabled(false);
                        nIFibreChannelPort.setTopology(NIFabricTopologyFicon.Option);
                        nIImageIOPort.setFabricTopology(NIFabricTopologyFicon.Option);
                        ((Vector)cloneable).add(nIImageIOPort);
                        nIImageIOPort.setAction(3);
                    }
                    ++n14;
                }
                nIImageHostPortGroup.addIOPorts((Vector)cloneable);
            }
        }
        nIImageHostPortGroup.setAttachedToImage(true);
        if (n4 == 1) {
            nIImageHostPortGroup.setAction(3);
        } else if (n4 == 5) {
            nIImageHostPortGroup.setAction(2);
        }
        int n15 = nIEnterpriseHostPortGroup.getAction();
        if (n15 == 1) {
            nIEnterpriseHostPortGroup.setAction(3);
        }
        nIImage.setAction(3);
        nIImageHostPortGroup.setVolumeGroup(nIVolumeGroupID);
        if (nIVolumeGroupID != null) {
            nIEnterpriseHost.addVolumeGroup(nIVolumeGroupID);
        }
        if ((n = nIEnterpriseHost.getAction()) == 1) {
            nIEnterpriseHost.setAction(3);
        }
        nIImage.getOwner().setAction(3);
    }

    public List getPlexesToModify() {
        logger.enter(CLASS_NAME, "getPlexesToModify()");
        Vector<NIPlex> vector = new Vector<NIPlex>();
        int n = this.vecAllPlexes.size();
        int n2 = 0;
        while (n2 < n) {
            NIPlex nIPlex = (NIPlex)this.vecAllPlexes.elementAt(n2);
            int n3 = nIPlex.getAction();
            if (n3 == 3) {
                vector.add(nIPlex);
            }
            ++n2;
        }
        logger.exit(CLASS_NAME, "getPlexesToModify()");
        return vector;
    }

    public List getImagesToModify(NIPlex nIPlex) throws NIParameterInvalidCAException {
        if (nIPlex == null) {
            throw new NIParameterInvalidCAException(nIPlex, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getImagesToModify()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Plex: " + nIPlex.toString());
        logger.debug_general(stringBuffer.toString());
        Vector<NIImage> vector = new Vector<NIImage>();
        int n = nIPlex.getAction();
        if (n == 3) {
            Vector vector2 = nIPlex.getImages();
            int n2 = vector2.size();
            int n3 = 0;
            while (n3 < n2) {
                NIImage nIImage = (NIImage)vector2.elementAt(n3);
                int n4 = nIImage.getAction();
                if (n4 == 3) {
                    vector.add(nIImage);
                }
                ++n3;
            }
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of images to modify: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        int n5 = 0;
        while (n5 < vector.size()) {
            stringBuffer = new StringBuffer();
            NIImage nIImage = (NIImage)vector.elementAt(n5);
            stringBuffer.append(" Image " + n5 + ": " + nIImage);
            logger.debug_general(stringBuffer.toString());
            ++n5;
        }
        logger.exit(CLASS_NAME, "getImagesToModify()");
        return vector;
    }

    public List getIOPortsToModify(NIImage nIImage) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getIOPortsToModify()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        logger.debug_general(stringBuffer.toString());
        Vector<NIIOPort> vector = new Vector<NIIOPort>();
        int n = nIImage.getAction();
        if (n == 3) {
            Vector vector2 = nIImage.getImagePorts();
            int n2 = vector2.size();
            int n3 = 0;
            while (n3 < n2) {
                NIImageIOPort nIImageIOPort = (NIImageIOPort)vector2.elementAt(n3);
                int n4 = nIImageIOPort.getAction();
                if (n4 == 3) {
                    vector.add(nIImageIOPort.getIOPort());
                }
                ++n3;
            }
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of I/O ports to modify: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        int n5 = 0;
        while (n5 < vector.size()) {
            stringBuffer = new StringBuffer();
            NIIOPort nIIOPort = (NIIOPort)vector.elementAt(n5);
            stringBuffer.append(" I/O port " + n5 + ": " + nIIOPort);
            if (nIIOPort instanceof NIFibreChannelPort) {
                stringBuffer.append("fabric topology: " + ((NIFibreChannelPort)nIIOPort).getTopology());
            }
            logger.debug_general(stringBuffer.toString());
            ++n5;
        }
        logger.exit(CLASS_NAME, "getIOPortsToModify()");
        return vector;
    }

    public List getHostPortsToCreate(NIImage nIImage) throws NIParameterInvalidCAException {
        Cloneable cloneable;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getHostPortsToCreate()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        logger.debug_general(stringBuffer.toString());
        Vector<NIImageHostPort> vector = new Vector<NIImageHostPort>();
        Vector vector2 = nIImage.getHostPortGroups();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            NIImageHostPort nIImageHostPort;
            int n3;
            NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector2.elementAt(n2);
            cloneable = nIImageHostPortGroup.getHostPorts();
            int n4 = ((Vector)cloneable).size();
            int n5 = nIImageHostPortGroup.getAction();
            if (n5 == 2) {
                n3 = 0;
                while (n3 < n4) {
                    nIImageHostPort = (NIImageHostPort)((Vector)cloneable).elementAt(n3);
                    if (!vector.contains(nIImageHostPort)) {
                        vector.add(nIImageHostPort);
                    }
                    ++n3;
                }
            } else if (n5 == 3) {
                n3 = 0;
                while (n3 < n4) {
                    nIImageHostPort = (NIImageHostPort)((Vector)cloneable).elementAt(n3);
                    int n6 = nIImageHostPort.getAction();
                    if (!(n6 != 2 && n6 != 4 || vector.contains(nIImageHostPort))) {
                        vector.add(nIImageHostPort);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of host ports to create: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        int n7 = 0;
        while (n7 < vector.size()) {
            stringBuffer = new StringBuffer();
            cloneable = (NIImageHostPort)vector.elementAt(n7);
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)((NIImageHostPort)cloneable).getHostPort();
            stringBuffer.append(" host port " + n7 + ": " + nISCSIHostPort);
            logger.debug_general(stringBuffer.toString());
            ++n7;
        }
        logger.exit(CLASS_NAME, "getHostPortsToCreate()");
        return vector;
    }

    public List getHostPortsToModify(NIImage nIImage) throws NIParameterInvalidCAException {
        Cloneable cloneable;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getHostPortsToModify()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        logger.debug_general(stringBuffer.toString());
        Vector<NIImageHostPort> vector = new Vector<NIImageHostPort>();
        Vector vector2 = nIImage.getHostPortGroups();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            NIImageHostPort nIImageHostPort;
            int n4;
            NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector2.elementAt(n2);
            cloneable = nIImageHostPortGroup.getHostPorts();
            int n5 = ((Vector)cloneable).size();
            int n6 = nIImageHostPortGroup.getAction();
            if (n6 == 2) {
                n4 = 0;
                while (n4 < n5) {
                    nIImageHostPort = (NIImageHostPort)((Vector)cloneable).elementAt(n4);
                    n3 = nIImageHostPort.getAction();
                    if (n3 == 3 && !vector.contains(nIImageHostPort)) {
                        vector.add(nIImageHostPort);
                    }
                    ++n4;
                }
            } else if (nIImageHostPortGroup.getAction() == 3) {
                n4 = 0;
                while (n4 < n5) {
                    nIImageHostPort = (NIImageHostPort)((Vector)cloneable).elementAt(n4);
                    n3 = nIImageHostPort.getAction();
                    if (n3 == 3 && !vector.contains(nIImageHostPort)) {
                        vector.add(nIImageHostPort);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of host ports to modify: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        int n7 = 0;
        while (n7 < vector.size()) {
            stringBuffer = new StringBuffer();
            cloneable = (NIImageHostPort)vector.elementAt(n7);
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)((NIImageHostPort)cloneable).getHostPort();
            stringBuffer.append(" host port " + n7 + ": " + nISCSIHostPort);
            logger.debug_general(stringBuffer.toString());
            ++n7;
        }
        logger.exit(CLASS_NAME, "getHostPortsToModify()");
        return vector;
    }

    public NIHostPort getNewHostPortsForModify(NIHostPort nIHostPort, NIHostPortID nIHostPortID) throws NIParameterInvalidCAException {
        if (nIHostPort == null) {
            throw new NIParameterInvalidCAException(nIHostPort, "Null Parameter");
        }
        if (nIHostPortID == null) {
            throw new NIParameterInvalidCAException(nIHostPortID, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getNewHostPortsForModify(NIHostPort futureHostPort, NIHostPortID hostPortID)");
        NISCSIHostPortImpl nISCSIHostPortImpl = new NISCSIHostPortImpl((NISCSIHostPortID)nIHostPortID, ((NISCSIHostPort)nIHostPort).getWWPN(), ((NISCSIHostPort)nIHostPort).getVolumeGroup(), ((NISCSIHostPort)nIHostPort).getPortProfile(), ((NISCSIHostPort)nIHostPort).getUserHostName(), ((NISCSIHostPort)nIHostPort).getUserHostDescription(), ((NISCSIHostPort)nIHostPort).getHostType(), ((NISCSIHostPort)nIHostPort).getLogicalBlockSize(), ((NISCSIHostPort)nIHostPort).getAddressDiscovery(), ((NISCSIHostPort)nIHostPort).getAttachingPortTopology(), ((NISCSIHostPort)nIHostPort).getPortGroup(), ((NISCSIHostPort)nIHostPort).getPortMask());
        logger.exit(CLASS_NAME, "getNewHostPortsForModify(NIHostPort futureHostPort, NIHostPortID hostPortID)");
        return nISCSIHostPortImpl;
    }

    public NIHostPort getNewHostPortsForModify(NIHostPort nIHostPort, NIHostPortID nIHostPortID, NIVolumeGroupID nIVolumeGroupID) throws NIParameterInvalidCAException {
        if (nIHostPort == null) {
            throw new NIParameterInvalidCAException(nIHostPort, "Null Parameter");
        }
        if (nIHostPortID == null) {
            throw new NIParameterInvalidCAException(nIHostPortID, "Null Parameter");
        }
        if (nIVolumeGroupID == null) {
            throw new NIParameterInvalidCAException(nIVolumeGroupID, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getNewHostPortsForModify(NIHostPort futureHostPort, NIHostPortID hostPortID, NIVolumeGroupID volumeGroupID)");
        NISCSIHostPortImpl nISCSIHostPortImpl = new NISCSIHostPortImpl((NISCSIHostPortID)nIHostPortID, ((NISCSIHostPort)nIHostPort).getWWPN(), nIVolumeGroupID, ((NISCSIHostPort)nIHostPort).getPortProfile(), ((NISCSIHostPort)nIHostPort).getUserHostName(), ((NISCSIHostPort)nIHostPort).getUserHostDescription(), ((NISCSIHostPort)nIHostPort).getHostType(), ((NISCSIHostPort)nIHostPort).getLogicalBlockSize(), ((NISCSIHostPort)nIHostPort).getAddressDiscovery(), ((NISCSIHostPort)nIHostPort).getAttachingPortTopology(), ((NISCSIHostPort)nIHostPort).getPortGroup(), ((NISCSIHostPort)nIHostPort).getPortMask());
        logger.exit(CLASS_NAME, "getNewHostPortsForModify(NIHostPort futureHostPort, NIHostPortID hostPortID, NIVolumeGroupID volumeGroupID)");
        return nISCSIHostPortImpl;
    }

    public List getHostPortsToDelete(NIImage nIImage) throws NIParameterInvalidCAException {
        Cloneable cloneable;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getHostPortsToDelete()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Image: " + nIImage.toString());
        logger.debug_general(stringBuffer.toString());
        Vector<NIImageHostPort> vector = new Vector<NIImageHostPort>();
        Vector vector2 = nIImage.getHostPortGroups();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            NIImageHostPort nIImageHostPort;
            int n3;
            NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector2.elementAt(n2);
            cloneable = nIImageHostPortGroup.getHostPorts();
            int n4 = ((Vector)cloneable).size();
            int n5 = nIImageHostPortGroup.getAction();
            if (n5 == 4) {
                n3 = 0;
                while (n3 < n4) {
                    nIImageHostPort = (NIImageHostPort)((Vector)cloneable).elementAt(n3);
                    if (!vector.contains(nIImageHostPort)) {
                        vector.add(nIImageHostPort);
                    }
                    ++n3;
                }
            } else if (n5 == 3) {
                n3 = 0;
                while (n3 < n4) {
                    nIImageHostPort = (NIImageHostPort)((Vector)cloneable).elementAt(n3);
                    int n6 = nIImageHostPort.getAction();
                    if (!(n6 != 5 && n6 != 4 || vector.contains(nIImageHostPort))) {
                        vector.add(nIImageHostPort);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of host ports to delete: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        int n7 = 0;
        while (n7 < vector.size()) {
            stringBuffer = new StringBuffer();
            cloneable = (NIImageHostPort)vector.elementAt(n7);
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)((NIImageHostPort)cloneable).getHostPort();
            stringBuffer.append(" host port " + n7 + ": " + nISCSIHostPort);
            logger.debug_general(stringBuffer.toString());
            ++n7;
        }
        logger.exit(CLASS_NAME, "getHostPortsToDelete()");
        return vector;
    }

    public void cancelUpdates() {
        logger.enter(CLASS_NAME, "cancelUpdates()");
        this.vecAllHosts = this.vecBackupHosts;
        this.vecAllPlexes = this.vecBackupPlexes;
        logger.exit(CLASS_NAME, "cancelUpdates()");
    }

    public List getAllImageHostPortGroups(NIESSID nIESSID) throws NIParameterInvalidCAException {
        Cloneable cloneable;
        if (nIESSID == null) {
            throw new NIParameterInvalidCAException(nIESSID, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "getAllImageHostPortGroups()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ESS: " + nIESSID.toString());
        logger.debug_general(stringBuffer.toString());
        NIImage nIImage = null;
        int n = this.vecAllPlexes.size();
        int n2 = 0;
        while (n2 < n) {
            cloneable = (NIPlex)this.vecAllPlexes.elementAt(n2);
            Vector vector = ((NIPlex)cloneable).getImages();
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                NIImage nIImage2 = (NIImage)vector.elementAt(n4);
                if (nIImage2.getESSID().equals(nIESSID)) {
                    nIImage = nIImage2;
                    break;
                }
                if (nIImage != null) break;
                ++n4;
            }
            ++n2;
        }
        cloneable = new Vector();
        if (nIImage != null) {
            cloneable = nIImage.getHostPortGroups();
        }
        logger.exit(CLASS_NAME, "getAllImageHostPortGroups()");
        return cloneable;
    }

    protected Vector getHostsList() {
        return this.vecAllHosts;
    }

    protected Vector getPlexesList() {
        return this.vecAllPlexes;
    }

    protected Vector getBackupHostsList() {
        return this.vecBackupHosts;
    }

    protected Vector getBackupPlexesList() {
        return this.vecBackupPlexes;
    }

    protected boolean isAnonymousFICONCreated() {
        return this.bCreatedAnonymousFICON;
    }

    protected boolean isAnonymousESCONCreated() {
        return this.bCreatedAnonymousESCON;
    }

    protected void setHostsList(NICAVector nICAVector) {
        this.vecAllHosts = nICAVector;
    }

    protected void setPlexesList(NICAVector nICAVector) {
        this.vecAllPlexes = nICAVector;
    }

    protected void setBackupHostsList(NICAVector nICAVector) {
        this.vecBackupHosts = nICAVector;
    }

    protected void setBackupPlexesList(NICAVector nICAVector) {
        this.vecBackupPlexes = nICAVector;
    }

    protected void setAnonymousFICONCreated(boolean bl) {
        this.bCreatedAnonymousFICON = bl;
    }

    protected void setAnonymousESCONCreated(boolean bl) {
        this.bCreatedAnonymousESCON = bl;
    }

    protected List getAllPlexes(NIServices[] nIServicesArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (this.vecAllHosts.size() == 0) {
            this.getAllHosts(nIServicesArray, true);
        }
        return this.vecAllPlexes;
    }

    protected NIEnterpriseHostPortGroup getHostPortGroup(NIEnterpriseHost nIEnterpriseHost, String string, NIHostPortType nIHostPortType, int n, Vector vector, int n2) throws NIParameterInvalidCAException {
        int n3;
        if (nIEnterpriseHost == null) {
            throw new NIParameterInvalidCAException(nIEnterpriseHost, "Null Parameter");
        }
        if (string == null) {
            throw new NIParameterInvalidCAException((Object)string, "Null Parameter");
        }
        if (nIHostPortType == null) {
            throw new NIParameterInvalidCAException(nIHostPortType, "Null Parameter");
        }
        NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = null;
        boolean bl = false;
        int[] nArray = new int[999];
        Arrays.fill(nArray, INVALID_NUMBER);
        int n4 = INVALID_NUMBER;
        Vector vector2 = nIEnterpriseHost.getPortGroups();
        int n5 = vector2.size();
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            String string2;
            String string3;
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup2 = (NIEnterpriseHostPortGroup)vector2.elementAt(n6);
            n3 = nIEnterpriseHostPortGroup2.getAction();
            if (n3 < 4 && (string3 = (string2 = nIEnterpriseHostPortGroup2.getIdentifier()).substring(0, n7 = string2.lastIndexOf("("))).equals(string)) {
                Vector vector3 = new Vector(nIEnterpriseHostPortGroup2.getWWPNs());
                int n8 = vector3.size();
                boolean bl2 = true;
                if (vector.size() > 0 && vector3.size() > 0 && vector.size() == n8) {
                    int n9 = 0;
                    while (n9 < n8 && bl2) {
                        String string4 = (String)vector3.elementAt(n9);
                        if (!vector.contains(string4)) {
                            bl2 = false;
                        }
                        ++n9;
                    }
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    nIEnterpriseHostPortGroup = nIEnterpriseHostPortGroup2;
                    bl = true;
                    break;
                }
                nArray[n4] = n4 = nIEnterpriseHostPortGroup2.getPortGroupNumber();
            }
            ++n6;
        }
        if (!bl) {
            int n10 = INVALID_NUMBER;
            if (n2 > 0) {
                n10 = n2;
            } else {
                n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] == INVALID_NUMBER) {
                        n10 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            String string5 = string + "(" + n + ")" + "_" + n10;
            nIEnterpriseHostPortGroup = new NIEnterpriseHostPortGroup(nIEnterpriseHost, string5, n10, nIHostPortType, n, 1);
            nIEnterpriseHostPortGroup.setSuffix(n10);
        }
        return nIEnterpriseHostPortGroup;
    }

    protected int getNextHostNumber(Vector vector) {
        int n;
        int[] nArray = new int[999];
        Arrays.fill(nArray, INVALID_NUMBER);
        int n2 = 0;
        while (n2 < this.vecAllHosts.size()) {
            NIEnterpriseHost nIEnterpriseHost = (NIEnterpriseHost)this.vecAllHosts.elementAt(n2);
            n = nIEnterpriseHost.getID().getHostNumber();
            if (nArray[n] == INVALID_NUMBER) {
                nArray[n] = n;
            }
            ++n2;
        }
        if (!this.vecAllHosts.containsAll(vector)) {
            int n3 = 0;
            while (n3 < vector.size()) {
                NIEnterpriseHost nIEnterpriseHost = (NIEnterpriseHost)vector.elementAt(n3);
                int n4 = nIEnterpriseHost.getID().getHostNumber();
                if (nArray[n4] == INVALID_NUMBER) {
                    nArray[n4] = n4;
                }
                ++n3;
            }
        }
        int n5 = INVALID_NUMBER;
        n = 0;
        while (n < nArray.length) {
            if (nArray[n] == INVALID_NUMBER) {
                n5 = n;
                break;
            }
            ++n;
        }
        return n5;
    }

    protected NIVolumeID[] getVolumes(NIVolumeGroupID nIVolumeGroupID, NIServices nIServices) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIConnectionCAException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (nIVolumeGroupID == null) {
            throw new NIParameterInvalidCAException(nIVolumeGroupID, "Null Parameter");
        }
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[]{};
        NIVolumeGroupID[] nIVolumeGroupIDArray = new NIVolumeGroupID[]{nIVolumeGroupID};
        NIVolumeGroup nIVolumeGroup = null;
        if (nIServices == null) {
            throw new NIConnectionCAException((Object)"Operation cannot continue. Service not available");
        }
        NILogicalConfigurationService nILogicalConfigurationService = nIServices.getLogicalConfigurationService();
        if (nILogicalConfigurationService == null) {
            throw new NIConnectionCAException((Object)"Operation cannot continue. Service not available");
        }
        try {
            List list = nILogicalConfigurationService.getVolumeGroups(nIVolumeGroupIDArray).getResourceList();
            if (list != null && list.size() > 0) {
                nIVolumeGroup = (NIVolumeGroup)list.get(0);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIVolumeGroup != null) {
            nIVolumeIDArray = nIVolumeGroup.getVolumeGroupList().getVolumesInVolumeGroup().toArray(new NIVolumeID[0]);
        }
        return nIVolumeIDArray;
    }

    protected String getPrefix(String string, NIEnterpriseHost nIEnterpriseHost, String string2) {
        String string3 = string + "|" + nIEnterpriseHost.getHostType().getHostType() + "|" + string2;
        return string3;
    }

    protected long getFBStorageInGB(NILogicalConfigurationService nILogicalConfigurationService, NIVolumeID[] nIVolumeIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        Serializable serializable;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = nILogicalConfigurationService.getVolumes(nIVolumeIDArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        Vector vector = new Vector();
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            throw new NIQueryFailureCAException("Query Failure");
        }
        long l = 0L;
        double d = 0.0;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            serializable = (NIVolume)vector.get(n2);
            l = serializable.getCapacity();
            d += (double)(l * 512L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN;
            ++n2;
        }
        serializable = new BigDecimal(d);
        serializable = ((BigDecimal)serializable).setScale(0, 0);
        long l2 = ((BigDecimal)serializable).longValue();
        return l2;
    }

    private NIImageHostPortGroup createImageHostPortGroup(NIImage nIImage, NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup) {
        String string;
        int n;
        Vector<NIImageHostPort> vector;
        int n2;
        Cloneable cloneable;
        Cloneable cloneable2 = new NIImageHostPortGroup(nIImage, nIEnterpriseHostPortGroup, 2);
        Vector vector2 = nIImage.getHostPortGroups();
        boolean bl = false;
        int n3 = 0;
        while (n3 < vector2.size() && !bl) {
            cloneable = (NIImageHostPortGroup)vector2.elementAt(n3);
            if (((NIImageHostPortGroup)cloneable).equals(cloneable2)) {
                cloneable2 = cloneable;
                bl = true;
            }
            ++n3;
        }
        cloneable = new Vector(nIEnterpriseHostPortGroup.getWWPNs());
        int n4 = ((Vector)cloneable).size();
        if (n4 > (n2 = nIEnterpriseHostPortGroup.getPortCount())) {
            n4 = n2;
        }
        long[] lArray = new long[n2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            String string2 = (String)((Vector)cloneable).elementAt(n5);
            lArray[n5] = NIEnterpriseAdvisor.toLongFromHexString(string2);
            ++n5;
            ++n6;
        }
        int n7 = n2 - n5;
        if (n7 > 0) {
            vector = this.generateDummyWWPN(n7);
            n = 0;
            while (n < n7) {
                string = (String)vector.elementAt(n);
                lArray[n5] = NIEnterpriseAdvisor.toLongFromHexString(string);
                ++n5;
                ++n;
            }
            ((Vector)cloneable).addAll(vector);
        }
        nIEnterpriseHostPortGroup.setWWPNs((Vector)cloneable);
        vector = new Vector<NIImageHostPort>();
        n = 0;
        while (n < n2) {
            NICADeepCloneable nICADeepCloneable;
            string = "XXXXX";
            String string3 = ((NIImageHostPortGroup)cloneable2).getHostType().getPortProfile();
            if (!string3.equals("XXXXX")) {
                nICADeepCloneable = ((NIImageHostPortGroup)cloneable2).getHostType();
                string = ((NIHostType)nICADeepCloneable).getPortProfile();
            }
            nICADeepCloneable = ((NIImageHostPortGroup)cloneable2).getEnterpriseGroup().getOwner();
            String string4 = ((NIEnterpriseHost)nICADeepCloneable).getUserName();
            String string5 = ((NIEnterpriseHost)nICADeepCloneable).getHostDescription();
            int n8 = ((NIImageHostPortGroup)cloneable2).getPortGroupNumber();
            NISCSIHostPort nISCSIHostPort = NIResourceFactory.newSCSIHostPort(nIImage.getESSID(), lArray[n], string, string4, string5);
            NIImageHostPort nIImageHostPort = new NIImageHostPort((NIImageHostPortGroup)cloneable2, nISCSIHostPort, 2);
            vector.add(nIImageHostPort);
            ++n;
        }
        ((NIImageHostPortGroup)cloneable2).addHostPorts(vector);
        nIImage.addHostPortGroup((NIImageHostPortGroup)cloneable2);
        nIEnterpriseHostPortGroup.addHostPortGroup((NIImageHostPortGroup)cloneable2);
        return cloneable2;
    }

    public Vector generateDummyWWPN(int n) {
        Vector<String> vector = new Vector<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
        Date date = Calendar.getInstance().getTime();
        String string = "0" + simpleDateFormat.format(date);
        int n2 = 1;
        while (n2 <= n) {
            String string2 = string + this.padding(n2, 3);
            vector.add(string2);
            ++n2;
        }
        return vector;
    }

    protected String padding(int n, int n2) {
        String string = "";
        String string2 = null;
        string2 = Integer.toString(n);
        int n3 = 0;
        while (n3 < n2 - string2.length()) {
            string = n3 == 0 ? "0" : string + "0";
            ++n3;
        }
        string = string + string2;
        return string;
    }

    private boolean isImageCompatible(NIEnterpriseHost nIEnterpriseHost, NIImage nIImage) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        boolean bl = false;
        NIESSID nIESSID = nIImage.getESSID();
        NIServices nIServices = nIImage.getServices();
        if (nIServices == null) {
            throw new NIConnectionCAException((Object)"Operation cannot continue. Service not available");
        }
        NIHostConfigurationService nIHostConfigurationService = nIServices.getHostConfigurationService();
        if (nIHostConfigurationService == null) {
            throw new NIConnectionCAException((Object)"Operation cannot continue. Service not available");
        }
        if (!nIEnterpriseHost.isSCSIHost()) {
            bl = true;
        } else {
            NIPortProfilesResult nIPortProfilesResult = null;
            String[] stringArray = null;
            try {
                nIPortProfilesResult = nIHostConfigurationService.queryPortProfiles(nIESSID);
            }
            catch (NullPointerException nullPointerException) {
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            if (nIPortProfilesResult.getCode() == 0) {
                stringArray = nIPortProfilesResult.portProfiles();
            } else if (nIPortProfilesResult.getCode() != 0) {
                throw new NIQueryFailureCAException("Query Failure");
            }
            NIHostType nIHostType = nIEnterpriseHost.getHostType();
            String string = nIHostType.getPortProfile();
            int n = 0;
            while (n < stringArray.length && !bl) {
                if (stringArray[n].equals(string)) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isImageCompatible(NIHostPortType nIHostPortType, NIImage nIImage) {
        boolean bl = false;
        Vector vector = nIImage.getImagePorts();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n && !bl) {
            NIImageIOPort nIImageIOPort = (NIImageIOPort)vector.elementAt(n2);
            bl = this.isImageIOPortCompatible(nIHostPortType, nIImageIOPort);
            ++n2;
        }
        return bl;
    }

    private boolean isImageIOPortCompatible(NIHostPortType nIHostPortType, NIImageIOPort nIImageIOPort) {
        logger.enter(CLASS_NAME, "isImageIOPortCompatible()");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        NIFabricTopology nIFabricTopology = nIImageIOPort.getFabricTopology();
        stringBuffer = new StringBuffer();
        stringBuffer.append(" HostPortType: " + nIHostPortType);
        if (nIHostPortType instanceof NIHostPortTypeESCON && nIImageIOPort.isESCONEnabled()) {
            bl = true;
        } else {
            stringBuffer.append(", Topology: " + nIFabricTopology.toString());
            if (nIFabricTopology instanceof NIFabricTopologyUnknown) {
                if ((nIHostPortType instanceof NIHostPortTypeSCSIFcAl || nIHostPortType instanceof NIHostPortTypeSCSIFcSf || nIHostPortType instanceof NIHostPortTypeFICON || nIHostPortType instanceof NIHostPortTypeUnknown) && (nIImageIOPort.getIOPortType() == 20 || nIImageIOPort.getIOPortType() == 21 || nIImageIOPort.getIOPortType() == 22)) {
                    bl = true;
                }
            } else if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl && nIFabricTopology instanceof NIFabricTopologyFCArbitratedLoop || nIHostPortType instanceof NIHostPortTypeSCSIFcSf && nIFabricTopology instanceof NIFabricTopologyScsiFcp || nIHostPortType instanceof NIHostPortTypeFICON && nIFabricTopology instanceof NIFabricTopologyFicon || nIHostPortType instanceof NIHostPortTypeUnknown && !(nIFabricTopology instanceof NIFabricTopologyFicon)) {
                bl = true;
            }
        }
        stringBuffer.append(", compatible: " + bl);
        logger.debug_general(stringBuffer.toString());
        logger.exit(CLASS_NAME, "isImageIOPortCompatible()");
        return bl;
    }

    private int getNumberOfRecommendation(NIHostPortType nIHostPortType, int n, int n2) {
        int n3 = 0;
        if (nIHostPortType instanceof NIHostPortTypeSCSIFcSf) {
            n3 = n > n2 ? n2 : n;
        } else if (nIHostPortType instanceof NIHostPortTypeSCSIFcAl) {
            n3 = n > 1 ? (n2 > 4 ? 4 : n2) : (n2 > 2 ? 2 : n2);
        } else if (nIHostPortType instanceof NIHostPortTypeFICON) {
            n3 = n2 > 4 ? 4 : n2;
        } else if (nIHostPortType instanceof NIHostPortTypeESCON) {
            n3 = n2;
        }
        return n3;
    }

    private List getCandidateImages(NIEnterpriseHost nIEnterpriseHost, Vector vector) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIConnectionCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector<NIImage> vector2 = new Vector<NIImage>();
        int n = this.vecAllPlexes.size();
        int n2 = 0;
        while (n2 < n) {
            NIPlex nIPlex = (NIPlex)this.vecAllPlexes.elementAt(n2);
            Vector vector3 = nIPlex.getImages();
            int n3 = vector3.size();
            int n4 = 0;
            while (n4 < n3) {
                NIImage nIImage = (NIImage)vector3.elementAt(n4);
                boolean bl = false;
                int n5 = vector.size();
                int n6 = 0;
                while (n6 < n5 && !bl) {
                    NIImage nIImage2 = (NIImage)vector.get(n6);
                    if (nIImage.getESSID().equals(nIImage2.getESSID())) {
                        bl = true;
                    }
                    ++n6;
                }
                if (!bl) {
                    boolean bl2 = false;
                    if (nIEnterpriseHost.isSCSIHost()) {
                        bl2 = this.isImageCompatible(nIEnterpriseHost, nIImage);
                    }
                    if (bl2) {
                        vector2.add(nIImage);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return vector2;
    }

    public List verifyUniqueWWPNs(NIImage nIImage, NIImageHostPortGroup nIImageHostPortGroup) throws NIParameterInvalidCAException {
        Object object;
        if (nIImage == null) {
            throw new NIParameterInvalidCAException(nIImage, "Null Parameter");
        }
        if (nIImageHostPortGroup == null) {
            throw new NIParameterInvalidCAException(nIImageHostPortGroup, "Null Parameter");
        }
        logger.enter(CLASS_NAME, "verifyUniqueWWPNs()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ImageHostPortGroup: " + nIImageHostPortGroup.toString());
        logger.debug_general(stringBuffer.toString());
        NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = nIImageHostPortGroup.getEnterpriseGroup();
        Vector vector = new Vector(nIEnterpriseHostPortGroup.getWWPNs());
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = nIImage.getHostPortGroups();
        int n2 = vector3.size();
        int n3 = 0;
        while (n3 < n2) {
            NIImageHostPortGroup nIImageHostPortGroup2 = (NIImageHostPortGroup)vector3.get(n3);
            if (!(nIImageHostPortGroup.getAction() != 5 && nIImageHostPortGroup.equals(nIImageHostPortGroup2) || nIImageHostPortGroup2.getAction() == 4)) {
                object = nIImageHostPortGroup2.getEnterpriseGroup();
                Vector vector4 = new Vector(((NIEnterpriseHostPortGroup)object).getWWPNs());
                stringBuffer = new StringBuffer();
                stringBuffer.append(" Number of existing WWPNs: " + vector4.size() + " [");
                int n4 = 0;
                while (n4 < vector4.size()) {
                    String string = (String)vector4.get(n4);
                    stringBuffer.append(string + " ");
                    ++n4;
                }
                stringBuffer.append("]");
                logger.debug_general(stringBuffer.toString());
                int n5 = 0;
                while (n5 < n) {
                    String string = (String)vector.get(n5);
                    if (vector4.contains(string) && !vector2.contains(string)) {
                        vector2.add(string);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of duplicate WWPNs: " + vector2.size() + " [");
        int n6 = 0;
        while (n6 < vector2.size()) {
            object = (String)vector2.get(n6);
            stringBuffer.append((String)object + " ");
            ++n6;
        }
        stringBuffer.append("]");
        logger.debug_general(stringBuffer.toString());
        return vector2;
    }

    protected static String hexStringFromLong(long l, int n) {
        String string = Long.toHexString(l);
        int n2 = 0;
        while (string.length() < n) {
            string = "0" + string;
            ++n2;
        }
        return string;
    }

    protected static long toLongFromHexString(String string) {
        long l = 0L;
        if (string == null) {
            l = 0L;
        } else {
            BigInteger bigInteger = new BigInteger(string, 16);
            l = bigInteger.longValue();
        }
        return l;
    }

    private void resetFlags(NIEnterpriseHost nIEnterpriseHost) {
        logger.enter(CLASS_NAME, "resetFlags(NIEnterpriseHost hostSystem)");
        nIEnterpriseHost.setAction(1);
        Vector vector = nIEnterpriseHost.getPortGroups();
        int n = 0;
        while (n < vector.size()) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)vector.get(n);
            nIEnterpriseHostPortGroup.setAction(1);
            Vector vector2 = nIEnterpriseHostPortGroup.getImageHostPortGrp();
            int n2 = 0;
            while (n2 < vector2.size()) {
                Cloneable cloneable;
                NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)vector2.get(n2);
                nIImageHostPortGroup.setAction(1);
                Vector vector3 = nIImageHostPortGroup.getHostPorts();
                int n3 = 0;
                while (n3 < vector3.size()) {
                    cloneable = (NIImageHostPort)vector3.get(n3);
                    ((NIImageHostPort)cloneable).setAction(1);
                    ++n3;
                }
                cloneable = nIImageHostPortGroup.getIOPorts();
                int n4 = 0;
                while (n4 < ((Vector)cloneable).size()) {
                    NIImageIOPort nIImageIOPort = (NIImageIOPort)((Vector)cloneable).get(n4);
                    nIImageIOPort.setAction(1);
                    ++n4;
                }
                ++n2;
            }
            ++n;
        }
        logger.exit(CLASS_NAME, "resetFlags(NIEnterpriseHost hostSystem)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

