/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.ca.NIEnterpriseHostID;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImage;
import com.ibm.storage.ess.ni.ca.NIPlex;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcAl;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcSf;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import java.io.Serializable;
import java.util.Vector;

public class NIEnterpriseHost
implements Serializable,
NICADeepCloneable {
    private static final long serialVersionUID = 1L;
    public static final int NO_ACTION = 1;
    public static final int CREATE = 2;
    public static final int MODIFY = 3;
    public static final int DELETE = 4;
    private int iAction;
    private String strHostName = new String();
    private String strHostDescription = new String();
    private boolean zSCSIHost;
    private NIHostType hostType;
    private Vector volGroups;
    private long lTotalStorageGB;
    private Vector vecPortGroups;
    private NIEnterpriseHostID hostID;

    protected NIEnterpriseHost(NIEnterpriseHostID nIEnterpriseHostID, String string, String string2, boolean bl, int n) {
        this.hostID = nIEnterpriseHostID;
        this.strHostName = string;
        this.strHostDescription = string2;
        this.iAction = n;
        this.zSCSIHost = bl;
        this.volGroups = new Vector();
        this.lTotalStorageGB = 0L;
        this.vecPortGroups = new Vector();
    }

    public NIEnterpriseHostID getID() {
        return this.hostID;
    }

    public NIHostType getHostType() {
        return this.hostType;
    }

    public void setHostType(NIHostType nIHostType) {
        this.hostType = nIHostType;
    }

    public boolean isSCSIHost() {
        return this.zSCSIHost;
    }

    public boolean isThereFcAl() {
        boolean bl = false;
        int n = this.vecPortGroups.size();
        int n2 = 0;
        while (n2 < n) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)this.vecPortGroups.elementAt(n2);
            if (nIEnterpriseHostPortGroup.getHostPortType() instanceof NIHostPortTypeSCSIFcAl) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isThereFcSf() {
        boolean bl = false;
        int n = this.vecPortGroups.size();
        int n2 = 0;
        while (n2 < n) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)this.vecPortGroups.elementAt(n2);
            if (nIEnterpriseHostPortGroup.getHostPortType() instanceof NIHostPortTypeSCSIFcSf) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public String getUserName() {
        String string = new String("");
        if (this.strHostName != null) {
            string = this.strHostName;
        }
        return string;
    }

    protected void setUserName(String string) {
        this.strHostName = string;
    }

    public String getHostDescription() {
        String string = new String("");
        if (this.strHostDescription != null) {
            string = this.strHostDescription;
        }
        return string;
    }

    protected void setHostDescription(String string) {
        this.strHostDescription = string;
    }

    public int getHostPortCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.vecPortGroups.size()) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)this.vecPortGroups.get(n2);
            n += nIEnterpriseHostPortGroup.getPortCount();
            ++n2;
        }
        return n;
    }

    public int getAttachmentCount() {
        return this.vecPortGroups.size();
    }

    public int getAttachedVolumeGroupCount() {
        return this.volGroups.size();
    }

    protected boolean addVolumeGroup(NIVolumeGroupID nIVolumeGroupID) {
        if (!this.volGroups.contains(nIVolumeGroupID)) {
            this.volGroups.add(nIVolumeGroupID);
            return true;
        }
        return false;
    }

    public long getTotalStorageGB() {
        return this.lTotalStorageGB;
    }

    protected void addTotalStorageGB(long l) {
        this.lTotalStorageGB += l;
    }

    protected int getAction() {
        return this.iAction;
    }

    protected void setAction(int n) {
        this.iAction = n;
    }

    public Vector getPortGroups() {
        return this.vecPortGroups;
    }

    protected void addHostPortGroup(NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup) {
        if (!this.vecPortGroups.contains(nIEnterpriseHostPortGroup)) {
            this.vecPortGroups.add(nIEnterpriseHostPortGroup);
        }
    }

    protected void removeHostPortGroup(NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup) {
        if (this.vecPortGroups.contains(nIEnterpriseHostPortGroup)) {
            this.vecPortGroups.remove(nIEnterpriseHostPortGroup);
        }
    }

    protected Vector getPlexes() {
        Vector<NIPlex> vector = new Vector<NIPlex>();
        Vector vector2 = this.getAttachedImages();
        int n = 0;
        while (n < vector2.size()) {
            NIImage nIImage = (NIImage)vector2.get(n);
            NIPlex nIPlex = nIImage.getOwner();
            if (!vector.contains(nIPlex)) {
                vector.add(nIPlex);
            }
            ++n;
        }
        return vector;
    }

    public int getAttachedImageCount() {
        return this.getAttachedImages().size();
    }

    protected Vector getAttachedImages() {
        Vector<NIImage> vector = new Vector<NIImage>();
        int n = 0;
        while (n < this.vecPortGroups.size()) {
            NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)this.vecPortGroups.get(n);
            if (nIEnterpriseHostPortGroup.getAction() != 4) {
                Vector vector2 = (Vector)nIEnterpriseHostPortGroup.getAttachedImages();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    NIImage nIImage = (NIImage)vector2.get(n2);
                    if (!vector.contains(nIImage)) {
                        vector.add(nIImage);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    public synchronized Object clone() {
        NIEnterpriseHost nIEnterpriseHost = null;
        try {
            nIEnterpriseHost = (NIEnterpriseHost)super.clone();
            nIEnterpriseHost.vecPortGroups = (Vector)this.vecPortGroups.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return nIEnterpriseHost;
    }

    public boolean equals(Object object) {
        return this.getUserName().equals(((NIEnterpriseHost)object).getUserName()) && this.getID().equals(((NIEnterpriseHost)object).getID());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hostID.toString());
        stringBuffer.append(" HostName: " + this.strHostName);
        stringBuffer.append(" HostDecription: " + this.strHostDescription);
        stringBuffer.append(this.hostType.toString());
        stringBuffer.append(" SCSI: " + this.zSCSIHost);
        stringBuffer.append(" volGroups: " + this.volGroups);
        stringBuffer.append(" TotalStorageGB: " + this.lTotalStorageGB);
        stringBuffer.append(" Action: " + this.iAction);
        return stringBuffer.toString();
    }
}

