/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;

public class NIExtentPoolData
implements Comparable,
Serializable {
    private int candidateSetNumber;
    private boolean existingExtentPool;
    private NIExtentPool extentPool;
    private NIExtentPoolID extentPoolID;
    private int rankGroup;
    private double extentPoolSizeGB;
    private long numExtents;
    private long numVolumeExtents;
    private Vector futureArrays;
    private Vector futureRanks;
    private Vector futureVolumes;
    private Vector existingRanks;
    private Vector existingArrays;
    private NIRaidType raidType;
    private static final long serialVersionUID = 1L;

    public NIExtentPoolData(NIExtentPool nIExtentPool, NIRaidType nIRaidType) {
        this.extentPool = nIExtentPool;
        this.extentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        this.rankGroup = nIExtentPool.getRankGroup();
        this.raidType = nIRaidType;
        this.candidateSetNumber = 0;
        this.extentPoolSizeGB = 0.0;
        this.numExtents = 0L;
        this.numVolumeExtents = 0L;
        this.futureArrays = new Vector();
        this.futureRanks = new Vector();
        this.futureVolumes = new Vector();
        this.existingRanks = new Vector();
    }

    public NIExtentPool getExtentPool() {
        return this.extentPool;
    }

    public NIExtentPoolID getExtentPoolID() {
        return this.extentPoolID;
    }

    public boolean isExisting() {
        return this.existingExtentPool;
    }

    public int getCandidateSetNumber() {
        return this.candidateSetNumber;
    }

    protected void setCandidateSetNumber(int n) {
        this.candidateSetNumber = n;
    }

    protected void setExisting(boolean bl) {
        this.existingExtentPool = bl;
    }

    public double getExtentPoolSizeGB() {
        return this.extentPoolSizeGB;
    }

    public long getNumExtents() {
        return this.numExtents;
    }

    protected void setNumExtents(long l) {
        this.numExtents = l;
    }

    public long getNumVolumeExtents() {
        return this.numVolumeExtents;
    }

    protected void setNumVolumeExtents(long l) {
        this.numVolumeExtents = l;
        this.updateExtentPoolSizeGB();
    }

    protected void addNumVolumeExtents(long l) {
        this.numVolumeExtents += l;
        this.updateExtentPoolSizeGB();
    }

    protected void addFutureVolume(NIVolume nIVolume) {
        this.futureVolumes.add(nIVolume);
    }

    private void updateExtentPoolSizeGB() {
        double d = 0.0;
        NIExtentType nIExtentType = this.extentPool.getExtentType();
        if (nIExtentType instanceof NIExtentTypeCKD) {
            d = 0.88104;
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            d = 1.0;
        }
        this.extentPoolSizeGB = (double)this.numVolumeExtents * d;
        BigDecimal bigDecimal = new BigDecimal(this.extentPoolSizeGB);
        bigDecimal = bigDecimal.setScale(0, 0);
        this.extentPoolSizeGB = bigDecimal.doubleValue();
    }

    public List getFutureArraysForExtentPoolData() {
        return this.futureArrays;
    }

    protected void setFutureArraysForExtentPoolData(List list) {
        this.futureArrays = new Vector(list);
    }

    public List getFutureRanksForExtentPoolData() {
        return this.futureRanks;
    }

    protected void setFutureRanksForExtentPoolData(List list) {
        this.futureRanks = new Vector(list);
    }

    protected int getRankGroup() {
        return this.rankGroup;
    }

    public List getFutureVolumesForExtentPoolData() {
        return this.futureVolumes;
    }

    protected void setFutureVolumesForExtentPoolData(List list) {
        this.futureVolumes = new Vector(list);
    }

    public int compareTo(Object object) {
        long l = ((NIExtentPoolData)object).getNumExtents();
        int n = (int)(this.numExtents - l);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" existingExtentPool: " + this.existingExtentPool);
        stringBuffer.append(" extentPoolID: " + this.extentPoolID.toString());
        stringBuffer.append(" candidate set: " + this.candidateSetNumber);
        stringBuffer.append(" rankGroup: " + this.rankGroup);
        stringBuffer.append(" extentPoolSizeGB: " + this.extentPoolSizeGB);
        stringBuffer.append(" numExtents: " + this.numExtents);
        stringBuffer.append(" numFutureArrays: " + this.futureArrays.size());
        stringBuffer.append(" numFutureRanks: " + this.futureRanks.size());
        stringBuffer.append(" numFutureVolumes: " + this.futureVolumes.size());
        return stringBuffer.toString();
    }

    public NIRaidType getRaidType() {
        return this.raidType;
    }

    public void setRaidType(NIRaidType nIRaidType) {
        this.raidType = nIRaidType;
    }

    public Vector getExistingArrays() {
        return this.existingArrays;
    }

    public Vector getExistingRanks() {
        return this.existingRanks;
    }

    public void setExistingArrays(Vector vector) {
        this.existingArrays = vector;
    }

    public void setExistingRanks(Vector vector) {
        this.existingRanks = vector;
    }

    public void setCreatedExtentPool(NIExtentPool nIExtentPool) {
        this.extentPool = nIExtentPool;
        this.extentPoolID = (NIExtentPoolID)nIExtentPool.getID();
    }
}

