/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImageHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIImageIOPort;
import com.ibm.storage.ess.ni.ca.NIPlex;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import java.io.Serializable;
import java.util.Vector;

public class NIImage
implements Serializable,
NICADeepCloneable {
    private static final long serialVersionUID = 1L;
    public static final int NO_ACTION = 1;
    public static final int MODIFY = 3;
    private Vector vecHostPortGroups;
    private Vector vecImagePorts;
    private Vector vecSupportedHostTypes;
    private NIESSID image;
    private NIPlex plex;
    private String strImageName;
    private boolean zAttached;
    private int iAction;
    private int iAttachVolGroups;
    private int iAttachVolumes;
    private long lAttachTotalGB;

    protected NIImage(NIPlex nIPlex, NIESSID nIESSID, int n) {
        this.plex = nIPlex;
        this.image = nIESSID;
        this.iAction = n;
        String string = new String("");
        this.zAttached = false;
        this.iAttachVolGroups = 0;
        this.iAttachVolumes = 0;
        this.lAttachTotalGB = 0L;
        this.vecSupportedHostTypes = new Vector();
        this.vecHostPortGroups = new Vector();
        this.vecImagePorts = new Vector();
    }

    public boolean isAttached() {
        return this.zAttached;
    }

    public NIESSID getESSID() {
        return this.image;
    }

    public String getNickName() {
        String string = new String("");
        if (this.strImageName != null) {
            string = this.strImageName;
        }
        return string;
    }

    public NIServices getServices() {
        return this.plex.getServices();
    }

    public synchronized Object clone() {
        NIImage nIImage = null;
        try {
            nIImage = (NIImage)super.clone();
            nIImage.vecSupportedHostTypes = (Vector)this.vecSupportedHostTypes.clone();
            nIImage.vecHostPortGroups = (Vector)this.vecHostPortGroups.clone();
            nIImage.vecImagePorts = (Vector)this.vecImagePorts.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return nIImage;
    }

    public boolean equals(Object object) {
        return this.getOwner().equals(((NIImage)object).getOwner()) && this.getESSID().equals(((NIImage)object).getESSID()) && this.getNickName().equals(((NIImage)object).getNickName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Plex: " + this.plex.toString());
        stringBuffer.append(" ESSID: " + this.image.toString());
        stringBuffer.append(" ImageName: " + this.strImageName);
        stringBuffer.append(" Attached: " + this.zAttached);
        stringBuffer.append(" Action: " + this.iAction);
        return stringBuffer.toString();
    }

    protected void setAction(int n) {
        this.iAction = n;
    }

    protected int getAction() {
        return this.iAction;
    }

    protected void setAttached(boolean bl) {
        this.zAttached = bl;
    }

    protected void setAttachedTotalGB(long l) {
        this.lAttachTotalGB = l;
    }

    protected void setAttachedVolumeGroups(int n) {
        this.iAttachVolGroups = n;
    }

    protected void setAttachedVolumes(int n) {
        this.iAttachVolumes = n;
    }

    protected Vector getHostPortGroups() {
        return this.vecHostPortGroups;
    }

    protected Vector getHostTypes() {
        return this.vecSupportedHostTypes;
    }

    protected NIImageIOPort getImagePort(NIIOPortID nIIOPortID) {
        NIImageIOPort nIImageIOPort = null;
        int n = this.vecImagePorts.size();
        int n2 = 0;
        while (n2 < n) {
            NIImageIOPort nIImageIOPort2 = (NIImageIOPort)this.vecImagePorts.elementAt(n2);
            if (((NIIOPortID)nIImageIOPort2.getIOPort().getID()).equals(nIIOPortID)) {
                nIImageIOPort = nIImageIOPort2;
                break;
            }
            ++n2;
        }
        return nIImageIOPort;
    }

    protected Vector getImagePorts() {
        return this.vecImagePorts;
    }

    protected void setNickName(String string) {
        this.strImageName = string;
    }

    protected NIPlex getOwner() {
        return this.plex;
    }

    protected void addHostPortGroup(NIImageHostPortGroup nIImageHostPortGroup) {
        if (!this.vecHostPortGroups.contains(nIImageHostPortGroup)) {
            this.vecHostPortGroups.add(nIImageHostPortGroup);
        }
    }

    protected void addHostType(NIHostType nIHostType) {
        if (!this.vecSupportedHostTypes.contains(nIHostType)) {
            this.vecSupportedHostTypes.addElement(nIHostType);
        }
    }

    protected void addImagePort(NIImageIOPort nIImageIOPort) {
        if (!this.vecImagePorts.contains(nIImageIOPort)) {
            this.vecImagePorts.add(nIImageIOPort);
        }
    }

    protected void removeAllImagePorts() {
        this.vecImagePorts.removeAllElements();
    }

    protected void removeHostPortGroup(NIImageHostPortGroup nIImageHostPortGroup) {
        if (this.vecHostPortGroups.contains(nIImageHostPortGroup)) {
            this.vecHostPortGroups.remove(nIImageHostPortGroup);
        }
    }

    protected void removeHostType(NIHostType nIHostType) {
        if (this.vecSupportedHostTypes.contains(nIHostType)) {
            this.vecSupportedHostTypes.removeElement(nIHostType);
        }
    }
}

