/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIHostPortType;
import java.io.Serializable;
import java.util.Vector;

public class NIImageHostAttachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String hostName;
    private String portProfile;
    private String hostTypeString;
    private int logicalBlockSize;
    private int addressDiscovery;
    private NIFabricTopology attachingPortTopology;
    private NIHostType hostType;
    private NIHostPortType portType;
    private int portGroupNumber;
    private Vector vecSCSIHostPorts;
    private NIVolumeGroupID volumeGroup;

    protected NIImageHostAttachment(String string, String string2, String string3, int n, int n2, NIFabricTopology nIFabricTopology, NIHostType nIHostType, NIHostPortType nIHostPortType, int n3, NIVolumeGroupID nIVolumeGroupID) {
        this.hostName = string;
        this.portProfile = string2;
        this.hostTypeString = string3;
        this.logicalBlockSize = n;
        this.addressDiscovery = n2;
        this.attachingPortTopology = nIFabricTopology;
        this.hostType = nIHostType;
        this.portType = nIHostPortType;
        this.portGroupNumber = n3;
        this.volumeGroup = nIVolumeGroupID;
        this.vecSCSIHostPorts = new Vector();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPortProfile() {
        return this.portProfile;
    }

    public String getHostTypeString() {
        return this.hostTypeString;
    }

    public int getLogicalBlockSize() {
        return this.logicalBlockSize;
    }

    public int getAddressDiscovery() {
        return this.addressDiscovery;
    }

    public NIFabricTopology getAttachingPortTopology() {
        return this.attachingPortTopology;
    }

    public NIHostType getHostType() {
        return this.hostType;
    }

    public NIHostPortType getHostPortType() {
        return this.portType;
    }

    public int getPortGroupNumber() {
        return this.portGroupNumber;
    }

    public NIVolumeGroupID getVolumeGroup() {
        return this.volumeGroup;
    }

    public void setVolumeGroup(NIVolumeGroupID nIVolumeGroupID) {
        this.volumeGroup = nIVolumeGroupID;
        int n = this.vecSCSIHostPorts.size();
        int n2 = 0;
        while (n2 < n) {
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)this.vecSCSIHostPorts.get(n2);
            nISCSIHostPort.setVolumeGroup(nIVolumeGroupID);
            ++n2;
        }
    }

    public String getIdentifier() {
        String string = "";
        string = this.attachingPortTopology instanceof NIFabricTopologyScsiFcp ? "Fc_Sf" : (this.attachingPortTopology instanceof NIFabricTopologyFCArbitratedLoop ? "Fc_Al" : "Unknown");
        String string2 = this.hostName + "|" + this.hostType.getHostType() + "|" + string + "(" + this.vecSCSIHostPorts.size() + ")" + "_" + this.portGroupNumber;
        return string2;
    }

    public Vector getSCSIHostPorts() {
        return this.vecSCSIHostPorts;
    }

    protected void addSCSIHostPort(NISCSIHostPort nISCSIHostPort) {
        this.vecSCSIHostPorts.add(nISCSIHostPort);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" HostName: " + this.hostName);
        stringBuffer.append(" PortProfile: " + this.portProfile);
        stringBuffer.append(" HostTypeString: " + this.hostTypeString);
        stringBuffer.append(" LogicalBlockSize: " + this.logicalBlockSize);
        stringBuffer.append(" AddressDiscovery: " + this.addressDiscovery);
        stringBuffer.append(" AttachingPortTopology: " + this.attachingPortTopology);
        stringBuffer.append(" PortType: " + this.portType);
        stringBuffer.append(" PortGroup: " + this.portGroupNumber);
        stringBuffer.append(" VolumeGroup: " + this.volumeGroup);
        return stringBuffer.toString();
    }
}

